/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.JobQueueProxy;
import com.helpsystems.enterprise.core.busobj.JobQueueScheduleEntry;
import com.helpsystems.enterprise.core.dm.JobQueueScheduleEntryDM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.module.JobQueueScheduleHelper;
import com.helpsystems.enterprise.module.JobQueueScheduleMonitor;
import org.apache.log4j.Logger;

public class JobQueueScheduleWorker {
    private static Logger logger = Logger.getLogger(JobQueueScheduleMonitor.class);

    public void processAllJobQueues(long l) throws ResourceUnavailableException {
        JobQueuesDM jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
        JobQueueProxy[] jobQueueProxyArray = jobQueuesDM.getJobQueuesWithSchedules(l);
        for (int i = 0; i < jobQueueProxyArray.length; ++i) {
            String string = "";
            try {
                string = jobQueueProxyArray[i].getName();
                logger.debug((Object)("Processing job queue schedule: " + string + " (" + jobQueueProxyArray[i].getDescription() + ")"));
                this.processJobQueue(jobQueueProxyArray[i], l);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("Error processing job queue schedule: " + string), (Throwable)exception);
            }
        }
    }

    private void processJobQueue(JobQueueProxy jobQueueProxy, long l) throws ResourceUnavailableException, DataException {
        if (jobQueueProxy == null) {
            throw new NullPointerException("Job Queue is null.");
        }
        JobQueueScheduleEntryDM jobQueueScheduleEntryDM = (JobQueueScheduleEntryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueueScheduleEntryDM");
        JobQueueScheduleEntry[] jobQueueScheduleEntryArray = jobQueueScheduleEntryDM.getEntriesForQueue(jobQueueProxy.getOID());
        JobQueueScheduleHelper.calculateJobQueueSchedule(jobQueueProxy, jobQueueScheduleEntryArray, l);
    }
}

