/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentJobQueue;
import com.helpsystems.enterprise.core.busobj.CrossAgentJobQueue;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobQueue;
import com.helpsystems.enterprise.core.busobj.JobQueueType;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.NotOnQueueException;
import com.helpsystems.enterprise.core.busobj.RequeueJobException;
import com.helpsystems.enterprise.core.busobj.actions.ChangeJobPriorityEvent;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobQueuePersisterAM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.module.AgentWorkManagerAMImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class JobQueueManager {
    private static Logger logger = Logger.getLogger(JobQueueManager.class);
    private static final String JOB_QUEUE_RUNNER_NAME = "Main Job Queue Runner";
    private JobQueuesDM jobQueuesDM;
    private HashMap<Long, JobQueue> jobQueueHM = new HashMap();
    private JobQueuePersisterAM jobQueuePersisterAM;
    private Thread runnerThread;
    private boolean stopped;
    private boolean globalHold;
    private LinkedBlockingQueue<Long> activeJobQueues;
    private AgentWorkManagerAMImpl agentWorkManagerAM;
    private Map<Long, Integer> failureOnCPF = new HashMap<Long, Integer>();

    protected JobQueueManager(AgentWorkManagerAMImpl agentWorkManagerAMImpl) {
        this.agentWorkManagerAM = agentWorkManagerAMImpl;
        this.jobQueuePersisterAM = (JobQueuePersisterAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuePersisterAM");
        this.init();
        logger.debug((Object)"***** The Job Queue Manager has started *****");
    }

    private void init() {
        this.activeJobQueues = new LinkedBlockingQueue();
        if (this.agentWorkManagerAM.isGlobalHoldInEffect()) {
            logger.debug((Object)"*** Global Hold is in effect.  Job Queue Runner will not be started.");
            this.globalHold = true;
            this.stopped = true;
            return;
        }
        this.startJobQueueRunner();
    }

    private void startJobQueueRunner() {
        if (!this.stopped && this.runnerThread != null && this.runnerThread.isAlive()) {
            logger.debug((Object)"Main Job Queue Runner is already started.");
            return;
        }
        if (this.runnerThread == null || !this.runnerThread.isAlive()) {
            JobQueueRunner jobQueueRunner = new JobQueueRunner();
            long l = SkybotStackSize.getStackSize();
            this.runnerThread = l != 0L ? new Thread(null, jobQueueRunner, JOB_QUEUE_RUNNER_NAME, l) : new Thread((Runnable)jobQueueRunner, JOB_QUEUE_RUNNER_NAME);
        }
        this.stopped = false;
        this.runnerThread.start();
    }

    private void stopJobQueueRunner() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
        }
    }

    protected void shutDown() {
        this.stopJobQueueRunner();
    }

    protected void enqueue(JobHistory jobHistory, boolean bl) throws Exception {
        JobQueue jobQueue;
        long l = jobHistory.getJobQueueID();
        try {
            jobQueue = this.getJobQueue(jobHistory.getJobQueueID());
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new Exception("Error obtaining job queue record.", resourceUnavailableException);
        }
        jobQueue.enqueue(jobHistory);
        if (bl) {
            this.jobQueuePersisterAM.processNewJobHistory(jobHistory);
        }
        logger.debug((Object)("Placed job: " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") on the queue: " + jobQueue.getName() + "(" + l + ") size:" + jobQueue.size() + " onHold:" + jobQueue.isOnHold()));
        if (bl && !jobQueue.isOnHold() && !jobQueue.isAtMaxActiveJobs() && !jobQueue.isAgentLocked(jobHistory.getAgentID())) {
            this.addToActiveJobQueues(l);
        }
    }

    protected void requeue(JobHistory jobHistory, SubmitFailedException.Reason reason) throws ResourceUnavailableException, EndJobException {
        long l = jobHistory.getJobQueueID();
        logger.debug((Object)("*** Inside requeue(" + jobHistory.getId() + ", " + (Object)((Object)reason) + ").  Queue = " + jobHistory.getJobQueueName() + "(" + l + ")"));
        JobQueue jobQueue = this.getJobQueue(jobHistory.getJobQueueID());
        this.decrementActiveJobCount(jobQueue, jobHistory);
        if (reason == SubmitFailedException.Reason.CREATE_PROCESS_FAILED) {
            jobQueue.setAgentUnavailable(jobHistory.getAgentID());
            logger.debug((Object)("Setting Agent " + jobHistory.getAgentName() + "(" + jobHistory.getAgentID() + ") unavailable for queue: " + jobQueue.getNameAndID() + " due to " + (Object)((Object)reason) + " on Job " + jobHistory.getJobName() + "(" + jobHistory.getId() + ")."));
            this.agentWorkManagerAM.startRetryForAgentTimer(jobHistory);
        }
        jobHistory.setQueueEndedTime(0L);
        jobQueue.enqueue(jobHistory);
        logger.debug((Object)("Placed job: " + jobHistory.getJobName() + " runID(" + jobHistory.getId() + ") back on the queue: " + jobQueue.getName() + "(" + l + ") size:" + jobQueue.size() + " onHold:" + jobQueue.isOnHold()));
    }

    private JobQueue getJobQueue(long l) throws ResourceUnavailableException {
        if (!this.jobQueueHM.containsKey(l)) {
            JobQueue jobQueue;
            try {
                jobQueue = this.getJobQueuesDM().getJobQueue(l);
                ArrayList<Long> arrayList = this.agentWorkManagerAM.getLockedAgentsList();
                switch (jobQueue.getJobQueueType()) {
                    case AGENT: {
                        if (!arrayList.contains(jobQueue.getTargetID())) break;
                        ((AgentJobQueue)jobQueue).setAgentLocked(jobQueue.getTargetID());
                        break;
                    }
                    case CROSS_AGENT: {
                        logger.debug((Object)("Loading Job Queue " + jobQueue.getNameAndID() + " with " + arrayList.size() + " locked Agent IDs."));
                        ((CrossAgentJobQueue)jobQueue).setAgentsLocked(arrayList);
                    }
                }
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Error obtaining job queue record for ID: " + l, (Throwable)exception);
            }
            this.jobQueueHM.put(jobQueue.getOID(), jobQueue);
            logger.debug((Object)("Added jobQueueID " + jobQueue.getOID() + " to the JobQueue HashMap with JobQueue: " + jobQueue.getNameAndID()));
        }
        return this.jobQueueHM.get(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregulateAllQueues() {
        HashMap<Long, JobQueue> hashMap = this.jobQueueHM;
        synchronized (hashMap) {
            Collection<JobQueue> collection = this.jobQueueHM.values();
            Iterator<JobQueue> iterator = collection.iterator();
            while (iterator.hasNext()) {
                JobQueue jobQueue;
                JobQueue jobQueue2 = jobQueue = iterator.next();
                synchronized (jobQueue2) {
                    if (jobQueue.isBeingRegulated()) {
                        jobQueue.setRegulated(false);
                        this.jobQueueChanged(jobQueue.getOID());
                    }
                }
            }
        }
    }

    protected int getJobQueueCount(long l) throws ResourceUnavailableException {
        if (logger.isTraceEnabled()) {
            JobQueue jobQueue = this.getJobQueue(l);
            String string = "\nActive for Job Queue " + jobQueue.getNameAndID() + ":";
            Long[] longArray = jobQueue.getAllActiveJobHistoryIDs();
            for (int i = 0; i < longArray.length; ++i) {
                string = string + "\n" + longArray[i];
            }
            logger.trace((Object)string);
        }
        return this.getJobQueue(l).size();
    }

    protected int getJobQueueCount(long l, long l2) throws ResourceUnavailableException {
        JobQueue jobQueue = this.getJobQueue(l);
        if (jobQueue instanceof CrossAgentJobQueue) {
            return ((CrossAgentJobQueue)jobQueue).getCountForAgent(l2);
        }
        return jobQueue.size();
    }

    protected int getJobQueueCountForAgent(long l) {
        int n = 0;
        Collection<JobQueue> collection = this.jobQueueHM.values();
        for (JobQueue jobQueue : collection) {
            if (jobQueue.getTargetID() == l) {
                n += jobQueue.size();
                continue;
            }
            if (!jobQueue.getJobQueueType().equals(JobQueueType.CROSS_AGENT)) continue;
            CrossAgentJobQueue crossAgentJobQueue = (CrossAgentJobQueue)jobQueue;
            n += crossAgentJobQueue.getCountForAgent(l);
        }
        return n;
    }

    protected ArrayList<JobHistory> getJobQueueEntries(long l) throws ResourceUnavailableException {
        return this.getJobQueue(l).getJobQueueEntries();
    }

    protected int getJobQueueRunningCount(long l) throws ResourceUnavailableException {
        JobQueue jobQueue;
        Long[] longArray;
        if (logger.isDebugEnabled() && (longArray = (jobQueue = this.getJobQueue(l)).getAllActiveJobHistoryIDs()).length > 0) {
            String string = "\nJob Queue " + jobQueue.getNameAndID() + " running jobs:";
            for (int i = 0; i < longArray.length; ++i) {
                string = string + "\n" + i + ":" + longArray[i];
            }
            logger.debug((Object)string);
        }
        return this.getJobQueue(l).getActiveJobsCount();
    }

    protected int getJobQueueRunningCount(long l, long l2) throws ResourceUnavailableException {
        JobQueue jobQueue = this.getJobQueue(l);
        if (jobQueue instanceof CrossAgentJobQueue) {
            return ((CrossAgentJobQueue)jobQueue).getActiveJobsForAgent(l2);
        }
        return jobQueue.getActiveJobsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToActiveJobQueues(long l) {
        LinkedBlockingQueue<Long> linkedBlockingQueue = this.activeJobQueues;
        synchronized (linkedBlockingQueue) {
            JobQueue jobQueue;
            if (!(this.activeJobQueues.contains(l) || (jobQueue = this.jobQueueHM.get(l)) == null || jobQueue.isEmpty() || jobQueue.isOnHold())) {
                this.activeJobQueues.add(l);
                logger.debug((Object)("Added jobQueueID: " + l + " to activeJobQueues."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromActiveJobQueues(long l) {
        LinkedBlockingQueue<Long> linkedBlockingQueue = this.activeJobQueues;
        synchronized (linkedBlockingQueue) {
            this.activeJobQueues.remove(l);
            logger.debug((Object)("Removed jobQueueID: " + l + " from activeJobQueues."));
        }
    }

    protected void agentConnected(long l) {
        Set<Long> set = this.jobQueueHM.keySet();
        Iterator<Long> iterator = set.iterator();
        block3: while (iterator.hasNext()) {
            JobQueue jobQueue = this.jobQueueHM.get(iterator.next());
            switch (jobQueue.getJobQueueType()) {
                case AGENT: {
                    if (jobQueue.getTargetID() != l) continue block3;
                    jobQueue.setAgentAvailable(l);
                    logger.debug((Object)("Set Agent ID " + l + " available for queue: " + jobQueue.getNameAndID()));
                    break;
                }
                default: {
                    jobQueue.setAgentAvailable(l);
                    logger.debug((Object)("Set Agent ID " + l + " available for queue: " + jobQueue.getNameAndID()));
                }
            }
            if (jobQueue.isOnHold() || jobQueue.isAgentLocked(l) || jobQueue.isEmpty()) continue;
            this.addToActiveJobQueues(jobQueue.getOID());
        }
    }

    protected int getMaxActiveIndexForUtilization(long l) throws ResourceUnavailableException {
        JobQueue jobQueue = this.getJobQueue(l);
        if (jobQueue.isLimitActivePerAgent()) {
            return jobQueue.getMaxActivePerAgent();
        }
        if (!jobQueue.isLimitActiveJobs()) {
            return 999;
        }
        return jobQueue.getMaxActiveJobs();
    }

    private JobQueue getNextJobQueue() {
        try {
            long l = this.activeJobQueues.take();
            return this.jobQueueHM.get(l);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private JobQueuesDM getJobQueuesDM() {
        if (this.jobQueuesDM == null) {
            this.jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
        }
        return this.jobQueuesDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void holdJobQueue(long l) {
        logger.debug((Object)("Received notice to hold the job queue with ID: " + l));
        if (this.jobQueueHM.containsKey(l)) {
            JobQueue jobQueue;
            JobQueue jobQueue2 = jobQueue = this.jobQueueHM.get(l);
            synchronized (jobQueue2) {
                jobQueue.setOnHold(true);
                if (!jobQueue.isEmpty()) {
                    this.removeFromActiveJobQueues(l);
                }
            }
        }
        try {
            this.persistJobQueueHoldStatus(l, true);
        }
        catch (ActionFailedException actionFailedException) {
            logger.error((Object)("Failed to persist hold status for Job Queue with ID: " + l));
        }
    }

    private void persistJobQueueHoldStatus(long l, boolean bl) throws ActionFailedException {
        try {
            JobQueue jobQueue = this.getJobQueuesDM().getJobQueue(l);
            if (bl && !jobQueue.isOnHold() || !bl && jobQueue.isOnHold()) {
                this.getJobQueuesDM().updateHold(l, bl);
            }
        }
        catch (Exception exception) {
            throw new ActionFailedException("Failed to persist Job Queue hold status.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseJobQueue(long l) {
        logger.debug((Object)("Received notice to release the job queue with ID: " + l));
        try {
            this.persistJobQueueHoldStatus(l, false);
        }
        catch (ActionFailedException actionFailedException) {
            logger.error((Object)("Failed to persist hold status for Job Queue with ID: " + l));
        }
        if (this.jobQueueHM.containsKey(l)) {
            JobQueue jobQueue;
            JobQueue jobQueue2 = jobQueue = this.jobQueueHM.get(l);
            synchronized (jobQueue2) {
                jobQueue.setOnHold(false);
                if (!jobQueue.isEmpty()) {
                    if (jobQueue.isBeingRegulated()) {
                        jobQueue.setRegulated(false);
                        this.jobQueueChanged(l);
                    }
                    this.addToActiveJobQueues(l);
                }
            }
        }
    }

    protected void setGlobalHold() {
        logger.debug((Object)"Received notice to set global hold.");
        this.globalHold = true;
        this.stopJobQueueRunner();
    }

    protected void releaseGlobalHold() {
        logger.debug((Object)"Received notice to release global hold.");
        this.globalHold = false;
        for (long l : this.jobQueueHM.keySet()) {
            JobQueue jobQueue = this.jobQueueHM.get(l);
            if (jobQueue.isEmpty() || jobQueue.isOnHold()) continue;
            this.addToActiveJobQueues(l);
        }
        this.startJobQueueRunner();
    }

    protected void holdAllJobQueues() {
        logger.debug((Object)"Received notice to hold all job queues.");
        this.stopJobQueueRunner();
    }

    protected void releaseAllJobQueues() {
        logger.debug((Object)"Received notice to release all job queues.");
        if (this.globalHold) {
            logger.warn((Object)"Job Queues not released due to global hold.");
            return;
        }
        for (Long l : this.jobQueueHM.keySet()) {
            if (!this.jobQueueHM.get(l).getJobQueueType().equals(JobQueueType.CROSS_AGENT)) continue;
            this.addToActiveJobQueues(l);
        }
        this.startJobQueueRunner();
    }

    protected void dequeue(JobHistory jobHistory) throws NotOnQueueException, ActionFailedException, ResourceUnavailableException {
        JobQueue jobQueue = this.getJobQueue(jobHistory.getJobQueueID());
        jobQueue.removeJob(jobHistory);
        logger.debug((Object)("JobHistory: " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") was removed from the Queue " + jobQueue.getNameAndID()));
        this.jobQueuePersisterAM.removePersistedEntry(jobHistory.getId(), jobHistory.getQueueEndedTime());
    }

    protected void jobStartedOnAgent(JobHistory jobHistory) {
        this.depersistJob(jobHistory);
        this.removeJobFromRequeuedOnCPFMap(jobHistory.getId());
    }

    private void removeJobFromRequeuedOnCPFMap(long l) {
        this.failureOnCPF.remove(l);
        logger.debug((Object)("CPF Requeue count: " + this.failureOnCPF.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobCompleted(JobHistory jobHistory) {
        logger.debug((Object)("Received notice of job completed: " + jobHistory.getId() + " with status code " + jobHistory.getStatusCode()));
        this.depersistJob(jobHistory);
        JobQueue jobQueue = this.jobQueueHM.get(jobHistory.getJobQueueID());
        if (jobQueue == null) {
            logger.warn((Object)("Unable to decrement max active.  Job Queue " + jobHistory.getJobQueueName() + "(" + jobHistory.getJobQueueID() + ") is not yet initialized."));
            return;
        }
        Object object = jobQueue;
        synchronized (object) {
            this.decrementActiveJobCount(jobQueue, jobHistory);
        }
        if (jobQueue.isHoldOnFailure() && !jobQueue.isOnHold() && jobHistory.getStatusCode().equals(JobStatusCode.FAILED)) {
            String[] stringArray;
            this.holdJobQueue(jobQueue.getOID());
            object = jobQueue.getName();
            if (jobQueue instanceof AgentJobQueue) {
                try {
                    stringArray = this.agentWorkManagerAM.getAgent(jobQueue.getTargetID());
                    object = (String)object + " for Agent " + stringArray.getName();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)"Error obtaining Agent name for Agent Job Queue.", (Throwable)resourceUnavailableException);
                }
            }
            stringArray = new String[]{object, "the Server due to a job failure"};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_QUEUE_HELD_BY_USER.newLogEntry(stringArray);
            SystemMessage systemMessage = RosettaMsg.JOB_QUEUE_HELD_BY_USER.newSystemMessage(stringArray);
            logger.warn((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write(scheduleLogEntry);
            SystemMessageQueue.write(systemMessage);
        }
        this.agentConnected(jobHistory.getAgentID());
    }

    protected void depersistJob(JobHistory jobHistory) {
        this.jobQueuePersisterAM.removePersistedEntry(jobHistory.getId(), jobHistory.getQueueEndedTime());
        logger.trace((Object)("Sent remove notice for " + jobHistory.getId() + " to persister."));
    }

    protected void incrementActiveJobCount(JobHistory jobHistory) {
        JobQueue jobQueue = this.jobQueueHM.get(jobHistory.getJobQueueID());
        if (jobQueue == null) {
            logger.error((Object)("Error: JobQueue not in HashMap for ID: " + jobHistory.getJobQueueID()));
            return;
        }
        boolean bl = jobQueue.incrementActiveJobs(jobHistory);
        if (logger.isDebugEnabled()) {
            String string = "JobHistoryID: " + jobHistory.getId() + " for Agent: " + jobHistory.getAgentID();
            string = bl ? string + " was " : string + " was NOT ";
            string = string + "added to active jobs list on job queue " + jobQueue.getNameAndID();
            logger.debug((Object)string);
        }
    }

    protected void decrementActiveForQueue(JobHistory jobHistory) {
        try {
            JobQueue jobQueue = this.getJobQueue(jobHistory.getJobQueueID());
            this.decrementActiveJobCount(jobQueue, jobHistory);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)("Error decrementing active jobs for job queue ID " + jobHistory.getJobQueueID()), (Throwable)resourceUnavailableException);
        }
    }

    private void decrementActiveJobCount(JobQueue jobQueue, JobHistory jobHistory) {
        boolean bl = jobQueue.decrementActiveJobs(jobHistory);
        if (logger.isDebugEnabled()) {
            String string = "JobHistoryID: " + jobHistory.getId() + " for Agent: " + jobHistory.getAgentID();
            string = bl ? string + " was " : string + " was NOT ";
            string = string + "removed from active jobs list on job queue " + jobQueue.getNameAndID();
            logger.debug((Object)string);
        }
    }

    protected void changeJobPriority(ChangeJobPriorityEvent changeJobPriorityEvent) throws DataException, ResourceUnavailableException, NotOnQueueException {
        String string = changeJobPriorityEvent.getUser();
        long l = changeJobPriorityEvent.getJobHistoryOID();
        int n = changeJobPriorityEvent.getPriority();
        long l2 = changeJobPriorityEvent.getJobQueueID();
        logger.debug((Object)("Received notice from " + string + " to change job priority to " + n + " on job history ID: " + l + " on job queue ID " + l2));
        JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        JobHistory jobHistory = jobHistoryDM.getWithAgentEnvironment(l);
        String string2 = String.valueOf(jobHistory.getJobPriority());
        jobHistory.setJobPriority(n);
        if (!this.jobQueueHM.containsKey(l2)) {
            throw new NotOnQueueException("Job Queue with ID " + l2 + " was not found in the list of active job queues.");
        }
        JobQueue jobQueue = this.jobQueueHM.get(l2);
        jobQueue.changeJobPriority(jobHistory);
        jobHistoryDM.updatePriority(n, l);
        this.addToActiveJobQueues(l2);
        String string3 = String.valueOf(l);
        String string4 = String.valueOf(n);
        String[] stringArray = new String[]{string, jobHistory.getJobName(), jobHistory.getAgentName(), string3, string2, string4};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_PRIORITY_CHANGED.newLogEntry(stringArray);
        scheduleLogEntry.setJobID(jobHistory.getJobID());
        scheduleLogEntry.setAgentID(jobHistory.getAgentID());
        scheduleLogEntry.setJobHistoryID(l);
        ScheduleLogger.write(scheduleLogEntry);
        logger.debug((Object)scheduleLogEntry.getMessageText());
    }

    protected Collection<JobHistory> clearJobQueue(long l) throws Exception {
        logger.debug((Object)("Received notice to clear job queue with ID: " + l));
        Collection<JobHistory> collection = new ArrayList<JobHistory>();
        if (this.jobQueueHM.containsKey(l)) {
            try {
                collection = this.getJobQueue(l).removeAllJobs();
                this.processDeletePersistedEntries(collection);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new Exception("Error obtaining Job Queue from the Job Queue HashMap with ID " + l);
            }
        }
        return collection;
    }

    private void processDeletePersistedEntries(final Collection<JobHistory> collection) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (JobHistory jobHistory : collection) {
                    arrayList.add(jobHistory.getId());
                }
                JobQueueManager.this.jobQueuePersisterAM.deletePersistedJobQueueEntries(arrayList);
            }
        });
        thread.start();
    }

    protected boolean isJobOnQueue(JobHistory jobHistory) throws ResourceUnavailableException {
        return this.getJobQueue(jobHistory.getJobQueueID()).contains(jobHistory);
    }

    protected boolean isJobQueueHeldForBalancing(long l) throws ResourceUnavailableException {
        JobQueue jobQueue = this.getJobQueue(l);
        return jobQueue.isOnHold() || jobQueue.isLimitActiveJobs() && jobQueue.getMaxActiveJobs() == 0;
    }

    protected void lockAgent(long l) {
        Set<Long> set = this.jobQueueHM.keySet();
        Iterator<Long> iterator = set.iterator();
        while (iterator.hasNext()) {
            JobQueue jobQueue = this.jobQueueHM.get(iterator.next());
            jobQueue.setAgentLocked(l);
        }
    }

    protected void unlockAgent(long l) {
        Set<Long> set = this.jobQueueHM.keySet();
        Iterator<Long> iterator = set.iterator();
        while (iterator.hasNext()) {
            JobQueue jobQueue = this.jobQueueHM.get(iterator.next());
            if (!jobQueue.setAgentUnlocked(l)) continue;
            logger.debug((Object)("Unlocked Agent in Job Queue " + jobQueue.getNameAndID()));
            if (jobQueue.isOnHold()) continue;
            this.addToActiveJobQueues(jobQueue.getOID());
        }
    }

    protected int getTotalJobQueueCount() {
        int n = 0;
        Set<Long> set = this.jobQueueHM.keySet();
        Iterator<Long> iterator = set.iterator();
        while (iterator.hasNext()) {
            JobQueue jobQueue = this.jobQueueHM.get(iterator.next());
            n += jobQueue.size();
        }
        return n;
    }

    protected void jobQueueChanged(long l) {
        logger.debug((Object)("Received notice of changed Job Queue for jobQueueID:" + l));
        if (this.jobQueueHM.containsKey(l)) {
            try {
                JobQueue jobQueue = this.getJobQueuesDM().getJobQueue(l);
                this.updateLoadedJobQueue(jobQueue);
            }
            catch (NoDataException noDataException) {
                JobQueue jobQueue = this.jobQueueHM.get(l);
                if (jobQueue.isEmpty()) {
                    JobQueue jobQueue2 = this.jobQueueHM.remove(l);
                    jobQueue = null;
                    logger.debug((Object)("Removed Job Queue " + jobQueue2.getNameAndID() + " from the internal HashMap."));
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Error updating Job Queue settings for ID " + l), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoadedJobQueue(JobQueue jobQueue) {
        boolean bl = false;
        HashMap<Long, JobQueue> hashMap = this.jobQueueHM;
        synchronized (hashMap) {
            JobQueue jobQueue2 = this.jobQueueHM.get(jobQueue.getOID());
            boolean bl2 = bl = jobQueue2.isLimitActiveJobs() && !jobQueue.isLimitActiveJobs();
            if (!bl) {
                boolean bl3 = bl = jobQueue2.getMaxActiveJobs() < jobQueue.getMaxActiveJobs();
            }
            if (!bl) {
                boolean bl4 = bl = jobQueue2.isLimiterEnabled() && !jobQueue.isLimiterEnabled();
            }
            if (!bl) {
                boolean bl5 = bl = jobQueue2.getLimiterMinimumPriority() < jobQueue.getLimiterMinimumPriority();
            }
            if (!bl) {
                boolean bl6 = bl = jobQueue2.getLimiterMaxActive() < jobQueue.getLimiterMaxActive();
            }
            if (!bl) {
                boolean bl7 = bl = jobQueue2.isLimitActivePerAgent() && !jobQueue.isLimitActivePerAgent();
            }
            if (!bl) {
                bl = jobQueue2.getMaxActivePerAgent() < jobQueue.getMaxActivePerAgent();
            }
            jobQueue2.setLimitActiveJobs(jobQueue.isLimitActiveJobs());
            jobQueue2.setMaxActiveJobs(jobQueue.getMaxActiveJobs());
            jobQueue2.setLimiterEnabled(jobQueue.isLimiterEnabled());
            jobQueue2.setLimiterMinimumPriority(jobQueue.getLimiterMinimumPriority());
            jobQueue2.setLimiterMaxActive(jobQueue.getLimiterMaxActive());
            jobQueue2.setLimitActivePerAgent(jobQueue.isLimitActivePerAgent());
            jobQueue2.setMaxActivePerAgent(jobQueue.getMaxActivePerAgent());
            jobQueue2.setHoldOnFailure(jobQueue.isHoldOnFailure());
            if (bl && jobQueue2 instanceof CrossAgentJobQueue) {
                ((CrossAgentJobQueue)jobQueue2).clearUnavailableAgents();
            }
            this.jobQueueHM.put(jobQueue2.getOID(), jobQueue2);
            logger.debug((Object)("Updated settings for Job Queue " + jobQueue2.getNameAndID()));
        }
        if (bl) {
            this.addToActiveJobQueues(jobQueue.getOID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agentDeleted(long l) {
        Map.Entry<Long, JobQueue> entry2;
        ArrayList arrayList = new ArrayList();
        Set<Map.Entry<Long, JobQueue>> set = this.jobQueueHM.entrySet();
        for (Map.Entry<Long, JobQueue> entry2 : set) {
            if (((JobQueue)((Object)entry2.getValue())).getTargetID() != l) continue;
            arrayList.add(entry2.getKey());
        }
        entry2 = arrayList.iterator();
        while (entry2.hasNext()) {
            HashMap<Long, JobQueue> hashMap = this.jobQueueHM;
            synchronized (hashMap) {
                Long l2 = (Long)entry2.next();
                JobQueue jobQueue = this.jobQueueHM.remove(l2);
                logger.debug((Object)("Removed Job Queue " + jobQueue.getNameAndID() + " from the internal Job Queue HashMap."));
                jobQueue = null;
            }
        }
    }

    protected void releaseAgentForQueue(long l, long l2) throws ResourceUnavailableException {
        this.getJobQueue(l).setAgentAvailable(l2);
        this.addToActiveJobQueues(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRunningJobs(ArrayList<JobHistory> arrayList) {
        for (JobHistory jobHistory : arrayList) {
            if (jobHistory == null) continue;
            try {
                JobQueue jobQueue;
                JobQueue jobQueue2 = jobQueue = this.getJobQueue(jobHistory.getJobQueueID());
                synchronized (jobQueue2) {
                    this.incrementActiveJobCount(jobHistory);
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)("Error loading job queue with ID " + jobHistory.getJobQueueID() + " for running job history ID " + jobHistory.getId()), (Throwable)resourceUnavailableException);
            }
        }
    }

    class JobQueueRunner
    implements Runnable {
        private JobQueue nextJobQueue;
        private JobHistory nextJobHistory;
        private long agentID;

        JobQueueRunner() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            logger.info((Object)"The Main Job Queue Runner has started.");
            try {
                while (!JobQueueManager.this.stopped) {
                    try {
                        logger.debug((Object)"Waiting for next Job Queue...");
                        this.nextJobQueue = JobQueueManager.this.getNextJobQueue();
                        if (this.nextJobQueue == null) continue;
                        String string = "The next Job Queue: " + this.nextJobQueue.getName() + "(" + this.nextJobQueue.getOID() + ") size: " + this.nextJobQueue.size();
                        this.nextJobHistory = this.nextJobQueue.poll();
                        logger.debug((Object)string);
                        this.checkForRegulation();
                        if (this.checkForNull()) {
                            JobQueueManager.this.removeFromActiveJobQueues(this.nextJobQueue.getOID());
                            continue;
                        }
                        this.agentID = this.nextJobHistory.getAgentID();
                        logger.debug((Object)("Job " + this.nextJobHistory.getJobName() + " runID(" + this.nextJobHistory.getId() + ") with target Agent: " + this.nextJobHistory.getAgentName() + "(" + this.agentID + ") was pulled off the queue: " + this.nextJobQueue.getNameAndID()));
                        if (this.atMaxActive()) {
                            this.nextJobQueue.enqueue(this.nextJobHistory);
                            logger.debug((Object)("Placed Job History ID " + this.nextJobHistory.getId() + " back on the queue " + this.nextJobQueue.getNameAndID() + " due to max active or priority limit reached."));
                            JobQueueManager.this.removeFromActiveJobQueues(this.nextJobQueue.getOID());
                            continue;
                        }
                        if (this.atMaxActiveForAgent()) {
                            logger.debug((Object)("Max active for Agent ID: " + this.agentID + " reached for Job Queue " + this.nextJobQueue.getNameAndID()));
                            this.nextJobQueue.setAgentUnavailable(this.agentID);
                            logger.debug((Object)("Set Agent ID " + this.agentID + " unavailable for queue: " + this.nextJobQueue.getNameAndID() + " due to max active for Agent"));
                            this.nextJobQueue.enqueue(this.nextJobHistory);
                            if (!this.nextJobQueue.getJobQueueType().equals(JobQueueType.CROSS_AGENT) || !((CrossAgentJobQueue)this.nextJobQueue).hasJobsNotForAgent(this.agentID)) continue;
                            JobQueueManager.this.addToActiveJobQueues(this.nextJobQueue.getOID());
                            continue;
                        }
                        JobQueueManager.this.incrementActiveJobCount(this.nextJobHistory);
                        JobQueueManager.this.agentWorkManagerAM.sendJobToAgent(this.nextJobHistory);
                        if (!this.nextJobQueue.isEmpty()) {
                            JobQueueManager.this.addToActiveJobQueues(this.nextJobQueue.getOID());
                        }
                    }
                    catch (RequeueJobException requeueJobException) {
                        logger.debug((Object)("RequeueJobException on Job History ID " + this.nextJobHistory.getId()), (Throwable)requeueJobException);
                        if (!requeueJobException.isJobRequeued()) {
                            this.nextJobQueue.enqueue(this.nextJobHistory);
                            JobQueueManager.this.decrementActiveJobCount(this.nextJobQueue, this.nextJobHistory);
                            logger.debug((Object)("Placed job " + this.nextJobHistory.getJobName() + "(" + this.nextJobHistory.getId() + ") back on the queue " + this.nextJobQueue.getNameAndID()));
                        }
                        if (requeueJobException.getReason().equals((Object)SubmitFailedException.Reason.AGENT_OFFLINE)) {
                            this.nextJobQueue.setAgentUnavailable(this.agentID);
                            if (this.nextJobQueue.getJobQueueType().equals(JobQueueType.AGENT)) continue;
                        }
                        if (requeueJobException.isRetryTimerStarted()) {
                            logger.debug((Object)(requeueJobException.getClass() + " indicates retry timer was started."), (Throwable)requeueJobException);
                            continue;
                        }
                    }
                    catch (EndJobException endJobException) {
                        JobQueueManager.this.decrementActiveJobCount(this.nextJobQueue, this.nextJobHistory);
                        logger.debug((Object)("Job " + this.nextJobHistory.getJobName() + "(" + this.nextJobHistory.getId() + ") was not sent to the" + "Agent and was not placed back on the queue " + this.nextJobQueue.getNameAndID() + ".  " + endJobException.getMessage()));
                    }
                    if (this.nextJobQueue.isEmpty()) continue;
                    JobQueueManager.this.addToActiveJobQueues(this.nextJobQueue.getOID());
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)"Main Job Queue Runner ended in error.", throwable);
            }
            logger.info((Object)"The Main Job Queue Runner has ended.");
        }

        private boolean checkForNull() {
            boolean bl = false;
            if (this.nextJobHistory == null) {
                bl = true;
                logger.debug((Object)("Polling " + this.nextJobQueue.getNameAndID() + " returned no job."));
                if (logger.isDebugEnabled() && this.nextJobQueue instanceof CrossAgentJobQueue) {
                    logger.debug((Object)("*** Queue " + this.nextJobQueue.getNameAndID() + ": " + ((CrossAgentJobQueue)this.nextJobQueue).listUnavailableAgents()));
                    logger.debug((Object)("*** Queue " + this.nextJobQueue.getNameAndID() + ": " + ((CrossAgentJobQueue)this.nextJobQueue).listLockedAgents()));
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForRegulation() throws ResourceUnavailableException {
            JobQueue jobQueue = this.nextJobQueue;
            synchronized (jobQueue) {
                if (this.nextJobQueue.isBeingRegulated()) {
                    String string = "";
                    if (logger.isDebugEnabled()) {
                        switch (this.nextJobQueue.getJobQueueType()) {
                            case AGENT: {
                                string = string + "Max Active: " + this.nextJobQueue.getMaxActiveJobs();
                                break;
                            }
                            case CROSS_AGENT: {
                                string = string + "Max Active per Agent: " + this.nextJobQueue.getMaxActivePerAgent();
                            }
                        }
                    }
                    logger.debug((Object)(this.nextJobQueue.getNameAndID() + " is regulating jobs at " + string));
                    int n = JobQueueManager.this.getJobQueueCount(this.nextJobQueue.getOID(), this.agentID);
                    if (n == 0) {
                        logger.debug((Object)("No more jobs queued from " + this.nextJobQueue.getNameAndID() + " for AgentID " + this.agentID + ". " + "Resetting regulation on all regulated queues."));
                        JobQueueManager.this.deregulateAllQueues();
                    }
                }
            }
        }

        private boolean atMaxActiveForAgent() {
            if (this.nextJobQueue instanceof CrossAgentJobQueue && this.nextJobQueue.isLimitActivePerAgent()) {
                CrossAgentJobQueue crossAgentJobQueue = (CrossAgentJobQueue)this.nextJobQueue;
                logger.debug((Object)("Current Active For AgentID: " + this.agentID + " = " + crossAgentJobQueue.getActiveJobsForAgent(this.agentID) + " for " + crossAgentJobQueue.getNameAndID()));
                logger.debug((Object)("... Max Active For AgentID: " + this.agentID + " = " + crossAgentJobQueue.getMaxActivePerAgent() + " for " + crossAgentJobQueue.getNameAndID()));
                return crossAgentJobQueue.isAtMaxActiveForAgent(this.agentID);
            }
            return false;
        }

        private boolean atMaxActive() {
            if (this.nextJobQueue.isAtMaxActiveJobs()) {
                logger.debug((Object)("Max active reached for Job Queue " + this.nextJobQueue.getNameAndID()));
                logger.debug((Object)("Max active: " + this.nextJobQueue.getMaxActiveJobs() + " currently active: " + this.nextJobQueue.getActiveJobsCount()));
                return true;
            }
            if (this.nextJobQueue.isLimiterEnabled()) {
                logger.debug((Object)("Current Priority Limit Active = " + this.nextJobQueue.getPriorityLimitActiveJobs() + " for " + this.nextJobQueue.getNameAndID()));
                logger.debug((Object)("Priority Limit Max Active     = " + this.nextJobQueue.getLimiterMaxActive() + " for " + this.nextJobQueue.getNameAndID()));
                if (this.nextJobHistory.getJobPriority() >= this.nextJobQueue.getLimiterMinimumPriority() && this.nextJobQueue.isAtPriorityLimitMaxActiveJobs()) {
                    logger.debug((Object)("Priority Limit(" + this.nextJobQueue.getLimiterMinimumPriority() + ") Max active(" + this.nextJobQueue.getLimiterMaxActive() + ") reached for Job Queue: " + this.nextJobQueue.getNameAndID()));
                    return true;
                }
            }
            return false;
        }
    }
}

