/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.JobMonitorSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.JobSuiteMonitorSNMPTrap;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMonitorDM;
import com.helpsystems.enterprise.core.dm.JobMonitorEventsDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.JobSuiteAM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.JobSuiteStatus;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobMonitorProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledTime;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.module.EmailInformation;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class JobMonitorManagerAMImpl
extends AbstractManager
implements JobMonitorManagerAM {
    private static Logger logger = Logger.getLogger(JobMonitorManagerAMImpl.class);
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private static BlockingQueue<JobMonitorEvent> eventQueue;
    private static Thread eventProcessorThread;
    private static Thread jobMonitorRunnerThread;
    private static ScheduleJobDM scheduleJobDM;
    private JobMonitorDM jobMonitorDM;
    private JobMonitorEventsDM jobMonitorEventsDM;
    private EnterpriseSNMPTrapAM snmpTrapAM;
    private EnterpriseEmailAM enterpriseEmailAM;
    private ScheduleInfoDM scheduleInfoDM;
    private ScheduledTimeDM scheduledTimeDM;
    private AgentDM agentDM;
    private AgentGroupDM agentGroupDM;
    private JobTrackerAM jobTrackerAM;
    private JobSuiteAM jobSuiteAM;
    private JobHistoryDM jobHistoryDM;
    private JobMonitorRunner jobMonitorRunner;
    private boolean missedJobsProcessComplete = false;
    private Object waitOnMissedJobsProcess = new Object();
    private boolean runnerIsActive = false;
    private boolean processorIsActive = false;

    public JobMonitorManagerAMImpl() {
        this.setName("ENTERPRISE.JobMonitorManagerAM");
        scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        this.jobMonitorDM = (JobMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorDM");
        this.jobMonitorEventsDM = (JobMonitorEventsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorEventsDM");
        this.snmpTrapAM = (EnterpriseSNMPTrapAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseSNMPTrapAM");
        this.enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
        this.scheduleInfoDM = (ScheduleInfoDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleInfoDM");
        this.scheduledTimeDM = (ScheduledTimeDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduledTimeDM");
        this.agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        this.agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
        this.jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
        this.init();
    }

    private void init() {
        this.startJobMonitorEventProcessor();
        this.startJobMonitorRunner();
    }

    private void startJobMonitorEventProcessor() {
        if (eventProcessorThread == null || !eventProcessorThread.isAlive()) {
            eventProcessorThread = new Thread(new JobMonitorEventProcessor());
            eventProcessorThread.setName("JobMonitorEventProcessor");
            eventProcessorThread.start();
            this.processorIsActive = true;
        }
    }

    private void startJobMonitorRunner() {
        if (jobMonitorRunnerThread == null || !jobMonitorRunnerThread.isAlive()) {
            this.jobMonitorRunner = new JobMonitorRunner();
            jobMonitorRunnerThread = new Thread(this.jobMonitorRunner);
            jobMonitorRunnerThread.setName("JobMonitorRunner");
            jobMonitorRunnerThread.start();
            this.runnerIsActive = true;
        }
    }

    @Override
    public void loadLateStartJobMonitor(JobHistory jobHistory) throws EndJobException, DataException, ResourceUnavailableException {
        ScheduleJobMonitorProxy scheduleJobMonitorProxy = scheduleJobDM.getScheduleJobMonitorProxy(jobHistory.getJobID());
        if (scheduleJobMonitorProxy.isLateStartMonitorSelected()) {
            this.jobMonitorRunner.lateStartJobEnqueued(jobHistory);
        }
    }

    @Override
    public boolean isMonitorStopped() {
        return !this.runnerIsActive && !this.processorIsActive;
    }

    @Override
    public void stopJobMonitorProcesses() {
        this.stopJobMonitorEventProcessor();
        this.stopJobMonitorRunner();
    }

    private void stopJobMonitorRunner() {
        this.jobMonitorRunner.shutdown = true;
        if (jobMonitorRunnerThread != null && jobMonitorRunnerThread.isAlive()) {
            jobMonitorRunnerThread.interrupt();
        }
    }

    private void stopJobMonitorEventProcessor() {
        if (eventProcessorThread != null && eventProcessorThread.isAlive()) {
            eventProcessorThread.interrupt();
        }
    }

    @Override
    public void jobHasStarted(JobHistory jobHistory) {
        logger.debug((Object)("Job with Job History ID " + jobHistory.getId() + " has started."));
        try {
            Object object;
            ScheduleJobMonitorProxy scheduleJobMonitorProxy = scheduleJobDM.getScheduleJobMonitorProxy(jobHistory.getJobID());
            if (scheduleJobMonitorProxy.isUnderrunMonitorSelected()) {
                object = this.createJobMonitor(JobMonitor.MonitorType.UNDERRUN, jobHistory);
                try {
                    this.jobMonitorDM.save((JobMonitor)((Object)object));
                    this.notifyMonitorAsNeeded((JobMonitor)((Object)object));
                }
                catch (Exception exception) {
                    logger.error((Object)("Error saving Underrun Job Monitor record for jobID:" + jobHistory.getJobID() + " agentID:" + jobHistory.getAgentID() + " startedTime:" + ((JobMonitor)((Object)object)).getJobStartTime()), (Throwable)exception);
                }
            }
            if (scheduleJobMonitorProxy.isOverrunMonitorSelected() && (!jobHistory.isManuallyStarted() || scheduleJobMonitorProxy.getOverrunMonitorOption() != JobMonitor.MonitorOption.TARGET_TIME)) {
                object = this.createJobMonitor(JobMonitor.MonitorType.OVERRUN, jobHistory);
                try {
                    this.jobMonitorDM.save((JobMonitor)((Object)object));
                    this.notifyMonitorAsNeeded((JobMonitor)((Object)object));
                }
                catch (Exception exception) {
                    logger.error((Object)("Error saving Overrun Job Monitor record for jobID:" + jobHistory.getJobID() + " agentID:" + jobHistory.getAgentID() + " startedTime:" + ((JobMonitor)((Object)object)).getJobStartTime()), (Throwable)exception);
                }
            }
            if (scheduleJobMonitorProxy.isLateStartMonitorSelected()) {
                object = Calendar.getInstance();
                ((Calendar)object).setTimeInMillis(jobHistory.getScheduledTime());
                try {
                    AgentGroupProxy agentGroupProxy;
                    int n;
                    JobMonitor jobMonitor = this.createJobMonitor(JobMonitor.MonitorType.LATESTART, jobHistory, true);
                    if (jobHistory.isJobSuite()) {
                        jobMonitor.setJobSuiteHistoryID(0L);
                    }
                    if ((n = this.deleteJobMonitor(jobMonitor, scheduleJobMonitorProxy.getSkybotJobName())) == 0 && jobMonitor.getAgentID() != 0L && scheduleJobMonitorProxy.getTargetType().equals(ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode()) && ((agentGroupProxy = this.agentGroupDM.getProxy(scheduleJobMonitorProxy.getTargetID())).getAgentGroupType() == AgentGroupType.PREFERRED_AGENT || agentGroupProxy.getAgentGroupType() == AgentGroupType.UTILIZATION_BALANCED)) {
                        jobMonitor.setAgentID(jobHistory.getAgentID());
                        n = this.deleteJobMonitor(jobMonitor, scheduleJobMonitorProxy.getSkybotJobName());
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)("Error deleting Late Start Job Monitor record for jobID:" + jobHistory.getJobID() + " agentID:" + jobHistory.getAgentID() + " scheduledTime:" + jobHistory.getScheduledTime()), (Throwable)exception);
                }
            }
            if (jobHistory.isJobSuite()) {
                this.suiteStarted(jobHistory);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error getting ScheduleJob for jobID:" + jobHistory.getJobID() + ". No Job Monitors will be handled."), (Throwable)exception);
        }
    }

    private String getNewMonitorLogString(JobMonitor jobMonitor, String string) {
        String string2 = "";
        switch (jobMonitor.getMonitorType()) {
            case UNDERRUN: 
            case OVERRUN: {
                string2 = jobMonitor.getMonitorType().name() + " job monitor created for job history ID " + jobMonitor.getJobHistoryID() + " of job " + string + "(" + jobMonitor.getJobID() + "): Started Time = " + this.getDateTimeString(jobMonitor.getJobStartTime()) + "  Monitor Time = " + this.getDateTimeString(jobMonitor.getMonitorTime());
                break;
            }
            case LATESTART: {
                string2 = jobMonitor.getMonitorType().name() + " job monitor created for job " + string + "(" + jobMonitor.getJobID() + ")";
                if (jobMonitor.getJobHistoryID() > 0L) {
                    string2 = string2 + " with job history ID " + jobMonitor.getJobHistoryID();
                }
                string2 = string2 + " on agent " + jobMonitor.getAgentID() + ": Scheduled Time = " + this.getDateTimeString(jobMonitor.getScheduledTime()) + "  Monitor Time = " + this.getDateTimeString(jobMonitor.getMonitorTime());
                break;
            }
        }
        return string2;
    }

    private String getDateTimeString(long l) {
        String string = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        String string2 = "";
        String string3 = "";
        string2 = numberFormatter.format(calendar.get(12));
        string3 = numberFormatter.format(calendar.get(13));
        string = calendar.get(1) + "." + (calendar.get(2) + 1) + "." + calendar.get(5) + " at " + calendar.get(11) + ":" + string2 + ":" + string3;
        return string;
    }

    @Override
    public void jobHasCompleted(JobHistory jobHistory, boolean bl) {
        Object object;
        long l = jobHistory.getId();
        if (logger.isDebugEnabled()) {
            object = "Job with JobHistoryOID " + l + " has ended.";
            if (!bl) {
                object = (String)object + " It did not run.";
            }
            logger.debug(object);
        }
        try {
            for (JobMonitor jobMonitor : object = this.jobMonitorDM.get(l)) {
                switch (jobMonitor.getMonitorType()) {
                    case UNDERRUN: {
                        this.processJobMonitorEventOccurred(jobMonitor);
                    }
                    case OVERRUN: 
                    case LATESTART: {
                        logger.debug((Object)("About to delete " + jobMonitor.getMonitorType().name() + " job monitor for JobHistoryID " + l));
                        this.jobMonitorDM.delete(jobMonitor);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error attempting to get Job Monitors for jobHistoryOID " + l + " which has ended."));
        }
        if (jobHistory.isJobSuite()) {
            this.suiteEnded(jobHistory);
        }
    }

    @Override
    public void jobWasTerminated(long l) {
        this.deleteAllJobMonitors(l);
    }

    private void deleteAllJobMonitors(long l) {
        logger.debug((Object)("About to delete all loaded job monitors for jobHistoryID " + l));
        try {
            this.jobMonitorDM.deleteAllJobMonitorsForJobHistoryID(l);
        }
        catch (Exception exception) {
            logger.error((Object)("Error attempting to delete Job Monitors for jobHistoryID " + l + "."));
        }
    }

    @Override
    public void postJobMonitorEvent(JobMonitorEvent jobMonitorEvent) {
        this.getQueue().offer(jobMonitorEvent);
    }

    private BlockingQueue<JobMonitorEvent> getQueue() {
        if (eventQueue == null) {
            eventQueue = new LinkedBlockingQueue<JobMonitorEvent>();
        }
        return eventQueue;
    }

    @Override
    public void lateStartNSTAddedOrReplaced(long l, long l2, Calendar calendar) {
        logger.debug((Object)("Received notification of NST added or replaced for jobID:" + l + " agentID:" + l2 + " scheduledTime:" + this.getDateTimeString(calendar.getTimeInMillis())));
        try {
            JobMonitor jobMonitor = this.createJobMonitor(JobMonitor.MonitorType.LATESTART, l, l2, calendar);
            long l3 = System.currentTimeMillis();
            if (jobMonitor.getMonitorTime() <= l3) {
                logger.debug((Object)("Late Start time for jobID:" + l + " agentID:" + l2 + " scheduledTime:" + this.getDateTimeString(calendar.getTimeInMillis()) + " is in the past.  Disregarding this notice."));
                return;
            }
            this.jobMonitorDM.save(jobMonitor);
            this.notifyMonitorAsNeeded(jobMonitor);
        }
        catch (Exception exception) {
            logger.error((Object)("Error attempting to save a new Late Start Job Monitor.  No Late Start Monitor will be started for jobID " + l), (Throwable)exception);
        }
    }

    @Override
    public void lateStartNSTUnknown(long l, long l2, Calendar calendar) {
        logger.debug((Object)("Job Monitor for jobID:" + l + " agentID:" + l2 + " scheduledTime:" + this.getDateTimeString(calendar.getTimeInMillis()) + " has been invalidated and will be removed."));
        JobMonitor jobMonitor = new JobMonitor(0L, 0L, l, l2, null, null, calendar.getTimeInMillis(), 0L);
        this.deleteJobMonitor(jobMonitor);
    }

    @Override
    public void lateStartNSTRemoved(long l) {
        logger.debug((Object)("Received notification that the jobID " + l + " is either no longer scheduled to run or the Agent/Group setting" + " has changed."));
        try {
            this.jobMonitorDM.deleteAllNonQueuedLateStartJMs(l);
        }
        catch (Exception exception) {
            logger.error((Object)"Error deleting a JobMonitor from the table. ", (Throwable)exception);
        }
    }

    @Override
    public void lateStartMonitorsAddedOrChanged(long l, long l2) {
        logger.debug((Object)("Received notification that the Job Monitor was modified for jobID " + l + " and targetID " + l2));
        try {
            JobMonitor[] jobMonitorArray = this.jobMonitorDM.getNonQueuedLSJMs(l);
            if (jobMonitorArray.length > 0) {
                for (int i = 0; i < jobMonitorArray.length; ++i) {
                    JobMonitor jobMonitor = jobMonitorArray[i];
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(jobMonitor.getScheduledTime());
                    this.lateStartNSTUpdated(l, jobMonitor.getAgentID(), calendar, calendar);
                }
            } else {
                ScheduleInfo scheduleInfo = this.scheduleInfoDM.get((int)l);
                if (scheduleInfo != null) {
                    if (scheduleInfo.getTargetType() == null) {
                        logger.debug((Object)("Processing Late Start record for Job Suite: " + l));
                        ScheduledTime scheduledTime = this.scheduledTimeDM.get((int)l, scheduleInfo.getTargetID());
                        Calendar calendar = scheduledTime.getNextScheduledTime();
                        calendar.setTimeZone(TimeZone.getDefault());
                        this.lateStartNSTAddedOrReplaced(l, scheduleInfo.getTargetID(), calendar);
                    } else if (scheduleInfo.getTargetType().equals(ScheduleInfo.TargetType.AGENT_GROUP)) {
                        logger.debug((Object)("Processing Late Start records for all Agents in the Agent Group " + l2 + "."));
                        AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(l2);
                        long[] lArray = new long[]{0L};
                        if (agentGroupProxy.getAgentGroupType() == AgentGroupType.PREFERRED_AGENT || agentGroupProxy.getAgentGroupType() == AgentGroupType.UTILIZATION_BALANCED) {
                            logger.debug((Object)("Processing Late Start records for TBD agent in the Agent Group " + l2 + " with type " + agentGroupProxy.getAgentGroupType() + "."));
                        } else {
                            logger.debug((Object)("Processing Late Start records for ALL agents in the Agent Group " + l2 + "."));
                            lArray = this.agentGroupDM.getAgentsIDsInGroup(scheduleInfo.getTargetID(), null);
                        }
                        for (int i = 0; i < lArray.length; ++i) {
                            ScheduledTime scheduledTime = this.scheduledTimeDM.get((int)l, (int)lArray[i]);
                            Calendar calendar = scheduledTime.getNextScheduledTime();
                            calendar.setTimeZone(TimeZone.getDefault());
                            this.lateStartNSTAddedOrReplaced(l, lArray[i], calendar);
                        }
                    } else {
                        ScheduledTime scheduledTime = this.scheduledTimeDM.get((int)l, scheduleInfo.getTargetID());
                        Calendar calendar = scheduledTime.getNextScheduledTime();
                        calendar.setTimeZone(TimeZone.getDefault());
                        this.lateStartNSTAddedOrReplaced(l, scheduleInfo.getTargetID(), calendar);
                    }
                } else {
                    logger.debug((Object)("Disregarding Late Start monitor for jobID " + l + " since job is not scheduled."));
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error updating existing records for a Late Start Job Monitor or Late Start Monitor added.", (Throwable)exception);
        }
    }

    @Override
    public void lateStartMonitorAgentChanged(long l, long l2, long l3) {
        logger.debug((Object)"Notified of Agent Change on Late Start Monitor.");
        try {
            int n = this.jobMonitorDM.updateAgentOnLateStart(l, l2, l3);
            logger.debug((Object)(n + " Late Start Monitor(s) updated with new Agent."));
        }
        catch (Exception exception) {
            logger.error((Object)"Error updating agent on non-queued Late Start Monitors. ", (Throwable)exception);
        }
    }

    @Override
    public void lateStartNSTUpdated(long l, long l2, Calendar calendar, Calendar calendar2) {
        logger.debug((Object)("Received notification of NST and/or LST updated for jobID " + l + " agentID " + l2 + ".  Old Scheduled Time: " + this.getDateTimeString(calendar.getTimeInMillis()) + " New Scheduled Time: " + this.getDateTimeString(calendar2.getTimeInMillis())));
        int n = 0;
        try {
            JobMonitor jobMonitor = this.createJobMonitor(JobMonitor.MonitorType.LATESTART, l, l2, calendar2);
            n = this.jobMonitorDM.updateTimes(l, l2, calendar.getTimeInMillis(), calendar2.getTimeInMillis(), jobMonitor.getMonitorTime());
            if (n == 0) {
                logger.debug((Object)"Adding as new record.");
                this.jobMonitorDM.save(jobMonitor);
            }
            this.notifyMonitorAsNeeded(jobMonitor);
        }
        catch (Exception exception) {
            logger.error((Object)"Error updating existing record for a new scheduled time or Late Start Monitor added.", (Throwable)exception);
        }
    }

    @Override
    public void lateStartMonitorNotSelected(long l) {
        logger.debug((Object)("Received notification of late start monitor not selected for jobID " + l));
        try {
            logger.debug((Object)("About to delete all Late Start Job Monitors for jobID " + l + "."));
            this.jobMonitorDM.deleteAllLateStartJMs(l);
            return;
        }
        catch (Exception exception) {
            logger.error((Object)"Error attempting to remove Late Start Job Monitors. ", (Throwable)exception);
            return;
        }
    }

    @Override
    public void jobIsHeld(int n, int n2, Calendar calendar) {
        logger.debug((Object)("Received notification that jobID " + n + " for Agent " + n2 + " scheduled to run on " + this.getDateTimeString(calendar.getTimeInMillis()) + " is on hold."));
        JobMonitor jobMonitor = new JobMonitor(0L, 0L, n, n2, JobMonitor.MonitorType.LATESTART, null, calendar.getTimeInMillis(), 0L);
        this.deleteJobMonitor(jobMonitor);
    }

    @Override
    public void jobIgnored(int n, int n2, Calendar calendar) {
        logger.debug((Object)("Received notification that jobID " + n + " for Agent " + n2 + " scheduled to run on " + this.getDateTimeString(calendar.getTimeInMillis()) + " will be ignored."));
        JobMonitor jobMonitor = new JobMonitor(0L, 0L, n, n2, JobMonitor.MonitorType.LATESTART, null, calendar.getTimeInMillis(), 0L);
        this.deleteJobMonitor(jobMonitor);
    }

    @Override
    public void jobSkipped(int n, int n2, Calendar calendar) {
        logger.debug((Object)("Received notification that jobID " + n + " for Agent " + n2 + " scheduled to run on " + this.getDateTimeString(calendar.getTimeInMillis()) + " will be skipped."));
        JobMonitor jobMonitor = new JobMonitor(0L, 0L, n, n2, JobMonitor.MonitorType.LATESTART, null, calendar.getTimeInMillis(), 0L);
        this.deleteJobMonitor(jobMonitor);
    }

    @Override
    public void jobDeleted(long l) {
        logger.debug((Object)("Received notification of jobID " + l + " being deleted."));
        try {
            logger.debug((Object)("About to delete all loaded Job Monitor records for jobID " + l + "."));
            this.jobMonitorDM.deleteAllJobMonitorsForJobID(l);
            return;
        }
        catch (Exception exception) {
            logger.error((Object)"Error attempting to remove Job Monitors. ", (Throwable)exception);
            return;
        }
    }

    @Override
    public void lateStartNSTAgentsDroppedFromAgentGroup(long l, ArrayList<Long> arrayList) {
        logger.debug((Object)("Received notification of " + arrayList.size() + " agent(s) being removed from the Agent Group assigned to jobID " + l + "."));
        try {
            logger.debug((Object)("About to delete all loaded Job Monitor records for " + arrayList.size() + " agent(s) assigned to jobID " + l + "."));
            Iterator<Long> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.jobMonitorDM.deleteAllNonQueuedLateStartJMs(l, iterator.next());
            }
            return;
        }
        catch (Exception exception) {
            logger.error((Object)"Error attempting to remove Job Monitors. ", (Throwable)exception);
            return;
        }
    }

    private void notifyMonitorAsNeeded(JobMonitor jobMonitor) {
        if (this.jobMonitorRunner.isWaitingForMonitorTime()) {
            if (jobMonitor.getMonitorTime() < this.jobMonitorRunner.getEarliestJobMonitor().getMonitorTime()) {
                this.jobMonitorRunner.restartForNewMonitorTime();
            }
        } else {
            this.jobMonitorRunner.restartForNewMonitorTime();
        }
    }

    private JobMonitor createJobMonitor(JobMonitor.MonitorType monitorType, JobHistory jobHistory) throws DataException, ResourceUnavailableException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(jobHistory.getScheduledTime());
        JobMonitor jobMonitor = this.createJobMonitor(monitorType, jobHistory.getJobID(), jobHistory.getAgentID(), calendar, jobHistory.getId(), jobHistory.getJobSuiteHistoryID(), false, null);
        return jobMonitor;
    }

    private JobMonitor createJobMonitor(JobMonitor.MonitorType monitorType, JobHistory jobHistory, boolean bl) throws DataException, ResourceUnavailableException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(jobHistory.getScheduledTime());
        JobMonitor jobMonitor = this.createJobMonitor(monitorType, jobHistory.getJobID(), jobHistory.getAgentID(), calendar, jobHistory.getId(), jobHistory.getJobSuiteHistoryID(), bl, null);
        return jobMonitor;
    }

    private JobMonitor createJobMonitor(JobMonitor.MonitorType monitorType, long l, long l2, Calendar calendar) throws DataException, ResourceUnavailableException {
        return this.createJobMonitor(monitorType, l, l2, calendar, 0L, 0L, false, null);
    }

    private JobMonitor createJobMonitor(JobMonitor.MonitorType monitorType, long l, long l2, Calendar calendar, long l3, long l4, boolean bl, ScheduleJobMonitorProxy scheduleJobMonitorProxy) throws DataException, ResourceUnavailableException {
        JobMonitor jobMonitor = new JobMonitor(l3, l4, l, l2, monitorType, calendar.getTimeInMillis());
        Calendar calendar2 = (Calendar)calendar.clone();
        ScheduleJobMonitorProxy scheduleJobMonitorProxy2 = scheduleJobMonitorProxy;
        if (scheduleJobMonitorProxy2 == null) {
            scheduleJobMonitorProxy2 = scheduleJobDM.getScheduleJobMonitorProxy(l);
        }
        JobMonitor.MonitorOption monitorOption = JobMonitor.MonitorOption.RUN_DURATION;
        block0 : switch (monitorType) {
            case UNDERRUN: {
                monitorOption = JobMonitor.MonitorOption.RUN_DURATION;
                jobMonitor.setJobStarted(true);
                calendar2.setTimeInMillis(jobMonitor.getJobStartTime());
                int n = scheduleJobMonitorProxy2.getUnderrunMinimumMinutes();
                calendar2.add(12, n);
                break;
            }
            case OVERRUN: {
                monitorOption = scheduleJobMonitorProxy2.getOverrunMonitorOption();
                jobMonitor.setJobStarted(true);
                calendar2.setTimeInMillis(jobMonitor.getJobStartTime());
                switch (monitorOption) {
                    case NONE: {
                        monitorOption = JobMonitor.MonitorOption.RUN_DURATION;
                        logger.error((Object)("An invalid MonitorOption of " + scheduleJobMonitorProxy2.getOverrunMonitorOption().name() + " was passed for an overrun job monitor." + "  Setting to RUN_DURATION."));
                    }
                    case RUN_DURATION: {
                        int n = scheduleJobMonitorProxy2.getOverrunMaximumMinutes();
                        calendar2.add(12, n);
                        break block0;
                    }
                    case TARGET_TIME: {
                        int n = scheduleJobMonitorProxy2.getOverrunTargetCompletionTime();
                        int n2 = n / 100;
                        int n3 = n - n2 * 100;
                        calendar2.setTimeZone(this.timezone(scheduleJobMonitorProxy2, l2));
                        calendar2.set(11, n2);
                        calendar2.set(12, n3);
                        calendar2.set(13, 0);
                        if (!calendar2.before(calendar)) break block0;
                        calendar2.add(5, 1);
                        break block0;
                    }
                }
                logger.error((Object)("An invalid MonitorOption of " + scheduleJobMonitorProxy2.getOverrunMonitorOption().name() + " was passed for an overrun job monitor."));
                break;
            }
            case LATESTART: {
                monitorOption = scheduleJobMonitorProxy2.getLateStartMonitorOption();
                switch (monitorOption) {
                    case NONE: {
                        monitorOption = JobMonitor.MonitorOption.RUN_DURATION;
                        logger.error((Object)("An invalid MonitorOption of " + scheduleJobMonitorProxy2.getLateStartMonitorOption().name() + " was passed for a late start job monitor." + "  Setting to RUN_DURATION."));
                    }
                    case RUN_DURATION: {
                        int n = scheduleJobMonitorProxy2.getLateStartMaximumMinutes();
                        calendar2.add(12, n);
                        break block0;
                    }
                    case TARGET_TIME: {
                        int n = scheduleJobMonitorProxy2.getLateStartTargetStartTime();
                        int n4 = n / 100;
                        int n5 = n - n4 * 100;
                        calendar2.setTimeZone(this.timezone(scheduleJobMonitorProxy2, l2));
                        calendar2.set(11, n4);
                        calendar2.set(12, n5);
                        calendar2.set(13, 0);
                        if (!calendar2.before(calendar)) break block0;
                        calendar2.add(5, 1);
                        int n6 = calendar2.get(5);
                        int n7 = calendar2.get(2) + 1;
                        logger.trace((Object)("Adding 1 day to the target monitor time.  Now it is " + n7 + "/" + n6));
                        break block0;
                    }
                }
                logger.error((Object)("An invalid MonitorOption of " + scheduleJobMonitorProxy2.getLateStartMonitorOption().name() + " was passed for a late start job monitor."));
                break;
            }
        }
        jobMonitor.setMonitorTime(calendar2.getTimeInMillis());
        jobMonitor.setMonitorOption(monitorOption);
        if (!bl) {
            logger.debug((Object)this.getNewMonitorLogString(jobMonitor, scheduleJobMonitorProxy2.getSkybotJobName()));
        }
        return jobMonitor;
    }

    private JobMonitorEvent processJobMonitorEventOccurred(JobMonitor jobMonitor) {
        JobMonitorEvent jobMonitorEvent = new JobMonitorEvent(jobMonitor);
        ScheduleJobMonitorProxy scheduleJobMonitorProxy = null;
        try {
            scheduleJobMonitorProxy = scheduleJobDM.getScheduleJobMonitorProxy(jobMonitor.getJobID());
            jobMonitorEvent.setJobType(scheduleJobMonitorProxy.getJobType());
            if (jobMonitorEvent.getJobType() != JobType.SUITE) {
                Proxy proxy;
                if (scheduleJobMonitorProxy.getTargetType().equals(ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode())) {
                    proxy = this.agentGroupDM.get(scheduleJobMonitorProxy.getTargetID());
                    jobMonitorEvent.setAgentGroupOID(scheduleJobMonitorProxy.getTargetID());
                    jobMonitorEvent.setAgentGroupName(proxy.getName());
                    if (jobMonitor.getAgentID() == 0L) {
                        jobMonitorEvent.setAgentName(Agent.getTBDInGroupAgentName(proxy.getName()));
                    }
                }
                if (jobMonitor.getAgentID() != 0L) {
                    proxy = this.agentDM.get(jobMonitor.getAgentID());
                    jobMonitorEvent.setAgentName(proxy.getName());
                }
            }
            if (jobMonitor.getJobHistoryID() == 0L && jobMonitor.getJobSuiteHistoryID() == 0L) {
                if (!scheduleJobMonitorProxy.isScheduleTypeJob()) {
                    throw new InvalidStateException("The monitored job is no longer scheduled.");
                }
                if (scheduleJobMonitorProxy.isJobHeld()) {
                    throw new InvalidStateException("The monitored job is on hold.");
                }
                if (jobMonitor.getScheduledTime() == jobMonitor.getMonitorTime()) {
                    throw new InvalidStateException("Scheduled time and monitor time are equal.");
                }
            }
            long l = jobMonitor.getJobSuiteHistoryID();
            jobMonitorEvent.setJobSuiteHistoryID(l);
            if (l != 0L) {
                try {
                    JobHistory jobHistory = this.jobHistoryDM.get(l);
                    jobMonitorEvent.setJobSuiteMemberJobID(jobHistory.getJobSuiteMemberID());
                    jobMonitorEvent.setJobSuiteID(jobHistory.getJobID());
                    if (jobMonitorEvent.getJobType() != JobType.SUITE) {
                        jobMonitorEvent.setJobSuiteName(jobHistory.getJobName());
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)"Error loading job suite information.", (Throwable)exception);
                }
            }
            jobMonitorEvent.setRuntimeJobName(scheduleJobMonitorProxy.getName());
            this.setActionsAndActionData(jobMonitorEvent, jobMonitor.getMonitorType(), scheduleJobMonitorProxy);
            jobMonitorEvent.setNotificationListID(this.getNotificationListID(jobMonitor.getMonitorType(), scheduleJobMonitorProxy));
        }
        catch (InvalidStateException invalidStateException) {
            logger.debug((Object)(jobMonitorEvent.getEventTypeDescription() + " Monitor for JobID " + jobMonitor.getJobID() + " with scheduled time " + this.getDateTimeString(jobMonitor.getScheduledTime()) + " was canceled.  " + invalidStateException.getMessage()));
            return jobMonitorEvent;
        }
        catch (Exception exception) {
            logger.error((Object)(jobMonitorEvent.getEventTypeDescription() + " Monitor for Job run number " + jobMonitor.getJobHistoryID() + " was canceled due to errors."), (Throwable)exception);
            return jobMonitorEvent;
        }
        int n = this.processJobMonitorEventActions(jobMonitorEvent, jobMonitor, scheduleJobMonitorProxy);
        jobMonitorEvent.setActions(n);
        this.postJobMonitorEvent(jobMonitorEvent);
        return jobMonitorEvent;
    }

    private void setActionsAndActionData(JobMonitorEvent jobMonitorEvent, JobMonitor.MonitorType monitorType, ScheduleJobMonitorProxy scheduleJobMonitorProxy) {
        int n = 0;
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (monitorType) {
            case UNDERRUN: {
                logger.debug((Object)("Underrun occurred for job history ID " + jobMonitorEvent.getJobRunID() + " of job " + scheduleJobMonitorProxy.getSkybotJobName() + "(" + jobMonitorEvent.getJobID() + ")."));
                if (scheduleJobMonitorProxy.isUnderrunSendEmail()) {
                    bl2 = true;
                }
                bl4 = scheduleJobMonitorProxy.isUnderrunSendSNMPTrap();
                break;
            }
            case OVERRUN: {
                logger.debug((Object)("Overrun occurred for job history ID " + jobMonitorEvent.getJobRunID() + " of job " + scheduleJobMonitorProxy.getSkybotJobName() + "(" + jobMonitorEvent.getJobID() + ")."));
                bl = scheduleJobMonitorProxy.isOverrunEndJob();
                if (scheduleJobMonitorProxy.isOverrunSendEmail()) {
                    bl2 = true;
                }
                bl4 = scheduleJobMonitorProxy.isOverrunSendSNMPTrap();
                break;
            }
            case LATESTART: {
                long l = jobMonitorEvent.getJobRunID();
                if (l != 0L) {
                    bl = scheduleJobMonitorProxy.isLateStartEndJob();
                }
                String string2 = "Late Start occurred for job " + scheduleJobMonitorProxy.getSkybotJobName() + "(" + jobMonitorEvent.getJobID() + ") scheduled to run on " + this.getDateTimeString(jobMonitorEvent.getScheduledTime());
                string2 = l != 0L ? string2 + " with job history ID " + l : string2 + ".  The job was never submitted.";
                logger.debug((Object)string2);
                if (scheduleJobMonitorProxy.isLateStartSendEmail()) {
                    bl2 = true;
                }
                bl4 = scheduleJobMonitorProxy.isLateStartSendSNMPTrap();
                break;
            }
        }
        if (bl) {
            n = 256;
            string = string + " Ending Job.";
        }
        if (bl2) {
            if (bl) {
                n = 272;
                bl3 = true;
            } else {
                n = 16;
            }
            string = string + " Sending email.";
        }
        if (bl4) {
            n = bl3 ? 273 : (bl ? 257 : (bl2 ? 17 : 1));
            string = string + " Sending SNMP Trap.";
        }
        jobMonitorEvent.setActions(n);
        jobMonitorEvent.setActionData(string);
    }

    private long getNotificationListID(JobMonitor.MonitorType monitorType, ScheduleJobMonitorProxy scheduleJobMonitorProxy) {
        long l = 0L;
        switch (monitorType) {
            case UNDERRUN: {
                l = scheduleJobMonitorProxy.getUnderrunNotificationListID();
                break;
            }
            case OVERRUN: {
                l = scheduleJobMonitorProxy.getOverrunNotificationListID();
                break;
            }
            case LATESTART: {
                l = scheduleJobMonitorProxy.getLateStartNotificationListID();
                break;
            }
        }
        return l;
    }

    private int processJobMonitorEventActions(JobMonitorEvent jobMonitorEvent, JobMonitor jobMonitor, ScheduleJobMonitorProxy scheduleJobMonitorProxy) {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        Object object2;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ScheduleLogEntry scheduleLogEntry = null;
        String string = ScheduleLogger.formatTimeStamp(jobMonitorEvent.getScheduledTime());
        String string2 = "";
        switch (jobMonitorEvent.getJobType()) {
            case JOB: {
                string2 = "Job";
                break;
            }
            case SUITE: {
                string2 = "Job Suite";
                break;
            }
            case SUITE_MEMBER: {
                string2 = "Job Suite Member";
                break;
            }
            default: {
                string2 = "'Undefined Job Type'";
            }
        }
        String string3 = String.valueOf(jobMonitorEvent.getJobRunID());
        String string4 = String.valueOf(jobMonitorEvent.getJobSuiteHistoryID());
        if (jobMonitor.getMonitorType().equals(JobMonitor.MonitorType.LATESTART)) {
            if (string3.equals("0")) {
                object2 = new String[]{jobMonitorEvent.getEventTypeDescription(), jobMonitorEvent.getRuntimeJobName(), jobMonitorEvent.getAgentName(), string, string4};
                switch (jobMonitorEvent.getJobType()) {
                    case SUITE: {
                        scheduleLogEntry = RosettaMsg.JOB_SUITE_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME.newLogEntry((String[])object2);
                        break;
                    }
                    case SUITE_MEMBER: {
                        scheduleLogEntry = RosettaMsg.JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME.newLogEntry((String[])object2);
                        break;
                    }
                    default: {
                        scheduleLogEntry = RosettaMsg.JOB_MONITOR_EVENT_OCCURRED_LATE_START_NO_RUNTIME.newLogEntry((String[])object2);
                        break;
                    }
                }
            } else {
                object2 = new String[]{jobMonitorEvent.getEventTypeDescription(), jobMonitorEvent.getRuntimeJobName(), string3, jobMonitorEvent.getAgentName(), string, string4};
                switch (jobMonitorEvent.getJobType()) {
                    case SUITE: {
                        scheduleLogEntry = RosettaMsg.JOB_SUITE_MONITOR_EVENT_OCCURRED_LATE_START.newLogEntry((String[])object2);
                        break;
                    }
                    case SUITE_MEMBER: {
                        scheduleLogEntry = RosettaMsg.JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED_LATE_START.newLogEntry((String[])object2);
                        break;
                    }
                    default: {
                        scheduleLogEntry = RosettaMsg.JOB_MONITOR_EVENT_OCCURRED_LATE_START.newLogEntry((String[])object2);
                        break;
                    }
                }
            }
        } else {
            object2 = new String[]{jobMonitorEvent.getEventTypeDescription(), jobMonitorEvent.getRuntimeJobName(), string3, jobMonitorEvent.getAgentName(), string4};
            switch (jobMonitorEvent.getJobType()) {
                case SUITE: {
                    scheduleLogEntry = RosettaMsg.JOB_SUITE_MONITOR_EVENT_OCCURRED.newLogEntry((String[])object2);
                    break;
                }
                case SUITE_MEMBER: {
                    scheduleLogEntry = RosettaMsg.JOB_SUITE_MEMBER_MONITOR_EVENT_OCCURRED.newLogEntry((String[])object2);
                    break;
                }
                default: {
                    scheduleLogEntry = RosettaMsg.JOB_MONITOR_EVENT_OCCURRED.newLogEntry((String[])object2);
                }
            }
        }
        scheduleLogEntry.setAgentID(jobMonitorEvent.getAgentID());
        scheduleLogEntry.setJobID(jobMonitorEvent.getJobID());
        scheduleLogEntry.setJobHistoryID(jobMonitorEvent.getJobRunID());
        ScheduleLogger.write(scheduleLogEntry);
        object2 = "";
        if (jobMonitorEvent.isActionEnd()) {
            logger.debug((Object)("About to end " + string2 + " with Job History ID " + jobMonitor.getJobHistoryID()));
            try {
                stringArray2 = new StringBuffer(string2 + " Monitor");
                switch (jobMonitor.getMonitorTypeAsInt()) {
                    case 1: {
                        stringArray2.append(" Underrun");
                        break;
                    }
                    case 2: {
                        stringArray2.append(" Overrun");
                        break;
                    }
                    case 3: {
                        stringArray2.append(" Latestart");
                        break;
                    }
                    default: {
                        stringArray2.append(" Unknown type");
                    }
                }
                object2 = stringArray2.toString();
                switch (jobMonitorEvent.getJobType()) {
                    case SUITE: {
                        this.getJobSuiteAM().terminateSuite(jobMonitor.getJobHistoryID(), JobSuiteStatus.CANCELED, (String)object2, true);
                        break;
                    }
                    default: {
                        this.getJobTrackerAM().terminateJobViaJobMonitor(jobMonitor.getJobHistoryID(), JobStatusCode.CANCELED, (String)object2);
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                if (exception instanceof EndJobException) {
                    if (((EndJobException)exception).getReason().equals((Object)EndJobException.Reason.MISSED_PROCESS_HISTORY)) {
                        logger.debug((Object)("Job History ID " + string3 + " was created by the missed job process and never actually ran.  " + exception.getMessage()));
                    } else if (((EndJobException)exception).getReason().equals((Object)EndJobException.Reason.MANAGED_STATUS)) {
                        logger.debug((Object)("Job Monitor is unable to end the " + string2 + ".  " + exception.getMessage()));
                    } else if (((EndJobException)exception).getReason().equals((Object)EndJobException.Reason.JOB_NOT_ACTIVE)) {
                        logger.debug((Object)("Job Monitor is unable to end the " + string2 + " because it is not active."), (Throwable)exception);
                    } else {
                        logger.warn((Object)"Failed to end job.", (Throwable)exception);
                        bl = true;
                    }
                } else {
                    logger.error((Object)("Error terminating " + string2 + " " + jobMonitor.getJobHistoryID() + " via Job Monitor. "), (Throwable)exception);
                }
                logger.warn((Object)("The Job Monitors for JobHistoryID " + jobMonitor.getJobHistoryID() + " will be removed from the database as a result of an exception. " + " See previous messages."));
                this.deleteAllJobMonitors(jobMonitor.getJobHistoryID());
            }
        }
        if (jobMonitorEvent.isActionEmail() && jobMonitorEvent.getNotificationListID() > 0L) {
            stringArray2 = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
            stringArray = null;
            try {
                stringArray = stringArray2.get(jobMonitorEvent.getNotificationListID()).getListOfUniqueEmails();
            }
            catch (Exception exception) {
                logger.error((Object)"Error retrieving Job Monitor Notification Options.", (Throwable)exception);
            }
            if (stringArray != null && stringArray.length > 0) {
                object = scheduleLogEntry.getMessageText();
                EmailInformation emailInformation = new EmailInformation((String)object, (String)object);
                try {
                    switch (jobMonitorEvent.getEventType()) {
                        case 2: {
                            emailInformation.setOverrideSubject(scheduleJobMonitorProxy.getEmailSubjectOverrun());
                            emailInformation.setOverrideBody(scheduleJobMonitorProxy.getEmailBodyOverrun());
                            break;
                        }
                        case 1: {
                            emailInformation.setOverrideSubject(scheduleJobMonitorProxy.getEmailSubjectUnderrun());
                            emailInformation.setOverrideBody(scheduleJobMonitorProxy.getEmailBodyUnderrun());
                            break;
                        }
                        case 3: {
                            emailInformation.setOverrideSubject(scheduleJobMonitorProxy.getEmailSubjectLatestart());
                            emailInformation.setOverrideBody(scheduleJobMonitorProxy.getEmailBodyLatestart());
                        }
                    }
                    emailInformation.replaceJobMonitorVariables(jobMonitor.getMonitorType().toString(), jobMonitorEvent.getAgentName(), jobMonitorEvent.getRuntimeJobName(), jobMonitor.getJobHistoryID(), jobMonitor.getScheduledTime());
                }
                catch (Exception exception) {
                    logger.error((Object)"Error preparing Job Monitor email subject/body.", (Throwable)exception);
                }
                this.sendEmail(stringArray, emailInformation.getFinalSubject(), emailInformation.getFinalBody());
                bl2 = true;
            }
        }
        if (jobMonitorEvent.isActionTrap()) {
            stringArray2 = null;
            switch (jobMonitorEvent.getJobType()) {
                case JOB: 
                case SUITE_MEMBER: {
                    stringArray = new JobMonitorSNMPTrap(jobMonitorEvent.getEventType());
                    stringArray.setJobID(jobMonitorEvent.getJobID());
                    stringArray.setJobName(jobMonitorEvent.getRuntimeJobName());
                    stringArray.setRunID(jobMonitorEvent.getJobRunID());
                    stringArray.setAgentID(jobMonitorEvent.getAgentID());
                    stringArray.setAgentName(jobMonitorEvent.getAgentName());
                    stringArray.setText(scheduleLogEntry.getMessageText());
                    stringArray2 = stringArray;
                    break;
                }
                case SUITE: {
                    object = new JobSuiteMonitorSNMPTrap(jobMonitorEvent.getEventType());
                    ((JobSuiteMonitorSNMPTrap)((Object)object)).setJobSuiteID(jobMonitorEvent.getJobID());
                    ((JobSuiteMonitorSNMPTrap)((Object)object)).setJobSuiteName(jobMonitorEvent.getRuntimeJobName());
                    ((JobSuiteMonitorSNMPTrap)((Object)object)).setJobSuiteRunID(jobMonitorEvent.getJobRunID());
                    ((EnterpriseSNMPTrap)((Object)object)).setText(scheduleLogEntry.getMessageText());
                    stringArray2 = object;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Undefined job type: " + jobMonitorEvent.getJobType());
                }
            }
            bl4 = this.sendSNMPTrap((EnterpriseSNMPTrap)stringArray2);
        }
        if (bl) {
            n = 256;
        }
        if (bl2) {
            if (bl) {
                n = 272;
                bl3 = true;
            } else {
                n = 16;
            }
        }
        if (bl4) {
            n = bl3 ? 273 : (bl ? 257 : (bl2 ? 17 : 1));
        }
        return n;
    }

    private JobTrackerAM getJobTrackerAM() {
        if (this.jobTrackerAM == null) {
            this.jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
        }
        return this.jobTrackerAM;
    }

    private JobSuiteAM getJobSuiteAM() {
        if (this.jobSuiteAM == null) {
            this.jobSuiteAM = (JobSuiteAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobSuiteAM");
        }
        return this.jobSuiteAM;
    }

    private boolean sendSNMPTrap(EnterpriseSNMPTrap enterpriseSNMPTrap) {
        logger.debug((Object)"Sending a Job Monitor SNMP Trap.");
        try {
            this.snmpTrapAM.sendSNMPTrap(enterpriseSNMPTrap);
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending a Job Monitor SNMP Trap.", (Throwable)exception);
            return false;
        }
    }

    private void sendEmail(String[] stringArray, String string, String string2) {
        logger.debug((Object)"Sending a Job Monitor email.");
        try {
            this.enterpriseEmailAM.sendMessage(stringArray, string, string2);
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending a Job Monitor email.", (Throwable)exception);
        }
    }

    private JobMonitor getNextJobMonitor() {
        try {
            JobMonitor jobMonitor = this.jobMonitorDM.getNext();
            return jobMonitor;
        }
        catch (Exception exception) {
            logger.error((Object)"Error getting next Late Start time for the Late Start Job Monitor.", (Throwable)exception);
            return new JobMonitor(null, JobMonitor.MonitorType.LATESTART, JobMonitor.MonitorOption.NONE, 0L);
        }
    }

    private int deleteJobMonitor(JobMonitor jobMonitor) {
        return this.deleteJobMonitor(jobMonitor, null);
    }

    private int deleteJobMonitor(JobMonitor jobMonitor, String string) {
        if (logger.isDebugEnabled()) {
            String string2 = "About to delete " + jobMonitor.getMonitorType().name() + " job monitor for job ";
            string2 = string != null ? string2 + string + "(" + jobMonitor.getJobID() + ")" : string2 + "ID " + jobMonitor.getJobID();
            string2 = string2 + " agentID:" + jobMonitor.getAgentID() + " scheduledTime:" + this.getDateTimeString(jobMonitor.getScheduledTime()) + " jobSuiteHistoryID: " + jobMonitor.getJobSuiteHistoryID();
            logger.debug((Object)string2);
        }
        try {
            return this.jobMonitorDM.delete(jobMonitor);
        }
        catch (Exception exception) {
            logger.error((Object)"Error deleting a JobMonitor from the table. ", (Throwable)exception);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMissedJobsProcessComplete(boolean bl) {
        this.missedJobsProcessComplete = bl;
        Object object = this.waitOnMissedJobsProcess;
        synchronized (object) {
            this.waitOnMissedJobsProcess.notify();
        }
    }

    private boolean isMissedJobsProcessComplete() {
        return this.missedJobsProcessComplete;
    }

    @Override
    public void suiteStarted(JobHistory jobHistory) {
        logger.debug((Object)("Processing Job Monitor - Suite Started for Job Suite " + jobHistory.getJobName() + " with history ID " + jobHistory.getId()));
        try {
            ScheduleJobMonitorProxy[] scheduleJobMonitorProxyArray = scheduleJobDM.getSuiteMembersWithLateStartMonitors(jobHistory.getJobID());
            logger.debug((Object)("Job Monitor - Suite Started processing " + scheduleJobMonitorProxyArray.length + " members with late start options for suite ID " + jobHistory.getJobID() + "..."));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(jobHistory.getScheduledTime());
            for (int i = 0; i < scheduleJobMonitorProxyArray.length; ++i) {
                ScheduleJobMonitorProxy scheduleJobMonitorProxy = scheduleJobMonitorProxyArray[i];
                logger.debug((Object)("Defining late start monitor for suite member: " + scheduleJobMonitorProxy.getName()));
                if (scheduleJobMonitorProxy.getTargetType().equalsIgnoreCase(ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode())) {
                    long l = scheduleJobMonitorProxy.getTargetID();
                    AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(l);
                    long[] lArray = new long[]{0L};
                    if (agentGroupProxy.getAgentGroupType() == AgentGroupType.PREFERRED_AGENT || agentGroupProxy.getAgentGroupType() == AgentGroupType.UTILIZATION_BALANCED) {
                        logger.debug((Object)("Processing Late Start records for TBD agent in the Agent Group " + l + " with type " + agentGroupProxy.getAgentGroupType() + "."));
                    } else {
                        logger.debug((Object)("Processing Late Start records for all Agents in the Agent Group " + l + "."));
                        lArray = this.agentGroupDM.getAgentsIDsInGroup(l, null);
                    }
                    for (int j = 0; j < lArray.length; ++j) {
                        this.saveLateStartJobMonitor(lArray[j], scheduleJobMonitorProxy, jobHistory, calendar);
                    }
                    continue;
                }
                long l = scheduleJobMonitorProxy.getTargetID();
                this.saveLateStartJobMonitor(l, scheduleJobMonitorProxy, jobHistory, calendar);
            }
            logger.debug((Object)"Job Monitor - Suite Started processing has completed!");
        }
        catch (Exception exception) {
            logger.error((Object)("Error defining late start monitors for suite members of job suite " + jobHistory.getJobName() + " for run history ID " + jobHistory.getId()), (Throwable)exception);
        }
    }

    private void saveLateStartJobMonitor(long l, ScheduleJobMonitorProxy scheduleJobMonitorProxy, JobHistory jobHistory, Calendar calendar) throws ResourceUnavailableException, DataException {
        JobMonitor jobMonitor = this.createJobMonitor(JobMonitor.MonitorType.LATESTART, scheduleJobMonitorProxy.getSkybotJobNumber(), l, calendar, 0L, jobHistory.getId(), false, scheduleJobMonitorProxy);
        this.jobMonitorDM.save(jobMonitor);
        this.notifyMonitorAsNeeded(jobMonitor);
    }

    private TimeZone timezone(ScheduleJobMonitorProxy scheduleJobMonitorProxy, long l) {
        TimeZone timeZone;
        String string = scheduleJobMonitorProxy.getName();
        ScheduleInfo.TimeZoneType timeZoneType = scheduleJobMonitorProxy.getTimezoneType();
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case AGENT: {
                String string2 = this.agentTimezoneID(l);
                timeZone = this.timezone(string2, string);
                break;
            }
            case JOB: {
                String string3 = scheduleJobMonitorProxy.getJobTimezone();
                if (string3 != null && !string3.isEmpty()) {
                    timeZone = this.timezone(string3, string);
                    break;
                }
                timeZone = this.serverTimeZone();
                String string4 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for job/suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{string, string4}));
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private TimeZone timezone(String string, String string2) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = this.serverTimeZone();
                String string3 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
            }
        }
        catch (Exception exception) {
            timeZone = this.serverTimeZone();
            String string4 = timeZone.getID();
            String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
            logger.error((Object)string5, (Throwable)exception);
        }
        return timeZone;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private String agentTimezoneID(long l) {
        String string;
        try {
            Agent agent = this.agentDM.get(l);
            string = agent.getTimeZone();
        }
        catch (Exception exception) {
            TimeZone timeZone = this.serverTimeZone();
            string = timeZone.getID();
            String string2 = MessageUtil.formatMsg((String)"Unable to retrieve the time zone ID for the agent with ID {0}. The ID of the server time zone ({1}) will be used instead.", (Object[])new Object[]{l, string});
            logger.error((Object)string2, (Throwable)exception);
        }
        return string;
    }

    @Override
    public void suiteEnded(JobHistory jobHistory) {
        logger.debug((Object)("Processing Job Monitor - Suite Ended for Job Suite " + jobHistory.getJobName() + " with history ID " + jobHistory.getId()));
        try {
            this.jobMonitorDM.deleteAllSuiteInstanceMonitors(jobHistory.getId());
        }
        catch (Exception exception) {
            logger.error((Object)("Error removing job monitors for job suite " + jobHistory.getJobName() + " with history ID " + jobHistory.getId()), (Throwable)exception);
        }
    }

    static {
        numberFormatter.setMinimumIntegerDigits(2);
    }

    class JobMonitorEventProcessor
    implements Runnable {
        private boolean readyToShutDown = false;

        JobMonitorEventProcessor() {
        }

        @Override
        public void run() {
            try {
                logger.debug((Object)"The JobMonitorEventProcessor has started.");
                while (!this.readyToShutDown) {
                    this.dequeue();
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"The JobMonitorEventProcessor has encountered a severe error. No more Job Monitor Events will be processed until the server is restarted.", throwable);
            }
            finally {
                logger.debug((Object)"The JobMonitorEventProcessor has ended.");
                JobMonitorManagerAMImpl.this.processorIsActive = false;
            }
        }

        private void dequeue() {
            JobMonitorEvent jobMonitorEvent;
            block5: {
                jobMonitorEvent = null;
                try {
                    jobMonitorEvent = (JobMonitorEvent)((Object)JobMonitorManagerAMImpl.this.getQueue().take());
                }
                catch (InterruptedException interruptedException) {
                    logger.debug((Object)"The JobMonitorEventProcessor was interrupted.");
                    if (!JobMonitorManagerAMImpl.this.getQueue().isEmpty()) break block5;
                    this.readyToShutDown = true;
                }
            }
            if (jobMonitorEvent == null) {
                return;
            }
            try {
                JobMonitorManagerAMImpl.this.jobMonitorEventsDM.save(jobMonitorEvent, null);
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to post JobMonitorEvent for JobHistoryID " + jobMonitorEvent.getJobRunID() + " to the database."), (Throwable)exception);
            }
        }
    }

    class JobMonitorRunner
    implements Runnable {
        private Object mainWaitObject = new Object();
        private boolean receivedNewMonitorTime = false;
        private JobMonitor earliestJM;
        private boolean waitingForMonitorTime = false;
        private boolean shutdown = false;

        JobMonitorRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            logger.debug((Object)"JobMonitorRunner is about to start.");
            try {
                Object object;
                while (!JobMonitorManagerAMImpl.this.isMissedJobsProcessComplete()) {
                    logger.debug((Object)"Waiting for missed jobs to be processed before starting.");
                    object = JobMonitorManagerAMImpl.this.waitOnMissedJobsProcess;
                    synchronized (object) {
                        try {
                            JobMonitorManagerAMImpl.this.waitOnMissedJobsProcess.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                logger.debug((Object)"After waiting for missed jobs to be processed.");
                while (!this.shutdown) {
                    object = this.mainWaitObject;
                    synchronized (object) {
                        this.earliestJM = JobMonitorManagerAMImpl.this.getNextJobMonitor();
                        try {
                            this.mainWaitObject.wait(this.getNewWaitTime());
                            logger.debug((Object)"Job Monitor is waking up...");
                        }
                        catch (InterruptedException interruptedException) {
                            logger.debug((Object)"The job Monitor was interrupted.");
                        }
                        catch (NowOrPastException nowOrPastException) {
                            logger.debug((Object)"The Job Monitor monitor time is in the past or now...");
                        }
                        this.waitingForMonitorTime = false;
                        if (this.shutdown) {
                            continue;
                        }
                        if (this.receivedNewMonitorTime) {
                            this.receivedNewMonitorTime = false;
                            continue;
                        }
                        this.earliestJM = JobMonitorManagerAMImpl.this.getNextJobMonitor();
                        if (this.earliestJM.getMonitorTime() != 0L) {
                            if (this.earliestJM.getMonitorTime() > System.currentTimeMillis()) {
                                continue;
                            }
                        } else {
                            continue;
                        }
                        boolean bl = false;
                        switch (this.earliestJM.getMonitorType()) {
                            case UNDERRUN: {
                                logger.debug((Object)(this.earliestJM.getMonitorType().name() + " job monitor for jobHistoryID:" + this.earliestJM.getJobHistoryID() + " will be removed since job is still running."));
                                break;
                            }
                            case OVERRUN: {
                                logger.debug((Object)("About to process OVERRUN on jobHistoryID " + this.earliestJM.getJobHistoryID()));
                                bl = JobMonitorManagerAMImpl.this.processJobMonitorEventOccurred(this.earliestJM).isActionEnd();
                                break;
                            }
                            case LATESTART: {
                                logger.debug((Object)("About to process LATESTART on jobID " + this.earliestJM.getJobID() + " AgentID:" + this.earliestJM.getAgentID() + " ScheduledTime:" + JobMonitorManagerAMImpl.this.getDateTimeString(this.earliestJM.getScheduledTime())));
                                bl = JobMonitorManagerAMImpl.this.processJobMonitorEventOccurred(this.earliestJM).isActionEnd();
                                break;
                            }
                            default: {
                                logger.error((Object)("Invalid MonitorType of " + this.earliestJM.getMonitorType().name() + " inside Job Monitor Runner."));
                            }
                        }
                        if (!bl) {
                            JobMonitorManagerAMImpl.this.deleteJobMonitor(this.earliestJM);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"Job Monitor Runner ended in error.", throwable);
            }
            logger.debug((Object)"JobMonitorRunner has ended.");
            JobMonitorManagerAMImpl.this.runnerIsActive = false;
        }

        private long getNewWaitTime() throws NowOrPastException {
            if (this.earliestJM.getMonitorTime() == 0L) {
                this.waitingForMonitorTime = false;
                logger.debug((Object)"The Monitor currently has no jobs to monitor.");
                return 0L;
            }
            if (logger.isDebugEnabled()) {
                this.postMonitorWaitMessage();
            }
            long l = System.currentTimeMillis();
            if (this.earliestJM.getMonitorTime() <= l) {
                throw new NowOrPastException();
            }
            this.waitingForMonitorTime = true;
            long l2 = this.earliestJM.getMonitorTime() - l;
            if (l2 < 1000L) {
                l2 += 500L;
            }
            l2 = this.roundToNearestSecond(l2);
            return l2;
        }

        private void postMonitorWaitMessage() {
            String string = "an";
            if (this.earliestJM.getMonitorType().equals(JobMonitor.MonitorType.LATESTART)) {
                string = "a";
            }
            logger.debug((Object)("Monitor will now wait until " + JobMonitorManagerAMImpl.this.getDateTimeString(this.earliestJM.getMonitorTime()) + " for " + string + " " + this.earliestJM.getMonitorType().name() + " on the jobID " + this.earliestJM.getJobID() + " scheduled to run on agentID " + this.earliestJM.getAgentID() + " on " + JobMonitorManagerAMImpl.this.getDateTimeString(this.earliestJM.getScheduledTime()) + " for Job History ID " + this.earliestJM.getJobHistoryID() + " for Job Suite History ID " + this.earliestJM.getJobSuiteHistoryID()));
        }

        private long roundToNearestSecond(long l) {
            return (l + 500L) / 1000L * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restartForNewMonitorTime() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                this.receivedNewMonitorTime = true;
                this.mainWaitObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lateStartJobEnqueued(JobHistory jobHistory) throws EndJobException, DataException, ResourceUnavailableException {
            Object object = this.mainWaitObject;
            synchronized (object) {
                long l;
                long l2;
                boolean bl = false;
                JobMonitor jobMonitor = null;
                jobMonitor = JobMonitorManagerAMImpl.this.jobMonitorDM.addJobHistoryID(jobHistory);
                if (jobMonitor != null) {
                    logger.debug((Object)("The Job Monitor record for jobID: " + jobHistory.getJobID() + ", agentID: " + jobHistory.getAgentID() + ", and scheduledTime: " + JobMonitorManagerAMImpl.this.getDateTimeString(jobHistory.getScheduledTime()) + " was updated with Job History ID: " + jobHistory.getId()));
                }
                if (jobHistory.isJobSuiteMember()) {
                    logger.debug((Object)("Bypassing late start monitor definition for suite member run history id: " + jobHistory.getId()));
                    return;
                }
                if (jobMonitor == null) {
                    if (!jobHistory.isManuallyStarted()) {
                        logger.debug((Object)("No Late Start Job Monitor record found for jobHistoryID: " + jobHistory.getId() + ".  Creating new record."));
                    }
                    jobMonitor = JobMonitorManagerAMImpl.this.createJobMonitor(JobMonitor.MonitorType.LATESTART, jobHistory);
                    bl = true;
                }
                if ((l2 = jobMonitor.getMonitorTime()) <= (l = System.currentTimeMillis())) {
                    if (jobHistory.isManuallyStarted()) {
                        logger.debug((Object)("Disregarding Late Start Monitor for jobHistoryID " + jobHistory.getId() + " since job is now being started" + " manually after the Late Start Time of " + JobMonitorManagerAMImpl.this.getDateTimeString(l2)));
                        return;
                    }
                    if (jobHistory.getMissedCode() != JobMissedCode.NOT_MISSED) {
                        logger.debug((Object)("Disregarding Late Start Monitor for jobHistoryID " + jobHistory.getId() + " since job was missed and is now being started" + " after the Late Start Time of " + JobMonitorManagerAMImpl.this.getDateTimeString(l2)));
                        return;
                    }
                    JobMonitorEvent jobMonitorEvent = JobMonitorManagerAMImpl.this.processJobMonitorEventOccurred(jobMonitor);
                    if (jobMonitorEvent.isActionEnd()) {
                        throw new EndJobException("Job to be ended by Late Start Job Monitor.");
                    }
                } else if (bl) {
                    JobMonitorManagerAMImpl.this.jobMonitorDM.save(jobMonitor);
                    JobMonitorManagerAMImpl.this.notifyMonitorAsNeeded(jobMonitor);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JobMonitor getEarliestJobMonitor() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                return this.earliestJM;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isWaitingForMonitorTime() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                return this.waitingForMonitorTime;
            }
        }

        class NowOrPastException
        extends Exception {
            NowOrPastException() {
            }
        }
    }
}

