/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.RoutableBasicIdentifier;
import com.helpsystems.common.core.license.InvalidLicenseVersionException;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.ex.SocketStartupException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentGroup;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.AgentJobQueue;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.busobj.BalancedAgentGroup;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobQueue;
import com.helpsystems.enterprise.core.busobj.NotOnQueueException;
import com.helpsystems.enterprise.core.busobj.PriorityBasedAgentGroup;
import com.helpsystems.enterprise.core.busobj.RunningJobLogException;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.busobj.User;
import com.helpsystems.enterprise.core.busobj.UtilizationBalancedAgentGroup;
import com.helpsystems.enterprise.core.busobj.actions.ChangeJobPriorityEvent;
import com.helpsystems.enterprise.core.busobj.actions.ClearJobQueueEvent;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.db.JDBC_Descriptor_ID;
import com.helpsystems.enterprise.core.dm.AgentConfigAM;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorAM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.AgentWorkManagerAM;
import com.helpsystems.enterprise.core.dm.CurrentStatusRollupDM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.JobCompletionDM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.ReplicationDM;
import com.helpsystems.enterprise.core.dm.StandbyBackupFileQueueAM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.dm.UserDM;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.observers.AgentGroupChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.AgentGroupChangeObserver;
import com.helpsystems.enterprise.core.util.AgentJQHistoryComparator;
import com.helpsystems.enterprise.module.ExecutableJobHelper;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.WindowsAgentAM;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class EnterpriseServerAMImpl
extends AbstractManager
implements EnterpriseServerAM {
    private static Logger logger = Logger.getLogger(EnterpriseServerAMImpl.class);
    private AgentPeer agentServer;
    private HashMap<PeerID, Long> peerIDAgentIDHM = new HashMap();
    private Map<Long, BalancedAgentGroup> balancedAgentGroupMap = new HashMap<Long, BalancedAgentGroup>();
    private BalancedAgentGroupHelper balancedAgentGroupHelper = new BalancedAgentGroupHelper();
    private AgentDM agentDM;
    private AgentGroupDM agentGroupDM;
    private AgentWorkManagerAM agentWorkManagerAM;
    private JobQueuesDM jobQueuesDM;
    private Thread theFinishStandbySetupThread;

    public EnterpriseServerAMImpl(AgentPeer agentPeer) {
        this.setName("ENTERPRISE.EnterpriseServerAM");
        this.setManagerVersion(EnterpriseServerAM.DM_VERSION);
        this.agentServer = agentPeer;
    }

    @Override
    public void changeJobPriority(ChangeJobPriorityEvent changeJobPriorityEvent) throws DataException, ResourceUnavailableException, NotOnQueueException {
        this.getAgentWorkManagerAM().changeJobPriority(changeJobPriorityEvent);
    }

    @Override
    public void checkStartupSystemMessages() throws ResourceUnavailableException, ActionFailedException {
        if (this.isGlobalHoldInEffect()) {
            SystemMessage systemMessage = RosettaMsg.ALL_JOB_QUEUES_LOCKED.newSystemMessage();
            SystemMessageQueue.write(systemMessage);
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.ALL_JOB_QUEUES_LOCKED.newLogEntry();
            ScheduleLogger.write(scheduleLogEntry);
            logger.warn((Object)scheduleLogEntry.getMessageText());
        }
    }

    @Override
    public void clearJobQueue(ClearJobQueueEvent clearJobQueueEvent) {
        try {
            String string = "with ID " + clearJobQueueEvent.getJobQueueOID();
            string = this.getJobQueueNameForLogging(clearJobQueueEvent.getJobQueueOID());
            int n = this.getAgentWorkManagerAM().clearJobQueue(clearJobQueueEvent.getJobQueueOID(), string);
            String string2 = "jobs";
            if (n == 1) {
                string2 = "job";
            }
            String string3 = Integer.toString(n);
            String[] stringArray = new String[]{string, clearJobQueueEvent.getUser(), string3, string2};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_QUEUE_CLEARED_BY_USER.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            logger.info((Object)scheduleLogEntry.getMessageText());
        }
        catch (Exception exception) {
            logger.error((Object)("Error clearing Job Queue with ID: " + clearJobQueueEvent.getJobQueueOID()), (Throwable)exception);
        }
    }

    private String getJobQueueNameForLogging(long l) {
        String string = "with ID " + l;
        try {
            JobQueue jobQueue = this.getJobQueuesDM().getJobQueue(l);
            string = jobQueue.getName();
            if (jobQueue instanceof AgentJobQueue) {
                Agent agent = this.getAgentDM().get(jobQueue.getTargetID());
                string = string + " for Agent " + agent.getName();
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error obtaining JobQueue record for ID " + l), (Throwable)exception);
        }
        return string;
    }

    @Override
    public void refreshAgentEventMonitors(long l) throws ResourceUnavailableException, ActionFailedException {
        try {
            int n;
            int n2;
            RelMod relMod;
            Agent agent = ExecutableJobHelper.loadAgentOID(l);
            if (agent == null) {
                throw new ActionFailedException("Agent " + l + " is undefined.");
            }
            logger.debug((Object)("Refreshing agent event monitors for agent: " + agent.getName()));
            if (this.agentServer.searchForAgent((AgentProxy)agent) == null) {
                throw new ActionFailedException("Agent " + agent.getName() + " is not on-line.");
            }
            AgentEventMonitorDM agentEventMonitorDM = (AgentEventMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorDM");
            RelMod relMod2 = agentEventMonitorDM.getEventsForAgent(l);
            AgentEventMonitorAM agentEventMonitorAM = (AgentEventMonitorAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"ENTERPRISE.AgentEventMonitorAM");
            if (!this.agentServer.isLicensedAndOnline((AgentProxy)agent)) {
                relMod = relMod2;
                n2 = ((AgentEventMonitor[])relMod).length;
                for (n = 0; n < n2; ++n) {
                    RelMod relMod3 = relMod[n];
                    relMod3.setDisabled(true);
                }
            }
            if ((n2 = AgentEventMonitorAM.RELMOD0202.compareTo((Object)(relMod = RelMod.parse((String)agent.getVersion())))) < 0) {
                for (n = 0; n < ((RelMod)relMod2).length; ++n) {
                    relMod2[n].setAgentOID(agent.getOid());
                }
                agentEventMonitorAM.setMonitors((AgentEventMonitor[])relMod2);
            } else {
                agentEventMonitorAM.setMonitors((AgentEventMonitor[])relMod2, agent.getOid());
            }
            logger.debug((Object)("Agent Event Monitors updated for Agent " + agent.getName() + "."));
        }
        catch (Exception exception) {
            String string = "Unable to notify agent " + l + " about new event monitors.";
            logger.debug((Object)string, (Throwable)exception);
            throw new ActionFailedException(string, (Throwable)exception);
        }
    }

    @Override
    public void setLoggingLevel(Level level) throws ResourceUnavailableException, ActionFailedException {
        if (level != Level.INFO && level != Level.DEBUG && level != Level.TRACE) {
            String string = "Logging Level" + level.toString() + " is not supported.";
            logger.debug((Object)string);
            throw new ActionFailedException(string);
        }
        Logger.getRootLogger().setLevel(level);
        String string = "Agent logging set to " + level.toString() + ".";
        logger.debug((Object)string);
    }

    @Override
    public void setServerPort(int n) throws ResourceUnavailableException, ActionFailedException {
        boolean bl = false;
        try {
            AgentPeerConfig agentPeerConfig = this.agentServer.getAgentConfig();
            if (n > 0) {
                int n2 = n;
                int n3 = agentPeerConfig.getListenPort();
                if (n2 == n3) {
                    String string = "Listen port is already " + n3 + ".";
                    logger.debug((Object)string);
                } else {
                    logger.debug((Object)("Setting listen port to " + n2 + "."));
                    try {
                        this.agentServer.switchListenPort(n2);
                        logger.debug((Object)("Listen port changed to " + n2));
                        bl = true;
                    }
                    catch (SocketStartupException socketStartupException) {
                        String string = "Unable to switch the peer listen port to " + n2;
                        logger.debug((Object)string, (Throwable)socketStartupException);
                        throw new ActionFailedException(string, (Throwable)socketStartupException);
                    }
                }
            }
            if (bl) {
                logger.debug((Object)"Saving Server Configuration");
                this.agentServer.saveConfig();
            }
        }
        catch (Exception exception) {
            String string = "An error occurred updating the Server Configuration.";
            logger.debug((Object)string, (Throwable)exception);
            throw new ActionFailedException(string, (Throwable)exception);
        }
    }

    @Override
    public void runJob(JobHistory jobHistory) throws Exception {
        if (this.agentServer.isShutdownRequested()) {
            throw new ResourceUnavailableException("Enterprise Server shutdown in progress, no new jobs will be started.");
        }
        if (jobHistory.getAgentID() == 0L) {
            long l = this.balancedAgentGroupHelper.assignAgent(jobHistory);
            jobHistory.setAgentID(l);
            jobHistory.setAgentName(this.getAgentName(l));
        }
        if (jobHistory.getJobQueueID() == 0L && jobHistory.getJobQueueName() != null) {
            try {
                JobQueueInfo jobQueueInfo = this.getJobQueueInfo(jobHistory.getAgentID(), jobHistory.getJobQueueName());
                jobHistory.setJobQueueID(jobQueueInfo.jobQueueID);
                jobHistory.setJobQueueName(jobQueueInfo.jobQueueName);
            }
            catch (Exception exception) {
                throw new ActionFailedException("Error running Job History ID " + jobHistory.getId(), (Throwable)exception);
            }
        }
        logger.debug((Object)("Passing Job: " + jobHistory.getJobID() + " with JobHistory ID: " + jobHistory.getId() + " AgentID: " + jobHistory.getAgentID() + " jobQueueID:" + jobHistory.getJobQueueID() + " jobQueueName:" + jobHistory.getJobQueueName() + " to the AgentWorkManagerAM"));
        try {
            this.getAgentWorkManagerAM().processJob(jobHistory);
        }
        catch (IllegalStateException illegalStateException) {
            logger.error((Object)("Error passing Job History with ID " + jobHistory.getId() + " to the AgentWorkManager for Agent " + jobHistory.getAgentName()), (Throwable)illegalStateException);
            throw new ActionFailedException("Error running Job History ID " + jobHistory.getId(), (Throwable)illegalStateException);
        }
        catch (EndJobException endJobException) {
            // empty catch block
        }
    }

    private JobQueueInfo getJobQueueInfo(long l, String string) throws Exception {
        JobQueueInfo jobQueueInfo;
        long l2 = 0L;
        try {
            logger.debug((Object)("Attempting to find ID for Agent Job Queue: '" + string + "' and agentID: " + l + " ..."));
            l2 = this.getJobQueuesDM().getJobQueueID(l, string);
            logger.debug((Object)("Found jobQueueID: " + l2 + " for Agent ID: " + l + " and Job Queue: " + string));
            jobQueueInfo = new JobQueueInfo(l2, string);
        }
        catch (NoDataException noDataException) {
            logger.debug((Object)("ID not found for Agent Job Queue: " + string + " and agentID: " + l));
            l2 = this.getJobQueuesDM().getJobQueueID(l, "Default");
            logger.debug((Object)("Using Default jobQueueID: " + l2 + " for Agent ID: " + l));
            jobQueueInfo = new JobQueueInfo(l2, "Default");
        }
        return jobQueueInfo;
    }

    private AgentWorkManagerAM getAgentWorkManagerAM() {
        if (this.agentWorkManagerAM == null) {
            this.agentWorkManagerAM = (AgentWorkManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentWorkManagerAM");
        }
        return this.agentWorkManagerAM;
    }

    @Override
    public void bypassConditionsOnJob(JobHistory jobHistory, String string) throws ResourceUnavailableException, ActionFailedException, DataException {
        if (this.agentServer.isShutdownRequested()) {
            throw new ResourceUnavailableException("Enterprise Server shutdown in progress.  The job conditions for Job History ID " + jobHistory.getId() + " will not be bypassed.");
        }
        try {
            this.getAgentWorkManagerAM().bypassJobConditions(jobHistory, string);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ActionFailedException("Error bypassing conditionals for Job History ID " + jobHistory.getId(), (Throwable)illegalStateException);
        }
    }

    @Override
    public void reloadPersistedJob(JobHistory jobHistory) throws ResourceUnavailableException, ActionFailedException, EndJobException {
        if (this.agentServer.isShutdownRequested()) {
            throw new ActionFailedException("Enterprise Server shutdown in progress, no persisted jobs will be loaded.");
        }
        logger.debug((Object)("Passing Job: '" + jobHistory.getJobName() + "(" + jobHistory.getJobID() + ") with run number " + jobHistory.getId() + " to the AgentWorkManager for Agent " + jobHistory.getAgentName() + " jobQueueID:" + jobHistory.getJobQueueID() + " jobQueueName:" + jobHistory.getJobQueueName()));
        try {
            this.getAgentWorkManagerAM().reloadPersistedJob(jobHistory);
        }
        catch (IllegalStateException illegalStateException) {
            logger.error((Object)("Error passing Job History with ID " + jobHistory.getId() + " to the AgentWorkManager for Agent " + jobHistory.getAgentName()), (Throwable)illegalStateException);
            throw new ActionFailedException("Error running Job History ID " + jobHistory.getId(), (Throwable)illegalStateException);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Error running Job History ID " + jobHistory.getId(), (Throwable)exception);
        }
    }

    private AgentDM getAgentDM() {
        if (this.agentDM == null) {
            this.agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        }
        return this.agentDM;
    }

    private AgentGroupDM getAgentGroupDM() {
        if (this.agentGroupDM == null) {
            this.agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
        }
        return this.agentGroupDM;
    }

    private String getAgentName(long l) {
        try {
            return this.getAgentDM().get(l).getName();
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving agent name for ID: " + l), (Throwable)exception);
            return "";
        }
    }

    @Override
    public ArrayList<JobHistory> getJobQueueEntries(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManagerAM().getJobQueueEntries(l);
    }

    @Override
    public int getJobQueueRunningCount(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManagerAM().getJobQueueRunningCount(l);
    }

    private JobQueuesDM getJobQueuesDM() {
        if (this.jobQueuesDM == null) {
            this.jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
        }
        return this.jobQueuesDM;
    }

    @Override
    public boolean isGlobalHoldInEffect() {
        return this.agentServer.getAgentConfig().getHoldAgents();
    }

    @Override
    public void dequeueJob(JobHistory jobHistory) throws ResourceUnavailableException, ActionFailedException, NotOnQueueException {
        this.getAgentWorkManagerAM().dequeueJob(jobHistory);
    }

    @Override
    public void enqueueJob(JobHistory jobHistory) throws Exception {
        this.getAgentWorkManagerAM().processJob(jobHistory);
    }

    @Override
    public void terminateJob(JobHistory jobHistory, String string, boolean bl) throws Exception {
        this.getAgentWorkManagerAM().terminateJob(jobHistory, string, bl);
    }

    @Override
    public void terminateRunningMemberJob(JobHistory jobHistory, String string) throws NoDataException, ActionFailedException, ResourceUnavailableException {
        JobExecDM jobExecDM;
        long l;
        JobCompletionDM jobCompletionDM = (JobCompletionDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobCompletionDM");
        ExecutableJob executableJob = jobCompletionDM.endJob(String.valueOf(l = jobHistory.getId()));
        if (executableJob == null) {
            throw new NoDataException(MessageUtil.formatMsg((String)"The job with run number {0} is not currently running.", (Object[])new Object[]{l}));
        }
        Agent agent = executableJob.getAgent();
        if (agent == null) {
            throw new ActionFailedException(MessageUtil.formatMsg((String)"Agent information not found for run number {0}.", (Object[])new Object[]{l}));
        }
        try {
            jobExecDM = (JobExecDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"ENTERPRISE.JobExecDM");
        }
        catch (Exception exception) {
            throw new ActionFailedException(MessageUtil.formatMsg((String)"Unable to contact agent {0}.", (Object[])new Object[]{agent}), (Throwable)exception);
        }
        try {
            jobExecDM.endJob(String.valueOf(l), string);
        }
        catch (Exception exception) {
            throw new ActionFailedException(MessageUtil.formatMsg((String)"Error while trying to terminate the job with run number {0}.", (Object[])new Object[]{l}), (Throwable)exception);
        }
    }

    @Override
    public void softHoldAllJobQueues() {
        this.getAgentWorkManagerAM().holdAllJobQueues();
    }

    @Override
    public void softReleaseAllJobQueues() {
        this.getAgentWorkManagerAM().releaseAllJobQueues();
    }

    @Override
    public String holdJobQueue(long l) throws ResourceUnavailableException, ActionFailedException {
        logger.debug((Object)("Holding Job Queue with jobQueueID: " + l));
        this.getAgentWorkManagerAM().holdJobQueue(l);
        return this.getJobQueueNameForLogging(l);
    }

    @Override
    public String releaseJobQueue(long l) throws ResourceUnavailableException, ActionFailedException {
        logger.debug((Object)("Releasing Job Queue with ID: " + l));
        this.getAgentWorkManagerAM().releaseJobQueue(l);
        return this.getJobQueueNameForLogging(l);
    }

    @Override
    public long runJobsImmediately(List<JobHistory> list, long l, String string) {
        Object[] objectArray = this.getAgentWorkManagerAM().runJobsImmediately(list);
        ArrayList arrayList = (ArrayList)objectArray[0];
        ArrayList arrayList2 = (ArrayList)objectArray[1];
        ArrayList arrayList3 = (ArrayList)objectArray[2];
        Collections.sort(arrayList, new AgentJQHistoryComparator());
        for (JobHistory jobHistory : arrayList) {
            String[] stringArray = new String[]{jobHistory.getJobName(), Long.toString(jobHistory.getId()), jobHistory.getAgentName(), ScheduleLogger.formatTimeStamp(l), string};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_RUN_IMMEDIATELY_BY_USER.newLogEntry(stringArray);
            scheduleLogEntry.setAgentID(jobHistory.getAgentID());
            scheduleLogEntry.setJobID(jobHistory.getJobID());
            scheduleLogEntry.setJobHistoryID(jobHistory.getId());
            ScheduleLogger.write(scheduleLogEntry);
        }
        Collections.sort(arrayList2, new AgentJQHistoryComparator());
        for (JobHistory jobHistory : arrayList2) {
            logger.warn((Object)("Failed to run job " + jobHistory.getJobName() + " with run ID " + jobHistory.getId() + " on Agent " + jobHistory.getAgentName()));
        }
        if (arrayList2.size() > 0) {
            return -2L;
        }
        if (arrayList3.size() > 0) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public void setGlobalHold() throws ActionFailedException {
        try {
            AgentPeerConfig agentPeerConfig = this.agentServer.getAgentConfig();
            if (!agentPeerConfig.getHoldAgents()) {
                logger.debug((Object)"Setting Hold Agents to true in Server Configuration.");
                agentPeerConfig.setHoldAgents(true);
                logger.debug((Object)"Saving Server Configuration");
                this.agentServer.saveConfig();
            } else {
                logger.debug((Object)"Hold Agents is already set to true in Server Configuration.");
            }
        }
        catch (IOException iOException) {
            logger.debug((Object)"Error saving Hold Agents to true in Server Configuration.", (Throwable)iOException);
        }
        this.getAgentWorkManagerAM().setGlobalHold();
    }

    @Override
    public void releaseGlobalHold() {
        try {
            AgentPeerConfig agentPeerConfig = this.agentServer.getAgentConfig();
            if (agentPeerConfig.getHoldAgents()) {
                logger.debug((Object)"Setting Hold Agents to false in Server Configuration.");
                agentPeerConfig.setHoldAgents(false);
                logger.debug((Object)"Saving Server Configuration");
                this.agentServer.saveConfig();
            } else {
                logger.debug((Object)"Hold Agents is already set to false in Server Configuration.");
            }
        }
        catch (IOException iOException) {
            logger.debug((Object)"Error saving Hold Agents to false in Server Configuration.", (Throwable)iOException);
        }
        this.getAgentWorkManagerAM().releaseGlobalHold();
    }

    @Override
    public boolean isAgentWorkManagerAMShutdown() {
        return this.agentWorkManagerAM == null;
    }

    @Override
    public void shutDownAgentWorkManagerAM() {
        this.getAgentWorkManagerAM().shutDown();
        this.agentWorkManagerAM = null;
    }

    @Override
    public void shutDownAgentWorkManager(long l) throws ResourceUnavailableException {
        this.getAgentWorkManagerAM().shutDownForAgent(l);
    }

    @Override
    public Properties getServerProperties() throws ActionFailedException {
        Properties properties = new Properties();
        AgentPeerConfig agentPeerConfig = this.agentServer.getAgentConfig();
        if (!this.agentServer.isServer()) {
            throw new IllegalStateException("Mode must be " + AgentPeerConfig.AgentMode.SERVER + ".");
        }
        properties.put("Configuration Path", this.agentServer.getConfigPath());
        properties.put("Module Release/Modification", this.agentServer.getRelMod().toString());
        properties.put("Hardware Hash", this.agentServer.getRemotePeerID().getHardwareHash());
        properties.put("Hardware Identifier", this.agentServer.getRemotePeerID().getHardwareKey());
        properties.put("Listen Port", String.valueOf(agentPeerConfig.getListenPort()));
        PeerDescriptor peerDescriptor = agentPeerConfig.getMaster();
        if (peerDescriptor != null) {
            String string = String.valueOf(peerDescriptor.getPort());
            String string2 = this.prepareAddresses(peerDescriptor.getAddresses());
            if (peerDescriptor.getType() == 1) {
                properties.put("Robot/NETWORK Host Address", string2);
                properties.put("Robot/NETWORK Host Port", string);
            } else if (peerDescriptor.getType() == 6) {
                properties.put("Enterprise Server Address", string2);
                properties.put("Enterprise Server Port", string);
            } else {
                properties.put("Master Attributes", "Unavailable");
            }
        }
        return properties;
    }

    @Override
    public int getJobQueueCount(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManagerAM().getJobQueueCount(l);
    }

    private int getJobQueueCount(long l, long l2) throws ResourceUnavailableException {
        return this.getAgentWorkManagerAM().getJobQueueCount(l2, l);
    }

    @Override
    public int getJobQueueCountForAgent(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManagerAM().getJobQueueCountForAgent(l);
    }

    @Override
    public int getTotalJobsQueued() {
        return this.getAgentWorkManagerAM().getTotalJobsQueued();
    }

    @Override
    public int getAgentJobQueueCount(RoutableBasicIdentifier routableBasicIdentifier) throws ResourceUnavailableException, ActionFailedException {
        PeerID peerID = (PeerID)routableBasicIdentifier;
        if (!this.peerIDAgentIDHM.containsKey(peerID)) {
            try {
                Agent agent = this.getAgentDM().getByHardwareHashAndInstanceIdentifier(peerID.getHardwareHash(), (String)((Object)peerID.getInstanceIdentifier()));
                if (agent != null) {
                    return this.getJobQueueCountForAgent(agent.getOid());
                }
            }
            catch (DataException dataException) {
                throw new ActionFailedException("Error occurred attempting to find Agent using PeerID information.", (Throwable)dataException);
            }
            return 0;
        }
        Long l = this.peerIDAgentIDHM.get(peerID);
        return this.getJobQueueCountForAgent(l);
    }

    @Override
    public int getAgentJobRunningCount(long l) throws ResourceUnavailableException {
        return this.getAgentWorkManagerAM().getAgentJobRunningCount(l);
    }

    @Override
    public void agentInfoUpdated(long l) {
        SystemSetupDM systemSetupDM;
        Agent agent = null;
        try {
            agent = this.getAgentDM().get(l);
        }
        catch (Exception exception) {
            logger.debug((Object)("Failed to obtain agent information for AgentID " + l), (Throwable)exception);
        }
        SystemSetup systemSetup = null;
        try {
            systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
            systemSetup = systemSetupDM.get();
        }
        catch (Exception exception) {
            logger.debug((Object)"Failed to load system settings data manager", (Throwable)exception);
        }
        try {
            systemSetupDM = this.agentServer.searchForAgent((AgentProxy)agent);
            if (systemSetupDM != null) {
                this.notifyConnectedAgent(systemSetup, (PeerID)systemSetupDM, agent);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Failed to notify agent of change.", (Throwable)exception);
        }
        this.getAgentWorkManagerAM().updateAgentInfo(agent);
    }

    @Override
    public boolean validateLicense(int n, String string) throws InvalidLicenseVersionException {
        return this.validateLicense(n, string, false, false);
    }

    @Override
    public boolean validateLicenseForUI(int n, String string, boolean bl) throws ActionFailedException, ResourceUnavailableException, InvalidLicenseVersionException {
        return this.validateLicense(n, string, bl, true);
    }

    @Override
    public boolean validateLicense(int n, String string, boolean bl) throws InvalidLicenseVersionException {
        return this.validateLicense(n, string, bl, false);
    }

    @Override
    public boolean validateLicense(int n, String string, boolean bl, boolean bl2) throws InvalidLicenseVersionException {
        if (n != 1 && n != 2) {
            return false;
        }
        EnterpriseProductLicense enterpriseProductLicense = new EnterpriseProductLicense(string, bl2);
        if (enterpriseProductLicense.getLicenseType() == -1 || enterpriseProductLicense.getLicenseType() == 0) {
            return false;
        }
        if (n == 1) {
            if (enterpriseProductLicense.getLicenseType() == 1 || enterpriseProductLicense.getLicenseType() == 2 && enterpriseProductLicense.isSystemSpecificTempCode()) {
                if (bl) {
                    return !enterpriseProductLicense.isValidOn(this.agentServer.getRemotePeerID().getHardwareKey());
                }
            } else {
                return false;
            }
        }
        if (n == 2) {
            if (enterpriseProductLicense.getLicenseType() == 2 && !enterpriseProductLicense.isSystemSpecificTempCode()) {
                if (bl) {
                    return !enterpriseProductLicense.isValidOn(this.agentServer.getRemotePeerID().getHardwareKey());
                }
                return enterpriseProductLicense.isValidOn(this.agentServer.getRemotePeerID().getHardwareKey());
            }
            return false;
        }
        return true;
    }

    private String prepareAddresses(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = i == 0 ? stringArray[i].trim() : string + ", " + stringArray[i].trim();
            }
        }
        return string;
    }

    @Override
    public String getServerHostName() {
        return PeerDescriptor.getLocalHostname();
    }

    @Override
    public String getHardwareKey() {
        return this.agentServer.getRemotePeerID().getHardwareKey();
    }

    @Override
    public void verifyStandbyConnection(String string, String string2, String string3, String string4) throws IllegalArgumentException, DataException, ResourceUnavailableException, SQLException {
        if (!this.checkPassword(string)) {
            throw new IllegalArgumentException("The password provided does not match the admin password on this server.");
        }
        if (!string2.equals(this.agentServer.getRelMod().toString())) {
            throw new IllegalArgumentException("The standby and master versions of Automate Schedule are not the same.");
        }
        if (!EnterpriseServerAMImpl.getArchForPostgresqlReplication().equals(string3)) {
            throw new IllegalArgumentException("The standby and master processor architecture are not the same.");
        }
        String string5 = System.getProperty("os.name");
        if (string5.indexOf("Windows") >= 0 ? string4.indexOf("Windows") < 0 : !string5.equals(string4)) {
            throw new IllegalArgumentException("The standby and master operating systems are not the same.");
        }
        SystemSetupDM systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
        SystemSetup systemSetup = systemSetupDM.get();
        if (systemSetup.getStandbyServer() != null && systemSetup.getStandbyServer().trim().length() > 0) {
            throw new IllegalArgumentException("A standby server is already configured for this master.");
        }
    }

    @Override
    public void finishStandbySetup(PeerID peerID, int n) {
        try {
            PeerDescriptor peerDescriptor = this.agentServer.getPeerFromRoutingTable(peerID).getPeerID().getPeerDescriptor();
            SystemSetupDM systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
            SystemSetup systemSetup = systemSetupDM.get();
            String string = peerDescriptor.getPreferredInetAddress().getHostAddress();
            systemSetup.setStandbyServer(string);
            systemSetup.setStandbyPort(n);
            systemSetupDM.save(systemSetup);
            this.notifyConnectedAgents();
            StandbyBackupFileQueueAM standbyBackupFileQueueAM = (StandbyBackupFileQueueAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.StandbyBackupFileQueueAM");
            this.theFinishStandbySetupThread = standbyBackupFileQueueAM.clearAndReloadQueue();
            this.updateCurrentStatuses();
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to finalize standby setup.", (Throwable)exception);
        }
    }

    @Override
    public boolean isFinishStandbySetupThreadActive() {
        return this.theFinishStandbySetupThread != null && this.theFinishStandbySetupThread.isAlive();
    }

    @Override
    public void notifyConnectedAgents() {
        Object object;
        SystemSetup systemSetup = null;
        try {
            object = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
            systemSetup = object.get();
        }
        catch (Exception exception) {
            logger.debug((Object)"Failed to load system settings data manager", (Throwable)exception);
        }
        object = this.getAgentDM();
        PeerID[] peerIDArray = this.agentServer.getConnectedAgents();
        for (int i = 0; i < peerIDArray.length; ++i) {
            try {
                Agent agent = object.getByHardwareHashAndInstanceIdentifier(peerIDArray[i].getHardwareHash(), peerIDArray[i].getInstanceIdentifier().toString());
                this.notifyConnectedAgent(systemSetup, peerIDArray[i], agent);
                continue;
            }
            catch (Exception exception) {
                logger.debug((Object)("Failed to notify agent at " + peerIDArray[i].getPeerDescriptor().getComputerName()), (Throwable)exception);
            }
        }
    }

    private void notifyConnectedAgent(SystemSetup systemSetup, PeerID peerID, Agent agent) throws ActionFailedException {
        PeerDescriptor peerDescriptor = null;
        String string = null;
        int n = 0;
        if (systemSetup.getStandbyServer() != null && systemSetup.getStandbyServer().trim().length() > 0) {
            string = systemSetup.getStandbyServer();
            n = systemSetup.getStandbyPort();
        }
        if (agent != null && agent.getStandbyPortOverride() > 0 && agent.getStandbyServerOverride() != null && agent.getStandbyServerOverride().length() > 0) {
            string = agent.getStandbyServerOverride();
            n = agent.getStandbyPortOverride();
        }
        if (n > 0 && string != null) {
            peerDescriptor = new PeerDescriptor(string, n, 9, null);
        }
        AgentConfigAM agentConfigAM = (AgentConfigAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.AgentConfigAM");
        agentConfigAM.setStandby(peerDescriptor);
    }

    private boolean checkPassword(String string) throws DataException, ResourceUnavailableException, SQLException {
        UserDM userDM = (UserDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.UserDM");
        try {
            int n = 20;
            User user = userDM.getUserByName("admin");
            if (user.getLoginCount() == 0) {
                throw new IllegalArgumentException("The admin password on the master server has not been set.  You must log into the master before connecting the standby.");
            }
            String string2 = string + user.getPasswordSalt();
            for (int i = 0; i < n; ++i) {
                string2 = EnterpriseServerAMImpl.encryptSHA512(string2);
            }
            if (string2.equals(user.getCryptedPassword())) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error((Object)noSuchAlgorithmException.getMessage());
        }
        return false;
    }

    public static String getArchForPostgresqlReplication() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("win") >= 0) {
            WindowsAgentAM windowsAgentAM = (WindowsAgentAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.WindowsAgentAM");
            if (windowsAgentAM.is64BitWindowsOS()) {
                return "WIN64";
            }
            return "WIN32";
        }
        return System.getProperty("os.arch");
    }

    @Override
    public ServiceDescriptor retrieveDBConnInfo() {
        String string = EnterpriseServerAMImpl.getRailsEnvironment();
        ServiceDescriptor serviceDescriptor = this.agentServer.getConfig().getServiceDescriptor(string);
        return serviceDescriptor;
    }

    private static String getRailsEnvironment() {
        String string = System.getenv("RAILS_ENV");
        if (string != null) {
            return string.toUpperCase();
        }
        return JDBC_Descriptor_ID.DEVELOPMENT.toString();
    }

    public static String encryptSHA512(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        messageDigest.reset();
        messageDigest.update(string.getBytes());
        byte[] byArray = messageDigest.digest();
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            String string3 = Integer.toHexString(new Byte(by).byteValue());
            while (string3.length() < 2) {
                string3 = "0" + string3;
            }
            string3 = string3.substring(string3.length() - 2);
            string2 = string2 + string3;
        }
        return string2;
    }

    @Override
    public void notifyAgentsOfSAPXMIAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        this.getAgentWorkManagerAM().notifyAgentsOfSAPXMIAuditLevelChange(l, sAPXMIAuditLevel);
    }

    @Override
    public void jobCompleted(JobHistory jobHistory) {
        this.jobCompleted(jobHistory, false);
    }

    @Override
    public void jobCompleted(JobHistory jobHistory, boolean bl) {
        this.getAgentWorkManagerAM().jobCompleted(jobHistory, bl);
    }

    @Override
    public void jobQueueChanged(long l) {
        this.getAgentWorkManagerAM().jobQueueChanged(l);
    }

    @Override
    public String loadRunningJobLog(JobHistory jobHistory, String string) throws ResourceUnavailableException, RunningJobLogException {
        return this.getAgentWorkManagerAM().loadRunningJobLog(jobHistory, string);
    }

    @Override
    public String lockAgent(long l) throws Exception {
        return this.getAgentWorkManagerAM().lockAgent(l);
    }

    @Override
    public String unlockAgent(long l) throws Exception {
        return this.getAgentWorkManagerAM().unlockAgent(l);
    }

    @Override
    public void notifyActiveAgentsOfLicenseChange() {
        this.getAgentWorkManagerAM().notifyAgentsOfLicenseChange();
    }

    public void setAgentGroupChangeNotifier(AgentGroupChangeNotifier agentGroupChangeNotifier) {
        ValidationHelper.checkForNull((String)"Agent Group Change Notifier", (Object)agentGroupChangeNotifier);
        agentGroupChangeNotifier.addAgentGroupChangeObserver(new AgentGroupChangeObserver(){

            @Override
            public void agentGroupChanged(long l) {
                try {
                    EnterpriseServerAMImpl.this.balancedAgentGroupHelper.agentGroupChanged(l);
                }
                catch (Exception exception) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to record the fact that the Agent Group with ID {0} changed.", (Object[])new Object[]{l}));
                }
            }
        });
    }

    @Override
    public void updateCurrentStatuses() {
        CurrentStatusRollupDM currentStatusRollupDM = (CurrentStatusRollupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CurrentStatusRollupDM");
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        SystemSetupDM systemSetupDM = MRHelper.getSystemSetupDM();
        try {
            SystemSetup systemSetup = systemSetupDM.get();
            bl2 = systemSetup.getMonitorSNMPTraps();
            bl = systemSetup.getAuditRecords();
            n = (systemSetup.getAgentEventAutoPurge() ? 1 : 0) + (systemSetup.getAuditAutoPurge() ? 1 : 0) + (systemSetup.getJobHistoryAutomaticPurge() ? 1 : 0) + (systemSetup.getJobMonitorAutoPurge() ? 1 : 0) + (systemSetup.getScheduleLogAutoPurge() ? 1 : 0) + (systemSetup.getSnmpTrapAutoPurge() ? 1 : 0) + (systemSetup.getSystemMessageAutoPurge() ? 1 : 0) + (systemSetup.getSapInterceptedJobHistoryAutoPurge() ? 1 : 0) + (systemSetup.isRemoteHistoryAutoPurge() ? 1 : 0);
            n2 = this.calculateStandbyStatus(n2, systemSetup);
        }
        catch (Exception exception) {
            logger.debug((Object)"Could not retrieve the System Settings for current status rollups.", (Throwable)exception);
        }
        try {
            currentStatusRollupDM.setAll(this.agentServer.getAgentConfig().getHoldScheduler() ? 0 : 1, this.agentServer.getAgentConfig().getHoldAgents(), bl2, bl, n, n2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.info((Object)"Failed setting initial status rollups.", (Throwable)resourceUnavailableException);
        }
    }

    private int calculateStandbyStatus(int n, SystemSetup systemSetup) {
        if (systemSetup.getStandbyServer() == null || systemSetup.getStandbyServer().trim().length() == 0 || systemSetup.getStandbyPort() < 1) {
            n = 0;
        } else if (this.isStandbyConnected()) {
            ReplicationDM replicationDM = (ReplicationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReplicationDM");
            try {
                replicationDM.getReplicationStatistics();
                n = 3;
            }
            catch (NoDataException noDataException) {
                n = 2;
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                resourceUnavailableException.printStackTrace();
            }
        } else {
            n = 1;
        }
        return n;
    }

    private boolean isStandbyConnected() {
        PeerID[] peerIDArray = this.agentServer.getConnectedStandbyServer();
        if (peerIDArray == null) {
            return false;
        }
        return peerIDArray.length > 0;
    }

    private class JobQueueInfo {
        private long jobQueueID;
        private String jobQueueName;

        JobQueueInfo(long l, String string) {
            this.jobQueueID = l;
            this.jobQueueName = string;
        }
    }

    private class BalancedAgentGroupHelper {
        private Object changeLock = new Object();

        private BalancedAgentGroupHelper() {
        }

        private long assignAgent(JobHistory jobHistory) throws ResourceUnavailableException {
            BalancedAgentGroup balancedAgentGroup;
            if (jobHistory.getAgentID() != 0L) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Run {0} of job {1} is already assigned to run on agent {2} (id={3}).", (Object[])new Object[]{jobHistory.getId(), jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getAgentID()}));
            }
            long l = jobHistory.getAgentGroupID();
            if (l == 0L) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"A request was made to assign run {0} of job {1} to an agent. However, this job is not set up to run on a balanced type agent group.", (Object[])new Object[]{jobHistory.getId(), jobHistory.getJobName()}));
            }
            try {
                balancedAgentGroup = this.getBalancedAgentGroup(l);
            }
            catch (NoDataException noDataException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to assign run {0} of job {1} to an agent because the agent group with ID {2} was not found.", (Object[])new Object[]{jobHistory.getId(), jobHistory.getJobName(), l}));
            }
            catch (BadDataException badDataException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to assign run {0} of job {1} to an agent because the agent group with ID {2} contains corrupt data.", (Object[])new Object[]{jobHistory.getId(), jobHistory.getJobName(), l}));
            }
            switch (balancedAgentGroup.getAgentGroupType()) {
                case UTILIZATION_BALANCED: {
                    ((UtilizationBalancedAgentGroup)balancedAgentGroup).setScores(this.calculateScores(jobHistory, balancedAgentGroup));
                    break;
                }
                case PREFERRED_AGENT: {
                    ((PriorityBasedAgentGroup)balancedAgentGroup).setScores(this.calculateScores(jobHistory, balancedAgentGroup));
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{balancedAgentGroup.getAgentGroupType()}));
                }
            }
            long l2 = balancedAgentGroup.chooseAgent();
            this.releaseIgnoreUntilFlags(balancedAgentGroup.getAgents());
            return l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BalancedAgentGroup getBalancedAgentGroup(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
            Object object = this.changeLock;
            synchronized (object) {
                BalancedAgentGroup balancedAgentGroup = (BalancedAgentGroup)((Object)EnterpriseServerAMImpl.this.balancedAgentGroupMap.get(l));
                if (balancedAgentGroup == null) {
                    AgentGroup agentGroup;
                    try {
                        agentGroup = EnterpriseServerAMImpl.this.getAgentGroupDM().get(l);
                    }
                    catch (DataException dataException) {
                        if (dataException instanceof NoDataException) {
                            throw (NoDataException)((Object)dataException);
                        }
                        if (dataException instanceof BadDataException) {
                            throw (BadDataException)((Object)dataException);
                        }
                        throw new IllegalStateException(dataException);
                    }
                    if (agentGroup instanceof BalancedAgentGroup) {
                        balancedAgentGroup = (BalancedAgentGroup)agentGroup;
                        EnterpriseServerAMImpl.this.balancedAgentGroupMap.put(l, (BalancedAgentGroup)agentGroup);
                    } else {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group {0} is not a BalancedAgentGroup.", (Object[])new Object[]{agentGroup.getName()}));
                    }
                }
                return balancedAgentGroup;
            }
        }

        private int getActiveJobs(long l, long l2) throws ResourceUnavailableException {
            if (this.isAgentOffline(l)) {
                logger.debug((Object)("Active Jobs is unknown.  Agent is offline: " + l));
                return 0;
            }
            return EnterpriseServerAMImpl.this.getAgentWorkManagerAM().getJobQueueRunningCount(l2, l);
        }

        private int getMaxActiveJobsForUtilization(long l) throws ResourceUnavailableException {
            return EnterpriseServerAMImpl.this.getAgentWorkManagerAM().getMaxActiveJobsForUtilization(l);
        }

        private Map<Long, Integer> calculateScores(JobHistory jobHistory, BalancedAgentGroup balancedAgentGroup) {
            long[] lArray;
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            AgentGroupType agentGroupType = balancedAgentGroup.getAgentGroupType();
            long l = 0L;
            if (jobHistory.getJobQueueID() != 0L) {
                l = jobHistory.getJobQueueID();
            }
            block4: for (long l2 : lArray = balancedAgentGroup.getNonIgnoredAgentIDs()) {
                long l3 = l;
                if (l3 == 0L) {
                    l3 = this.getJobQueueIDForAgentJobQueueName(l2, jobHistory.getJobQueueName());
                }
                switch (agentGroupType) {
                    case UTILIZATION_BALANCED: {
                        hashMap.put(l2, this.calculateScore(jobHistory, l2, l3));
                        continue block4;
                    }
                    case PREFERRED_AGENT: {
                        hashMap.put(l2, this.calculateScore(l2, l3, (PriorityBasedAgentGroup)balancedAgentGroup));
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                    }
                }
            }
            return hashMap;
        }

        private long getJobQueueIDForAgentJobQueueName(long l, String string) {
            try {
                if (string != null && string.trim().length() > 0) {
                    try {
                        return EnterpriseServerAMImpl.this.getJobQueuesDM().getJobQueueID(l, string);
                    }
                    catch (NoDataException noDataException) {
                        logger.debug((Object)("Load Balanced Job Queue named '" + string + "' was not found for Agent ID '" + l + "'."));
                    }
                }
                Agent agent = EnterpriseServerAMImpl.this.getAgentDM().get(l);
                long l2 = agent.getDefaultJobQueueID();
                logger.debug((Object)("Using Default(" + l2 + ") Job Queue for Agent ID " + l + "."));
                return l2;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error loading Job Queue '" + string + "' for agent ID '" + l + "'.", throwable);
            }
        }

        private int calculateScore(JobHistory jobHistory, long l, long l2) {
            logger.debug((Object)("Calculating Utilization Balanced score for Run/Agent/JobQueue: " + jobHistory.getId() + "/" + l + "/" + l2));
            int n = 0;
            try {
                if (this.isAgentUnlicensed(l)) {
                    n += UtilizationBalancedAgentGroup.UNLICENSED_SCORE_VALUE;
                }
                if (this.isAgentHeld(l)) {
                    n += UtilizationBalancedAgentGroup.HELD_AGENT_SCORE_VALUE;
                }
                if (this.isAgentOffline(l) || this.isAgentEnding(l)) {
                    n += UtilizationBalancedAgentGroup.OFFLINE_SCORE_VALUE;
                }
                if (this.isJobQueueHeldForBalancing(l2)) {
                    n += UtilizationBalancedAgentGroup.HELD_JOB_QUEUE_SCORE_VALUE;
                }
                n += this.calculateUtilizationScore(l, l2);
            }
            catch (Exception exception) {
                logger.error((Object)"Unable to calculate a score.", (Throwable)exception);
                n = UtilizationBalancedAgentGroup.ERROR_SCORE_VALUE;
            }
            return n;
        }

        private int calculateScore(long l, long l2, PriorityBasedAgentGroup priorityBasedAgentGroup) {
            int n = 0;
            try {
                if (priorityBasedAgentGroup.getUnlicensedScoreValue() > 0 && this.isAgentUnlicensed(l)) {
                    n += priorityBasedAgentGroup.getUnlicensedScoreValue();
                }
                if (priorityBasedAgentGroup.getHeldAgentScoreValue() > 0 && this.isAgentHeld(l)) {
                    n += priorityBasedAgentGroup.getHeldAgentScoreValue();
                }
                if (priorityBasedAgentGroup.getOfflineScoreValue() > 0 && (this.isAgentOffline(l) || this.isAgentEnding(l))) {
                    n += priorityBasedAgentGroup.getOfflineScoreValue();
                }
                if (priorityBasedAgentGroup.getHeldAgentScoreValue() > 0 && this.isJobQueueHeldForBalancing(l2)) {
                    n += priorityBasedAgentGroup.getHeldAgentScoreValue();
                }
                n += priorityBasedAgentGroup.getBaseValueForAgent(l);
            }
            catch (Exception exception) {
                logger.error((Object)"Unable to calculate a score.", (Throwable)exception);
                n = 999999999;
            }
            return n;
        }

        private int calculateUtilizationScore(long l, long l2) throws ResourceUnavailableException {
            int n = this.getMaxActiveJobsForUtilization(l2);
            if (n == 0) {
                n = 1;
            }
            logger.debug((Object)("Max Active Jobs: " + n));
            int n2 = this.getActiveJobs(l, l2);
            logger.debug((Object)("Active Jobs: " + n2));
            int n3 = EnterpriseServerAMImpl.this.getJobQueueCount(l, l2);
            logger.debug((Object)("Queued Jobs: " + n3));
            int n4 = (n2 + n3) * 1000 / n;
            logger.debug((Object)("Calculated Untilization Score: " + n4));
            return n4;
        }

        private boolean isAgentEnding(long l) throws ResourceUnavailableException {
            PeerID peerID = EnterpriseServerAMImpl.this.getAgentWorkManagerAM().getAgentPeerID(l);
            return EnterpriseServerAMImpl.this.agentServer.isAgentEnding(peerID);
        }

        private boolean isAgentHeld(long l) throws ResourceUnavailableException {
            return EnterpriseServerAMImpl.this.getAgentWorkManagerAM().isAgentLocked(l);
        }

        private boolean isJobQueueHeldForBalancing(long l) throws ResourceUnavailableException {
            try {
                return EnterpriseServerAMImpl.this.getAgentWorkManagerAM().isJobQueueHeldForBalancing(l);
            }
            catch (Throwable throwable) {
                throw new ResourceUnavailableException("Error retieving job queue status.", throwable);
            }
        }

        private boolean isAgentOffline(long l) throws ResourceUnavailableException {
            Agent agent = EnterpriseServerAMImpl.this.getAgentWorkManagerAM().getAgent(l);
            return EnterpriseServerAMImpl.this.agentServer.searchForAgent((AgentProxy)agent) == null;
        }

        private boolean isAgentUnlicensed(long l) throws ResourceUnavailableException {
            Agent agent = EnterpriseServerAMImpl.this.getAgentWorkManagerAM().getAgent(l);
            PeerID peerID = EnterpriseServerAMImpl.this.agentServer.searchForAgent((AgentProxy)agent);
            if (peerID == null) {
                return false;
            }
            return !EnterpriseServerAMImpl.this.agentServer.isLicensedAndOnline(peerID);
        }

        private boolean isBalancedTypeAgentGroup(AgentGroupType agentGroupType) {
            return agentGroupType == AgentGroupType.UTILIZATION_BALANCED || agentGroupType == AgentGroupType.PREFERRED_AGENT;
        }

        private void releaseIgnoreUntilFlags(AgentGroupAgent[] agentGroupAgentArray) {
            if (agentGroupAgentArray == null) {
                return;
            }
            long l = System.currentTimeMillis();
            for (AgentGroupAgent agentGroupAgent : agentGroupAgentArray) {
                if (agentGroupAgent.getIgnoreInGroup() != 2 || agentGroupAgent.currentlyIgnored(l)) continue;
                try {
                    EnterpriseServerAMImpl.this.getAgentGroupDM().release(agentGroupAgent.getOid());
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)"Error while releasing the ignore until flag.", (Throwable)resourceUnavailableException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void agentGroupChanged(long l) throws ResourceUnavailableException {
            AgentGroupProxy agentGroupProxy;
            try {
                agentGroupProxy = EnterpriseServerAMImpl.this.getAgentGroupDM().getProxy(l);
            }
            catch (DataException dataException) {
                if (dataException instanceof NoDataException) {
                    EnterpriseServerAMImpl.this.balancedAgentGroupMap.remove(l);
                    return;
                }
                throw new IllegalStateException(dataException);
            }
            if (!this.isBalancedTypeAgentGroup(agentGroupProxy.getAgentGroupType())) {
                return;
            }
            Object object = this.changeLock;
            synchronized (object) {
                BalancedAgentGroup balancedAgentGroup;
                BalancedAgentGroup balancedAgentGroup2 = (BalancedAgentGroup)((Object)EnterpriseServerAMImpl.this.balancedAgentGroupMap.get(l));
                if (balancedAgentGroup2 == null) {
                    return;
                }
                try {
                    balancedAgentGroup = (BalancedAgentGroup)EnterpriseServerAMImpl.this.getAgentGroupDM().get(l);
                }
                catch (DataException dataException) {
                    throw new IllegalStateException(dataException);
                }
                long l2 = balancedAgentGroup2.getLastAgentChosen();
                balancedAgentGroup.setLastChoicePointer(l2);
                EnterpriseServerAMImpl.this.balancedAgentGroupMap.put(l, balancedAgentGroup);
            }
        }
    }
}

