/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.as400.access.RemoteFileAMAS400;
import com.helpsystems.common.as400.service.AS400ServiceDescriptor;
import com.helpsystems.common.as400.service.AS400ServiceStarter;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.GenericManagerLoader;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerLoader;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.dm.SNMPTrapAM;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.service.ServiceException;
import com.helpsystems.common.core.util.DaemonThreadFactory;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.server.access.PasswdUserListDM;
import com.helpsystems.common.server.dm.ActiveProcessAM;
import com.helpsystems.common.server.file.BasicFileAM;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.common.server.file.WindowsFileAM;
import com.helpsystems.common.server.snmp.SNMPTrapAMImpl;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.module.ModuleDescriptor;
import com.helpsystems.common.tl.module.ModuleException;
import com.helpsystems.common.tl.module.ModuleLifecycle;
import com.helpsystems.enterprise.access.jdbc.AgentEventHistoryInfoDMJdbc;
import com.helpsystems.enterprise.access.jdbc.JobHistoryDMJdbc;
import com.helpsystems.enterprise.access.jdbc.JobMonitorEventsDMJdbc;
import com.helpsystems.enterprise.access.jdbc.PrereqEventDMJdbc;
import com.helpsystems.enterprise.access.jdbc.SNMPTrapEventDMJdbc;
import com.helpsystems.enterprise.access.sap.SAPEventHistoryDMJdbc;
import com.helpsystems.enterprise.access.scheduler.PrereqDMJdbc;
import com.helpsystems.enterprise.core.EnterpriseGlobals;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseLicenseInfoAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapManagerDM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.ForecastAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.JobSuiteAM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.PrereqEventDM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.forecast.ForecastPrerequisitesDM;
import com.helpsystems.enterprise.core.ibmi.IBMiAgent;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.scheduler.ActivityMatcherAM;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.ForecastDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.core.scheduler.observers.AgentGroupChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.AgentTimeZoneChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.DateListChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.JobChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.MemberChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.SuiteChangeNotifier;
import com.helpsystems.enterprise.module.AgentAMImpl;
import com.helpsystems.enterprise.module.AgentCommandAMImpl;
import com.helpsystems.enterprise.module.AgentConfigAMImpl;
import com.helpsystems.enterprise.module.AgentEventMonitorAMImpl;
import com.helpsystems.enterprise.module.AgentEventRefreshAMImpl;
import com.helpsystems.enterprise.module.AgentStatusAMImpl;
import com.helpsystems.enterprise.module.AgentWorkManagerAMImpl;
import com.helpsystems.enterprise.module.AllUserListDM;
import com.helpsystems.enterprise.module.EnterpriseEmailAMImpl;
import com.helpsystems.enterprise.module.EnterpriseSNMPTrapAMImpl;
import com.helpsystems.enterprise.module.EnterpriseServerAMImpl;
import com.helpsystems.enterprise.module.InteractiveCommandProcessor;
import com.helpsystems.enterprise.module.JobMonitorManagerAMImpl;
import com.helpsystems.enterprise.module.JobQueuePersisterAMImpl;
import com.helpsystems.enterprise.module.JobQueueScheduleAMImpl;
import com.helpsystems.enterprise.module.JobTrackerAMImpl;
import com.helpsystems.enterprise.module.OutputDistributionAMImpl;
import com.helpsystems.enterprise.module.SNMPTrapMonitorAMImpl;
import com.helpsystems.enterprise.module.SkybotPeerInfoAMImpl;
import com.helpsystems.enterprise.module.UserFileAMImpl;
import com.helpsystems.enterprise.module.exec.AgentConditionHelperAMImpl;
import com.helpsystems.enterprise.module.exec.AgentLogAMImpl;
import com.helpsystems.enterprise.module.exec.FilePeerGatewayAMImpl;
import com.helpsystems.enterprise.module.exec.IBMiJobExecDMImpl;
import com.helpsystems.enterprise.module.exec.JobCompletionDMImpl;
import com.helpsystems.enterprise.module.exec.JobExecDMImpl;
import com.helpsystems.enterprise.module.exec.JobMarkRunningAMImpl;
import com.helpsystems.enterprise.module.exec.PlatformFactory;
import com.helpsystems.enterprise.module.exec.PostJobLogEntryHelperAMImpl;
import com.helpsystems.enterprise.module.exec.StandbyBackupFileQueueAMImpl;
import com.helpsystems.enterprise.module.exec.StandbyBackupFileTransferAMImpl;
import com.helpsystems.enterprise.module.exec.UNIXPlatform;
import com.helpsystems.enterprise.module.exec.WindowsPlatform;
import com.helpsystems.enterprise.module.infocloud.SkybotCommandDMImpl;
import com.helpsystems.enterprise.module.informatica.InformaticaServerHelperAMImpl;
import com.helpsystems.enterprise.module.oracle.OracleServerHelperAMImpl;
import com.helpsystems.enterprise.module.reports.ReportsProcessorAMImpl;
import com.helpsystems.enterprise.module.sap.SAPCommandHelperAMImpl;
import com.helpsystems.enterprise.module.sap.SAPInterceptedJobMonitorAMImpl;
import com.helpsystems.enterprise.module.sap.SAPSLDRegistrarAMImpl;
import com.helpsystems.enterprise.module.sap.SAPServerHelperAMImpl;
import com.helpsystems.enterprise.module.unix.UnixActiveProcessAM;
import com.helpsystems.enterprise.module.windows.WindowsActiveProcessAM;
import com.helpsystems.enterprise.module.windows.WindowsAgentAMImpl;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.ImportCronAMImpl;
import com.helpsystems.enterprise.remoteserver.RemoteServerAMImpl;
import com.helpsystems.enterprise.scheduler.ForecastAMImpl;
import com.helpsystems.enterprise.scheduler.JobSuiteAMImpl;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import com.helpsystems.enterprise.scheduler.ReactivityAMImpl;
import com.helpsystems.enterprise.scheduler.SchedulerAMImpl;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class AgentModuleImpl
implements ModuleLifecycle {
    public static final String IBMI_LOCAL_POOL_NAME = "IBMI_LOCAL_POOL";
    private static Logger logger = Logger.getLogger(AgentModuleImpl.class);
    private AgentPeer peer;
    private AgentPeerConfig config;
    private ManagerLoader osDMLoader;
    private ActiveProcessAM processAM;

    public void startup(HeavyweightPeer heavyweightPeer, ModuleDescriptor moduleDescriptor) throws ModuleException {
        logger.debug((Object)"The Automate Schedule Module is starting up...");
        this.peer = (AgentPeer)heavyweightPeer;
        this.config = (AgentPeerConfig)this.peer.getConfig();
        EnterpriseVersionedObject.staticFillInVersion(this.peer.getVersionInfo());
        this.loadDataManagers();
        if (this.peer.isClient()) {
            this.loadAgentClientManagers();
        } else if (this.peer.isServer()) {
            if (this.isStandby()) {
                this.loadStandbyServerManagers();
            } else {
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.ENTERPRISE_SERVER_STARTUP.newLogEntry();
                ScheduleLogger.write(scheduleLogEntry);
                this.loadAgentServerManagers();
            }
        } else {
            this.loadServerServiceManagers();
        }
        this.peer.setStartupComplete(true);
        logger.debug((Object)"The Automate Schedule Module startup has completed.");
    }

    public boolean isStandby() {
        return AgentPeerConfig.AgentMode.STANDBY.equals((Object)this.config.getMode());
    }

    public void shutdown() throws ModuleException {
        Vector<String> vector = new Vector<String>();
        for (IAbstractManager iAbstractManager : ManagerRegistry.getManagers()) {
            String string = iAbstractManager.getName();
            if (!string.startsWith("ENTERPRISE.")) continue;
            vector.add(string);
        }
        for (String string : vector) {
            ManagerRegistry.removeManager((String)string);
        }
    }

    protected void loadDataManagers() throws ModuleException {
        logger.trace((Object)"AgentModuleImpl: loadDataManagers");
        String string = System.getProperty("os.name").toUpperCase();
        this.osDMLoader = new GenericAgentDMLoader();
        if (this.osDMLoader == null) {
            throw new ModuleException("The operating system type " + string + " is not supported.");
        }
        this.loadManagers(this.osDMLoader);
    }

    private void loadManagers(ManagerLoader managerLoader) throws ModuleException {
        try {
            managerLoader.loadAll();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ModuleException(resourceUnavailableException.getMessage(), resourceUnavailableException.getCause());
        }
    }

    private void loadAgentClientManagers() throws ModuleException {
        Object object;
        ManagerRegistry.registerManager((IAbstractManager)new AgentConfigAMImpl(this.peer));
        ManagerRegistry.registerManager((IAbstractManager)new FilePeerGatewayAMImpl(this.peer));
        ManagerRegistry.registerManager((IAbstractManager)new AgentPeer.LocalAgentTranslationDMImpl(this.peer));
        RemoteFileAM remoteFileAM = (RemoteFileAM)ManagerRegistry.getManager((String)"COMMON.RemoteFileAM");
        if (remoteFileAM == null) {
            remoteFileAM = new BasicFileAM();
        }
        try {
            object = new AgentEventMonitorAMImpl(this.peer, remoteFileAM, this.processAM);
            ManagerRegistry.registerManager((IAbstractManager)object);
        }
        catch (IOException iOException) {
            throw new ModuleException("Unable to start the AgentEventMonitorAMImpl", (Throwable)iOException);
        }
        if (this.isIBMi()) {
            logger.debug((Object)"This agent will be considered an IBM i agent.");
            ManagerRegistry.registerManager((IAbstractManager)new IBMiJobExecDMImpl(this.peer));
        } else {
            File file;
            logger.debug((Object)"This agent will be considered a non IBM i agent.");
            try {
                ManagerRegistry.registerManager((IAbstractManager)new JobExecDMImpl(this.peer));
            }
            catch (Exception exception) {
                throw new ModuleException("Unable to start the JobExecDM. No jobs can be run on this agent system.", (Throwable)exception);
            }
            try {
                ManagerRegistry.registerManager((IAbstractManager)new SkybotCommandDMImpl(this.peer));
            }
            catch (Exception exception) {
                throw new ModuleException("Unable to start the SkybotCommandDM.", (Throwable)exception);
            }
            ManagerRegistry.registerManager((IAbstractManager)new SAPCommandHelperAMImpl(this.peer));
            object = PlatformFactory.getPlatform();
            if (object != null && object instanceof UNIXPlatform && "root".equals(System.getProperty("user.name"))) {
                logger.warn((Object)"This agent is running as 'root' and will not be able to run any jobs as 'root' because the 'su' command will not prompt for the password.");
            }
            if (object != null && object instanceof WindowsPlatform) {
                InteractiveCommandProcessor.startProcessor(this.peer);
            }
            if ((file = new File("/etc/passwd")).exists()) {
                ManagerRegistry.registerManager((IAbstractManager)new PasswdUserListDM());
            } else {
                ManagerRegistry.registerManager((IAbstractManager)new AllUserListDM());
            }
        }
    }

    private void loadStandbyServerManagers() {
        ManagerRegistry.registerManager((IAbstractManager)new StandbyBackupFileTransferAMImpl(this.peer));
        ManagerRegistry.registerManager((IAbstractManager)new EnterpriseEmailAMImpl(MRHelper.getSystemSetupDM()));
        ManagerRegistry.registerManager((IAbstractManager)new SkybotPeerInfoAMImpl(this.peer));
    }

    private void loadAgentServerManagers() throws ModuleException {
        Object object;
        try {
            ManagerRegistry.registerManager((IAbstractManager)new StandbyBackupFileQueueAMImpl());
            ManagerRegistry.registerManager((IAbstractManager)new JobCompletionDMImpl(this.peer));
            ManagerRegistry.registerManager((IAbstractManager)new AgentEventRefreshAMImpl(this.peer));
            ManagerRegistry.registerManager((IAbstractManager)new AgentCommandAMImpl(this.peer));
            object = new EnterpriseServerAMImpl(this.peer);
            ManagerRegistry.registerManager((IAbstractManager)object);
            ManagerRegistry.registerManager((IAbstractManager)new AgentStatusAMImpl(this.peer));
            ManagerRegistry.registerManager((IAbstractManager)new SNMPTrapAMImpl(this.peer.getPeerDescriptor().findIPAddress()));
            ManagerRegistry.registerManager((IAbstractManager)new AgentLogAMImpl());
            EnterpriseSNMPTrapManagerDM enterpriseSNMPTrapManagerDM = (EnterpriseSNMPTrapManagerDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseSNMPTrapManagerDM");
            SNMPTrapAM sNMPTrapAM = (SNMPTrapAM)ManagerRegistry.getManagerOrFail((String)"COMMON.SNMPTrapAM");
            ManagerRegistry.registerManager((IAbstractManager)new EnterpriseSNMPTrapAMImpl(enterpriseSNMPTrapManagerDM, sNMPTrapAM));
            SystemSetupDM systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
            ManagerRegistry.registerManager((IAbstractManager)new EnterpriseEmailAMImpl(systemSetupDM));
            RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServersDM");
            ManagerRegistry.registerManager((IAbstractManager)new RemoteServerAMImpl(remoteServersDM, (Peer)this.peer));
            ManagerRegistry.registerManager((IAbstractManager)new ImportCronAMImpl());
            ManagerRegistry.registerManager((IAbstractManager)new JobMonitorManagerAMImpl());
            AgentWorkManagerAMImpl agentWorkManagerAMImpl = new AgentWorkManagerAMImpl(this.peer);
            ManagerRegistry.registerManager((IAbstractManager)agentWorkManagerAMImpl);
            EnterpriseEmailAM enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
            ManagerRegistry.registerManager((IAbstractManager)new OutputDistributionAMImpl(this.peer, enterpriseEmailAM));
            ManagerRegistry.registerManager((IAbstractManager)new ReportsProcessorAMImpl(this.peer, enterpriseEmailAM));
            ScheduleInfoDM scheduleInfoDM = (ScheduleInfoDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleInfoDM");
            ScheduledTimeDM scheduledTimeDM = (ScheduledTimeDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduledTimeDM");
            ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
            AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
            JobMonitorManagerAM jobMonitorManagerAM = (JobMonitorManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorManagerAM");
            NSTCalculator nSTCalculator = new NSTCalculator(scheduleInfoDM, scheduledTimeDM, scheduleJobDM, agentDM, jobMonitorManagerAM, agentGroupDM);
            SchedulerAMImpl schedulerAMImpl = new SchedulerAMImpl(nSTCalculator, scheduleJobDM, scheduledTimeDM, scheduleInfoDM);
            ManagerRegistry.registerManager((IAbstractManager)schedulerAMImpl);
            ((EnterpriseServerAMImpl)object).setAgentGroupChangeNotifier((AgentGroupChangeNotifier)schedulerAMImpl);
            scheduleInfoDM.setCalendarObjectChangeNotifier((CalendarObjectChangeNotifier)schedulerAMImpl);
            JobTrackerAMImpl jobTrackerAMImpl = new JobTrackerAMImpl(this.peer);
            ManagerRegistry.registerManager((IAbstractManager)jobTrackerAMImpl);
            PrereqDMJdbc prereqDMJdbc = (PrereqDMJdbc)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
            JobSuiteDM jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobSuiteDM");
            ActivityMatcherAM activityMatcherAM = (ActivityMatcherAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ActivityMatcherAM");
            JobSuiteAMImpl jobSuiteAMImpl = new JobSuiteAMImpl(jobSuiteDM, (JobTrackerAM)jobTrackerAMImpl, (PrereqDM)prereqDMJdbc, jobMonitorManagerAM, activityMatcherAM, scheduleJobDM);
            ManagerRegistry.registerManager((IAbstractManager)jobSuiteAMImpl);
            PrereqEventDMJdbc prereqEventDMJdbc = (PrereqEventDMJdbc)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqEventDM");
            ReactivityAMImpl reactivityAMImpl = new ReactivityAMImpl((PrereqEventDM)prereqEventDMJdbc, (PrereqDM)prereqDMJdbc);
            ManagerRegistry.registerManager((IAbstractManager)reactivityAMImpl);
            JobQueueScheduleAMImpl jobQueueScheduleAMImpl = new JobQueueScheduleAMImpl();
            ManagerRegistry.registerManager((IAbstractManager)jobQueueScheduleAMImpl);
            JobHistoryDMJdbc jobHistoryDMJdbc = (JobHistoryDMJdbc)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
            jobHistoryDMJdbc.setReactivityAM((ReactivityAM)reactivityAMImpl);
            jobHistoryDMJdbc.setJobSuiteAM((JobSuiteAM)jobSuiteAMImpl);
            jobSuiteAMImpl.setReactivityAM((ReactivityAM)reactivityAMImpl);
            AgentEventHistoryInfoDMJdbc agentEventHistoryInfoDMJdbc = (AgentEventHistoryInfoDMJdbc)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEventHistoryInfoDM");
            agentEventHistoryInfoDMJdbc.setReactivityAM((ReactivityAM)reactivityAMImpl);
            JobMonitorEventsDMJdbc jobMonitorEventsDMJdbc = (JobMonitorEventsDMJdbc)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobMonitorEventsDM");
            jobMonitorEventsDMJdbc.setReactivityAM((ReactivityAM)reactivityAMImpl);
            SNMPTrapEventDMJdbc sNMPTrapEventDMJdbc = (SNMPTrapEventDMJdbc)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SNMPTrapEventDM");
            sNMPTrapEventDMJdbc.setReactivityAM((ReactivityAM)reactivityAMImpl);
            SAPEventHistoryDMJdbc sAPEventHistoryDMJdbc = (SAPEventHistoryDMJdbc)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPEventHistoryDM");
            sAPEventHistoryDMJdbc.setReactivityAM((ReactivityAM)reactivityAMImpl);
            ForecastDM forecastDM = (ForecastDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ForecastDM");
            ForecastPrerequisitesDM forecastPrerequisitesDM = (ForecastPrerequisitesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ForecastPrerequisitesDM");
            ForecastAMImpl forecastAMImpl = new ForecastAMImpl(forecastDM, forecastPrerequisitesDM, scheduleInfoDM, nSTCalculator, (JobHistoryDM)jobHistoryDMJdbc, agentGroupDM, scheduleJobDM, agentDM);
            forecastAMImpl.setJobChangeNotifier((JobChangeNotifier)schedulerAMImpl);
            forecastAMImpl.setMemberChangeNotifier((MemberChangeNotifier)schedulerAMImpl);
            forecastAMImpl.setSuiteChangeNotifier((SuiteChangeNotifier)schedulerAMImpl);
            forecastAMImpl.setAgentGroupChangeNotifier((AgentGroupChangeNotifier)schedulerAMImpl);
            forecastAMImpl.setAgentTimeZoneChangeNotifier((AgentTimeZoneChangeNotifier)schedulerAMImpl);
            forecastAMImpl.setCalendarObjectChangeNotifier((CalendarObjectChangeNotifier)schedulerAMImpl);
            forecastAMImpl.setDateListChangeNotifier((DateListChangeNotifier)schedulerAMImpl);
            ManagerRegistry.registerManager((IAbstractManager)forecastAMImpl);
            JobTrackerAMImpl jobTrackerAMImpl2 = (JobTrackerAMImpl)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
            jobTrackerAMImpl2.setForecastAM((ForecastAM)forecastAMImpl);
            JobSuiteAMImpl jobSuiteAMImpl2 = (JobSuiteAMImpl)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobSuiteAM");
            jobSuiteAMImpl2.setForecastAM((ForecastAM)forecastAMImpl);
            ManagerRegistry.registerManager((IAbstractManager)new JobQueuePersisterAMImpl(scheduleJobDM, jobHistoryDMJdbc, jobTrackerAMImpl, (EnterpriseServerAM)object, agentGroupDM));
            ManagerRegistry.registerManager((IAbstractManager)new SNMPTrapMonitorAMImpl());
            SchedulerStatusAMImpl schedulerStatusAMImpl = new SchedulerStatusAMImpl();
            ManagerRegistry.registerManager((IAbstractManager)schedulerStatusAMImpl);
            JobMarkRunningAMImpl jobMarkRunningAMImpl = new JobMarkRunningAMImpl();
            ManagerRegistry.registerManager((IAbstractManager)jobMarkRunningAMImpl);
            PostJobLogEntryHelperAMImpl postJobLogEntryHelperAMImpl = new PostJobLogEntryHelperAMImpl();
            ManagerRegistry.registerManager((IAbstractManager)postJobLogEntryHelperAMImpl);
            ManagerRegistry.registerManager((IAbstractManager)new FilePeerGatewayAMImpl(this.peer));
            ManagerRegistry.registerManager((IAbstractManager)new UserFileAMImpl());
            EnterpriseLicenseInfo enterpriseLicenseInfo = this.getLicenseInfo();
            this.loadSAPAgentServerManagers(enterpriseLicenseInfo);
            InformaticaServerHelperAMImpl informaticaServerHelperAMImpl = new InformaticaServerHelperAMImpl(this.peer);
            ManagerRegistry.registerManager((IAbstractManager)informaticaServerHelperAMImpl);
            this.postInformaticaLicenseStatus(enterpriseLicenseInfo);
            this.loadOracleAgentServerManagers(enterpriseLicenseInfo);
            this.postRSILicenseStatus(enterpriseLicenseInfo);
            this.postUniversalConnectorLicenseStatus(enterpriseLicenseInfo);
        }
        catch (IOException iOException) {
            throw new ModuleException("Unable to start the server managers", (Throwable)iOException);
        }
        object = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("RefreshRunnerThread"));
        ((ScheduledThreadPoolExecutor)object).scheduleWithFixedDelay(new RefreshRunner(), 3540L, 3600L, TimeUnit.SECONDS);
    }

    private void postUniversalConnectorLicenseStatus(EnterpriseLicenseInfo enterpriseLicenseInfo) {
        boolean bl = this.isLicensedForFeature(enterpriseLicenseInfo, EnterpriseProductLicense.FEATURE.UNIVERSAL_CONNECTOR);
        ScheduleLogEntry scheduleLogEntry = bl ? RosettaMsg.UNIVERSAL_CONNECTOR_LICENSE_VALID.newLogEntry() : RosettaMsg.UNIVERSAL_CONNECTOR_LICENSE_INVALID.newLogEntry();
        ScheduleLogger.write(scheduleLogEntry);
    }

    private void postInformaticaLicenseStatus(EnterpriseLicenseInfo enterpriseLicenseInfo) {
        boolean bl = this.isLicensedForFeature(enterpriseLicenseInfo, EnterpriseProductLicense.FEATURE.INFORMATICA);
        ScheduleLogEntry scheduleLogEntry = bl ? RosettaMsg.INFORMATICA_LICENSE_VALID.newLogEntry() : RosettaMsg.INFORMATICA_LICENSE_INVALID.newLogEntry();
        ScheduleLogger.write(scheduleLogEntry);
    }

    private void postRSILicenseStatus(EnterpriseLicenseInfo enterpriseLicenseInfo) {
        boolean bl = this.isLicensedForFeature(enterpriseLicenseInfo, EnterpriseProductLicense.FEATURE.RSI);
        ScheduleLogEntry scheduleLogEntry = bl ? RosettaMsg.RSI_LICENSE_VALID.newLogEntry() : RosettaMsg.RSI_LICENSE_INVALID.newLogEntry();
        ScheduleLogger.write(scheduleLogEntry);
    }

    private EnterpriseLicenseInfo getLicenseInfo() {
        EnterpriseLicenseInfoAM enterpriseLicenseInfoAM = (EnterpriseLicenseInfoAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseLicenseInfoAM");
        EnterpriseLicenseInfo enterpriseLicenseInfo = null;
        try {
            enterpriseLicenseInfo = enterpriseLicenseInfoAM.getLicenseInfo();
        }
        catch (Exception exception) {
            logger.error((Object)"Error obtaining license information.", (Throwable)exception);
        }
        return enterpriseLicenseInfo;
    }

    private void loadSAPAgentServerManagers(EnterpriseLicenseInfo enterpriseLicenseInfo) {
        boolean bl = this.isLicensedForFeature(enterpriseLicenseInfo, EnterpriseProductLicense.FEATURE.SAP);
        ScheduleLogEntry scheduleLogEntry = bl ? RosettaMsg.SAP_LICENSE_VALID.newLogEntry() : RosettaMsg.SAP_LICENSE_INVALID.newLogEntry();
        ScheduleLogger.write(scheduleLogEntry);
        ManagerRegistry.registerManager((IAbstractManager)new SAPServerHelperAMImpl(this.peer, bl));
        ManagerRegistry.registerManager((IAbstractManager)new SAPInterceptedJobMonitorAMImpl(bl));
        ManagerRegistry.registerManager((IAbstractManager)new SAPSLDRegistrarAMImpl(bl));
    }

    private boolean isLicensedForFeature(EnterpriseLicenseInfo enterpriseLicenseInfo, EnterpriseProductLicense.FEATURE fEATURE) {
        if (enterpriseLicenseInfo == null) {
            logger.error((Object)"Error obtaining license information.");
            return false;
        }
        return enterpriseLicenseInfo.isLicensedForFeature(fEATURE, this.peer.getRemotePeerID().getHardwareKey().toUpperCase());
    }

    private void loadOracleAgentServerManagers(EnterpriseLicenseInfo enterpriseLicenseInfo) {
        boolean bl = this.isLicensedForFeature(enterpriseLicenseInfo, EnterpriseProductLicense.FEATURE.ORACLE);
        ScheduleLogEntry scheduleLogEntry = bl ? RosettaMsg.ORACLE_LICENSE_VALID.newLogEntry() : RosettaMsg.ORACLE_LICENSE_INVALID.newLogEntry();
        ScheduleLogger.write(scheduleLogEntry);
        ManagerRegistry.registerManager((IAbstractManager)new OracleServerHelperAMImpl(this.peer));
    }

    private void loadServerServiceManagers() throws ModuleException {
        if (this.config.getServiceType() == AgentPeerConfig.ServiceType.REPORTRUNNER) {
            String string = "Loading ReportRunner managers for the service.";
            logger.info((Object)string);
            SystemSetupDM systemSetupDM = (SystemSetupDM)ManagerRegistry.getManager((String)"ENTERPRISE.SystemSetupDM");
            ManagerRegistry.registerManager((IAbstractManager)new EnterpriseEmailAMImpl(systemSetupDM));
            EnterpriseEmailAM enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
            ManagerRegistry.registerManager((IAbstractManager)new ReportsProcessorAMImpl(this.peer, enterpriseEmailAM));
        } else {
            String string = "No managers were loaded for the service.";
            logger.info((Object)string);
        }
    }

    public static void startIBMiLocalConnectionPool(String string) throws ResourceUnavailableException {
        String string2 = "localhost";
        String string3 = "*CURRENT";
        String string4 = "*CURRENT";
        int n = 15;
        AS400ServiceDescriptor aS400ServiceDescriptor = new AS400ServiceDescriptor();
        aS400ServiceDescriptor.setIPAddress(string2);
        aS400ServiceDescriptor.setUsername(string3);
        aS400ServiceDescriptor.setEncryptedPassword(string4);
        aS400ServiceDescriptor.setName(string);
        aS400ServiceDescriptor.setAutoStartup(false);
        aS400ServiceDescriptor.setMaxConnections(n);
        aS400ServiceDescriptor.setCleanSystemLibraryList(false);
        AS400ServiceStarter aS400ServiceStarter = new AS400ServiceStarter();
        try {
            aS400ServiceStarter.startService((ServiceDescriptor)aS400ServiceDescriptor);
        }
        catch (ServiceException serviceException) {
            String string5 = "Error starting up AS400 Object pool.";
            throw new ResourceUnavailableException(string5, (Throwable)serviceException);
        }
    }

    private boolean isIBMi() {
        String string = "force.agent.type.to.IBMi";
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to access the JVM system property '{0}'.", (Object[])new Object[]{string}), (Throwable)securityException);
        }
        if (string2 != null) {
            return string2.trim().toLowerCase().equals("true");
        }
        return IBMiAgent.isIBMiOS();
    }

    class RefreshRunner
    implements Runnable {
        RefreshRunner() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("RefreshRunner");
            try {
                AgentModuleImpl.this.peer.pollAgents(false);
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to poll active agents", (Throwable)exception);
            }
        }
    }

    class GenericAgentDMLoader
    extends GenericManagerLoader {
        GenericAgentDMLoader() {
            super("bogus", null);
        }

        public void loadAll() throws ResourceUnavailableException {
            this.registerManager(new AgentAMImpl(AgentModuleImpl.this.peer));
            this.registerManager(new WindowsAgentAMImpl(AgentModuleImpl.this.peer));
            this.registerManager(new AgentConditionHelperAMImpl(AgentModuleImpl.this.peer));
            String string = System.getProperty("os.name").toLowerCase();
            if (string.startsWith("win")) {
                AgentModuleImpl.this.processAM = new WindowsActiveProcessAM();
                WindowsFileAM windowsFileAM = new WindowsFileAM();
                windowsFileAM.setName("COMMON.RemoteFileAM");
                this.registerManager((AbstractManager)windowsFileAM);
            } else if (string.indexOf("400") > -1) {
                AgentModuleImpl.this.processAM = new UnixActiveProcessAM();
                AgentModuleImpl.startIBMiLocalConnectionPool(AgentModuleImpl.IBMI_LOCAL_POOL_NAME);
                RemoteFileAMAS400 remoteFileAMAS400 = new RemoteFileAMAS400(AgentModuleImpl.IBMI_LOCAL_POOL_NAME, "COMMON.RemoteFileAM");
                this.registerManager((AbstractManager)remoteFileAMAS400);
            } else {
                AgentModuleImpl.this.processAM = new UnixActiveProcessAM();
                BasicFileAM basicFileAM = new BasicFileAM();
                basicFileAM.setName("COMMON.RemoteFileAM");
                this.registerManager((AbstractManager)basicFileAM);
            }
            if (AgentModuleImpl.this.processAM != null) {
                this.registerManager((AbstractManager)AgentModuleImpl.this.processAM);
            }
        }

        protected RelMod retrieveInterfaceVersion() {
            return EnterpriseGlobals.PRODUCT_RELMOD;
        }
    }
}

