/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import junit.framework.TestCase;

public class UnacodeMashTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDecodeReversesEncode() {
        String string = "bobo";
        String string2 = null;
        String string3 = null;
        try {
            string2 = UnacodeMash.mash(string);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            UnacodeMashTest.fail((String)"Unable to mash");
        }
        try {
            string3 = UnacodeMash.unMash(string2);
            UnacodeMashTest.assertEquals((String)"Unmash did not reverse mash", (String)string, (String)string3);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            UnacodeMashTest.fail((String)"Unable to unMash");
            resourceUnavailableException.printStackTrace();
        }
    }

    public void testGetForDataManagers() throws Exception {
        EncryptUtil encryptUtil = UnacodeMash.getForDataManagers();
        String string = "bobo";
        String string2 = null;
        String string3 = null;
        string2 = encryptUtil.encode(string);
        string3 = encryptUtil.decode(string2);
        UnacodeMashTest.assertEquals((String)"Decode did not reverse encode", (String)string, (String)string3);
    }
}

