/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class OutputDistributionSetup {
    private static Logger logger = Logger.getLogger(OutputDistributionSetup.class);
    public static final String DEFAULT_OUTPUT_DIR_NAME = "output";
    public static final String IMPORT_DIR_NAME = "import";
    public static final String EXPORT_DIR_NAME = "export";
    public static final String UC_IMPORT_DIR_NAME = "uc_import";
    public static final String UC_EXPORT_DIR_NAME = "uc_export";
    public static final String REPORTS_QUEUE = "reports.dq";
    public static final String STANDBY_BACKUP_FILE_QUEUE = "standbyBackupFileQueue.dq";
    public static final String JASPER_TEMP_DIR_NAME = "temp";
    public static final File JASPER_TEMP_DIR = OutputDistributionSetup.getJasperTempDirName();
    public static final int DATE_FOLDER_DEEPNESS = 4;
    public static String ENV_OUTPUT_DIR = System.getenv("OUTPUT_DIR");
    public static String SERVER_DIRECTORY = System.getenv("SERVER_PATH");
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "dd");
    public static final String OUTPUT_DIR_NAME = OutputDistributionSetup.getOutputDirName();
    private static final File OUTPUT_DIR = OutputDistributionSetup.getOutputDir();
    public static final File ATTACHMENTS_DIR = OutputDistributionSetup.getAttachmentsDir();
    public static final String REPORTS_QUEUE_NAME = OutputDistributionSetup.getReportQueueName();
    public static final String REPORT_RUNNER_LOG_FILE_NAME = OutputDistributionSetup.getLogFileName();
    public static final File REPORTS_QUEUE_DIR = OutputDistributionSetup.getReportQueueDir();
    public static final File STANDBY_BACKUP_FILE_QUEUE_DIR = OutputDistributionSetup.getStandbyBackupFileQueueDir();
    public static final File IMPORT_DIR = OutputDistributionSetup.getImportDir();
    public static final File EXPORT_DIR = OutputDistributionSetup.getExportDir();
    public static final File UC_IMPORT_DIR = OutputDistributionSetup.getUcImportDir();
    public static final File UC_EXPORT_DIR = OutputDistributionSetup.getUcExportDir();
    public static final String OUTPUT_ABSOLUTE_PATH = OUTPUT_DIR.getAbsolutePath();

    public static void init() {
        OUTPUT_DIR.mkdir();
        ATTACHMENTS_DIR.mkdir();
        REPORTS_QUEUE_DIR.mkdir();
        STANDBY_BACKUP_FILE_QUEUE_DIR.mkdir();
        IMPORT_DIR.mkdir();
        EXPORT_DIR.mkdir();
        UC_IMPORT_DIR.mkdir();
        UC_EXPORT_DIR.mkdir();
        JASPER_TEMP_DIR.mkdir();
    }

    private static String getLogFileName() {
        StringBuffer stringBuffer = new StringBuffer("entlogs");
        stringBuffer.append(File.separator);
        stringBuffer.append("Enterprise");
        stringBuffer.append(File.separator);
        stringBuffer.append("report_runner.log");
        File file = new File(SERVER_DIRECTORY, stringBuffer.toString());
        return file.getAbsolutePath();
    }

    public static String getReportQueueName() {
        StringBuffer stringBuffer = new StringBuffer(DEFAULT_OUTPUT_DIR_NAME);
        stringBuffer.append(File.separator);
        stringBuffer.append("report_queue");
        stringBuffer.append(File.separator);
        stringBuffer.append(REPORTS_QUEUE);
        return new File(SERVER_DIRECTORY, stringBuffer.toString()).getAbsolutePath();
    }

    public static String getStandbyBackupFileQueueName() {
        StringBuffer stringBuffer = new StringBuffer(DEFAULT_OUTPUT_DIR_NAME);
        stringBuffer.append(File.separator);
        stringBuffer.append("standby_backup_file_queue");
        stringBuffer.append(File.separator);
        stringBuffer.append(STANDBY_BACKUP_FILE_QUEUE);
        return new File(SERVER_DIRECTORY, stringBuffer.toString()).getAbsolutePath();
    }

    private static String getOutputDirName() {
        if (ENV_OUTPUT_DIR == null) {
            ENV_OUTPUT_DIR = DEFAULT_OUTPUT_DIR_NAME;
        }
        return ENV_OUTPUT_DIR;
    }

    private static File getAttachmentsDir() {
        File file = new File(OUTPUT_DIR.getAbsolutePath(), "attachments");
        return file;
    }

    public static String getAttachmentsDirName() {
        File file = new File(OUTPUT_DIR.getAbsolutePath(), "attachments");
        return file.getAbsolutePath();
    }

    private static File getOutputDir() {
        File file = null;
        if (SERVER_DIRECTORY != null && SERVER_DIRECTORY.trim().length() > 1) {
            file = new File(SERVER_DIRECTORY, OUTPUT_DIR_NAME);
            logger.debug((Object)("SRV_DIR: " + SERVER_DIRECTORY));
        } else {
            file = new File(OUTPUT_DIR_NAME);
        }
        logger.debug((Object)("Using DIR: " + file));
        return file;
    }

    public static String createDirForJobRun(long l, long l2) throws DataException, ResourceUnavailableException {
        JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.JobHistoryDM");
        JobHistory jobHistory = jobHistoryDM.get(l);
        Date date = new Date(jobHistory.getServerInitiatedTime());
        StringBuilder stringBuilder = new StringBuilder(DATE_FORMAT.format(date));
        stringBuilder.append(File.separator);
        stringBuilder.append(jobHistory.getJobID());
        stringBuilder.append(File.separator);
        stringBuilder.append(l);
        stringBuilder.append(File.separator);
        stringBuilder.append(l2);
        File file = new File(ATTACHMENTS_DIR.getAbsolutePath(), stringBuilder.toString());
        try {
            file.mkdirs();
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to create directory: " + file.getAbsolutePath(), (Throwable)exception);
        }
        return file.getPath();
    }

    public static String getOutputDirName(long l) throws DataException, ResourceUnavailableException {
        JobHistoryDM jobHistoryDM = (JobHistoryDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.JobHistoryDM");
        JobHistory jobHistory = jobHistoryDM.get(l);
        Date date = new Date(jobHistory.getServerInitiatedTime());
        StringBuilder stringBuilder = new StringBuilder(ATTACHMENTS_DIR.getAbsolutePath());
        stringBuilder.append(File.separator);
        stringBuilder.append(DATE_FORMAT.format(date));
        stringBuilder.append(File.separator);
        stringBuilder.append(jobHistory.getJobID());
        stringBuilder.append(File.separator);
        stringBuilder.append(l);
        return stringBuilder.toString();
    }

    public static File getReportQueueDir() {
        return new File(OUTPUT_DIR.getAbsolutePath(), "report_queue");
    }

    public static File getStandbyBackupFileQueueDir() {
        return new File(OUTPUT_DIR.getAbsolutePath(), "standby_backup_file_queue");
    }

    public static String getReportQueueDirName() {
        return REPORTS_QUEUE_DIR.getAbsolutePath();
    }

    public static String getReportQueueLogFileName() {
        return new File(OutputDistributionSetup.getReportQueueDirName(), "report_queue.log").getAbsolutePath();
    }

    public static String getUserFilesDirName() {
        File file = new File(OUTPUT_DIR.getAbsolutePath(), "userfiles");
        return file.getAbsolutePath();
    }

    public static String getUserFileRelativeName() {
        String string = OUTPUT_DIR_NAME + File.separator + "userfiles";
        return string;
    }

    public static File getJasperTempDirName() {
        File file = new File(SERVER_DIRECTORY, JASPER_TEMP_DIR_NAME);
        return file;
    }

    public static File getImportDir() {
        File file = new File(OUTPUT_DIR.getAbsolutePath(), IMPORT_DIR_NAME);
        return file;
    }

    public static File getExportDir() {
        File file = new File(OUTPUT_DIR.getAbsolutePath(), EXPORT_DIR_NAME);
        return file;
    }

    public static File getUcImportDir() {
        File file = new File(OUTPUT_DIR.getAbsolutePath(), UC_IMPORT_DIR_NAME);
        return file;
    }

    public static File getUcExportDir() {
        File file = new File(OUTPUT_DIR.getAbsolutePath(), UC_EXPORT_DIR_NAME);
        return file;
    }

    static {
        OutputDistributionSetup.init();
    }
}

