/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.io.File;
import java.io.IOException;

public class FileLocker {
    private static final String DEFAULT_FILE_NAME = "filelocker.lock";
    private static final long MILLISECONDS = 1000L;
    private static final int UNLIMITED_ATTEMPTS = Integer.MAX_VALUE;
    private static final int MAX_ATTEMPTS = 0x7FFFFFFE;
    private static final int MIN_ATTEMPTS = 1;
    private static final int DFT_ATTEMPTS = Integer.MAX_VALUE;
    private static final int MAX_INTERVAL = 3600;
    private static final int MIN_INTERVAL = 1;
    private static final int DFT_INTERVAL = 2;
    private static final int EXITCODE_OK = 0;
    private static final int EXITCODE_HELP_REQUESTED = -2;
    private static final int EXITCODE_INTERRUPTED = -1;
    private static final int EXITCODE_IO_EXCEPTION = 1;
    private static final int EXITCODE_SECURITY_EXCEPTION = 2;
    private static final int EXITCODE_TIMEOUT = 3;
    private static final int EXITCODE_UNKNOWN_EXCEPTION = 4;
    private static final int EXITCODE_PARAMETER_ERROR = 5;

    public static void main(String[] stringArray) {
        try {
            Parms parms = FileLocker.processParameters(stringArray);
            File file = new File(parms.fileName);
            FileLocker.logParms(parms);
            long l = 0L;
            System.out.println("Attempting to create file: " + file.getAbsolutePath());
            while (!file.createNewFile()) {
                System.out.print(".");
                if (++l % 60L == 0L) {
                    System.out.println();
                }
                if (parms.attempts != Integer.MAX_VALUE && l >= (long)parms.attempts) {
                    System.out.println();
                    System.out.println("FileLocker failed " + l + " attempts...");
                    System.exit(3);
                }
                try {
                    Thread.sleep((long)parms.interval * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("FileLocker was interrupted...");
                    System.exit(-1);
                }
            }
            System.out.println();
            System.out.println();
            System.out.println("Locker file " + file.getAbsolutePath() + " was created.");
            System.out.println("REMINDER: Delete the lock file when the exclusive function is complete.");
            System.exit(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            System.exit(2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(4);
        }
    }

    private static void logParms(Parms parms) {
        System.out.println();
        System.out.println("Lock File Name: " + parms.fileName);
        if (parms.attempts != Integer.MAX_VALUE) {
            System.out.println("Lock Attempts: " + parms.attempts);
        }
        System.out.println("Attempt Interval (seconds): " + parms.interval);
        System.out.println();
    }

    private static Parms processParameters(String[] stringArray) {
        String string;
        int n;
        Parms parms = new Parms();
        boolean bl = false;
        int n2 = 3;
        if (stringArray.length > n2) {
            bl = true;
            System.out.println(stringArray.length + " parameters were specified. Maximum = " + n2);
        }
        if (stringArray.length > 0 && stringArray[0] != null && stringArray[0].trim().length() > 0) {
            parms.fileName = stringArray[0].trim();
            if (FileLocker.isHelpParameter(parms.fileName)) {
                FileLocker.logHelp();
                System.exit(-2);
            }
        }
        if (stringArray.length > 1 && stringArray[1] != null && stringArray[1].trim().length() > 0) {
            n = 0;
            string = stringArray[1].trim();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.out.println("Invalid Attempts parameter: " + string);
                bl = true;
            }
            if (n != 0) {
                if (n < 1 || n > 0x7FFFFFFE) {
                    System.out.println("Invalid Attempts parameter value: " + string);
                    bl = true;
                } else {
                    parms.attempts = n;
                }
            }
        }
        if (stringArray.length > 2 && stringArray[2] != null && stringArray[2].trim().length() > 0) {
            n = 0;
            string = stringArray[2].trim();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.out.println("Invalid Interval parameter: " + string);
                bl = true;
            }
            if (n != 0) {
                if (n < 1 || n > 3600) {
                    System.out.println("Invalid Interval parameter value: " + string);
                    bl = true;
                } else {
                    parms.interval = n;
                }
            }
        }
        if (bl) {
            FileLocker.logHelp();
            System.exit(5);
        }
        return parms;
    }

    private static boolean isHelpParameter(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim().toLowerCase();
        return "-h".equals(string2) || "--h".equals(string2) || "-help".equals(string2) || "--help".equals(string2) || "-?".equals(string2) || "--?".equals(string2);
    }

    private static void logHelp() {
        System.out.println("");
        System.out.println("This program provides a method of ensuring multiple processes do not run at the same time.");
        System.out.println("");
        System.out.println("The process will attempt to create a new lock file.");
        System.out.println("If the lock file already exists, it repeatedly attempts to create the lock file until it is deleted by another process.");
        System.out.println("After a process has created the lock file, it can continue with it mutually exclusive work.");
        System.out.println("After a process has completed the mutually exclusive work, it should delete the lock file so another process can create the file and continue.");
        System.out.println("");
        System.out.println("This program has several parameter options:");
        System.out.println("   Parameter #1 = Lock file name.  Default: filelocker.lock");
        System.out.println("   Parameter #2 = Attempts before failure [1-2147483646] Default: UNLIMITED");
        System.out.println("   Parameter #3 = Seconds between attempts [1-3600] Default: 2");
        System.out.println("");
    }

    private static class Parms {
        public String fileName = "filelocker.lock";
        public int attempts = Integer.MAX_VALUE;
        public int interval = 2;

        private Parms() {
        }
    }
}

