/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfPeriod;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoTest;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfPeriod;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;

public class ScheduleInfo_DayOfPeriodTest
extends ScheduleInfoTest {
    private ScheduleInfo_DayOfPeriod info;
    private Runtimes_DayOfPeriod runtimes;

    public ScheduleInfo_DayOfPeriodTest(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.info = new ScheduleInfo_DayOfPeriod();
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        this.info.setCalendarObject(this.calendar);
        this.info.setOmitDates(this.omitDates);
        this.runtimes = new Runtimes_DayOfPeriod(this.calendar, CalendarObject.DayType.ALL_DAYS);
        this.runtimes.addRuntime(CalendarObject.PeriodType.MONTH, 15, new LocalHHMM(9, 0));
        this.runtimes.addRuntime(CalendarObject.PeriodType.MONTH, 17, new LocalHHMM(11, 15));
        this.runtimes.addRuntime(CalendarObject.PeriodType.MONTH, 18, new LocalHHMM(13, 30));
        this.info.setRuntimes(this.runtimes);
    }

    @Override
    protected void tearDown() throws Exception {
        this.info = null;
        this.runtimes = null;
        super.tearDown();
    }

    public void testGetScheduleType() {
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD, (Object)this.info.getScheduleType());
    }

    public void testValidate() {
        this.info = new ScheduleInfo_DayOfPeriod();
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        this.info.setCalendarObject(this.calendar);
        this.info.setOmitDates(this.omitDates);
        try {
            this.info.validate();
            ScheduleInfo_DayOfPeriodTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        try {
            this.info.validate();
            ScheduleInfo_DayOfPeriodTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.info.setRuntimes(this.runtimes);
        this.info.validate();
    }

    @Override
    public void testCreateScheduleInfoOfType() {
        super.testCreateScheduleInfoOfType();
        ScheduleInfo scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD, (Object)scheduleInfo.getScheduleType());
    }

    public void testToString() {
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        String string = this.info.toString();
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("Schedule type: DAY_OF_PERIOD|"));
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("Timezone type: AGENT|"));
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("Omit Date List: OmitDates|"));
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("Day type: WORKDAYS|"));
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("Runtimes: {MONTH={"));
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("15=[09:00]"));
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("17=[11:15]"));
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)string.contains("18=[13:30]"));
    }

    public void testIsRunDay() {
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)this.info.isRunDay(MAR15_SERVER_TIME_ZONE, this.jobInfo));
        ScheduleInfo_DayOfPeriodTest.assertFalse((boolean)this.info.isRunDay(MAR20_SERVER_TIME_ZONE, this.jobInfo));
    }

    public void testSetDayType() {
        this.info.setDayType(CalendarObject.DayType.ALL_DAYS);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)CalendarObject.DayType.ALL_DAYS, (Object)this.info.getDayType());
        this.info.setDayType(CalendarObject.DayType.WORKDAYS);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)CalendarObject.DayType.WORKDAYS, (Object)this.info.getDayType());
        this.info.setDayType(CalendarObject.DayType.NON_WORKDAYS);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)CalendarObject.DayType.NON_WORKDAYS, (Object)this.info.getDayType());
    }

    public void testSetRuntimes() {
    }

    @Override
    public void testCalcNST() {
        this.info.setOmitDates(null);
        Calendar calendar = this.info.calcNST(MAR15_SERVER_TIME_ZONE, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)17, (int)calendar.get(5));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)11, (int)calendar.get(11));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)15, (int)calendar.get(12));
        calendar = this.info.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)18, (int)calendar.get(5));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)13, (int)calendar.get(11));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)30, (int)calendar.get(12));
        calendar.set(11, 18);
        calendar = this.info.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)3, (int)calendar.get(2));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)15, (int)calendar.get(5));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)9, (int)calendar.get(11));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)0, (int)calendar.get(12));
        calendar = this.info.calcNST(MAR15_AGENT_TIME_ZONE, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)17, (int)calendar.get(5));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)11, (int)calendar.get(11));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)15, (int)calendar.get(12));
        calendar = this.info.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2, (int)calendar.get(2));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)18, (int)calendar.get(5));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)13, (int)calendar.get(11));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)30, (int)calendar.get(12));
        calendar.set(11, 18);
        calendar = this.info.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2010, (int)calendar.get(1));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)3, (int)calendar.get(2));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)15, (int)calendar.get(5));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)9, (int)calendar.get(11));
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)0, (int)calendar.get(12));
    }

    @Override
    public void testGetOmitDates() {
        int[] nArray = this.info.getOmitDates().getDates();
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)2, (int)nArray.length);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)20100316, (int)nArray[0]);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)20100318, (int)nArray[1]);
    }

    @Override
    public void testSetLateStartJob() {
        this.info.setLateStartJob(false);
        ScheduleInfo_DayOfPeriodTest.assertFalse((boolean)this.info.isLateStartJob());
        this.info.setLateStartJob(true);
        ScheduleInfo_DayOfPeriodTest.assertTrue((boolean)this.info.isLateStartJob());
    }

    @Override
    public void testSetNonWorkdayOption() {
        this.info.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.DO_NOT_RUN);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.DO_NOT_RUN, (Object)this.info.getNonWorkdayOption());
    }

    @Override
    public void testSetTargetID() {
        this.info.setTargetID(12345);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)12345, (int)this.info.getTargetID());
    }

    @Override
    public void testSetTargetType() {
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT, (Object)this.info.getTargetType());
        this.info.setTargetType(ScheduleInfo.TargetType.AGENT_GROUP);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT_GROUP, (Object)this.info.getTargetType());
    }

    @Override
    public void testSetTimeZoneToUse() {
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)ScheduleInfo.TimeZoneType.SERVER, (Object)this.info.getTimeZoneType());
        this.info.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        ScheduleInfo_DayOfPeriodTest.assertEquals((Object)ScheduleInfo.TimeZoneType.AGENT, (Object)this.info.getTimeZoneType());
    }

    @Override
    public void testSetUpdateCounter() {
        this.info.setUpdateCounter(33333);
        ScheduleInfo_DayOfPeriodTest.assertEquals((int)33333, (int)this.info.getUpdateCounter());
    }
}

