/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.DSTHelper;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ScheduleInfo_DateList
extends ScheduleInfo {
    private DateObject runDates;
    private Runtimes runtimes;

    public ScheduleInfo_DateList() {
        super(ScheduleJobProxy.ScheduleType.DATE_LIST);
    }

    public void setRunDates(DateObject dateObject) {
        this.runDates = dateObject;
    }

    public void setRuntimes(Runtimes runtimes) {
        ValidationHelper.checkForNull((String)"Run Times", (Object)runtimes);
        this.runtimes = runtimes;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationHelper.validateReqFieldNotNull((String)"Run Times", (Object)this.runtimes);
        if (this.runDates == null) {
            throw new IllegalStateException("There are no run dates specified, because there is no run-type Date List associated with this job.");
        }
    }

    @Override
    public Calendar calcNST(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        ValidationHelper.checkForNull((String)"CST", (Object)calendar);
        if (this.runtimes.isEmpty()) {
            throw new IllegalStateException("There are no runtimes defined.");
        }
        Calendar calendar2 = null;
        if (this.isRunDay(calendar, jobInfo)) {
            calendar2 = this.nextRuntimeSameDay(calendar, jobInfo, timeZone);
        }
        if (calendar2 == null && (calendar2 = this.nextRunDay(calendar)) != null) {
            calendar2 = this.firstRuntimeOfDay(calendar2, jobInfo, timeZone);
        }
        return calendar2;
    }

    @Override
    public String toString() {
        return super.toString() + "|Run Date List: " + this.runDates.getName() + "|Runtimes: " + this.runtimes.toString().replace("null", "none");
    }

    private Calendar firstRuntimeOfDay(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        Calendar calendar2 = this.runtimes.firstRuntimeOfDay(calendar, jobInfo);
        if (this.isOmitDate(calendar2)) {
            this.logThatJobWasOmitted(calendar2, jobInfo);
        } else {
            Calendar calendar3 = this.adjustForNonWorkdayIfNecessary(calendar2, jobInfo, timeZone);
            if (calendar3 != null) {
                return calendar3;
            }
        }
        return this.calcNST(calendar2, jobInfo, timeZone);
    }

    private Calendar nextRuntimeSameDay(Calendar calendar, JobInfo jobInfo, TimeZone timeZone) {
        Calendar calendar2;
        while ((calendar2 = this.runtimes.nextRuntimeSameDay(calendar, jobInfo)) != null) {
            if (this.isOmitDate(calendar2)) {
                this.logThatJobWasOmitted(calendar2, jobInfo);
            } else {
                Calendar calendar3 = this.adjustForNonWorkdayIfNecessary(calendar2, jobInfo, timeZone);
                if (calendar3 != null) {
                    return calendar3;
                }
            }
            calendar = calendar2;
        }
        return null;
    }

    @Override
    protected boolean isRunDay(Calendar calendar, JobInfo jobInfo) {
        int n = this.getCalendarObject().yyyymmdd_AdjustedForVirtualDay(calendar);
        return this.runDates.contains(n);
    }

    private Calendar nextRunDay(Calendar calendar) {
        int n = this.getCalendarObject().yyyymmdd_AdjustedForVirtualDay(calendar);
        int n2 = this.runDates.nextDate(n);
        if (n2 != 0) {
            long l = this.millisBetween(n, n2);
            int n3 = this.millisToDays(l);
            Calendar calendar2 = (Calendar)calendar.clone();
            try {
                DSTHelper.addDays(calendar2, n3);
            }
            catch (InvalidDateTimeException invalidDateTimeException) {
                calendar2 = invalidDateTimeException.getMovedInvalidDateTime();
            }
            return calendar2;
        }
        throw new IllegalStateException("There are no future run dates defined in the run-type Date List(s) associated with this job.");
    }

    private long millisBetween(int n, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.setCalendarToYyyymmdd(gregorianCalendar, n);
        long l = gregorianCalendar.getTimeInMillis();
        this.setCalendarToYyyymmdd(gregorianCalendar, n2);
        long l2 = gregorianCalendar.getTimeInMillis();
        return l2 - l;
    }

    private int millisToDays(long l) {
        long l2 = 86400000L;
        if (l % l2 != 0L) {
            throw new IllegalArgumentException("Milliseconds to days conversion error.");
        }
        return (int)(l / l2);
    }

    private void setCalendarToYyyymmdd(Calendar calendar, int n) {
        int n2 = n / 10000;
        int n3 = n / 100 % 100;
        int n4 = n % 100;
        calendar.clear();
        boolean bl = calendar.isLenient();
        calendar.setLenient(false);
        try {
            calendar.set(n2, n3 - 1, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = MessageUtil.formatMsg((String)"Invalid date: {0}-{1}-{2}.", (Object[])new Object[]{n2, n3, n4});
            throw new IllegalArgumentException(string);
        }
        calendar.setLenient(bl);
    }
}

