/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class Runtimes_WeekOfPeriod
implements Runtimes {
    private CalendarObject calendarObject;
    private Map<Integer, Runtimes_Basic> map = new HashMap<Integer, Runtimes_Basic>();
    private Runtimes_Basic lastWeekOfPeriodRuntimes;
    private int maximumWeeksInPeriod = 5;

    public Runtimes_WeekOfPeriod(CalendarObject calendarObject) {
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        this.calendarObject = calendarObject;
    }

    public void addRuntime(int n, LocalHHMM localHHMM) {
        ValidationHelper.validateBounds((String)"Week of period", (long)1L, (long)this.maximumWeeksInPeriod, (long)n);
        ValidationHelper.checkForNull((String)"Runtime", (Object)((Object)localHHMM));
        Runtimes_Basic runtimes_Basic = this.map.get(n);
        if (runtimes_Basic == null) {
            runtimes_Basic = new Runtimes_Basic(this.calendarObject.getDayStart());
            this.map.put(n, runtimes_Basic);
        }
        runtimes_Basic.addRuntime(localHHMM);
    }

    public void addLastWeekOfPeriodRuntime(LocalHHMM localHHMM) {
        ValidationHelper.checkForNull((String)"Runtime", (Object)((Object)localHHMM));
        if (this.lastWeekOfPeriodRuntimes == null) {
            this.lastWeekOfPeriodRuntimes = new Runtimes_Basic(this.calendarObject.getDayStart());
        }
        this.lastWeekOfPeriodRuntimes.addRuntime(localHHMM);
    }

    public void addRuntimeToEachWeek(LocalHHMM localHHMM) {
        ValidationHelper.checkForNull((String)"Runtime", (Object)((Object)localHHMM));
        for (int i = 1; i <= this.maximumWeeksInPeriod; ++i) {
            this.addRuntime(i, localHHMM);
        }
    }

    public void addRuntimesToEachWeek(Runtimes_Basic runtimes_Basic) {
        ValidationHelper.checkForNull((String)"Runtimes", (Object)runtimes_Basic);
        for (int i = 1; i <= this.maximumWeeksInPeriod; ++i) {
            this.addRuntimes(i, runtimes_Basic);
        }
    }

    @Override
    public Calendar firstRuntimeOfDay(Calendar calendar, JobInfo jobInfo) {
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        int n = this.calendarObject.weekOfMonth(calendar);
        Runtimes_Basic runtimes_Basic = this.map.get(n);
        if (this.isLastWeekOfPeriod(calendar)) {
            runtimes_Basic = this.combineRuntimes(runtimes_Basic, this.lastWeekOfPeriodRuntimes);
        }
        if (runtimes_Basic == null) {
            return null;
        }
        return runtimes_Basic.firstRuntimeOfDay(calendar, jobInfo);
    }

    @Override
    public Calendar nextRuntimeSameDay(Calendar calendar, JobInfo jobInfo) {
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        int n = this.calendarObject.weekOfMonth(calendar);
        Runtimes_Basic runtimes_Basic = this.map.get(n);
        if (this.isLastWeekOfPeriod(calendar)) {
            runtimes_Basic = this.combineRuntimes(runtimes_Basic, this.lastWeekOfPeriodRuntimes);
        }
        if (runtimes_Basic == null) {
            return null;
        }
        return runtimes_Basic.nextRuntimeSameDay(calendar, jobInfo);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty() && this.lastWeekOfPeriodRuntimes == null;
    }

    public String toString() {
        if (this.lastWeekOfPeriodRuntimes == null) {
            return this.map.toString();
        }
        return this.map.toString() + ", L=" + this.lastWeekOfPeriodRuntimes;
    }

    private void addRuntimes(int n, Runtimes_Basic runtimes_Basic) {
        LocalHHMM[] localHHMMArray;
        for (LocalHHMM localHHMM : localHHMMArray = runtimes_Basic.getRuntimes()) {
            this.addRuntime(n, localHHMM);
        }
    }

    private boolean isLastWeekOfPeriod(Calendar calendar) {
        return this.calendarObject.isLastWeekOfMonth(calendar);
    }

    private Runtimes_Basic combineRuntimes(Runtimes_Basic runtimes_Basic, Runtimes_Basic runtimes_Basic2) {
        if (runtimes_Basic == null) {
            return runtimes_Basic2;
        }
        if (runtimes_Basic2 == null) {
            return runtimes_Basic;
        }
        Runtimes_Basic runtimes_Basic3 = new Runtimes_Basic(this.calendarObject.getDayStart());
        for (LocalHHMM localHHMM : runtimes_Basic.getRuntimes()) {
            runtimes_Basic3.addRuntime(localHHMM);
        }
        for (LocalHHMM localHHMM : runtimes_Basic2.getRuntimes()) {
            runtimes_Basic3.addRuntime(localHHMM);
        }
        return runtimes_Basic3;
    }
}

