/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_Basic;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_WeekOfPeriod;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class RuntimeRanges_WeekOfPeriodTest
extends TestCase {
    private RuntimeRanges_WeekOfPeriod ranges;
    private CalendarObject calendar;
    private static final TimeRange TR0800TO0930 = new TimeRange(new LocalHHMM(8, 0), new LocalHHMM(9, 30));
    private static final TimeRange TR0900TO1000 = new TimeRange(new LocalHHMM(9, 0), new LocalHHMM(10, 0));
    private static final TimeRange TR1100TO1330 = new TimeRange(new LocalHHMM(11, 0), new LocalHHMM(13, 30));
    private static final TimeRange TR1400TO1530 = new TimeRange(new LocalHHMM(14, 0), new LocalHHMM(15, 30));
    private static final TimeRange TR1600TO1630 = new TimeRange(new LocalHHMM(16, 0), new LocalHHMM(16, 30));

    public RuntimeRanges_WeekOfPeriodTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = new CalendarObject();
        this.calendar.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        this.ranges = new RuntimeRanges_WeekOfPeriod(new CalendarObject());
    }

    protected void tearDown() throws Exception {
        this.ranges = null;
        this.calendar = null;
        super.tearDown();
    }

    public void testAddRuntimeRange() {
        this.ranges.addRuntimeRange(1, TR0800TO0930);
        String string = "{1=[08:00 - 09:30]}";
        RuntimeRanges_WeekOfPeriodTest.assertEquals((String)string, (String)this.ranges.toString());
    }

    public void testAddLastWeekOfPeriodRuntimeRange() {
        this.ranges.addLastWeekOfPeriodRuntimeRange(TR0900TO1000);
        String string = "{}, L=[09:00 - 10:00]";
        RuntimeRanges_WeekOfPeriodTest.assertEquals((String)string, (String)this.ranges.toString());
    }

    public void testAddRuntimeRangeToEachWeek() {
        this.ranges.addRuntimeRangeToEachWeek(TR0900TO1000);
        String string = "{1=[09:00 - 10:00], 2=[09:00 - 10:00], 3=[09:00 - 10:00], 4=[09:00 - 10:00], 5=[09:00 - 10:00]}";
        RuntimeRanges_WeekOfPeriodTest.assertEquals((String)string, (String)this.ranges.toString());
    }

    public void testAddRuntimeRangesToEachWeek() {
        RuntimeRanges_Basic runtimeRanges_Basic = new RuntimeRanges_Basic();
        runtimeRanges_Basic.addRuntimeRange(TR0800TO0930);
        runtimeRanges_Basic.addRuntimeRange(TR1600TO1630);
        this.ranges.addRuntimeRangesToEachWeek(runtimeRanges_Basic);
        String string = "{1=[08:00 - 09:30, 16:00 - 16:30], 2=[08:00 - 09:30, 16:00 - 16:30], 3=[08:00 - 09:30, 16:00 - 16:30], 4=[08:00 - 09:30, 16:00 - 16:30], 5=[08:00 - 09:30, 16:00 - 16:30]}";
        RuntimeRanges_WeekOfPeriodTest.assertEquals((String)string, (String)this.ranges.toString());
    }

    public void testContains() {
        this.ranges.addRuntimeRange(2, TR0900TO1000);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 9);
        gregorianCalendar.set(12, 30);
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(5, 12);
        gregorianCalendar.set(11, 13);
        gregorianCalendar.set(12, 30);
        RuntimeRanges_WeekOfPeriodTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        gregorianCalendar.set(5, 26);
        gregorianCalendar.set(11, 9);
        gregorianCalendar.set(12, 30);
        RuntimeRanges_WeekOfPeriodTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
    }

    public void testHasNoRuntimeRangesDefinedForDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(11, 9);
        gregorianCalendar.set(12, 30);
        gregorianCalendar.set(5, 26);
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        this.ranges.addRuntimeRange(1, TR0800TO0930);
        this.ranges.addLastWeekOfPeriodRuntimeRange(TR0900TO1000);
        gregorianCalendar.set(5, 5);
        RuntimeRanges_WeekOfPeriodTest.assertFalse((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        gregorianCalendar.set(5, 12);
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        gregorianCalendar.set(5, 19);
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
        gregorianCalendar.set(5, 26);
        RuntimeRanges_WeekOfPeriodTest.assertFalse((boolean)this.ranges.hasNoRuntimeRangesDefinedForDate(gregorianCalendar));
    }

    public void testIsEmpty() {
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.isEmpty());
        this.ranges.addRuntimeRange(1, TR0800TO0930);
        RuntimeRanges_WeekOfPeriodTest.assertFalse((boolean)this.ranges.isEmpty());
    }

    public void testToString() {
        this.ranges.addRuntimeRange(3, TR1600TO1630);
        this.ranges.addRuntimeRange(1, TR0800TO0930);
        this.ranges.addRuntimeRange(2, TR1100TO1330);
        this.ranges.addRuntimeRange(1, TR1400TO1530);
        String string = "{1=[08:00 - 09:30, 14:00 - 15:30], 2=[11:00 - 13:30], 3=[16:00 - 16:30]}";
        RuntimeRanges_WeekOfPeriodTest.assertEquals((String)string, (String)this.ranges.toString());
    }

    public void testContainsCombinesRuntimeRanges() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(11, 16);
        gregorianCalendar.set(12, 15);
        gregorianCalendar.set(5, 26);
        this.ranges.addRuntimeRange(1, TR1600TO1630);
        RuntimeRanges_WeekOfPeriodTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        this.ranges.addRuntimeRange(4, TR1600TO1630);
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        this.ranges = new RuntimeRanges_WeekOfPeriod(this.calendar);
        this.ranges.addLastWeekOfPeriodRuntimeRange(TR0800TO0930);
        RuntimeRanges_WeekOfPeriodTest.assertFalse((boolean)this.ranges.contains(gregorianCalendar));
        this.ranges.addLastWeekOfPeriodRuntimeRange(TR1600TO1630);
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
        this.ranges = new RuntimeRanges_WeekOfPeriod(this.calendar);
        this.ranges.addRuntimeRange(4, TR1600TO1630);
        this.ranges.addLastWeekOfPeriodRuntimeRange(TR0800TO0930);
        RuntimeRanges_WeekOfPeriodTest.assertTrue((boolean)this.ranges.contains(gregorianCalendar));
    }
}

