/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges_Basic;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class RuntimeRanges_WeekOfPeriod
implements RuntimeRanges {
    private CalendarObject calendarObject;
    private Map<Integer, RuntimeRanges_Basic> map = new HashMap<Integer, RuntimeRanges_Basic>();
    private RuntimeRanges_Basic lastWeekOfPeriodRuntimeRanges;
    private int maximumWeeksInPeriod = 5;

    public RuntimeRanges_WeekOfPeriod(CalendarObject calendarObject) {
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        this.calendarObject = calendarObject;
    }

    public void addRuntimeRange(int n, TimeRange timeRange) {
        ValidationHelper.validateBounds((String)"Week of period", (long)1L, (long)this.maximumWeeksInPeriod, (long)n);
        ValidationHelper.checkForNull((String)"Runtime Range", (Object)timeRange);
        RuntimeRanges_Basic runtimeRanges_Basic = this.map.get(n);
        if (runtimeRanges_Basic == null) {
            runtimeRanges_Basic = new RuntimeRanges_Basic();
            this.map.put(n, runtimeRanges_Basic);
        }
        runtimeRanges_Basic.addRuntimeRange(timeRange);
    }

    public void addLastWeekOfPeriodRuntimeRange(TimeRange timeRange) {
        ValidationHelper.checkForNull((String)"Runtime Range", (Object)timeRange);
        if (this.lastWeekOfPeriodRuntimeRanges == null) {
            this.lastWeekOfPeriodRuntimeRanges = new RuntimeRanges_Basic();
        }
        this.lastWeekOfPeriodRuntimeRanges.addRuntimeRange(timeRange);
    }

    public void addRuntimeRangeToEachWeek(TimeRange timeRange) {
        ValidationHelper.checkForNull((String)"Runtime Range", (Object)timeRange);
        for (int i = 1; i <= this.maximumWeeksInPeriod; ++i) {
            this.addRuntimeRange(i, timeRange);
        }
    }

    public void addRuntimeRangesToEachWeek(RuntimeRanges_Basic runtimeRanges_Basic) {
        ValidationHelper.checkForNull((String)"Runtime Ranges", (Object)runtimeRanges_Basic);
        for (int i = 1; i <= this.maximumWeeksInPeriod; ++i) {
            this.addRuntimeRanges(i, runtimeRanges_Basic);
        }
    }

    @Override
    public boolean contains(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Date/Time", (Object)calendar);
        int n = this.calendarObject.weekOfMonth(calendar);
        RuntimeRanges_Basic runtimeRanges_Basic = this.map.get(n);
        if (this.isLastWeekOfPeriod(calendar)) {
            runtimeRanges_Basic = this.combineRuntimeRanges(runtimeRanges_Basic, this.lastWeekOfPeriodRuntimeRanges);
        }
        return runtimeRanges_Basic != null && runtimeRanges_Basic.contains(calendar);
    }

    @Override
    public boolean hasNoRuntimeRangesDefinedForDate(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Date/Time", (Object)calendar);
        int n = this.calendarObject.weekOfMonth(calendar);
        if (this.isLastWeekOfPeriod(calendar)) {
            return this.map.get(n) == null && this.lastWeekOfPeriodRuntimeRanges == null;
        }
        return this.map.get(n) == null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty() && this.lastWeekOfPeriodRuntimeRanges == null;
    }

    public String toString() {
        if (this.lastWeekOfPeriodRuntimeRanges == null) {
            return this.map.toString();
        }
        return this.map.toString() + ", L=" + this.lastWeekOfPeriodRuntimeRanges;
    }

    private void addRuntimeRanges(int n, RuntimeRanges_Basic runtimeRanges_Basic) {
        TimeRange[] timeRangeArray;
        for (TimeRange timeRange : timeRangeArray = runtimeRanges_Basic.getRuntimeRanges()) {
            this.addRuntimeRange(n, timeRange);
        }
    }

    private RuntimeRanges_Basic combineRuntimeRanges(RuntimeRanges_Basic runtimeRanges_Basic, RuntimeRanges_Basic runtimeRanges_Basic2) {
        if (runtimeRanges_Basic == null) {
            return runtimeRanges_Basic2;
        }
        if (runtimeRanges_Basic2 == null) {
            return runtimeRanges_Basic;
        }
        RuntimeRanges_Basic runtimeRanges_Basic3 = new RuntimeRanges_Basic();
        for (TimeRange timeRange : runtimeRanges_Basic.getRuntimeRanges()) {
            runtimeRanges_Basic3.addRuntimeRange(timeRange);
        }
        for (TimeRange timeRange : runtimeRanges_Basic2.getRuntimeRanges()) {
            runtimeRanges_Basic3.addRuntimeRange(timeRange);
        }
        return runtimeRanges_Basic3;
    }

    private boolean isLastWeekOfPeriod(Calendar calendar) {
        return this.calendarObject.isLastWeekOfMonth(calendar);
    }
}

