/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.scheduler.AgentGroupPrereqStatus;
import com.helpsystems.enterprise.core.scheduler.PrereqStatus;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;

public class Prereq
extends EnterpriseVersionedObject {
    private static final long serialVersionUID = -2935853147083830326L;
    private static final String LABEL = "DEPID({0}).DEP_JOB({1}).PR_OBJECT({2}).PR_FILE({3}).PR_TYPE({4}).CONJUNCTION({5}).SEQ({6}).REACTSTS({7})";
    private static final String UNSATISFIED_JOB_STATUS = "Prereq {0} for Job {1} on agent {2} has {3} instead of {4} status.";
    private static final String UNSATISFIED_EVENT_STATUS = "Prereq {0} for Agent Event {1} on agent {2} has {3} instead of {4} status.";
    private static final String UNSATISFIED_SNMP_STATUS = "Prereq {0} for SNMP Trap {1} has {2} instead of {3} status.";
    private static final String UNSATISFIED_JOB_MONITOR = "Prereq {0} for Job Monitor {1} on agent {2} has {3} instead of {4} status.";
    private static final String UNSATISFIED_JOB_SUITE_STATUS = "Prereq {0} for Job Suite {1} has {3} instead of {4} status.";
    private static final String UNSATISFIED_JOB_SUITE_MEMBER_STATUS = "Prereq {0} for Job Suite Member {1} on agent {2} has {3} instead of {4} status.";
    private static final String UNSATISFIED_JOB_SUITE_MONITOR = "Prereq {0} for Job Monitor for Suite {1} has {3} instead of {4} status.";
    private static final String UNSATISFIED_JOB_SUITE_MEMBER_MONITOR = "Prereq {0} for Job Monitor for Suite Member {1} on agent {2} has {3} instead of {4} status.";
    private static final String UNSATISFIED_SAP_EVENT = "Prereq {0} for SAP Event {1} has {2} instead of {3} status.";
    private static final String UNSATISFIED_REMOTE_EVENT = "Prereq {0} for Remote Event {1} has {2} instead of {3} status.";
    private static final String SATISFIED_JOB_STATUS = "Prereq {0} for Job {1} on agent {2} has {3} status from job history {4}.";
    private static final String SATISFIED_EVENT_STATUS = "Prereq {0} for Agent Event {1} on agent {2} has {3} status from event history {4}.";
    private static final String SATISFIED_SNMP_STATUS = "Prereq {0} for SNMP Trap {1} has {2} status from SNMP history {3}.";
    private static final String SATISFIED_REMOTE_EVENT_STATUS = "Prereq {0} for Remote Event {1} has {2} status from Remote Event history {3}.";
    private static final String SATISFIED_JOB_MONITOR = "Prereq {0} for Job Monitor {1} on agent {2} has {3} status from job monitor history {4}.";
    private static final String SATISFIED_JOB_SUITE_STATUS = "Prereq {0} for Job Suite {1} has {3} status from job suite history {4}.";
    private static final String SATISFIED_JOB_SUITE_MEMBER_STATUS = "Prereq {0} for Job Suite Member {1} on agent {2} has {3} status from job monitor history {4}.";
    private static final String SATISFIED_JOB_SUITE_MONITOR = "Prereq {0} for Job Monitor for Suite {1} has {3} status from job suite monitor history {4}.";
    private static final String SATISFIED_JOB_SUITE_MEMBER_MONITOR = "Prereq {0} for Job Monitor for Suite Member {1} on agent {2} has {3} status from job monitor history {4}.";
    private static final String SATISFIED_SAP_EVENT = "Prereq {0} for SAP Event {1} has {2} status from SAP Event history {3}.";
    private static final String SATISFIED_JOBSTS_CODE = "PR_JOBSTS:{0}:{1}:{2}:{3}:{4}";
    private static final String SATISFIED_EVTMON_CODE = "PR_EVTMON:{0}:{1}:{2}:{3}:{4}";
    private static final String SATISFIED_SNMP_CODE = "PR_SNMP:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_JOBMON_CODE = "PR_JOBMON:{0}:{1}:{2}:{3}:{4}";
    private static final String SATISFIED_RMTEVT_CODE = "PR_RMTEVT:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_JS_STS_CODE = "PR_JSSTS:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_JSM_STS_CODE = "PR_JSMSTS:{0}:{1}:{2}:{3}:{4}";
    private static final String SATISFIED_JS_MON_CODE = "PR_JSMON:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_JSM_MON_CODE = "PR_JSMMON:{0}:{1}:{2}:{3}:{4}";
    private static final String SATISFIED_SAPEVENT_CODE = "PR_SAPEH:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_AG_EVTMON_CODE = "PR_AG_EVTMON:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_AG_JOBSTS_CODE = "PR_AG_JOBSTS:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_AG_JOBMON_CODE = "PR_AG_JOBMON:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_AG_JOB_SUITE_MEMBER_STATUS = "PR_AG_JSMSTS:{0}:{1}:{2}:{3}";
    private static final String SATISFIED_AG_JSMMON_CODE = "PR_AG_JSMMON:{0}:{1}:{2}:{3}";
    private long id;
    private long depJobID;
    private long prereqObjectID;
    private ParentType prereqObjectFile;
    private PrereqEventType type;
    private int sequenceNumber;
    private String conjunction;
    private PrereqStatusType reactToStatus;
    private boolean latchStatus;
    private boolean keepStatus;
    private long specialInstanceID;
    private PrereqStatus prereqStatus;

    public String toString() {
        return MessageUtil.formatMsg((String)LABEL, (Object[])new Object[]{this.id, this.depJobID, this.prereqObjectID, this.prereqObjectFile, this.type, this.conjunction, this.sequenceNumber, this.reactToStatus});
    }

    public long getID() {
        return this.id;
    }

    public void setID(long l) {
        this.id = l;
    }

    public long getDepJobID() {
        return this.depJobID;
    }

    public void setDepJobID(long l) {
        this.depJobID = l;
    }

    public long getPrereqObjectID() {
        return this.prereqObjectID;
    }

    public void setPrereqObjectID(long l) {
        this.prereqObjectID = l;
    }

    public ParentType getPrereqObjectFile() {
        return this.prereqObjectFile;
    }

    public void setPrereqObjectFile(ParentType parentType) {
        this.prereqObjectFile = parentType;
    }

    public PrereqEventType getType() {
        return this.type;
    }

    public void setType(PrereqEventType prereqEventType) {
        this.type = prereqEventType;
    }

    public PrereqStatusType getReactToStatus() {
        return this.reactToStatus;
    }

    public void setReactToStatus(PrereqStatusType prereqStatusType) {
        this.reactToStatus = prereqStatusType;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int n) {
        this.sequenceNumber = n;
    }

    public String getConjunction() {
        return this.conjunction;
    }

    public void setConjunction(String string) {
        this.conjunction = string;
    }

    public PrereqStatus getPrereqStatus() {
        return this.prereqStatus;
    }

    public void setPrereqStatus(PrereqStatus prereqStatus) {
        this.prereqStatus = prereqStatus;
    }

    public boolean isLatchStatus() {
        return this.latchStatus;
    }

    public void setLatchStatus(boolean bl) {
        this.latchStatus = bl;
    }

    public boolean isKeepStatus() {
        return this.keepStatus;
    }

    public void setKeepStatus(boolean bl) {
        this.keepStatus = bl;
    }

    public String getPrereqText() {
        if (this.isSatisfied()) {
            return this.getSatisfiedText();
        }
        return this.getNotSatisfiedText();
    }

    public String getHistoryCode() {
        if (this.prereqStatus instanceof AgentGroupPrereqStatus) {
            AgentGroupPrereqStatus agentGroupPrereqStatus = (AgentGroupPrereqStatus)this.prereqStatus;
            switch (this.type) {
                case JOB_STATUS_CHANGE: {
                    return MessageUtil.formatMsg((String)SATISFIED_AG_JOBSTS_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, agentGroupPrereqStatus.getPrereqAgentGroupID(), this.reactToStatus.persistanceCode()});
                }
                case AGENT_EVENT: {
                    return MessageUtil.formatMsg((String)SATISFIED_AG_EVTMON_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, agentGroupPrereqStatus.getPrereqAgentGroupID(), this.reactToStatus.persistanceCode()});
                }
                case JOB_MONITOR_EVENT: {
                    return MessageUtil.formatMsg((String)SATISFIED_AG_JOBMON_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, agentGroupPrereqStatus.getPrereqAgentGroupID(), this.reactToStatus.persistanceCode()});
                }
                case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                    return MessageUtil.formatMsg((String)SATISFIED_AG_JOB_SUITE_MEMBER_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, agentGroupPrereqStatus.getPrereqAgentGroupID(), this.reactToStatus.persistanceCode()});
                }
                case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                    return MessageUtil.formatMsg((String)SATISFIED_AG_JSMMON_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, agentGroupPrereqStatus.getPrereqAgentGroupID(), this.reactToStatus.persistanceCode()});
                }
            }
            return "Error getting history code (1) for Type: " + this.type + " Prerequisite with AgentGroupPrereqStatus and agentGroupId " + agentGroupPrereqStatus.getPrereqAgentGroupID() + " is not properly defined.";
        }
        long l = 0L;
        long l2 = 0L;
        if (this.prereqStatus != null) {
            l = this.prereqStatus.getPrereqAgentID();
            l2 = this.prereqStatus.getHistoryID();
        }
        switch (this.type) {
            case JOB_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)SATISFIED_JOBSTS_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l, l2, this.reactToStatus.persistanceCode()});
            }
            case AGENT_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_EVTMON_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l, l2, this.reactToStatus.persistanceCode()});
            }
            case SNMP_TRAP_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_SNMP_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l2, this.reactToStatus.persistanceCode()});
            }
            case SAP_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_SAPEVENT_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l2, this.reactToStatus.persistanceCode()});
            }
            case JOB_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_JOBMON_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l, l2, this.reactToStatus.persistanceCode()});
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)SATISFIED_JS_STS_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l2, this.reactToStatus.persistanceCode()});
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)SATISFIED_JSM_STS_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l, l2, this.reactToStatus.persistanceCode()});
            }
            case JOB_SUITE_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_JS_MON_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l2, this.reactToStatus.persistanceCode()});
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_JSM_MON_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l, l2, this.reactToStatus.persistanceCode()});
            }
            case REMOTE_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_RMTEVT_CODE, (Object[])new Object[]{this.id, this.prereqObjectID, l2, this.reactToStatus.persistanceCode()});
            }
        }
        return "Error getting history code (2) for Type: " + this.type + "Prerequisite " + this.id + " is not properly defined.";
    }

    private String getNotSatisfiedText() {
        String string;
        String string2;
        if (this.prereqStatus != null && this.prereqStatus.getCurrentStatus() != null) {
            string2 = this.prereqStatus.getCurrentStatus().toString();
            string = String.valueOf(this.prereqStatus.getPrereqAgentID());
        } else {
            string2 = "No Status";
            string = "N/A";
        }
        switch (this.type) {
            case JOB_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)UNSATISFIED_JOB_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, string, string2, this.reactToStatus.toString()});
            }
            case AGENT_EVENT: {
                return MessageUtil.formatMsg((String)UNSATISFIED_EVENT_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, string, string2, this.reactToStatus.toString()});
            }
            case SNMP_TRAP_EVENT: {
                return MessageUtil.formatMsg((String)UNSATISFIED_SNMP_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, string2, this.reactToStatus.toString()});
            }
            case JOB_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)UNSATISFIED_JOB_MONITOR, (Object[])new Object[]{this.id, this.prereqObjectID, string, string2, this.reactToStatus.toString()});
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)UNSATISFIED_JOB_SUITE_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, 0L, string2, this.reactToStatus.toString()});
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)UNSATISFIED_JOB_SUITE_MEMBER_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, string, string2, this.reactToStatus.toString()});
            }
            case JOB_SUITE_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)UNSATISFIED_JOB_SUITE_MONITOR, (Object[])new Object[]{this.id, this.prereqObjectID, 0L, string2, this.reactToStatus.toString()});
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)UNSATISFIED_JOB_SUITE_MEMBER_MONITOR, (Object[])new Object[]{this.id, this.prereqObjectID, string, string2, this.reactToStatus.toString()});
            }
            case SAP_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)UNSATISFIED_SAP_EVENT, (Object[])new Object[]{this.id, this.prereqObjectID, string2, this.reactToStatus.toString()});
            }
            case REMOTE_EVENT: {
                return MessageUtil.formatMsg((String)UNSATISFIED_REMOTE_EVENT, (Object[])new Object[]{this.id, this.prereqObjectID, string2, this.reactToStatus.toString()});
            }
        }
        return "Error getting not satisfied text for Type: " + this.type + " Prerequisite " + this.id + " is not properly defined.";
    }

    private String getSatisfiedText() {
        switch (this.type) {
            case JOB_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)SATISFIED_JOB_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getPrereqAgentID(), this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case AGENT_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_EVENT_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getPrereqAgentID(), this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case SNMP_TRAP_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_SNMP_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case SAP_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_SAP_EVENT, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case JOB_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_JOB_MONITOR, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getPrereqAgentID(), this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)SATISFIED_JOB_SUITE_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, 0L, this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return MessageUtil.formatMsg((String)SATISFIED_JOB_SUITE_MEMBER_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getPrereqAgentID(), this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case JOB_SUITE_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_JOB_SUITE_MONITOR, (Object[])new Object[]{this.id, this.prereqObjectID, 0L, this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_JOB_SUITE_MEMBER_MONITOR, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getPrereqAgentID(), this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
            case REMOTE_EVENT: {
                return MessageUtil.formatMsg((String)SATISFIED_REMOTE_EVENT_STATUS, (Object[])new Object[]{this.id, this.prereqObjectID, this.prereqStatus.getCurrentStatus().toString(), this.prereqStatus.getHistoryID()});
            }
        }
        return "Error getting satisfied text for Type: " + this.type + " Prerequisite " + this.id + " is not properly defined.";
    }

    public boolean isSatisfied() {
        if (this.prereqStatus == null) {
            return false;
        }
        if (this.reactToStatus.equals(PrereqStatusType.ENDED)) {
            return this.prereqStatus.getCurrentStatus() == PrereqStatusType.COMPLETED || this.prereqStatus.getCurrentStatus() == PrereqStatusType.FAILED || this.prereqStatus.getCurrentStatus() == PrereqStatusType.CANCELED || this.prereqStatus.getCurrentStatus() == PrereqStatusType.SKIPPED;
        }
        return this.reactToStatus == this.prereqStatus.getCurrentStatus();
    }

    public void validate() {
    }

    public void setSpecialInstanceID(long l) {
        this.specialInstanceID = l;
    }

    public long getSpecialInstanceID() {
        return this.specialInstanceID;
    }
}

