/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.util.Arrays;
import java.util.Collection;

public enum JobSuiteStatus implements PersistableEnum<String>
{
    INITIATED(JobStatusCode.INITIATED.persistanceCode()),
    RUNNING(JobStatusCode.RUNNING.persistanceCode()),
    COMPLETED(JobStatusCode.COMPLETED.persistanceCode()),
    MEMBER_FAILED(JobStatusCode.MEMBER_FAILED.persistanceCode()),
    FAILED(JobStatusCode.FAILED.persistanceCode()),
    MEMBER_CANCELED(JobStatusCode.MEMBER_CANCELED.persistanceCode()),
    CANCELED(JobStatusCode.CANCELED.persistanceCode()),
    SKIPPED(JobStatusCode.SKIPPED.persistanceCode()),
    MANAGED(JobStatusCode.MANAGED.persistanceCode());

    public static final Collection<JobSuiteStatus> TERMINAL_STATES;
    public static final Collection<JobSuiteStatus> TERMINATABLE_STATES;
    private String persistanceCode;
    private static PersistanceCodeToEnumMap<String, JobSuiteStatus> map;

    private JobSuiteStatus(String string2) {
        this.persistanceCode = string2;
    }

    @Override
    public String persistanceCode() {
        return this.persistanceCode;
    }

    public static JobSuiteStatus persistanceCodeToEnum(String string) {
        JobSuiteStatus jobSuiteStatus = map.get(string);
        if (jobSuiteStatus == null) {
            String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
            throw new IllegalStateException(string2);
        }
        return jobSuiteStatus;
    }

    public boolean isTerminalState() {
        return TERMINAL_STATES.contains(this);
    }

    public boolean isTerminatableState() {
        return TERMINATABLE_STATES.contains(this);
    }

    static {
        TERMINAL_STATES = Arrays.asList(COMPLETED, FAILED, CANCELED);
        TERMINATABLE_STATES = Arrays.asList(INITIATED, RUNNING, MEMBER_FAILED, MEMBER_CANCELED);
        map = new PersistanceCodeToEnumMap((Enum[])JobSuiteStatus.values());
    }
}

