/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.JobInfo;
import junit.framework.TestCase;

public class JobInfoTest
extends TestCase {
    private JobInfo info;

    protected void setUp() throws Exception {
        super.setUp();
        this.info = new JobInfo();
    }

    protected void tearDown() throws Exception {
        this.info = null;
        super.tearDown();
    }

    public void testJobInfoIntString() {
        this.info = new JobInfo(12345, "jobName");
        JobInfoTest.assertEquals((int)12345, (int)this.info.getJobID());
        JobInfoTest.assertEquals((String)"jobName", (String)this.info.getJobName());
    }

    public void testJobInfoIntStringIntString() {
        this.info = new JobInfo(12345, "jobName", 34567, "agentName");
        JobInfoTest.assertEquals((int)12345, (int)this.info.getJobID());
        JobInfoTest.assertEquals((String)"jobName", (String)this.info.getJobName());
        JobInfoTest.assertEquals((int)34567, (int)this.info.getAgentID());
        JobInfoTest.assertEquals((String)"agentName", (String)this.info.getAgentName());
    }

    public void testSetAgentID() {
        this.info.setAgentID(23456);
        JobInfoTest.assertEquals((int)23456, (int)this.info.getAgentID());
    }

    public void testSetAgentName() {
        this.info.setAgentName("agentName");
        JobInfoTest.assertEquals((String)"agentName", (String)this.info.getAgentName());
    }

    public void testSetAgentInfo() {
        this.info.setAgentInfo(45678, "the_agent_name");
        JobInfoTest.assertEquals((int)45678, (int)this.info.getAgentID());
        JobInfoTest.assertEquals((String)"the_agent_name", (String)this.info.getAgentName());
    }

    public void testSetJobID() {
        this.info.setJobID(34567);
        JobInfoTest.assertEquals((int)34567, (int)this.info.getJobID());
    }

    public void testSetJobName() {
        this.info.setJobName("jobName");
        JobInfoTest.assertEquals((String)"jobName", (String)this.info.getJobName());
    }

    public void testGetAgentIDAsString() {
        this.info.setAgentID(23456);
        JobInfoTest.assertEquals((String)"23456", (String)this.info.getAgentIDAsString());
    }

    public void testGetAgentNameOrID() {
        this.info.setAgentName(null);
        this.info.setAgentID(12345);
        JobInfoTest.assertEquals((String)"12345", (String)this.info.getAgentNameOrID());
        this.info.setAgentName("agent_name");
        JobInfoTest.assertEquals((String)"agent_name", (String)this.info.getAgentNameOrID());
    }

    public void testGetAgentNameWithID() {
        this.info.setAgentName("agent_name");
        this.info.setAgentID(0);
        JobInfoTest.assertEquals((String)"agent_name", (String)this.info.getAgentNameWithID());
        this.info.setAgentID(12345);
        JobInfoTest.assertEquals((String)"agent_name (12345)", (String)this.info.getAgentNameWithID());
        this.info.setAgentName(null);
        JobInfoTest.assertEquals((String)"12345", (String)this.info.getAgentNameWithID());
    }

    public void testGetJobIDAsString() {
        this.info.setJobID(123456);
        JobInfoTest.assertEquals((String)"123456", (String)this.info.getJobIDAsString());
    }

    public void testGetJobNameOrID() {
        this.info.setJobName(null);
        this.info.setJobID(34567);
        JobInfoTest.assertEquals((String)"34567", (String)this.info.getJobNameOrID());
        this.info.setJobName("job_name");
        JobInfoTest.assertEquals((String)"job_name", (String)this.info.getJobNameOrID());
    }

    public void testGetJobNameWithID() {
        this.info.setJobName("job_name");
        this.info.setJobID(0);
        JobInfoTest.assertEquals((String)"job_name (0)", (String)this.info.getJobNameWithID());
        this.info.setJobID(45678);
        JobInfoTest.assertEquals((String)"job_name (45678)", (String)this.info.getJobNameWithID());
    }
}

