/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.ForecastFilter;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.ForecastedEvent;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;

public class ForecastResults {
    private ForecastedEvent[] forecastedEvents;
    private Map<ForecastableEvent, Exception> errorMap;
    private ForecastableEvent[] forecastableEvents;
    private ForecastFilter forecastFilter;
    private Calendar rangeBegin;
    private Calendar rangeEnd;

    public ForecastResults(ForecastableEvent[] forecastableEventArray, Calendar calendar, Calendar calendar2) {
        ValidationHelper.checkForNull((String)"Forecastable Events", (Object)forecastableEventArray);
        ValidationHelper.checkForNull((String)"Range Begin", (Object)calendar);
        ValidationHelper.checkForNull((String)"Range End", (Object)calendar2);
        this.forecastableEvents = forecastableEventArray;
        this.rangeBegin = calendar;
        this.rangeEnd = calendar2;
    }

    public Map<ForecastableEvent, Exception> getErrorMap() {
        return this.errorMap;
    }

    public Set<ForecastableEvent> getEventsWithError() {
        if (this.errorMap != null) {
            return this.errorMap.keySet();
        }
        return null;
    }

    public ForecastedEvent[] getForecastedEvents() {
        return this.forecastedEvents;
    }

    public ForecastableEvent[] getForecastableEvents() {
        return this.forecastableEvents;
    }

    public ForecastFilter getForecastFilter() {
        return this.forecastFilter;
    }

    public Calendar getRangeBegin() {
        return this.rangeBegin;
    }

    public Calendar getRangeEnd() {
        return this.rangeEnd;
    }

    public boolean hasErrors() {
        return this.errorMap != null && this.errorMap.size() > 0;
    }

    public void setErrorMap(Map<ForecastableEvent, Exception> map) {
        this.errorMap = map;
    }

    public void setForecastedEvents(ForecastedEvent[] forecastedEventArray) {
        ValidationHelper.checkForNull((String)"Forecasted Events", (Object)forecastedEventArray);
        this.forecastedEvents = forecastedEventArray;
    }

    public void setForecastFilter(ForecastFilter forecastFilter) {
        this.forecastFilter = forecastFilter;
    }
}

