/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.DateRange;
import com.helpsystems.enterprise.core.scheduler.FiscalYear;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;

public class FiscalCalendar
extends CalendarObject {
    FiscalYear[] years = new FiscalYear[0];

    public void setYears(FiscalYear[] fiscalYearArray) {
        ValidationHelper.checkForNull((String)"Fiscal Years", (Object)fiscalYearArray);
        this.years = fiscalYearArray;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public boolean isLastWeekOfMonth(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        int n = 0;
        RuntimeException runtimeException = null;
        try {
            n = this.relativeDayFromEndOfPeriod(calendar, CalendarObject.PeriodType.MONTH, CalendarObject.DayType.ALL_DAYS);
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        if (n == 0 || runtimeException != null) {
            String string = MessageUtil.formatMsg((String)"Unable to determine if the date occurs in the last week of the month, because unable to determine the relative day from the end of the month, for the date: {0}.", (Object[])new Object[]{this.formatAsYyyymmdd(calendar)});
            throw new IllegalStateException(string, runtimeException);
        }
        return n <= 7;
    }

    @Override
    public boolean isNonWorkday(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Date field", (Object)calendar);
        int n = this.yyyymmdd_AdjustedForVirtualDay(calendar);
        if (this.isDateOutsideRangeOfCalendar(n)) {
            String string = MessageUtil.formatMsg((String)"Unable to determine if {0} is a non-workday, because it is outside of the range of dates defined in fiscal calendar {1}. The fiscal years defined are {2}.", (Object[])new Object[]{n, this.getName(), Arrays.toString(this.years)});
            throw new CalendarObjectRangeException(string);
        }
        return super.isNonWorkday(n);
    }

    public int maximumDateDefined() {
        int n = 0;
        for (FiscalYear fiscalYear : this.years) {
            if (fiscalYear.getEnd() <= n) continue;
            n = fiscalYear.getEnd();
        }
        return n;
    }

    @Override
    public int weekOfMonth(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        int n = 0;
        RuntimeException runtimeException = null;
        try {
            n = this.relativeDayFromBeginOfPeriod(calendar, CalendarObject.PeriodType.MONTH, CalendarObject.DayType.ALL_DAYS);
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        if (n == 0 || runtimeException != null) {
            String string = MessageUtil.formatMsg((String)"Unable to calculate the week of the month, because unable to determine the relative day from the beginning of the month, for the date: {0}.", (Object[])new Object[]{this.formatAsYyyymmdd(calendar)});
            throw new IllegalStateException(string, runtimeException);
        }
        return (n - 1) / 7 + 1;
    }

    @Override
    protected DateRange periodContaining(int n, CalendarObject.PeriodType periodType) {
        ValidationHelper.checkForNull((String)"Period type", (Object)periodType);
        switch (periodType) {
            case YEAR: {
                for (FiscalYear fiscalYear : this.years) {
                    if (!fiscalYear.contains(n)) continue;
                    return fiscalYear;
                }
                String string = MessageUtil.formatMsg((String)"Unable to determine the period, of type {0}, defined in fiscal calendar {1} that contains {2}. This is because {2} is outside of the range of dates defined. The fiscal years defined are {3}.", (Object[])new Object[]{periodType, this.getName(), n, Arrays.toString(this.years)});
                throw new CalendarObjectRangeException(string, this.maximumDateDefined());
            }
        }
        FiscalYear fiscalYear = (FiscalYear)this.periodContaining(n, CalendarObject.PeriodType.YEAR);
        try {
            return fiscalYear.periodContaining(n, periodType);
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Unable to determine the period, of type {0}, defined in fiscal calendar {1} that contains {2}.", (Object[])new Object[]{periodType, this, n});
            throw new IllegalStateException(string, exception);
        }
    }

    private boolean isDateOutsideRangeOfCalendar(int n) {
        for (FiscalYear fiscalYear : this.years) {
            if (!fiscalYear.contains(n)) continue;
            return false;
        }
        return true;
    }

    private String formatAsYyyymmdd(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        return simpleDateFormat.format(calendar.getTime());
    }
}

