/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.DateObject;
import junit.framework.TestCase;

public class DateObjectTest
extends TestCase {
    private DateObject dateObj;
    private static final int JAN_01 = 20100101;
    private static final int FEB_01 = 20100201;
    private static final int MAR_01 = 20100301;
    private static final int[] FIRST_OF_MONTH = new int[]{20100101, 20100201, 20100301};
    private static final int JAN_15 = 20100115;
    private static final int FEB_15 = 20100215;
    private static final int MAR_15 = 20100315;
    private static final int[] FIFTEENTH_OF_MONTH = new int[]{20100115, 20100215, 20100315};
    private static final int FEB_10 = 20100210;
    private static final int[] FEB_DATES = new int[]{20100201, 20100210, 20100215};

    public DateObjectTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dateObj = new DateObject();
    }

    protected void tearDown() throws Exception {
        this.dateObj = null;
        super.tearDown();
    }

    public void testSetDates() {
        this.dateObj.addDates(FIFTEENTH_OF_MONTH);
        DateObjectTest.assertEquals((int)3, (int)this.dateObj.getDates().length);
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100101));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100201));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100210));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100301));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100115));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100215));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100315));
        this.dateObj.setDates(FIRST_OF_MONTH);
        DateObjectTest.assertEquals((int)3, (int)this.dateObj.getDates().length);
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100115));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100210));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100215));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100315));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100101));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100201));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100301));
    }

    public void testSetDatesRemovesDuplicates() {
        int[] nArray = new int[]{20100115, 20100115, 20100120, 20100201, 20100201, 20100215};
        this.dateObj.setDates(nArray);
        DateObjectTest.assertEquals((int)4, (int)this.dateObj.getDates().length);
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100115));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100120));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100201));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100215));
    }

    public void testSetNotifyBeforeExpiration() {
        this.dateObj.setNotifyBeforeExpiration(false);
        DateObjectTest.assertFalse((boolean)this.dateObj.isNotifyBeforeExpiration());
        this.dateObj.setNotifyBeforeExpiration(true);
        DateObjectTest.assertTrue((boolean)this.dateObj.isNotifyBeforeExpiration());
    }

    public void testNextDate() {
        this.dateObj.addDates(FIRST_OF_MONTH);
        DateObjectTest.assertEquals((int)20100201, (int)this.dateObj.nextDate(20100115));
        DateObjectTest.assertEquals((int)20100301, (int)this.dateObj.nextDate(20100201));
        DateObjectTest.assertEquals((int)0, (int)this.dateObj.nextDate(20100301));
        DateObjectTest.assertEquals((int)0, (int)this.dateObj.nextDate(20100315));
    }

    public void testAddDates() {
        this.dateObj.setName("DATEOBJ");
        this.dateObj.setDescription("Test Date Object");
        this.dateObj.addDates(FIRST_OF_MONTH);
        DateObjectTest.assertEquals((int)3, (int)this.dateObj.getDates().length);
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100101));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100115));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100201));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100210));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100215));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100301));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100315));
        this.dateObj.addDates(FIFTEENTH_OF_MONTH);
        DateObjectTest.assertEquals((int)6, (int)this.dateObj.getDates().length);
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100101));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100115));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100201));
        DateObjectTest.assertFalse((boolean)this.dateObj.contains(20100210));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100215));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100301));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100315));
        this.dateObj.addDates(FEB_DATES);
        DateObjectTest.assertEquals((int)7, (int)this.dateObj.getDates().length);
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100101));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100115));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100201));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100210));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100215));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100301));
        DateObjectTest.assertTrue((boolean)this.dateObj.contains(20100315));
        DateObjectTest.assertEquals((int)20100101, (int)this.dateObj.nextDate(20091231));
        DateObjectTest.assertEquals((int)20100115, (int)this.dateObj.nextDate(20100101));
        DateObjectTest.assertEquals((int)20100201, (int)this.dateObj.nextDate(20100115));
        DateObjectTest.assertEquals((int)20100210, (int)this.dateObj.nextDate(20100201));
        DateObjectTest.assertEquals((int)20100215, (int)this.dateObj.nextDate(20100210));
        DateObjectTest.assertEquals((int)20100301, (int)this.dateObj.nextDate(20100215));
        DateObjectTest.assertEquals((int)20100315, (int)this.dateObj.nextDate(20100301));
        DateObjectTest.assertEquals((int)0, (int)this.dateObj.nextDate(20100315));
    }
}

