/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.SimpleProxy;
import java.util.Arrays;

public class DateObject
extends SimpleProxy {
    private int[] dates = new int[0];
    private boolean notifyBeforeExpiration;

    public int[] getDates() {
        return this.dates;
    }

    public void setDates(int[] nArray) {
        ValidationHelper.checkForNull((String)"Dates", (Object)nArray);
        this.dates = this.duplicateDates(nArray) ? this.removeDuplicates(nArray) : nArray;
    }

    public boolean isNotifyBeforeExpiration() {
        return this.notifyBeforeExpiration;
    }

    public void setNotifyBeforeExpiration(boolean bl) {
        this.notifyBeforeExpiration = bl;
    }

    public void addDates(int[] nArray) {
        ValidationHelper.checkForNull((String)"Additional Dates", (Object)nArray);
        int[] nArray2 = new int[this.dates.length + nArray.length];
        System.arraycopy(this.dates, 0, nArray2, 0, this.dates.length);
        System.arraycopy(nArray, 0, nArray2, this.dates.length, nArray.length);
        this.setDates(nArray2);
    }

    public boolean contains(int n) {
        return this.isInArray(this.dates, n);
    }

    public int nextDate(int n) {
        int n2 = Arrays.binarySearch(this.dates, n);
        int n3 = n2 >= 0 ? n2 + 1 : -(n2 + 1);
        if (n3 < this.dates.length) {
            return this.dates[n3];
        }
        return 0;
    }

    private boolean isInArray(int[] nArray, int n) {
        return Arrays.binarySearch(nArray, n) > -1;
    }

    private boolean duplicateDates(int[] nArray) {
        Arrays.sort(nArray);
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] != nArray[i - 1]) continue;
            return true;
        }
        return false;
    }

    private int[] removeDuplicates(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = 0;
        for (int n3 : nArray) {
            if (n3 == n2) continue;
            nArray2[n++] = n3;
            n2 = n3;
        }
        return Arrays.copyOf(nArray2, n);
    }
}

