/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import junit.framework.TestCase;

public class CalendarObjectTest
extends TestCase {
    private CalendarObject calendar;

    public CalendarObjectTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = new CalendarObject();
        this.calendar.setName("Test");
    }

    protected void tearDown() throws Exception {
        this.calendar = null;
        super.tearDown();
    }

    public void testAddDays() throws InvalidDateTimeException {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, 3);
        Calendar calendar3 = this.calendar.addDays(3, CalendarObject.DayType.ALL_DAYS, calendar);
        CalendarObjectTest.assertEquals((long)calendar2.getTimeInMillis(), (long)calendar3.getTimeInMillis());
        int n = this.calendar.yyyymmdd_AdjustedForVirtualDay(calendar2);
        this.calendar.setHolidays(new int[]{n});
        Calendar calendar4 = (Calendar)calendar.clone();
        calendar4.add(5, 4);
        calendar3 = this.calendar.addDays(3, CalendarObject.DayType.WORKDAYS, calendar);
        CalendarObjectTest.assertEquals((long)calendar4.getTimeInMillis(), (long)calendar3.getTimeInMillis());
        calendar3 = this.calendar.addDays(1, CalendarObject.DayType.NON_WORKDAYS, calendar);
        CalendarObjectTest.assertEquals((long)calendar2.getTimeInMillis(), (long)calendar3.getTimeInMillis());
    }

    public void testAddDays_Subtract() throws InvalidDateTimeException {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, -3);
        Calendar calendar3 = this.calendar.addDays(-3, CalendarObject.DayType.ALL_DAYS, calendar);
        CalendarObjectTest.assertEquals((long)calendar2.getTimeInMillis(), (long)calendar3.getTimeInMillis());
        int n = this.calendar.yyyymmdd_AdjustedForVirtualDay(calendar2);
        this.calendar.setHolidays(new int[]{n});
        Calendar calendar4 = (Calendar)calendar.clone();
        calendar4.add(5, -4);
        calendar3 = this.calendar.addDays(-3, CalendarObject.DayType.WORKDAYS, calendar);
        CalendarObjectTest.assertEquals((long)calendar4.getTimeInMillis(), (long)calendar3.getTimeInMillis());
        calendar3 = this.calendar.addDays(-1, CalendarObject.DayType.NON_WORKDAYS, calendar);
        CalendarObjectTest.assertEquals((long)calendar2.getTimeInMillis(), (long)calendar3.getTimeInMillis());
    }

    public void testAddDays_Subtract_9999() throws InvalidDateTimeException {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, -9999);
        Calendar calendar3 = this.calendar.addDays(-9999, CalendarObject.DayType.ALL_DAYS, calendar);
        CalendarObjectTest.assertEquals((long)calendar2.getTimeInMillis(), (long)calendar3.getTimeInMillis());
        try {
            calendar3 = this.calendar.addDays(-9999, CalendarObject.DayType.NON_WORKDAYS, calendar);
            CalendarObjectTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
        this.calendar.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        Calendar calendar4 = (Calendar)calendar.clone();
        calendar4.add(5, -5);
        calendar3 = this.calendar.addDays(-9999, CalendarObject.DayType.NON_WORKDAYS, calendar);
    }

    public void testAddDays_NotEnoughWorkdaysDefined() throws InvalidDateTimeException {
        EnumSet<CalendarObject.DayOfWeek> enumSet = EnumSet.allOf(CalendarObject.DayOfWeek.class);
        this.calendar.setNonWorkdayByDOW(enumSet);
        try {
            this.calendar.addDays(1, CalendarObject.DayType.WORKDAYS, Calendar.getInstance());
            CalendarObjectTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
    }

    public void testAddDays_NotEnoughNonWorkdaysDefined() throws InvalidDateTimeException {
        Calendar calendar = Calendar.getInstance();
        try {
            this.calendar.addDays(3, CalendarObject.DayType.NON_WORKDAYS, calendar);
            CalendarObjectTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, -3);
        int n = this.calendar.yyyymmdd_AdjustedForVirtualDay(calendar2);
        this.calendar.setHolidays(new int[]{n});
        Calendar calendar3 = (Calendar)calendar.clone();
        calendar3.add(5, 4);
        int n2 = this.calendar.yyyymmdd_AdjustedForVirtualDay(calendar3);
        Calendar calendar4 = (Calendar)calendar.clone();
        calendar4.add(5, 7);
        int n3 = this.calendar.yyyymmdd_AdjustedForVirtualDay(calendar4);
        this.calendar.setOtherNonWorkdates(new int[]{n2, n3});
        try {
            this.calendar.addDays(3, CalendarObject.DayType.NON_WORKDAYS, calendar);
            CalendarObjectTest.fail((String)"Should throw a CalendarObjectRangeException.");
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            // empty catch block
        }
    }

    public void testAddDays_Land_On_Invalid() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, 2010);
        calendar.set(2, 2);
        calendar.set(5, 12);
        calendar.set(11, 2);
        calendar.set(12, 30);
        calendar.set(13, 0);
        try {
            this.calendar.addDays(366, CalendarObject.DayType.WORKDAYS, calendar);
            CalendarObjectTest.fail((String)"Should throw an InvalidDateTimeException.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            // empty catch block
        }
    }

    public void testDayOfWeek() {
        this.calendar.setDayStart(new LocalHHMM(8, 0));
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2010);
        calendar.set(2, 3);
        calendar.set(5, 7);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.WED), (Object)((Object)this.calendar.dayOfWeek(calendar)));
        calendar.set(11, 7);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.TUE), (Object)((Object)this.calendar.dayOfWeek(calendar)));
    }

    public void testSetHolidays() {
        int[] nArray = new int[]{20100101, 20100704, 20101124, 20101125};
        this.calendar.setHolidays(nArray);
        CalendarObjectTest.assertTrue((boolean)Arrays.equals(nArray, this.calendar.getHolidays()));
    }

    public void testSetOtherNonWorkdates() {
        int[] nArray = new int[]{20100214, 20100527, 20101214};
        this.calendar.setOtherNonWorkdates(nArray);
        CalendarObjectTest.assertTrue((boolean)Arrays.equals(nArray, this.calendar.getOtherNonWorkdates()));
    }

    public void testSetNonWorkdayByDOW() {
        EnumSet<CalendarObject.DayOfWeek> enumSet = EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN);
        this.calendar.setNonWorkdayByDOW(enumSet);
        EnumSet<CalendarObject.DayOfWeek> enumSet2 = this.calendar.getNonWorkdayByDOW();
        CalendarObjectTest.assertEquals((int)2, (int)enumSet2.size());
        CalendarObjectTest.assertTrue((boolean)enumSet2.contains((Object)CalendarObject.DayOfWeek.SAT));
        CalendarObjectTest.assertTrue((boolean)enumSet2.contains((Object)CalendarObject.DayOfWeek.SUN));
    }

    public void testEquals() {
        CalendarObject calendarObject = new CalendarObject();
        CalendarObject calendarObject2 = new CalendarObject();
        CalendarObject calendarObject3 = new CalendarObject();
        calendarObject.setName("Test");
        calendarObject2.setName("Test");
        calendarObject3.setName("different_name");
        CalendarObjectTest.assertFalse((boolean)calendarObject.equals(null));
        CalendarObjectTest.assertFalse((boolean)calendarObject.equals(new Object()));
        CalendarObjectTest.assertTrue((boolean)calendarObject.equals(calendarObject));
        CalendarObjectTest.assertTrue((boolean)calendarObject.equals(calendarObject2));
        CalendarObjectTest.assertTrue((boolean)calendarObject2.equals(calendarObject));
        CalendarObjectTest.assertFalse((boolean)calendarObject.equals(calendarObject3));
    }

    public void testHashCode() {
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setName("Test");
        int n = calendarObject.hashCode();
        for (int i = 0; i < 100; ++i) {
            CalendarObjectTest.assertEquals((int)n, (int)calendarObject.hashCode());
        }
        CalendarObject calendarObject2 = new CalendarObject();
        calendarObject2.setName("Test");
        CalendarObjectTest.assertEquals((Object)calendarObject, (Object)calendarObject2);
        CalendarObjectTest.assertEquals((int)calendarObject.hashCode(), (int)calendarObject2.hashCode());
    }

    public void testAssignStartDayToNextDay() {
        this.calendar.setAssignDayStartToNextDay(false);
        CalendarObjectTest.assertFalse((boolean)this.calendar.isAssignDayStartToNextDay());
        this.calendar.setAssignDayStartToNextDay(true);
        CalendarObjectTest.assertTrue((boolean)this.calendar.isAssignDayStartToNextDay());
    }

    public void testNotifyBeforeExpiration() {
        this.calendar.setNotifyBeforeExpiration(false);
        CalendarObjectTest.assertFalse((boolean)this.calendar.isNotifyBeforeExpiration());
        this.calendar.setNotifyBeforeExpiration(true);
        CalendarObjectTest.assertTrue((boolean)this.calendar.isNotifyBeforeExpiration());
    }

    public void testIsWorkday() {
        this.calendar.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2010);
        calendar.set(2, 3);
        calendar.set(5, 7);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.WED), (Object)((Object)this.calendar.dayOfWeek(calendar)));
        CalendarObjectTest.assertTrue((boolean)this.calendar.isWorkday(calendar));
        calendar.set(5, 10);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.SAT), (Object)((Object)this.calendar.dayOfWeek(calendar)));
        CalendarObjectTest.assertFalse((boolean)this.calendar.isWorkday(calendar));
        calendar.set(5, 12);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.MON), (Object)((Object)this.calendar.dayOfWeek(calendar)));
        CalendarObjectTest.assertTrue((boolean)this.calendar.isWorkday(calendar));
        this.calendar.setHolidays(new int[]{20100412});
        CalendarObjectTest.assertFalse((boolean)this.calendar.isWorkday(calendar));
        calendar.set(5, 19);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.MON), (Object)((Object)this.calendar.dayOfWeek(calendar)));
        CalendarObjectTest.assertTrue((boolean)this.calendar.isWorkday(calendar));
        this.calendar.setOtherNonWorkdates(new int[]{20100419});
        CalendarObjectTest.assertFalse((boolean)this.calendar.isWorkday(calendar));
    }

    public void testDayTypePersistenceCodeToEnum() {
        CalendarObjectTest.assertEquals((Object)CalendarObject.DayType.NON_WORKDAYS, (Object)CalendarObject.DayType.persistanceCodeToEnum("N"));
        try {
            CalendarObject.DayType.persistanceCodeToEnum("bogus");
            CalendarObjectTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPeriodTypePersistenceCodeToEnum() {
        CalendarObjectTest.assertEquals((Object)CalendarObject.PeriodType.QUARTER, (Object)CalendarObject.PeriodType.persistanceCodeToEnum("Q"));
        try {
            CalendarObject.PeriodType.persistanceCodeToEnum("bogus");
            CalendarObjectTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRelativeDayFromBeginOfPeriod() {
        this.calendar.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2010);
        calendar.set(2, 3);
        calendar.set(5, 12);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.MON), (Object)((Object)this.calendar.dayOfWeek(calendar)));
        CalendarObject.PeriodType periodType = CalendarObject.PeriodType.MONTH;
        CalendarObject.DayType dayType = CalendarObject.DayType.ALL_DAYS;
        CalendarObjectTest.assertEquals((int)12, (int)this.calendar.relativeDayFromBeginOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.WORKDAYS;
        CalendarObjectTest.assertEquals((int)8, (int)this.calendar.relativeDayFromBeginOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.NON_WORKDAYS;
        CalendarObjectTest.assertEquals((int)0, (int)this.calendar.relativeDayFromBeginOfPeriod(calendar, periodType, dayType));
        calendar.set(5, 17);
        dayType = CalendarObject.DayType.ALL_DAYS;
        CalendarObjectTest.assertEquals((int)17, (int)this.calendar.relativeDayFromBeginOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.WORKDAYS;
        CalendarObjectTest.assertEquals((int)0, (int)this.calendar.relativeDayFromBeginOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.NON_WORKDAYS;
        CalendarObjectTest.assertEquals((int)5, (int)this.calendar.relativeDayFromBeginOfPeriod(calendar, periodType, dayType));
    }

    public void testRelativeDayFromEndOfPeriod() {
        this.calendar.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2010);
        calendar.set(2, 3);
        calendar.set(5, 12);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        CalendarObjectTest.assertEquals((Object)((Object)CalendarObject.DayOfWeek.MON), (Object)((Object)this.calendar.dayOfWeek(calendar)));
        CalendarObject.PeriodType periodType = CalendarObject.PeriodType.MONTH;
        CalendarObject.DayType dayType = CalendarObject.DayType.ALL_DAYS;
        CalendarObjectTest.assertEquals((int)19, (int)this.calendar.relativeDayFromEndOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.WORKDAYS;
        CalendarObjectTest.assertEquals((int)15, (int)this.calendar.relativeDayFromEndOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.NON_WORKDAYS;
        CalendarObjectTest.assertEquals((int)0, (int)this.calendar.relativeDayFromEndOfPeriod(calendar, periodType, dayType));
        calendar.set(5, 17);
        dayType = CalendarObject.DayType.ALL_DAYS;
        CalendarObjectTest.assertEquals((int)14, (int)this.calendar.relativeDayFromEndOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.WORKDAYS;
        CalendarObjectTest.assertEquals((int)0, (int)this.calendar.relativeDayFromEndOfPeriod(calendar, periodType, dayType));
        dayType = CalendarObject.DayType.NON_WORKDAYS;
        CalendarObjectTest.assertEquals((int)4, (int)this.calendar.relativeDayFromEndOfPeriod(calendar, periodType, dayType));
    }
}

