/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.reports;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.enterprise.core.busobj.CustomMailMessage;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.MailSentEvent;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.dm.UserDM;
import com.helpsystems.enterprise.core.reports.Report;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.ReportRenderer;
import com.helpsystems.enterprise.core.util.FileHandler;
import com.helpsystems.enterprise.core.util.OutputDistributionSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public abstract class AbstractReport
extends EnterpriseVersionedObject
implements Report,
SimpleEventListener {
    private static final Logger logger = Logger.getLogger(AbstractReport.class);
    protected Locale locale = null;
    protected ReportOutput.OutputType outputType = null;
    private String resourceBundle = null;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected String runAsUser;
    private Object[] params;
    protected transient PrintWriter logWriter = null;
    protected transient StringWriter stringWriter = null;
    private File reportOutputFile;
    private File reportLogFile;
    private String reportFileName;
    private String reportLogFileName;
    private boolean systemExit = false;
    private ReportRenderer renderer;
    private int maxEmailAttachmentSizeInBytes = 0;
    private final SystemSetupDM systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM");
    private List<CustomMailMessage> mailList;

    public AbstractReport() {
        try {
            SystemSetup systemSetup = this.systemSetupDM.get();
            this.maxEmailAttachmentSizeInBytes = systemSetup.getMaxEmailAttachmentSize() * 1024 * 1024;
            this.mailList = new ArrayList<CustomMailMessage>();
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
    }

    protected ResourceBundle getBundle() {
        return ResourceBundle.getBundle(this.resourceBundle, this.locale, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void log(String string) {
        try {
            this.getReportLogWriter().println(string);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to log message to Report Log Writer:" + string));
        }
    }

    @Override
    public void log(String string, Throwable throwable) {
        this.log(string);
        try {
            throwable.printStackTrace(this.logWriter);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to print stack trace for message to Log Writer: " + string), (Throwable)exception);
        }
    }

    @Override
    public StringWriter getReportLogWriters() {
        return this.stringWriter;
    }

    @Override
    public PrintWriter getReportLogWriter() {
        if (this.logWriter == null) {
            this.stringWriter = new StringWriter();
            this.logWriter = new PrintWriter(this.stringWriter);
        }
        return this.logWriter;
    }

    public void setReportLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setReportLocale(Locale locale) {
        this.locale = locale == null ? Locale.US : locale;
    }

    @Override
    public Locale getReportLocale() {
        return this.locale;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String string) {
        this.resourceBundle = string;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> map) {
        this.parameters = map;
    }

    @Override
    public ReportOutput.OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(ReportOutput.OutputType outputType) {
        this.outputType = outputType;
    }

    @Override
    public String getRunAsUserName() {
        return this.runAsUser;
    }

    public void setRunAsUserName(String string) {
        this.runAsUser = string == null ? "" : string;
    }

    protected URL getReportDefinitionPath() {
        StringBuilder stringBuilder = new StringBuilder("com/helpsystems/enterprise/module/reports/");
        stringBuilder.append(this.getReportName());
        stringBuilder.append("/");
        stringBuilder.append(this.getReportName());
        stringBuilder.append(this.getReportDefinitionExtension());
        if (logger.isTraceEnabled()) {
            this.log("Loading report resource: " + stringBuilder.toString());
        }
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(stringBuilder.toString());
        if (logger.isTraceEnabled()) {
            this.log("Found Resource: " + uRL);
        }
        return uRL;
    }

    @Override
    public File getDestinationFile() {
        if (this.reportOutputFile == null) {
            this.setReportOutputFile();
        }
        return this.reportOutputFile;
    }

    @Override
    public void setDestinationFile(File file) {
        this.reportOutputFile = file;
    }

    @Override
    public File getUserReportDir() {
        String string = OutputDistributionSetup.getUserFilesDirName();
        long l = this.getRunAsUserID();
        File file = new File(string, String.valueOf(l));
        logger.debug((Object)("Returning file: " + file.toString()));
        return file;
    }

    private void setReportOutputFile() {
        logger.debug((Object)"Setting Report Ouput File Destination.");
        File file = this.getUserReportDir();
        file.mkdirs();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getReportName());
        stringBuffer.append("_");
        stringBuffer.append(simpleDateFormat.format(new Date()));
        String string = stringBuffer.toString();
        this.reportFileName = string + this.outputType.getReportTypeExtension();
        this.reportLogFileName = string + ".log";
        this.reportOutputFile = new File(file, this.reportFileName);
        if (this.reportOutputFile.exists()) {
            logger.debug((Object)("Report output file " + this.reportOutputFile.getAbsolutePath() + " exists.  Creating rolling file."));
            String string2 = FileHandler.generateIncrementFileName(this.reportOutputFile);
            this.reportOutputFile = new File(file, string2);
            logger.debug((Object)("Report output file is " + this.reportOutputFile.getAbsolutePath() + "."));
        }
    }

    @Override
    public String getReportFileName() {
        return this.reportFileName;
    }

    @Override
    public String getReportLogFileName() {
        return this.reportLogFileName;
    }

    private void setReportLogFile() {
        String string = this.reportOutputFile.getAbsolutePath();
        string = string.replaceAll(this.outputType.getReportTypeExtension(), ".log");
        if (logger.isTraceEnabled()) {
            logger.debug((Object)("Logger file is: " + string));
        }
        this.reportLogFile = new File(string);
    }

    @Override
    public File getLogFile() {
        if (this.reportLogFile == null) {
            this.setReportLogFile();
        }
        return this.reportLogFile;
    }

    @Override
    public void renderReport() throws ReportException {
        this.parseParameters(this.getParams());
        if (this.renderer == null) {
            this.initializeReportRender();
        }
        this.renderer.render();
    }

    @Override
    public void setReportRenderer(ReportRenderer reportRenderer) {
        this.renderer = reportRenderer;
    }

    @Override
    public String getReportOuputLocation() {
        return this.getDestinationFile().getAbsolutePath();
    }

    protected abstract void parseParameters(Object ... var1);

    public void setParams(Object[] objectArray) {
        this.params = objectArray;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public void sendReport(String[] stringArray, EnterpriseEmailAM enterpriseEmailAM) {
        String string = this.reportOutputFile.getAbsolutePath();
        enterpriseEmailAM.addEventListener(this);
        StringBuilder stringBuilder = new StringBuilder(this.reportOutputFile.getName());
        stringBuilder.append(' ');
        stringBuilder.append(" report");
        String[] stringArray2 = new String[]{string};
        CustomMailMessage customMailMessage = new CustomMailMessage(-1L, stringBuilder.toString(), "", null);
        customMailMessage.setType(1);
        customMailMessage.setAttachmentNameList(stringArray2);
        this.mailList.add(customMailMessage);
        long l = FileHandler.getFileSizeInBytes(string);
        if (l > (long)this.maxEmailAttachmentSizeInBytes) {
            String string2 = this.bigAttachmentReport(string, l);
            logger.info((Object)string2);
            customMailMessage.setDeleteWhenFinished(false);
            this.doSend(stringArray, stringBuilder.toString(), string2, null, customMailMessage, enterpriseEmailAM);
        } else {
            this.doSend(stringArray, stringBuilder.toString(), "", stringArray2, customMailMessage, enterpriseEmailAM);
        }
    }

    private void doSend(String[] stringArray, String string, String string2, String[] stringArray2, Object object, EnterpriseEmailAM enterpriseEmailAM) {
        if (stringArray != null) {
            int n = stringArray.length;
            if (n > 0) {
                try {
                    enterpriseEmailAM.sendMessage(stringArray, string, string2, stringArray2, object);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.debug((Object)"Error sending email", (Throwable)resourceUnavailableException);
                }
                catch (ActionFailedException actionFailedException) {
                    logger.debug((Object)"Error sending email", (Throwable)actionFailedException);
                }
            }
        } else {
            this.systemExit = true;
            logger.debug((Object)"Recipient list is empty");
        }
    }

    private String bigAttachmentReport(String string, long l) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" file is not attached to mail as it's size is ");
        stringBuilder.append(l);
        stringBuilder.append(" which is greater than max email size:");
        stringBuilder.append(this.maxEmailAttachmentSizeInBytes);
        return stringBuilder.toString();
    }

    @Override
    public void copyfile(String string, String string2) {
        try {
            int n;
            String string3;
            String string4 = "";
            String string5 = "";
            if (string != null) {
                string4 = string.trim();
            }
            if (string2 != null) {
                string5 = string2.trim();
            }
            int n2 = string4.length();
            int n3 = string5.length();
            if (string == null && string2 == null) {
                return;
            }
            if ((string == null || n2 == 0) && n3 > 0) {
                logger.error((Object)"Unable to copy the report, the destination file path is not specified.");
                return;
            }
            if (string != null && n2 == 0 && string != null && n3 == 0) {
                return;
            }
            if (this.reportOutputFile == null) {
                logger.error((Object)"Unable to copy the report, the report output file is null.");
                return;
            }
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                logger.error((Object)("Unable to copy the report. The directory " + string + " does not exist."));
                return;
            }
            if (string2 == null || n3 == 0) {
                string2 = this.reportOutputFile.getName();
            }
            if (!(string3 = this.extension(string2)).equalsIgnoreCase(this.outputType.toString())) {
                string2 = string2 + this.outputType.getReportTypeExtension();
            }
            File file2 = new File(string, string2);
            FileInputStream fileInputStream = new FileInputStream(this.reportOutputFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)("Unable to copy report " + string2 + " into the directory " + string), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            logger.error((Object)("Unable to copy report " + string2 + " into the directory " + string), (Throwable)iOException);
        }
    }

    public String extension(String string) {
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    @Override
    public long getRunAsUserID() {
        long l = 1L;
        String string = this.getRunAsUserName();
        if (string == null || string.trim().length() < 1) {
            string = "admin";
        }
        UserDM userDM = (UserDM)ManagerRegistry.getManager((String)"ENTERPRISE.UserDM");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for user path for " + string));
            }
            l = userDM.getUserByNameOrAdmin(string).getID();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder("Unable to find the passed in user name:");
            stringBuilder.append(string);
            stringBuilder.append(", so admin id is used, i.e.:");
            stringBuilder.append(l);
            logger.info((Object)stringBuilder.toString(), (Throwable)exception);
        }
        return l;
    }

    public void serviceEvent(GenericEvent genericEvent) {
        MailSentEvent mailSentEvent;
        Object object;
        if (genericEvent != null && genericEvent instanceof MailSentEvent && this.mailList.contains(object = (mailSentEvent = (MailSentEvent)genericEvent).getMailObject()) && object instanceof CustomMailMessage) {
            switch (mailSentEvent.getSentStatus()) {
                case SUCCESS_SENT_STATUS: 
                case MIXED_SENT_STATUS: 
                case FAILED_SENT_STATUS: {
                    this.systemExit = true;
                }
            }
        }
    }

    @Override
    public boolean isSystemExit() {
        return this.systemExit;
    }

    @Override
    public void setSystemExit(boolean bl) {
        this.systemExit = bl;
    }
}

