/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.messages;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import junit.framework.TestCase;

public class SystemMessageTest
extends TestCase {
    SystemMessage msg;

    protected void setUp() throws Exception {
        super.setUp();
        this.msg = new SystemMessage();
    }

    protected void tearDown() throws Exception {
        this.msg = null;
        super.tearDown();
    }

    public void testSetMessage() {
        this.msg.setMessage(RosettaMsg.ALL_JOB_QUEUES_LOCKED);
        SystemMessageTest.assertEquals((Object)((Object)RosettaMsg.ALL_JOB_QUEUES_LOCKED), (Object)((Object)this.msg.getMessage()));
    }

    public void testSetMessageID() {
        this.msg = new SystemMessage(RosettaMsg.DAILY_CLEANUP_NEXT_WAKEUP);
        try {
            this.msg.setMessageID("message_id");
            SystemMessageTest.fail((String)"Allowed setMessageID(String)");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        SystemMessageTest.assertEquals((String)RosettaMsg.DAILY_CLEANUP_NEXT_WAKEUP.toString(), (String)this.msg.getMessageID());
    }

    public void testToString() {
        this.msg = new SystemMessage(RosettaMsg.PURGE_COMPLETE);
        this.msg.setTimestampUTC(123456789L);
        String string = this.msg.toString();
        SystemMessageTest.assertTrue((boolean)string.startsWith("Id->" + this.msg.getId()));
        SystemMessageTest.assertTrue((boolean)string.contains("TimestampUTC->123456789"));
        SystemMessageTest.assertTrue((boolean)string.endsWith("Msg->PURGE_COMPLETE"));
    }

    public void testToStringNullMessage() {
        this.msg = new SystemMessage();
        this.msg.setTimestampUTC(123456789L);
        String string = this.msg.toString();
        SystemMessageTest.assertTrue((boolean)string.startsWith("Id->" + this.msg.getId()));
        SystemMessageTest.assertTrue((boolean)string.contains("TimestampUTC->123456789"));
        SystemMessageTest.assertTrue((boolean)string.endsWith("Msg-><null>"));
    }

    public void testSetId() {
        this.msg.setId(12345L);
        SystemMessageTest.assertEquals((long)12345L, (long)this.msg.getId());
    }

    public void testSetTimestampUTC() {
        this.msg.setTimestampUTC(12345678L);
        SystemMessageTest.assertEquals((long)12345678L, (long)this.msg.getTimestampUTC());
    }

    public void testSetAcknowledged() {
        this.msg.setAcknowledged(false);
        SystemMessageTest.assertFalse((boolean)this.msg.getAcknowledged());
        SystemMessageTest.assertFalse((boolean)this.msg.isAcknowledged());
        this.msg.setAcknowledged(true);
        SystemMessageTest.assertTrue((boolean)this.msg.getAcknowledged());
        SystemMessageTest.assertTrue((boolean)this.msg.isAcknowledged());
    }

    public void testSetAcknowledgedByUserID() {
        this.msg.setAcknowledgedByUserID(54321L);
        SystemMessageTest.assertEquals((long)54321L, (long)this.msg.getAcknowledgedByUserID());
    }

    public void testSetAcknowledgedTimestampUTC() {
        this.msg.setAcknowledgedTimestampUTC(55303L);
        SystemMessageTest.assertEquals((long)55303L, (long)this.msg.getAcknowledgedTimestampUTC());
    }

    public void testGetMessageText() {
        this.msg = new SystemMessage(RosettaMsg.DATE_OBJECT_EXPIRING_TODAY, "DateObject");
        String string = "The Date List DateObject will expire today.";
        String string2 = this.msg.getMessageText();
        SystemMessageTest.assertEquals((String)string, (String)string2);
    }

    public void testSetMessageTextThrowsException() {
        try {
            this.msg.setMessageText("anything");
            SystemMessageTest.fail((String)"setMessageText() should have thrown a RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            SystemMessageTest.assertTrue((boolean)runtimeException.getMessage().contains("not supported"));
        }
    }

    public void testSetMessageVarsStringThrowsException() {
        try {
            this.msg.setMessageVarsString("anything");
            SystemMessageTest.fail((String)"setMessageVarsString() should have thrown a RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            SystemMessageTest.assertTrue((boolean)runtimeException.getMessage().contains("not supported"));
        }
    }

    public void testGetMessageVarsString() {
        this.msg = new SystemMessage(RosettaMsg.AGENT_EVENT_OCCURRED, new String[]{"abc", "def", "ghi"});
        String string = this.msg.getMessageVarsString();
        String string2 = "abc\tdef\tghi";
        SystemMessageTest.assertEquals((String)string2, (String)string);
    }
}

