/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.messages;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.User;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseServerSNMPTrap;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.UserDM;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageDM;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SystemMessageQueue {
    private static DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
    private static final Logger logger = Logger.getLogger(SystemMessageQueue.class);

    public static String formatTimeStamp(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        return SystemMessageQueue.formatTimeStamp(calendar.getTime());
    }

    public static String formatTimeStamp(long l) {
        return SystemMessageQueue.formatTimeStamp(new Date(l));
    }

    public static String formatTimeStamp(Date date) {
        if (date == null) {
            return "";
        }
        return formatter.format(date);
    }

    public void write(RosettaMsg rosettaMsg) {
        SystemMessage systemMessage = SystemMessageQueue.makeMessage(rosettaMsg);
        SystemMessageQueue.write(systemMessage);
    }

    public void write(RosettaMsg rosettaMsg, RosettaMsg rosettaMsg2) {
        SystemMessage systemMessage = SystemMessageQueue.makeMessage(rosettaMsg);
        SystemMessage systemMessage2 = SystemMessageQueue.makeMessage(rosettaMsg2);
        SystemMessageQueue.write(systemMessage, systemMessage2);
    }

    public static SystemMessage makeMessage(RosettaMsg rosettaMsg) {
        SystemMessage systemMessage = new SystemMessage(rosettaMsg);
        return systemMessage;
    }

    public static void write(SystemMessage systemMessage) {
        SystemMessageQueue.write(systemMessage, "IN");
    }

    public static void write(SystemMessage systemMessage, SystemMessage systemMessage2) {
        SystemMessageQueue.write(systemMessage, "IN", systemMessage2);
    }

    public static void write(SystemMessage systemMessage, String string) {
        SystemMessage systemMessage2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE.newSystemMessage();
        SystemMessageQueue.write(systemMessage, string, systemMessage2);
    }

    public static void write(SystemMessage systemMessage, String string, SystemMessage systemMessage2) {
        User[] userArray;
        Object object;
        try {
            object = (SystemMessageDM)ManagerRegistry.getManager((String)"ENTERPRISE.SystemMessageDM");
            object.save(systemMessage);
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error writing system message: " + systemMessage.toString()), throwable);
        }
        try {
            object = (EnterpriseSNMPTrapAM)ManagerRegistry.getManager((String)"ENTERPRISE.EnterpriseSNMPTrapAM");
            userArray = new EnterpriseServerSNMPTrap();
            userArray.setText(systemMessage.getMessageText());
            userArray.setSeverity(string);
            object.sendSNMPTrap((EnterpriseSNMPTrap)userArray);
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error sending SNMP Trap for system message.", throwable);
        }
        try {
            object = (UserDM)ManagerRegistry.getManager((String)"ENTERPRISE.UserDM");
            userArray = object.getNotifyUsers();
            if (userArray != null && userArray.length > 0) {
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < userArray.length; ++i) {
                    try {
                        if (userArray[i].getEmailAddress() == null || userArray[i].getEmailAddress().trim().length() <= 0) continue;
                        vector.addElement(userArray[i].getEmailAddress().trim());
                        continue;
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"Error retrieving User.", (Throwable)exception);
                    }
                }
                if (vector.size() > 0) {
                    Object[] objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                    EnterpriseEmailAM enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
                    enterpriseEmailAM.sendMessage((String[])objectArray, systemMessage2.getMessageText(), systemMessage.getMessageText());
                }
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error notifying users of system message.", throwable);
        }
    }
}

