/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.logger;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.logger.Log4jID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class CrossAppenderLogger
implements Runnable {
    private Logger logger = Logger.getLogger(CrossAppenderLogger.class);
    Level level = null;
    String message = null;
    Log4jID log4jID = null;

    public CrossAppenderLogger(Log4jID log4jID, Level level, String string) {
        ValidationHelper.checkForNull((String)"Log4jID", (Object)((Object)log4jID));
        ValidationHelper.checkForNull((String)"Message", (Object)string);
        this.log4jID = log4jID;
        this.level = level;
        this.message = string;
    }

    @Override
    public void run() {
        MDC.put((String)"MDC_LOG_ID", (String)this.log4jID.getMDCKeyValue());
        if (this.level != null) {
            this.logger.log(this.level, (Object)this.message);
        } else {
            this.logger.log(this.logger.getEffectiveLevel(), (Object)this.message);
        }
    }

    public static void logMessage(Log4jID log4jID, Level level, String string) {
        CrossAppenderLogger crossAppenderLogger = new CrossAppenderLogger(log4jID, level, string);
        Thread thread = new Thread((Runnable)crossAppenderLogger, "CrossAppenderLoggerThread");
        thread.start();
    }

    public static void logMessage(Log4jID log4jID, String string) {
        CrossAppenderLogger crossAppenderLogger = new CrossAppenderLogger(log4jID, null, string);
        Thread thread = new Thread((Runnable)crossAppenderLogger, "CrossAppenderLoggerThread");
        thread.start();
    }
}

