/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.infocloud.busobj;

import com.google.gson.annotations.SerializedName;
import com.helpsystems.enterprise.core.infocloud.busobj.ICObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ICServerTime
extends ICObject {
    @SerializedName(value="@type")
    private String entryType;
    private String time;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static Date convertICTimeToTimestamp(String string) {
        if (string == null) {
            throw new RuntimeException("icTime is null.");
        }
        if (string.trim().length() != 24) {
            throw new RuntimeException("icTime must a 24-character UTC formatted String (yyyy-MM-ddTHH:mm:ss.SSSZ): " + string);
        }
        try {
            return formatter.parse(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException("icTime format must be 'yyyy-MM-ddTHH:mm:ss.SSSZ': " + string, parseException);
        }
    }

    public static String getAdjustedTime(String string) {
        if (string == null) {
            throw new RuntimeException("icTime is null.");
        }
        if (string.trim().length() != 24) {
            throw new RuntimeException("icTime must a 24-character UTC formatted String (yyyy-MM-ddTHH:mm:ss.SSSZ): " + string);
        }
        return string.subSequence(0, 20) + "000Z";
    }

    public String getEntryType() {
        return this.entryType;
    }

    public void setEntryType(String string) {
        this.entryType = string;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String string) {
        this.time = string;
    }

    @Override
    public String[] toStringArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("entryType=" + this.getEntryType());
        arrayList.add("time=" + this.getTime());
        String[] stringArray = new String[]{};
        return arrayList.toArray(stringArray);
    }
}

