/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.forecast;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.forecast.ForecastedObjectRunID;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.ForecastedEvent;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;

public class ForecastReactivityCausePrereq {
    private long prereqObjectID;
    private PrereqEventType prereqObjectType;
    private long prereqAgentID;
    private PrereqStatusType status;
    private long timestamp;
    private ForecastedObjectRunID forecastedObjectRunID;

    public ForecastedObjectRunID getForecastedObjectRunID() {
        return this.forecastedObjectRunID;
    }

    public long getPrereqObjectID() {
        return this.prereqObjectID;
    }

    public PrereqEventType getPrereqObjectType() {
        return this.prereqObjectType;
    }

    public long getPrereqAgentID() {
        return this.prereqAgentID;
    }

    public PrereqStatusType getStatus() {
        return this.status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setForecastedObjectRunID(ForecastedObjectRunID forecastedObjectRunID) {
        this.forecastedObjectRunID = forecastedObjectRunID;
    }

    public void setPrereqObjectId(long l) {
        this.prereqObjectID = l;
    }

    public void setPrereqObjectType(PrereqEventType prereqEventType) {
        this.prereqObjectType = prereqEventType;
    }

    public void setPrereqAgentID(long l) {
        this.prereqAgentID = l;
    }

    public void setStatus(PrereqStatusType prereqStatusType) {
        this.status = prereqStatusType;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public boolean isMatchesForecastedEvent(ForecastedEvent forecastedEvent) {
        long l = forecastedEvent.getForecastableEvent().getID();
        ForecastableEvent.ForecastableEventType forecastableEventType = forecastedEvent.getForecastableEvent().getType();
        return l == this.prereqObjectID && this.isMatchesForecastedEventType(forecastableEventType) && forecastedEvent.getAgentID() == this.prereqAgentID && this.isMatchesDateTime(forecastedEvent);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ForecastReactivityCausePrereq forecastReactivityCausePrereq = (ForecastReactivityCausePrereq)object;
        boolean bl2 = bl = forecastReactivityCausePrereq.prereqObjectID == this.prereqObjectID && forecastReactivityCausePrereq.prereqObjectType == this.prereqObjectType && forecastReactivityCausePrereq.prereqAgentID == this.prereqAgentID && forecastReactivityCausePrereq.status == this.status && forecastReactivityCausePrereq.timestamp == this.timestamp;
        boolean bl3 = forecastReactivityCausePrereq.forecastedObjectRunID == null ? this.forecastedObjectRunID == null : (this.forecastedObjectRunID == null ? false : forecastReactivityCausePrereq.forecastedObjectRunID.equals(this.forecastedObjectRunID));
        return bl && bl3;
    }

    public String toString() {
        String string = "{0} {1} {2}";
        if (this.prereqObjectType == PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE) {
            string = "M {0} {1} {2}";
        }
        return MessageUtil.formatMsg((String)string, (Object[])new Object[]{this.prereqObjectID, this.status, this.timestamp});
    }

    private boolean isMatchesForecastedEventType(ForecastableEvent.ForecastableEventType forecastableEventType) {
        switch (this.prereqObjectType) {
            case JOB_STATUS_CHANGE: {
                return forecastableEventType == ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return forecastableEventType == ForecastableEvent.ForecastableEventType.JOB_SUITE;
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return forecastableEventType == ForecastableEvent.ForecastableEventType.MEMBER_JOB;
            }
            case AGENT_EVENT: {
                return forecastableEventType == ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS;
            }
            case SNMP_TRAP_EVENT: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prerequisite Object Type {0} is not supported by this method.", (Object[])new Object[]{this.prereqObjectType}));
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prerequisite Object Type {0} is not supported by this method.", (Object[])new Object[]{this.prereqObjectType}));
    }

    private boolean isMatchesDateTime(ForecastedEvent forecastedEvent) {
        long l = forecastedEvent.getDateTime();
        switch (this.status) {
            case SUBMITTED: {
                return this.timestamp == l;
            }
            case RUNNING: {
                return this.timestamp == l + forecastedEvent.getQueueWait();
            }
            case COMPLETED: {
                return this.timestamp == l + forecastedEvent.getQueueWait() + forecastedEvent.getRunDuration();
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prerequisite status {0} is not supported by this method.", (Object[])new Object[]{this.status}));
    }
}

