/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.enterprise.core.cmdlineobj.GetAgentStatusData;
import junit.framework.TestCase;

public class GetAgentStatusDataTest
extends TestCase {
    private GetAgentStatusData getAgentStatusData;

    protected void setUp() throws Exception {
        super.setUp();
        this.getAgentStatusData = new GetAgentStatusData();
    }

    protected void tearDown() throws Exception {
        this.getAgentStatusData = null;
        super.tearDown();
    }

    public void testGetAgentStatus() {
        this.getAgentStatusData.setAgentStatus(0);
        GetAgentStatusDataTest.assertEquals((int)0, (int)this.getAgentStatusData.getAgentStatus());
        this.getAgentStatusData.setAgentStatus(10);
        GetAgentStatusDataTest.assertEquals((int)10, (int)this.getAgentStatusData.getAgentStatus());
        this.getAgentStatusData.setAgentStatus(20);
        GetAgentStatusDataTest.assertEquals((int)20, (int)this.getAgentStatusData.getAgentStatus());
        this.getAgentStatusData.setAgentStatus(30);
        GetAgentStatusDataTest.assertEquals((int)30, (int)this.getAgentStatusData.getAgentStatus());
        try {
            this.getAgentStatusData.setAgentStatus(-999);
            GetAgentStatusDataTest.fail((String)"setAgentStatus allowed invalid status.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetEnterpriseServerName() {
        this.getAgentStatusData.setEnterpriseServerName("somename");
        GetAgentStatusDataTest.assertEquals((String)"somename", (String)this.getAgentStatusData.getEnterpriseServerName());
    }

    public void testGetEnterpriseServerAddress() {
        this.getAgentStatusData.setEnterpriseServerAddress("https://enterpriseserver");
        GetAgentStatusDataTest.assertEquals((String)"https://enterpriseserver", (String)this.getAgentStatusData.getEnterpriseServerAddress());
    }

    public void testGetConnectionText() {
        this.getAgentStatusData.setEnterpriseServerName("somename");
        this.getAgentStatusData.setEnterpriseServerAddress("https://enterpriseserver");
        this.getAgentStatusData.setAgentStatus(30);
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("inactive"));
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("somename (https://enterpriseserver)"));
        this.getAgentStatusData.setAgentStatus(10);
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("active, but not connected"));
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("somename (https://enterpriseserver)"));
        this.getAgentStatusData.setAgentStatus(0);
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("active and connected"));
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("somename (https://enterpriseserver)"));
        this.getAgentStatusData.setAgentStatus(20);
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("active and connected"));
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("but preparing to shut down"));
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("somename (https://enterpriseserver)"));
        this.getAgentStatusData.setEnterpriseServerName("somename");
        this.getAgentStatusData.setEnterpriseServerAddress("somename");
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("somename"));
        this.getAgentStatusData.setEnterpriseServerName(null);
        this.getAgentStatusData.setEnterpriseServerAddress("someaddress");
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("someaddress"));
        this.getAgentStatusData.setEnterpriseServerName(null);
        this.getAgentStatusData.setEnterpriseServerAddress(null);
        GetAgentStatusDataTest.assertTrue((boolean)this.getAgentStatusData.getConnectionText().contains("<- Enterprise Server Name is N/A ->"));
        try {
            this.getAgentStatusData.setAgentStatus(-999);
            this.getAgentStatusData.getConnectionText();
            GetAgentStatusDataTest.fail((String)"getConnectionText should have caught invalid agentstatus.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

