/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import com.helpsystems.enterprise.core.util.UnacodeMash;

public class FileTransferDetails
extends AbstractBusinessObject {
    private static final long serialVersionUID = 6040627285491616004L;
    public static final String COMMAND_NAME = "FTP";
    public static final String AGT_ENV_PWD = "AGT_ENV_PWD";
    public static final String AGT_ENV_SALT = "AGT_ENV_SALT";
    public static final String COMMAND_PUT = "put";
    public static final String COMMAND_GET = "get";
    public static final String UNKNOWN_HOST_CHALLENGE_YES = "yes";
    public static final String UNKNOWN_HOST_CHALLENGE_NO = "no";
    public static final String REPLACE_YES = "yes";
    public static final String REPLACE_NO = "no";
    public static final String USE_IMPLICIT_FTPS_YES = "yes";
    public static final String USE_IMPLICIT_FTPS_NO = "no";
    public static final String TRANSFER_TYPE_BINARY = "binary";
    public static final String TRANSFER_TYPE_TEXT = "text";
    public static final String MODE_FTP = "ftp";
    public static final String MODE_FTPS = "ftps";
    public static final String MODE_SFTP = "sftp";
    private int direction;
    private String hostFile = null;
    private String agentFile = null;
    private boolean isReplace = true;
    private String user = null;
    private String host = null;
    private int port = 0;
    private String passwordSalt = null;
    private String password = null;
    private int systemTransferType = 0;
    private boolean isBinary = false;
    private boolean unknownHostChallenge = true;
    private String siteCommand = null;
    private boolean useImplicitFtps = false;
    private boolean deleteAfterTransfer = false;
    private String privateKeyPath;
    private int authenticationType;

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public String getHostFile() {
        return this.hostFile;
    }

    public void setHostFile(String string) {
        this.hostFile = string;
    }

    public String getAgentFile() {
        return this.agentFile;
    }

    public void setAgentFile(String string) {
        this.agentFile = string;
    }

    public boolean isReplace() {
        return this.isReplace;
    }

    public void setReplace(boolean bl) {
        this.isReplace = bl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getPasswordSalt() {
        return this.passwordSalt;
    }

    public void setPasswordSalt(String string) {
        this.passwordSalt = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getSystemTransferType() {
        return this.systemTransferType;
    }

    public void setSystemTransferType(int n) {
        this.systemTransferType = n;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void setBinary(boolean bl) {
        this.isBinary = bl;
    }

    public boolean isUnknownHostChallenge() {
        return this.unknownHostChallenge;
    }

    public void setUnknownHostChallenge(boolean bl) {
        this.unknownHostChallenge = bl;
    }

    public String getSiteCommand() {
        return this.siteCommand;
    }

    public void setSiteCommand(String string) {
        this.siteCommand = string;
    }

    public void parseParameters(String[] stringArray) throws ActionFailedException {
        String string = null;
        String string2 = null;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            int n2 = stringArray2.length;
            if (n2 > 0) {
                string = stringArray2[0].trim().toLowerCase();
            }
            string2 = null;
            if (n2 == 2) {
                string2 = stringArray2[1];
            } else if (n2 > 2) {
                String string3;
                string2 = string3 = stringArray[i].substring(stringArray2[0].length() + 1);
            }
            try {
                if (string.equals("-d")) {
                    if (string2.equals(COMMAND_PUT)) {
                        this.direction = 1;
                        continue;
                    }
                    if (!string2.equals(COMMAND_GET)) continue;
                    this.direction = 0;
                    continue;
                }
                if (string.equals("-r")) {
                    this.hostFile = string2;
                    continue;
                }
                if (string.equals("-a")) {
                    this.agentFile = string2;
                    continue;
                }
                if (string.equals("-e")) {
                    if (string2.equals("yes")) {
                        this.isReplace = true;
                        continue;
                    }
                    if (!string2.equals("no")) continue;
                    this.isReplace = false;
                    continue;
                }
                if (string.equals("-t")) {
                    if (string2.equals(TRANSFER_TYPE_BINARY)) {
                        this.isBinary = true;
                        continue;
                    }
                    if (!string2.equals(TRANSFER_TYPE_TEXT)) continue;
                    this.isBinary = false;
                    continue;
                }
                if (string.equals("-m")) {
                    if (string2.equals(MODE_FTP)) {
                        this.systemTransferType = 0;
                        continue;
                    }
                    if (string2.equals(MODE_FTPS)) {
                        this.systemTransferType = 2;
                        continue;
                    }
                    if (!string2.equals(MODE_SFTP)) continue;
                    this.systemTransferType = 1;
                    continue;
                }
                if (string.equals("-y")) {
                    this.host = string2;
                    continue;
                }
                if (string.equals("-u")) {
                    this.user = string2;
                    continue;
                }
                if (string.equals("-w")) {
                    this.password = string2;
                    continue;
                }
                if (string.equals("-p")) {
                    this.port = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("-c")) {
                    if (string2.equals("yes")) {
                        this.unknownHostChallenge = true;
                        continue;
                    }
                    if (!string2.equals("no")) continue;
                    this.unknownHostChallenge = false;
                    continue;
                }
                if (string.equals("-g")) {
                    this.siteCommand = string2;
                    continue;
                }
                if (string.equals("-i")) {
                    if (string2.equals("yes")) {
                        this.useImplicitFtps = true;
                        continue;
                    }
                    if (!string2.equals("no")) continue;
                    this.useImplicitFtps = false;
                    continue;
                }
                if (string.equals("-l")) {
                    if (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true")) {
                        this.deleteAfterTransfer = true;
                    }
                    continue;
                }
                if (string.equals("-b")) {
                    if (string2.equalsIgnoreCase("key")) {
                        this.setAuthenticationType(2);
                    }
                    continue;
                }
                if (string.equals("-k")) {
                    this.setPrivateKeyPath(string2);
                    continue;
                }
                throw new ActionFailedException("Invalid option parameter: " + string + " full parm: " + stringArray[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ActionFailedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
        this.password = this.decode(System.getenv(AGT_ENV_PWD));
        this.passwordSalt = System.getenv(AGT_ENV_SALT);
    }

    public String getCommandHash() {
        StringBuffer stringBuffer = new StringBuffer(this.direction);
        stringBuffer.append(Boolean.toString(this.isReplace).hashCode());
        stringBuffer.append(this.systemTransferType);
        return stringBuffer.toString();
    }

    private String decode(String string) {
        String string2 = string;
        try {
            string2 = UnacodeMash.unMash(string);
            String string3 = this.getCommandHash();
            if (string2 != null && string2.startsWith(string3)) {
                return UnacodeMash.mash(string2.replaceAll(string3, ""));
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string;
    }

    protected String getCommandInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Direction: ");
        stringBuilder.append(this.direction);
        stringBuilder.append(" Host File: ");
        stringBuilder.append(this.hostFile == null ? "NULL" : this.hostFile);
        stringBuilder.append(" Agent File: ");
        stringBuilder.append(this.agentFile == null ? "NULL" : this.agentFile);
        stringBuilder.append(" Is Replace: ");
        stringBuilder.append(this.isReplace);
        stringBuilder.append(" User Name: ");
        stringBuilder.append(this.user == null ? "NULL" : this.user);
        stringBuilder.append(" Host: ");
        stringBuilder.append(this.host == null ? "NULL" : this.host);
        stringBuilder.append(" Port: ");
        stringBuilder.append(this.port);
        stringBuilder.append(" Password Salt: ");
        stringBuilder.append(this.passwordSalt == null ? "NULL" : "<hidden>");
        stringBuilder.append(" Password: ");
        stringBuilder.append(this.password == null ? "NULL" : "<hidden>");
        stringBuilder.append(" System Transfer Type: ");
        stringBuilder.append(this.systemTransferType);
        stringBuilder.append(" Is Binary: ");
        stringBuilder.append(this.isBinary);
        stringBuilder.append(" Unknown Host Challenge: ");
        stringBuilder.append(this.unknownHostChallenge);
        stringBuilder.append(" Use Implicit security mode: ");
        stringBuilder.append(this.useImplicitFtps);
        return stringBuilder.toString();
    }

    public boolean isUseImplicitFtps() {
        return this.useImplicitFtps;
    }

    public void setUseImplicitFtps(boolean bl) {
        this.useImplicitFtps = bl;
    }

    public boolean isDeleteAfterTransfer() {
        return this.deleteAfterTransfer;
    }

    public void setDeleteAfterTransfer(boolean bl) {
        this.deleteAfterTransfer = bl;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public void setPrivateKeyPath(String string) {
        this.privateKeyPath = string;
    }

    public int getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(int n) {
        this.authenticationType = n;
    }
}

