/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetActivityCommand;
import com.helpsystems.enterprise.core.cmdlineobj.GetAgentStatusCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SendMessageCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableCommand;
import java.io.Serializable;
import junit.framework.TestCase;

public class AgentCommandTest
extends TestCase {
    public void testAgentCommandCanLoadSendMessageCommand() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("SENDMSG");
        AgentCommandTest.assertNotNull((Object)((Object)agentCommand));
        AgentCommandTest.assertTrue((boolean)(agentCommand instanceof SendMessageCommand));
    }

    public void testAgentCommandCanLoadGetActivityCommand() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("GETACTIVITY");
        AgentCommandTest.assertNotNull((Object)((Object)agentCommand));
        AgentCommandTest.assertTrue((boolean)(agentCommand instanceof GetActivityCommand));
    }

    public void testAgentCommandCanLoadReservedCommandVariableCommand() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("ROVAR");
        AgentCommandTest.assertNotNull((Object)((Object)agentCommand));
        AgentCommandTest.assertTrue((boolean)(agentCommand instanceof SkybotVariableCommand));
    }

    public void testAgentCommandCanLoadGetAgentStatusCommand() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("GETSTATUS");
        AgentCommandTest.assertNotNull((Object)((Object)agentCommand));
        AgentCommandTest.assertTrue((boolean)(agentCommand instanceof GetAgentStatusCommand));
    }

    public void testAgentCommandCanLoadFileTransferProtocolCommand() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("FTP");
        AgentCommandTest.assertNotNull((Object)((Object)agentCommand));
        AgentCommandTest.assertTrue((boolean)(agentCommand instanceof FileTransferCommand));
    }

    public void testAgentCommandHandlesBadLoadRequest() throws Exception {
        try {
            AgentCommand.loadAgentCommand("BOGUS_VALUE");
            AgentCommandTest.fail((String)"loadAgentCommand() accepted bogus command type");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testGetAgentName() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("SENDMSG");
        AgentCommandTest.assertEquals((String)"", (String)agentCommand.getAgentName());
        agentCommand.setAgentName("AGENT_NAME");
        AgentCommandTest.assertEquals((String)"AGENT_NAME", (String)agentCommand.getAgentName());
    }

    public void testGetEnterpriseServerName() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("SENDMSG");
        AgentCommandTest.assertEquals((String)"", (String)agentCommand.getEnterpriseServerName());
        agentCommand.setEnterpriseServerName("SERVERNAME");
        AgentCommandTest.assertEquals((String)"SERVERNAME", (String)agentCommand.getEnterpriseServerName());
    }

    public void testRequestTimeStamp() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("SENDMSG");
        long l = System.currentTimeMillis();
        agentCommand.setRequestTimestamp(l);
        AgentCommandTest.assertEquals((long)agentCommand.getRequestTimestamp(), (long)agentCommand.getRequestTimestamp());
    }

    public void testSetInitiatingAgent() throws Exception {
        AgentCommand agentCommand = AgentCommand.loadAgentCommand("SENDMSG");
        PeerDescriptor peerDescriptor = new PeerDescriptor("localhost", 1234, 1, "unknown");
        PeerID peerID = PeerID.createPeerID((String)"hardwareKey", (Serializable)((Object)"instanceIdentifier"), (PeerDescriptor)peerDescriptor);
        agentCommand.setInitiatingAgent(peerID);
        AgentCommandTest.assertEquals((Object)peerID, (Object)agentCommand.getInitiatingAgent());
    }
}

