/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.enterprise.core.cmdlineobj.AgentCommandReply;
import java.io.Serializable;
import junit.framework.TestCase;

public class AgentCommandReplyTest
extends TestCase {
    AgentCommandReply acr = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.acr = new AgentCommandReply();
    }

    protected void tearDown() throws Exception {
        this.acr = null;
        super.tearDown();
    }

    public void testConstructorWithException() {
        Exception exception = new Exception("Test exception");
        AgentCommandReply agentCommandReply = new AgentCommandReply(exception);
        AgentCommandReplyTest.assertEquals((Object)exception, (Object)agentCommandReply.getException());
        AgentCommandReplyTest.assertTrue((boolean)agentCommandReply.isFailed());
        AgentCommandReplyTest.assertEquals((String)"Test exception", (String)agentCommandReply.getReplyText());
    }

    public void testConstructorWithExceptionAndText() {
        Exception exception = new Exception("Test exception");
        AgentCommandReply agentCommandReply = new AgentCommandReply(exception, "Some other text");
        AgentCommandReplyTest.assertEquals((Object)exception, (Object)agentCommandReply.getException());
        AgentCommandReplyTest.assertTrue((boolean)agentCommandReply.isFailed());
        AgentCommandReplyTest.assertEquals((String)"Some other text", (String)agentCommandReply.getReplyText());
    }

    public void testConstructorWithBooleanAndText() {
        AgentCommandReply agentCommandReply = new AgentCommandReply(false, "Some text");
        AgentCommandReplyTest.assertFalse((boolean)agentCommandReply.isFailed());
        AgentCommandReplyTest.assertEquals((String)"Some text", (String)agentCommandReply.getReplyText());
        AgentCommandReplyTest.assertNull((Object)agentCommandReply.getException());
        agentCommandReply = new AgentCommandReply(true, "More text");
        AgentCommandReplyTest.assertTrue((boolean)agentCommandReply.isFailed());
        AgentCommandReplyTest.assertEquals((String)"More text", (String)agentCommandReply.getReplyText());
        AgentCommandReplyTest.assertNotNull((Object)agentCommandReply.getException());
    }

    public void testGetFailed() {
        this.acr.setFailed(true);
        AgentCommandReplyTest.assertTrue((boolean)this.acr.getFailed());
        this.acr.setFailed(false);
        AgentCommandReplyTest.assertFalse((boolean)this.acr.getFailed());
    }

    public void testGetException() {
        Throwable throwable = new Throwable();
        this.acr.setException(throwable);
        AgentCommandReplyTest.assertEquals((Object)throwable, (Object)this.acr.getException());
    }

    public void testGetReplyText() {
        String string = "This is reply text.";
        this.acr.setReplyText(string);
        AgentCommandReplyTest.assertEquals((String)string, (String)this.acr.getReplyText());
    }

    public void testGetReturnObject() {
        ReturnObject returnObject = new ReturnObject();
        this.acr.setReturnObject(returnObject);
        AgentCommandReplyTest.assertEquals((Object)returnObject, (Object)this.acr.getReturnObject());
    }

    private class ReturnObject
    implements Serializable {
        private ReturnObject() {
        }
    }
}

