/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPParameterSign;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantActionList;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public class SAPVariantAction
extends EnterpriseProxy {
    private static final long serialVersionUID = -1L;
    private long commandID;
    private long sapSystemEnvironmentID;
    private String sapProgramName;
    private String sapVariant;
    private String parameterName;
    private SAPVariantParameterType parameterType;
    private SAPParameterSign parameterSign;
    private SAPVariantParameterOption parameterOption;
    private String parameterLowValue;
    private String parameterHighValue;

    public SAPVariantAction() {
    }

    public SAPVariantAction(int n, String string, String string2) {
        this.sapSystemEnvironmentID = n;
        this.sapProgramName = string;
        this.sapVariant = string2;
        this.init();
    }

    public SAPVariantAction(SAPVariantActionList sAPVariantActionList) {
        this.sapSystemEnvironmentID = sAPVariantActionList.getSAPSystemEnvironmentID();
        this.sapProgramName = sAPVariantActionList.getSapProgramName();
        this.sapVariant = sAPVariantActionList.getSapVariant();
        this.init();
    }

    private void init() {
        this.parameterType = SAPVariantParameterType.PARAMETER;
        this.parameterSign = SAPParameterSign.INCLUDE;
        this.parameterOption = SAPVariantParameterOption.EQUALS;
    }

    public long getSAPSystemEnvironmentID() {
        return this.sapSystemEnvironmentID;
    }

    public void setSAPSystemEnvironmentID(long l) {
        this.sapSystemEnvironmentID = l;
    }

    public String getSapProgramName() {
        return this.sapProgramName;
    }

    public void setSapProgramName(String string) {
        this.sapProgramName = string;
    }

    public String getSapVariant() {
        return this.sapVariant;
    }

    public void setSapVariant(String string) {
        this.sapVariant = string;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String string) {
        this.parameterName = string;
    }

    public SAPVariantParameterType getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(SAPVariantParameterType sAPVariantParameterType) {
        this.parameterType = sAPVariantParameterType;
    }

    public SAPParameterSign getParameterSign() {
        return this.parameterSign;
    }

    public void setParameterSign(SAPParameterSign sAPParameterSign) {
        this.parameterSign = sAPParameterSign;
    }

    public SAPVariantParameterOption getParameterOption() {
        return this.parameterOption;
    }

    public void setParameterOption(SAPVariantParameterOption sAPVariantParameterOption) {
        this.parameterOption = sAPVariantParameterOption;
    }

    public String getParameterLowValue() {
        return this.parameterLowValue;
    }

    public void setParameterLowValue(String string) {
        this.parameterLowValue = string;
    }

    public String getParameterHighValue() {
        return this.parameterHighValue;
    }

    public void setParameterHighValue(String string) {
        this.parameterHighValue = string;
    }

    public String getVariantChangeParameters() {
        return "CommandID: " + this.commandID + " SAP System Environment ID:" + this.sapSystemEnvironmentID + " Program:" + this.sapProgramName + " Variant:" + this.sapVariant;
    }

    public void setCommandID(long l) {
        this.commandID = l;
    }

    public long getCommandID() {
        return this.commandID;
    }

    public static enum SAPVariantParameterOption implements PersistableEnum<String>
    {
        EQUALS("EQ"),
        NOT_EQUAL_TO("NE"),
        BETWEEN("BT"),
        LESS_THAN_OR_EQUAL_TO("LE"),
        GREATER_THAN_OR_EQUAL_TO("GE"),
        CONTAINS_PATTERN("CP");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, SAPVariantParameterOption> map;

        private SAPVariantParameterOption(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static SAPVariantParameterOption persistanceCodeToEnum(String string) {
            SAPVariantParameterOption sAPVariantParameterOption = map.get(string);
            if (sAPVariantParameterOption == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return sAPVariantParameterOption;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])SAPVariantParameterOption.values());
        }
    }

    public static enum SAPVariantParameterType implements PersistableEnum<String>
    {
        PARAMETER("P"),
        SELECTION("S");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, SAPVariantParameterType> map;

        private SAPVariantParameterType(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static SAPVariantParameterType persistanceCodeToEnum(String string) {
            SAPVariantParameterType sAPVariantParameterType = map.get(string);
            if (sAPVariantParameterType == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return sAPVariantParameterType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])SAPVariantParameterType.values());
        }
    }
}

