/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.sap.SAPJobClass;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobStatus;

public class SAPJobSimple
extends SAPJobProxy {
    private static final long serialVersionUID = -1L;
    private String eventIdentifier;
    private String jobInitiator;
    private SAPJobClass jobClass;
    private int jobStepCount;
    private String releaser;

    public SAPJobSimple(String string, String string2) {
        this.setJobName(string);
        this.setJobCount(string2);
    }

    public SAPJobSimple() {
    }

    public SAPJobSimple(long l) {
        this.setSapSystemDefinitionID(l);
        this.initDefaults();
    }

    private void initDefaults() {
        this.setJobStatus(SAPJobStatus.UNKNOWN);
        this.setJobInitiator("");
        this.setPeriodic(false);
    }

    public SAPJobSimple(long l, String string, String string2, SAPJobStatus sAPJobStatus) {
        this.setSapSystemDefinitionID(l);
        this.setJobName(string);
        this.setJobCount(string2);
        this.setJobStatus(sAPJobStatus);
    }

    @Override
    public String getNameAndCount() {
        return this.getJobName() + "(" + this.getJobCount() + ")";
    }

    public void setJobClass(SAPJobClass sAPJobClass) {
        this.jobClass = sAPJobClass;
    }

    public SAPJobClass getJobClass() {
        return this.jobClass;
    }

    public void setJobClassAsString(String string) {
        this.jobClass = SAPJobClass.persistanceCodeToEnum(string);
    }

    public String getJobClassAsString() {
        return this.jobClass.persistanceCode();
    }

    public void setEventIdentifier(String string) {
        this.eventIdentifier = string;
    }

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public void setJobInitiator(String string) {
        this.jobInitiator = string;
    }

    public String getJobInitiator() {
        return this.jobInitiator;
    }

    public void setJobStepCount(int n) {
        this.jobStepCount = n;
    }

    public int getJobStepCount() {
        return this.jobStepCount;
    }

    public void setReleaser(String string) {
        this.releaser = string;
    }

    public String getReleaser() {
        return this.releaser;
    }
}

