/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPNoMatchException;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;

public class SAPInterceptCriterion {
    private static Logger logger = Logger.getLogger(SAPInterceptCriterion.class);
    private static final long serialVersionUID = -1L;
    private static final String WILDCARD = "*";
    private long OID;
    private long skybotJobID;
    private String skybotJobName;
    private ScheduleInfo.TimeZoneType timeZoneType;
    private String jobTimezone;
    private long skybotTargetID;
    private String skybotAgentName;
    private long sapSystemDefinitionID;
    private String sapSystemDefinitionName;
    private String client;
    private String jobName;
    private String jobCreator;
    private int allowedFromHHMM;
    private int allowedToHHMM;
    private boolean restrictedMonday;
    private boolean restrictedTuesday;
    private boolean restrictedWednesday;
    private boolean restrictedThursday;
    private boolean restrictedFriday;
    private boolean restrictedSaturday;
    private boolean restrictedSunday;

    public SAPInterceptCriterion(String string, long l, String string2, String string3, String string4) {
        this.sapSystemDefinitionName = string;
        this.sapSystemDefinitionID = l;
        this.client = string2;
        this.jobName = string3;
        this.jobCreator = string4;
    }

    public SAPInterceptCriterion() {
    }

    public SAPInterceptCriterion(String string) {
        this.sapSystemDefinitionName = string;
    }

    public SAPInterceptCriterion(long l) {
        this.setSapSystemDefinitionID(l);
    }

    public void setOID(long l) {
        this.OID = l;
    }

    public long getOID() {
        return this.OID;
    }

    public void setSapSystemDefinitionID(long l) {
        this.sapSystemDefinitionID = l;
    }

    public long getSapSystemDefinitionID() {
        return this.sapSystemDefinitionID;
    }

    public String getSapSystemDefinitionName() {
        return this.sapSystemDefinitionName;
    }

    public void setSapSystemDefinitionName(String string) {
        this.sapSystemDefinitionName = string;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String string) {
        this.client = string;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String string) {
        this.jobName = string;
    }

    public String getJobCreator() {
        return this.jobCreator;
    }

    public void setJobCreator(String string) {
        this.jobCreator = string;
    }

    public String toString() {
        return "SAP System: " + this.sapSystemDefinitionName + "(" + this.sapSystemDefinitionID + "); SAP Job:" + this.jobName + "; Job Owner:" + this.jobCreator + "; client:" + this.client;
    }

    public void setSkybotJobID(long l) {
        this.skybotJobID = l;
    }

    public long getSkybotJobID() {
        return this.skybotJobID;
    }

    public ScheduleInfo.TimeZoneType getTimeZoneType() {
        return this.timeZoneType;
    }

    public void setTimeZoneType(ScheduleInfo.TimeZoneType timeZoneType) {
        this.timeZoneType = timeZoneType;
    }

    public String getJobTimezone() {
        return this.jobTimezone;
    }

    public void setJobTimezone(String string) {
        this.jobTimezone = string;
    }

    public void setSkybotTargetID(long l) {
        this.skybotTargetID = l;
    }

    public long getSkybotTargetID() {
        return this.skybotTargetID;
    }

    public String getSkybotJobName() {
        return this.skybotJobName;
    }

    public void setSkybotJobName(String string) {
        this.skybotJobName = string;
    }

    public String getSkybotAgentName() {
        return this.skybotAgentName;
    }

    public void setSkybotAgentName(String string) {
        this.skybotAgentName = string;
    }

    public void setAllowedFromHHMM(int n) {
        this.allowedFromHHMM = n;
    }

    public int getAllowedFromHHMM() {
        return this.allowedFromHHMM;
    }

    public void setAllowedToHHMM(int n) {
        this.allowedToHHMM = n;
    }

    public int getAllowedToHHMM() {
        return this.allowedToHHMM;
    }

    public void setRestrictedMonday(boolean bl) {
        this.restrictedMonday = bl;
    }

    public boolean isRestrictedMonday() {
        return this.restrictedMonday;
    }

    public void setRestrictedTuesday(boolean bl) {
        this.restrictedTuesday = bl;
    }

    public boolean isRestrictedTuesday() {
        return this.restrictedTuesday;
    }

    public boolean isRestrictedWednesday() {
        return this.restrictedWednesday;
    }

    public void setRestrictedWednesday(boolean bl) {
        this.restrictedWednesday = bl;
    }

    public boolean isRestrictedThursday() {
        return this.restrictedThursday;
    }

    public void setRestrictedThursday(boolean bl) {
        this.restrictedThursday = bl;
    }

    public boolean isRestrictedFriday() {
        return this.restrictedFriday;
    }

    public void setRestrictedFriday(boolean bl) {
        this.restrictedFriday = bl;
    }

    public boolean isRestrictedSaturday() {
        return this.restrictedSaturday;
    }

    public void setRestrictedSaturday(boolean bl) {
        this.restrictedSaturday = bl;
    }

    public boolean isRestrictedSunday() {
        return this.restrictedSunday;
    }

    public void setRestrictedSunday(boolean bl) {
        this.restrictedSunday = bl;
    }

    public boolean isRestricted() {
        return this.isRestrictedMonday() || this.isRestrictedTuesday() || this.isRestrictedWednesday() || this.isRestrictedThursday() || this.isRestrictedFriday() || this.isRestrictedSaturday() || this.isRestrictedSunday();
    }

    public int getMatchingWeight(boolean bl, boolean bl2, boolean bl3, SAPInterceptedJob sAPInterceptedJob) throws SAPNoMatchException {
        if (bl) {
            if (!sAPInterceptedJob.getJobName().equals(this.jobName)) {
                throw new SAPNoMatchException();
            }
            return this.getWeightAfterJobName(sAPInterceptedJob, bl2, bl3);
        }
        int n = this.getWildCardMatchWeight(SAPCriteriaChoice.JOB_NAME, sAPInterceptedJob.getJobName());
        int n2 = this.getWeightAfterJobName(sAPInterceptedJob, bl2, bl3);
        return n + n2;
    }

    private int getWeightAfterJobName(SAPInterceptedJob sAPInterceptedJob, boolean bl, boolean bl2) throws SAPNoMatchException {
        if (bl) {
            if (!sAPInterceptedJob.getJobOwner().equals(this.jobCreator)) {
                throw new SAPNoMatchException();
            }
            if (bl2) {
                if (!sAPInterceptedJob.getClient().equals(this.client)) {
                    throw new SAPNoMatchException();
                }
                return -1;
            }
            return this.getWildCardMatchWeight(SAPCriteriaChoice.JOB_CLIENT, sAPInterceptedJob.getClient());
        }
        int n = this.getWildCardMatchWeight(SAPCriteriaChoice.JOB_CREATOR, sAPInterceptedJob.getJobOwner());
        if (bl2 && !sAPInterceptedJob.getClient().equals(this.client)) {
            throw new SAPNoMatchException();
        }
        int n2 = this.getWildCardMatchWeight(SAPCriteriaChoice.JOB_CLIENT, sAPInterceptedJob.getClient());
        return n + n2;
    }

    private int getWildCardMatchWeight(SAPCriteriaChoice sAPCriteriaChoice, String string) throws SAPNoMatchException {
        int n;
        logger.trace((Object)("checkString = " + string));
        String string2 = null;
        switch (sAPCriteriaChoice) {
            case JOB_NAME: {
                string2 = this.jobName;
                break;
            }
            case JOB_CREATOR: {
                string2 = this.jobCreator;
                break;
            }
            case JOB_CLIENT: {
                string2 = this.client;
            }
        }
        if (string2.equals(string)) {
            logger.debug((Object)("Criteria string: " + string2 + " matches check string: " + string));
            return string2.length();
        }
        for (int i = n = string.length(); i >= 0; --i) {
            String string3 = string.substring(0, i) + WILDCARD;
            logger.trace((Object)("Comparing " + string2 + " with " + string3));
            if (!string2.equals(string3)) continue;
            return string2.length();
        }
        throw new SAPNoMatchException();
    }

    public void setValue(String[] stringArray) {
        if (stringArray == null || stringArray.length != 2) {
            throw new InvalidParameterException("splitItem must be length of 2.");
        }
        String string = stringArray[0].replace("\"", "");
        String string2 = stringArray[1].replace("\"", "");
        logger.trace((Object)("criteriaTitle(value) = " + string + "(" + string2 + ")"));
        SAPCriteriaChoice sAPCriteriaChoice = SAPCriteriaChoice.persistanceCodeToEnum(string);
        switch (sAPCriteriaChoice) {
            case JOB_NAME: {
                this.setJobName(string2);
                break;
            }
            case JOB_CREATOR: {
                this.setJobCreator(string2);
                break;
            }
            case JOB_CLIENT: {
                this.setClient(string2);
            }
        }
    }

    public boolean isRestrictedDay(DayOfWeek dayOfWeek) {
        switch (dayOfWeek) {
            case SUNDAY: {
                return this.isRestrictedSunday();
            }
            case MONDAY: {
                return this.isRestrictedMonday();
            }
            case TUESDAY: {
                return this.isRestrictedTuesday();
            }
            case WEDNESDAY: {
                return this.isRestrictedWednesday();
            }
            case THURSDAY: {
                return this.isRestrictedThursday();
            }
            case FRIDAY: {
                return this.isRestrictedFriday();
            }
            case SATURDAY: {
                return this.isRestrictedSaturday();
            }
        }
        logger.error((Object)("Invalid enum DayOfWeek value " + dayOfWeek + " passed to method."));
        return false;
    }

    public static enum DayOfWeek implements PersistableEnum<Integer>
    {
        SUNDAY(1),
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7);

        private int dayNumber;
        private static PersistanceCodeToEnumMap<Integer, DayOfWeek> map;

        private DayOfWeek(int n2) {
            this.dayNumber = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.dayNumber;
        }

        public static DayOfWeek persistanceCodeToEnum(Integer n) {
            DayOfWeek dayOfWeek = map.get(n);
            if (dayOfWeek == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return dayOfWeek;
        }

        public static DayOfWeek getTomorrow(DayOfWeek dayOfWeek) {
            if (dayOfWeek.equals(SATURDAY)) {
                return SUNDAY;
            }
            int n = dayOfWeek.dayNumber + 1;
            return DayOfWeek.persistanceCodeToEnum(n);
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])DayOfWeek.values());
        }
    }

    private static enum SAPCriteriaChoice implements PersistableEnum<String>
    {
        JOB_NAME("job"),
        JOB_CREATOR("user"),
        JOB_CLIENT("client");

        private String criteriaName;
        private static PersistanceCodeToEnumMap<String, SAPCriteriaChoice> map;

        private SAPCriteriaChoice(String string2) {
            this.criteriaName = string2;
        }

        public static SAPCriteriaChoice persistanceCodeToEnum(String string) {
            SAPCriteriaChoice sAPCriteriaChoice = map.get(string);
            if (sAPCriteriaChoice == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return sAPCriteriaChoice;
        }

        @Override
        public String persistanceCode() {
            return this.criteriaName;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])SAPCriteriaChoice.values());
        }
    }
}

