/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPCommand;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemEnvironment;

public class SAPExecutable
extends EnterpriseProxy {
    private static final long serialVersionUID = -1L;
    private SAPCommand sapCommand;
    private SAPSystemDefinition sapSystemDefinition;
    private SAPSystemEnvironment sapSystemEnvironment;
    private long skybotEventID;
    private String agentNameAndPort;
    private long sapSystemDefinitionID;
    private String commandString;

    public SAPExecutable() {
    }

    public SAPExecutable(SAPCommand sAPCommand) {
        this.sapCommand = sAPCommand;
        this.setSapSystemDefinitionID(sAPCommand.getSAPSystemDefinitionID());
    }

    public void setSapCommand(SAPCommand sAPCommand) {
        this.sapCommand = sAPCommand;
    }

    public SAPCommand getSapCommand() {
        return this.sapCommand;
    }

    public void setSapSystemDefinition(SAPSystemDefinition sAPSystemDefinition) {
        this.sapSystemDefinition = sAPSystemDefinition;
    }

    public SAPSystemDefinition getSapSystemDefinition() {
        return this.sapSystemDefinition;
    }

    public long getSapSystemDefinitionID() throws ResourceUnavailableException {
        if (this.sapSystemDefinitionID != 0L) {
            return this.sapSystemDefinitionID;
        }
        throw new ResourceUnavailableException("No SAPSystemDefinitionID found in SAPExecutable.");
    }

    public void setSapSystemEnvironment(SAPSystemEnvironment sAPSystemEnvironment) {
        this.sapSystemEnvironment = sAPSystemEnvironment;
        this.setSapSystemDefinitionID(sAPSystemEnvironment.getSapSystemDefinitionID());
    }

    public SAPSystemEnvironment getSapSystemEnvironment() {
        return this.sapSystemEnvironment;
    }

    public void setSkybotEventID(long l) {
        this.skybotEventID = l;
    }

    public long getSkybotEventID() {
        return this.skybotEventID;
    }

    public String getSAPSystemName() {
        return this.sapSystemDefinition.getName();
    }

    public void setAgentNameAndPort(String string) {
        this.agentNameAndPort = string;
    }

    public String getAgentNameAndPort() {
        return this.agentNameAndPort;
    }

    public void setSapSystemDefinitionID(long l) {
        this.sapSystemDefinitionID = l;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public void setCommandString(String string) {
        this.commandString = string;
    }
}

