/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaNode;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaXMLInfo;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriterionProfile;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SAPCriteria {
    private static Logger logger = Logger.getLogger(SAPCriteria.class);
    private int profileID;
    private String criterionType;
    private String criteriaXML;
    private SAPCriteriaXMLInfo sapCriteriaXMLInfo;
    private SAPCriterionProfile sapCriterionProfile;
    private ArrayList<SAPCriteriaNode> sapCriteriaNodes = new ArrayList();

    public SAPCriteria() {
    }

    public SAPCriteria(int n, String string, SAPCriterionProfile sAPCriterionProfile) throws Exception {
        this.profileID = n;
        this.criteriaXML = string;
        this.sapCriterionProfile = sAPCriterionProfile;
        this.init();
    }

    private void init() throws Exception {
        this.criteriaXML = this.criteriaXML.substring(1);
        logger.debug((Object)"after criteriaXML.substring(1)");
        this.criteriaXML = this.criteriaXML.replace("\"utf-16\"?", "\"utf-16\" ?");
        this.criteriaXML = this.criteriaXML.replace("> <", "><");
        logger.debug((Object)"After replace");
        try {
            this.sapCriteriaXMLInfo = new SAPCriteriaXMLInfo(this.criteriaXML, this);
            this.sapCriterionProfile.setCriterionType(this.sapCriteriaXMLInfo.getProfileType());
            this.sapCriterionProfile.setDescription(this.sapCriteriaXMLInfo.getProfileDescription());
            this.sapCriterionProfile.setProfileStatus(SAPCriterionProfile.SAPCriterionProfileStatus.persistanceCodeToEnum(this.sapCriteriaXMLInfo.getProfileState()));
            this.sapCriterionProfile.setLastchUser(this.sapCriteriaXMLInfo.getProfileLastChUser());
            this.sapCriterionProfile.setLastChTimeUTC(BigDecimal.valueOf(Long.parseLong(this.sapCriteriaXMLInfo.getProfileLastchtmstmp().trim())));
            this.sapCriterionProfile.setCreateUser(this.sapCriteriaXMLInfo.getProfileCreateuser());
        }
        catch (Exception exception) {
            throw new Exception("Error instantiating new SAPCriteriaXMLInfo ", exception);
        }
    }

    public int getProfileID() {
        return this.profileID;
    }

    public void setProfileID(int n) {
        this.profileID = n;
    }

    public String getCriterionType() {
        return this.criterionType;
    }

    public void setCriterionType(String string) {
        this.criterionType = string;
    }

    public String getCriteriaXML() {
        return this.criteriaXML;
    }

    public void setCriteriaXML(String string) {
        this.criteriaXML = string;
    }

    public String getCriteriaProfileDescription() {
        return this.sapCriteriaXMLInfo.getProfileDescription();
    }

    public void setCriteriaProfileDescription(String string) {
        this.sapCriteriaXMLInfo.setProfileDescription(string);
    }

    public String getCriteriaProfileState() {
        return this.sapCriteriaXMLInfo.getProfileState();
    }

    public void setCriteriaProfileState(String string) {
        this.sapCriteriaXMLInfo.setProfileState(string);
    }

    public void addNode(SAPCriteriaNode sAPCriteriaNode) {
        this.sapCriteriaNodes.add(sAPCriteriaNode);
    }

    public ArrayList<SAPCriteriaNode> getNodes() {
        return this.sapCriteriaNodes;
    }
}

