/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPField;
import com.helpsystems.enterprise.core.busobj.sap.SAPParameters;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.security.InvalidParameterException;

public class SAPAllPrintParameters
extends SAPParameters {
    private static final long serialVersionUID = -1L;
    public static final String PARAMETER_NAME = "ALLPRIPAR";
    public static final String STRUCTURE_NAME = "BAPIPRIPAR";
    public static final String SAP_EMPTY_CHARACTER = "$";
    private long oid;
    private String outputDevice = "";
    private int numberOfCopies = 1;
    private String spoolRequestName = "";
    private String coverPageText = "";
    private boolean printImmediately;
    private boolean deleteAfterPrinting;
    private boolean newSpoolRequest;
    private int spoolRetentionPeriod;
    private int pageLengthOfList;
    private int lineWidthOfList;
    private String printFormat = "";
    private boolean printSelectionCoverPage;
    private SAP_PRSAP_Setting printSAPCoverPage = SAP_PRSAP_Setting.OutputDeviceDependent;
    private String recipient = "";
    private String coverPageDepartment = "";
    private String authorization = "";
    private String nameOfSpoolFile = "";
    private String typeOfSpoolRequest = "";
    private int archivingMode = 1;
    private int spoolRequestPriority = 5;
    private boolean printHostCoverPage;
    private String sapObject = "";
    private String arObject = "";
    private String arcText = "";
    private String info = "";

    public SAPAllPrintParameters(String string, String string2, String string3) {
        this.setField(PrintParameterField.PDEST, string);
        this.setField(PrintParameterField.PLIST, string2);
        this.setField(PrintParameterField.PRCOP, string3);
    }

    public SAPAllPrintParameters() {
    }

    @Override
    public String getBooleanFieldAsString(SAPField sAPField) {
        PrintParameterField printParameterField = (PrintParameterField)sAPField;
        switch (printParameterField) {
            case PRIMM: {
                return this.getSAPSelectStringForBoolean(this.isPrintImmediately());
            }
            case PRREL: {
                return this.getSAPSelectStringForBoolean(this.isDeleteAfterPrinting());
            }
            case PRNEW: {
                return this.getSAPSelectStringForBoolean(this.isNewSpoolRequest());
            }
            case PRUNX: {
                return this.getSAPSelectStringForBoolean(this.isPrintHostCoverPage());
            }
            case PRBIG: {
                return this.getSAPSelectStringForBoolean(this.isPrintSelectionCoverPage());
            }
        }
        throw new InvalidParameterException("The field " + printParameterField + " is not one of the known Boolean fields for the parameter " + PARAMETER_NAME + ".");
    }

    private String getSAPSelectStringForBoolean(boolean bl) {
        if (bl) {
            return "X";
        }
        return SAP_EMPTY_CHARACTER;
    }

    @Override
    public Object getField(SAPField sAPField) {
        PrintParameterField printParameterField = (PrintParameterField)sAPField;
        switch (printParameterField) {
            case PDEST: {
                return this.getOutputDevice();
            }
            case PRCOP: {
                return this.getNumberOfCopies();
            }
            case PLIST: {
                return this.getSpoolRequestName();
            }
            case PRTXT: {
                return this.getCoverPageText();
            }
            case PEXPI: {
                return this.getSpoolRetentionPeriod();
            }
            case LINCT: {
                if (this.getPageLengthOfList() > 0) {
                    return this.getPageLengthOfList();
                }
                return "";
            }
            case LINSZ: {
                if (this.getLineWidthOfList() > 0) {
                    return this.getLineWidthOfList();
                }
                return "";
            }
            case PAART: {
                return this.getPrintFormat();
            }
            case PRSAP: {
                return this.getContentsOrDollarSign(this.getPrintSAPCoverPage().persistenceCode);
            }
            case PRREC: {
                return this.getContentsOrDollarSign(this.getRecipient());
            }
            case PRABT: {
                return this.getContentsOrDollarSign(this.getCoverPageDepartment());
            }
            case PRBER: {
                return this.getAuthorization();
            }
            case PRDSN: {
                return this.getNameOfSpoolFile();
            }
            case PTYPE: {
                return this.getTypeOfSpoolRequest();
            }
            case ARMOD: {
                return this.getArchivingMode();
            }
            case PRIOT: {
                return this.getSpoolRequestPriority();
            }
            case SAP_OBJECT: {
                return this.getSapObject();
            }
            case AR_OBJECT: {
                return this.getArObject();
            }
            case INFO: {
                return this.getInfo();
            }
            case ARCTEXT: {
                return this.getArcText();
            }
        }
        throw new InvalidParameterException("The field " + printParameterField + " is not one of the known non-Boolean fields for the parameter " + PARAMETER_NAME + ".");
    }

    private String getContentsOrDollarSign(String string) {
        if (string == null || string.length() == 0) {
            return SAP_EMPTY_CHARACTER;
        }
        return string;
    }

    public void setBooleanField(PrintParameterField printParameterField, boolean bl) {
        switch (printParameterField) {
            case PRIMM: {
                this.setPrintImmediately(bl);
                break;
            }
            case PRREL: {
                this.setDeleteAfterPrinting(bl);
                break;
            }
            case PRNEW: {
                this.setNewSpoolRequest(bl);
                break;
            }
            case PRUNX: {
                this.setPrintHostCoverPage(bl);
                break;
            }
            case PRBIG: {
                this.setPrintSelectionCoverPage(bl);
                break;
            }
            default: {
                throw new InvalidParameterException("The field " + printParameterField + " is not a known Boolean field for the parameter " + PARAMETER_NAME + ".");
            }
        }
    }

    public void setField(PrintParameterField printParameterField, Object object) {
        switch (printParameterField) {
            case PDEST: {
                this.setOutputDevice(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PRCOP: {
                this.setNumberOfCopies(this.getIntegerFromValue(object, printParameterField));
                break;
            }
            case PLIST: {
                this.setSpoolRequestName(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PRTXT: {
                this.setCoverPageText(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PEXPI: {
                this.setSpoolRetentionPeriod(this.getIntegerFromValue(object, printParameterField));
                break;
            }
            case LINCT: {
                this.setPageLengthOfList(this.getIntegerFromValue(object, printParameterField));
                break;
            }
            case LINSZ: {
                this.setLineWidthOfList(this.getIntegerFromValue(object, printParameterField));
                break;
            }
            case PAART: {
                this.setPrintFormat(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PRSAP: {
                this.setPrintSAPCoverPage((SAP_PRSAP_Setting)object);
                break;
            }
            case PRREC: {
                this.setRecipient(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PRABT: {
                this.setCoverPageDepartment(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PRBER: {
                this.setAuthorization(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PRDSN: {
                this.setNameOfSpoolFile(this.getStringFromValue(object, printParameterField));
                break;
            }
            case PTYPE: {
                this.setTypeOfSpoolRequest(this.getStringFromValue(object, printParameterField));
                break;
            }
            case ARMOD: {
                this.setArchivingMode(this.getIntegerFromValue(object, printParameterField));
                break;
            }
            case PRIOT: {
                this.setSpoolRequestPriority(this.getIntegerFromValue(object, printParameterField));
                break;
            }
            case SAP_OBJECT: {
                this.setSapObject(this.getStringFromValue(object, printParameterField));
                break;
            }
            case AR_OBJECT: {
                this.setArObject(this.getStringFromValue(object, printParameterField));
                break;
            }
            case ARCTEXT: {
                this.setArcText(this.getStringFromValue(object, printParameterField));
                break;
            }
            case INFO: {
                this.setInfo(this.getStringFromValue(object, printParameterField));
                break;
            }
            default: {
                throw new InvalidParameterException("The field " + printParameterField + " is not a String or an Integer.");
            }
        }
    }

    public long getOid() {
        return this.oid;
    }

    public void setOid(long l) {
        this.oid = l;
    }

    private String getOutputDevice() {
        return this.outputDevice;
    }

    private void setOutputDevice(String string) {
        this.outputDevice = string;
    }

    private int getNumberOfCopies() {
        return this.numberOfCopies;
    }

    private void setNumberOfCopies(int n) {
        this.numberOfCopies = n;
    }

    private String getSpoolRequestName() {
        return this.spoolRequestName;
    }

    private void setSpoolRequestName(String string) {
        this.spoolRequestName = string;
    }

    private String getCoverPageText() {
        return this.coverPageText;
    }

    private void setCoverPageText(String string) {
        this.coverPageText = string;
    }

    private boolean isPrintImmediately() {
        return this.printImmediately;
    }

    private void setPrintImmediately(boolean bl) {
        this.printImmediately = bl;
    }

    private boolean isDeleteAfterPrinting() {
        return this.deleteAfterPrinting;
    }

    private void setDeleteAfterPrinting(boolean bl) {
        this.deleteAfterPrinting = bl;
    }

    private boolean isNewSpoolRequest() {
        return this.newSpoolRequest;
    }

    private void setNewSpoolRequest(boolean bl) {
        this.newSpoolRequest = bl;
    }

    private int getSpoolRetentionPeriod() {
        return this.spoolRetentionPeriod;
    }

    private void setSpoolRetentionPeriod(int n) {
        this.spoolRetentionPeriod = n;
    }

    private int getPageLengthOfList() {
        return this.pageLengthOfList;
    }

    private void setPageLengthOfList(int n) {
        this.pageLengthOfList = n;
    }

    private int getLineWidthOfList() {
        return this.lineWidthOfList;
    }

    private void setLineWidthOfList(int n) {
        this.lineWidthOfList = n;
    }

    private String getPrintFormat() {
        return this.printFormat;
    }

    private void setPrintFormat(String string) {
        this.printFormat = string;
    }

    private boolean isPrintSelectionCoverPage() {
        return this.printSelectionCoverPage;
    }

    private void setPrintSelectionCoverPage(boolean bl) {
        this.printSelectionCoverPage = bl;
    }

    private SAP_PRSAP_Setting getPrintSAPCoverPage() {
        return this.printSAPCoverPage;
    }

    private void setPrintSAPCoverPage(SAP_PRSAP_Setting sAP_PRSAP_Setting) {
        this.printSAPCoverPage = sAP_PRSAP_Setting;
    }

    private String getRecipient() {
        return this.recipient;
    }

    private void setRecipient(String string) {
        this.recipient = string;
    }

    private String getCoverPageDepartment() {
        return this.coverPageDepartment;
    }

    private void setCoverPageDepartment(String string) {
        this.coverPageDepartment = string;
    }

    private String getAuthorization() {
        return this.authorization;
    }

    private void setAuthorization(String string) {
        this.authorization = string;
    }

    private String getNameOfSpoolFile() {
        return this.nameOfSpoolFile;
    }

    private void setNameOfSpoolFile(String string) {
        this.nameOfSpoolFile = string;
    }

    private String getTypeOfSpoolRequest() {
        return this.typeOfSpoolRequest;
    }

    private void setTypeOfSpoolRequest(String string) {
        this.typeOfSpoolRequest = string;
    }

    private int getArchivingMode() {
        return this.archivingMode;
    }

    private void setArchivingMode(int n) {
        this.archivingMode = n;
    }

    public boolean isArchiving() {
        return this.archivingMode == 2 || this.archivingMode == 3;
    }

    private int getSpoolRequestPriority() {
        return this.spoolRequestPriority;
    }

    private void setSpoolRequestPriority(int n) {
        this.spoolRequestPriority = n;
    }

    private boolean isPrintHostCoverPage() {
        return this.printHostCoverPage;
    }

    private void setPrintHostCoverPage(boolean bl) {
        this.printHostCoverPage = bl;
    }

    private String getSapObject() {
        return this.sapObject;
    }

    private void setSapObject(String string) {
        this.sapObject = string;
    }

    private String getArObject() {
        return this.arObject;
    }

    private void setArObject(String string) {
        this.arObject = string;
    }

    private String getArcText() {
        return this.arcText;
    }

    private void setArcText(String string) {
        this.arcText = string;
    }

    private String getInfo() {
        return this.info;
    }

    private void setInfo(String string) {
        this.info = string;
    }

    public boolean getBooleanField(PrintParameterField printParameterField) {
        switch (printParameterField) {
            case PRIMM: {
                return this.isPrintImmediately();
            }
            case PRREL: {
                return this.isDeleteAfterPrinting();
            }
            case PRNEW: {
                return this.isNewSpoolRequest();
            }
            case PRUNX: {
                return this.isPrintHostCoverPage();
            }
            case PRBIG: {
                return this.isPrintSelectionCoverPage();
            }
        }
        throw new InvalidParameterException("The field " + printParameterField + " is not one of the known Boolean fields for the parameter " + PARAMETER_NAME + ".");
    }

    public String getSpoolRequestPriorityAsString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "1 - Very High";
                break;
            }
            case 2: {
                string = "2 - High";
                break;
            }
            case 3: {
                string = "3 - High";
                break;
            }
            case 4: {
                string = "4 - Medium";
                break;
            }
            case 5: {
                string = "5 - Medium";
                break;
            }
            case 6: {
                string = "6 - Medium";
                break;
            }
            case 7: {
                string = "7 - Low";
                break;
            }
            case 8: {
                string = "8 - Low";
                break;
            }
            case 9: {
                string = "9 - Very Low";
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid value for Spool Request Priority: " + n);
            }
        }
        return string;
    }

    public String getArchivingModeAsString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "Print";
                break;
            }
            case 2: {
                string = "Archive";
                break;
            }
            case 3: {
                string = "Print and Archive";
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid value for the archive mode: " + n);
            }
        }
        return string;
    }

    public static enum SAP_PRSAP_Setting implements PersistableEnum<String>
    {
        StandardCoverPage("X"),
        OutputDeviceDependent("D"),
        NoCoverPage("");

        private String persistenceCode;
        private static PersistanceCodeToEnumMap<String, SAP_PRSAP_Setting> map;

        private SAP_PRSAP_Setting(String string2) {
            this.persistenceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistenceCode;
        }

        public static SAP_PRSAP_Setting persistanceCodeToEnum(String string) {
            SAP_PRSAP_Setting sAP_PRSAP_Setting = map.get(string);
            if (sAP_PRSAP_Setting == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return sAP_PRSAP_Setting;
        }

        public static String getName(String string) {
            SAP_PRSAP_Setting sAP_PRSAP_Setting = string.equalsIgnoreCase(SAPAllPrintParameters.SAP_EMPTY_CHARACTER) ? NoCoverPage : SAP_PRSAP_Setting.persistanceCodeToEnum(string);
            String string2 = "";
            switch (sAP_PRSAP_Setting) {
                case StandardCoverPage: {
                    string2 = "Standard Cover Page";
                    break;
                }
                case OutputDeviceDependent: {
                    string2 = "Depends on output device";
                    break;
                }
                case NoCoverPage: {
                    string2 = "No Cover Page";
                    break;
                }
                default: {
                    throw new InvalidParameterException("Undefined Cover Page: " + sAP_PRSAP_Setting);
                }
            }
            return string2;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])SAP_PRSAP_Setting.values());
        }
    }

    public static enum PrintParameterField implements SAPField
    {
        PDEST(SAPField.ParameterType.STRING, 0, 4, "", "Output Device", true),
        PRCOP(SAPField.ParameterType.INT, 1, 255, 1, "Number of Copies", true),
        PLIST(SAPField.ParameterType.STRING, 0, 12, "", "Spool Request Name", true),
        PRTXT(SAPField.ParameterType.STRING, 0, 68, "", "Spool Request Title", true),
        PRBER(SAPField.ParameterType.STRING, 0, 12, "", "Authorization", true),
        PRBIG(SAPField.ParameterType.BOOLEAN, 0, 0, false, "Print Selection Cover Page", true),
        PRSAP(SAPField.ParameterType.STRING, 0, 1, "D", "Print SAP Cover Page", true),
        PRREC(SAPField.ParameterType.STRING, 0, 12, "", "Cover Page Recipient", true),
        PRABT(SAPField.ParameterType.STRING, 0, 12, "", "Cover Page Department", true),
        PRUNX(SAPField.ParameterType.BOOLEAN, 0, 0, false, "Print Host Cover Page", true),
        PRIMM(SAPField.ParameterType.BOOLEAN, 0, 0, false, "Print Immediately", true),
        PRREL(SAPField.ParameterType.BOOLEAN, 0, 0, false, "Delete after Printing", true),
        PRNEW(SAPField.ParameterType.BOOLEAN, 0, 0, false, "New Spool Request", true),
        PEXPI(SAPField.ParameterType.INT, 1, 9, 8, "Spool Retention Period", true),
        ARMOD(SAPField.ParameterType.STRING, 1, 3, "1", "Archiving Mode", true),
        SAP_OBJECT(SAPField.ParameterType.STRING, 0, 10, "", "Archive Object Type", true),
        AR_OBJECT(SAPField.ParameterType.STRING, 0, 10, "", "Archive Document Type", true),
        INFO(SAPField.ParameterType.STRING, 0, 3, "", "Archive Information", true),
        ARCTEXT(SAPField.ParameterType.STRING, 0, 40, "", "Archive Text", true),
        PRDSN(SAPField.ParameterType.STRING, 0, 6, "", "Name of Spool File", true),
        PRIOT(SAPField.ParameterType.INT, 1, 9, 5, "Spool Request Priority", true),
        LINCT(SAPField.ParameterType.INT, 0, 0, 0, "Number of List Lines", false),
        LINSZ(SAPField.ParameterType.INT, 0, 0, 0, "Characters per List Line", false),
        PAART(SAPField.ParameterType.STRING, 0, 16, "", "Print Format", false),
        PTYPE(SAPField.ParameterType.STRING, 0, 12, "", "Type of Spool Request", false);

        private SAPField.ParameterType parameterType;
        private int maxValue;
        private int minValue;
        private Object defaultValue;
        private String description;
        private boolean showInReport;

        private PrintParameterField(SAPField.ParameterType parameterType, int n2, int n3, Object object, String string2, boolean bl) {
            this.parameterType = parameterType;
            this.minValue = n2;
            this.maxValue = n3;
            this.defaultValue = object;
            this.description = string2;
            this.showInReport = bl;
        }

        @Override
        public SAPField.ParameterType getParameterType() {
            return this.parameterType;
        }

        @Override
        public int getMinValue() {
            return this.minValue;
        }

        @Override
        public int getMaxValue() {
            return this.maxValue;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public boolean getShowInReport() {
            return this.showInReport;
        }
    }
}

