/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;

public class RBECONFIGData
extends EnterpriseVersionedObject {
    public static final String DFT_ENTSERVER_CFG_FILE = "agentServer.xml";
    private static final long serialVersionUID = -3259872496709289L;
    public static final String OPTION_PATH = "-p";
    public static final String OPTION_LISTEN_PORT = "-lp";
    public static final String OPTION_NOTIFY_PORT = "-np";
    public static final String OPTION_HOST_ADDRESS = "-ha";
    public static final String OPTION_HOST_PORT = "-hp";
    public static final int SAME_PORT = -1;
    public static final String SAME_ADDRESS = "*SAME";
    private String path = "";
    private int listenPort = -1;
    private int notifyPort = -1;
    private String hostAddress = "*SAME";
    private int hostPort = -1;

    public RBECONFIGData() {
    }

    public RBECONFIGData(String string) {
        this();
        if (string.indexOf("-p ") > -1) {
            throw new IllegalArgumentException("The path parameter (-p) cannot be parsed in the parm string.");
        }
        String[] stringArray = string.split(" ");
        this.parseParameters(stringArray);
    }

    public RBECONFIGData(String[] stringArray) {
        this();
        this.parseParameters(stringArray);
    }

    public void parseParameters(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("The RBECONFIG parameter list cannot be null.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.validateParm(stringArray, i);
            String string = stringArray[i].trim();
            if (i == 0 && string.equalsIgnoreCase("rbeconfig")) continue;
            if (string.equalsIgnoreCase(OPTION_PATH)) {
                this.path = this.getOptionValue(stringArray, i);
                ++i;
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_LISTEN_PORT)) {
                this.listenPort = this.convertPortString(this.getOptionValue(stringArray, i));
                ++i;
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_NOTIFY_PORT)) {
                this.notifyPort = this.convertPortString(this.getOptionValue(stringArray, i));
                ++i;
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_HOST_ADDRESS)) {
                this.hostAddress = this.getOptionValue(stringArray, i);
                ++i;
                continue;
            }
            if (string.equalsIgnoreCase(OPTION_HOST_PORT)) {
                this.hostPort = this.convertPortString(this.getOptionValue(stringArray, i));
                ++i;
                continue;
            }
            throw new IllegalArgumentException("Unknown option: " + string);
        }
    }

    private boolean validateParm(String[] stringArray, int n) {
        if (stringArray[n] == null) {
            throw new NullPointerException("The parameter at position " + (n + 1) + " is null.");
        }
        return true;
    }

    private String getOptionValue(String[] stringArray, int n) {
        int n2 = n + 1;
        int n3 = n + 2;
        if (stringArray.length < n3) {
            throw new IllegalArgumentException("A value is required for the '" + stringArray[n] + "' parameter");
        }
        this.validateParm(stringArray, n2);
        return stringArray[n2];
    }

    private int convertPortString(String string) {
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string + " is not a valid port number.");
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int n) {
        this.listenPort = n;
    }

    public int getNotifyPort() {
        return this.notifyPort;
    }

    public void setNotifyPort(int n) {
        this.notifyPort = n;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String string) {
        this.hostAddress = string;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(int n) {
        this.hostPort = n;
    }
}

