/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.busobj.CollectedExceptions;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobHistoryComparator;
import com.helpsystems.enterprise.core.busobj.JobQueueProxy;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.NotOnQueueException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class JobQueue
extends JobQueueProxy {
    protected static final int DEFAULT_INITIAL_QUEUE_CAPACITY = 11;
    protected PriorityBlockingQueue<JobHistory> actualJobQueue;
    protected int initialQueueCapacity = 11;
    private AtomicInteger priorityLimitActiveJobs = new AtomicInteger(0);
    private boolean beingRegulated = false;

    public JobQueue(String string) {
        this(string, 11);
    }

    public JobQueue(String string, int n) {
        this.setName(string);
        this.initialQueueCapacity = n;
        this.init();
    }

    public JobQueue() {
        this.init();
    }

    private void init() {
        this.actualJobQueue = new PriorityBlockingQueue<JobHistory>(this.initialQueueCapacity, new JobHistoryComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(JobHistory jobHistory) throws IllegalStateException {
        PriorityBlockingQueue<JobHistory> priorityBlockingQueue = this.actualJobQueue;
        synchronized (priorityBlockingQueue) {
            if (this.actualJobQueue.contains((Object)jobHistory)) {
                throw new IllegalStateException("Job History " + jobHistory.getId() + " is already on the queue.");
            }
            this.actualJobQueue.add(jobHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatedQueueWithJobs(JobHistory jobHistory) {
        PriorityBlockingQueue<JobHistory> priorityBlockingQueue = this.actualJobQueue;
        synchronized (priorityBlockingQueue) {
            if (this.actualJobQueue.remove((Object)jobHistory)) {
                this.actualJobQueue.add(jobHistory);
            }
        }
    }

    public JobHistory dequeue() throws InterruptedException {
        JobHistory jobHistory = this.actualJobQueue.take();
        return jobHistory;
    }

    public JobHistory poll() {
        return this.actualJobQueue.poll();
    }

    @Override
    public String toString() {
        String string = "The raw JobQueue(" + this.actualJobQueue.hashCode() + ") (size = " + this.actualJobQueue.size() + "):";
        for (JobHistory jobHistory : this.actualJobQueue) {
            string = string + "\n" + jobHistory.getId() + " priority:" + jobHistory.getJobPriority() + " server init time: " + jobHistory.getServerInitiatedTime() + " server submit time: " + jobHistory.getServerSubmittedTime();
        }
        return string;
    }

    public boolean isEmpty() {
        return this.actualJobQueue.isEmpty();
    }

    public int size() {
        return this.actualJobQueue.size();
    }

    public ArrayList<JobHistory> getJobQueueEntries() {
        return new ArrayList<JobHistory>(this.actualJobQueue);
    }

    public String getNameAndID() {
        return this.getName() + "(" + this.getOID() + ")";
    }

    public void removeJob(JobHistory jobHistory) throws NotOnQueueException, ActionFailedException {
        this.removeJob(jobHistory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(JobHistory jobHistory, JobStatusCode jobStatusCode) throws NotOnQueueException, ActionFailedException {
        Object object = this.actualJobQueue;
        synchronized (object) {
            this.nullAndNotOnQueueCheck(jobHistory);
            if (!this.actualJobQueue.remove((Object)jobHistory)) {
                throw new ActionFailedException("Failed to remove job " + (Object)((Object)jobHistory) + " from the queue.");
            }
        }
        jobHistory.setQueueEndedTime(System.currentTimeMillis());
        object = jobStatusCode;
        if (jobStatusCode == null) {
            object = JobStatusCode.CANCELED;
        }
        if (!this.isJobStatusCodeValid((JobStatusCode)object)) {
            throw new ActionFailedException("Could not update Job History completion record.  Invalid Job Status code: " + object + ".");
        }
    }

    private boolean isJobStatusCodeValid(JobStatusCode jobStatusCode) {
        return JobStatusCode.ENDABLE_JOB_STATES.contains(jobStatusCode);
    }

    private void nullAndNotOnQueueCheck(JobHistory jobHistory) throws NotOnQueueException {
        if (jobHistory == null) {
            throw new NullPointerException("Job passed is null.");
        }
        if (!this.actualJobQueue.contains((Object)jobHistory)) {
            throw new NotOnQueueException("Job with JobHistoryID " + jobHistory.getId() + " is not on the queue " + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JobHistory> removeAllJobs() {
        ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>();
        PriorityBlockingQueue<JobHistory> priorityBlockingQueue = this.actualJobQueue;
        synchronized (priorityBlockingQueue) {
            this.actualJobQueue.drainTo(arrayList);
        }
        return arrayList;
    }

    public void removeJobs(ArrayList<JobHistory> arrayList) throws CollectedExceptions {
        CollectedExceptions collectedExceptions = new CollectedExceptions();
        for (JobHistory jobHistory : arrayList) {
            try {
                this.removeJob(jobHistory);
            }
            catch (Exception exception) {
                collectedExceptions.add(exception);
            }
        }
        if (!collectedExceptions.isEmpty()) {
            throw collectedExceptions;
        }
    }

    public boolean contains(JobHistory jobHistory) {
        return this.actualJobQueue.contains((Object)jobHistory);
    }

    public synchronized boolean isAtMaxActiveJobs() {
        return this.isLimitActiveJobs() && this.getActiveJobsCount() >= this.getMaxActiveJobs();
    }

    public synchronized int getPriorityLimitActiveJobs() {
        return this.priorityLimitActiveJobs.get();
    }

    public synchronized boolean isAtPriorityLimitMaxActiveJobs() {
        return this.priorityLimitActiveJobs.get() >= this.getLimiterMaxActive();
    }

    public synchronized void incrementPriorityLimitActiveJobs() {
        this.priorityLimitActiveJobs.incrementAndGet();
    }

    public synchronized void decrementPriorityLimitActiveJobs() {
        int n = this.priorityLimitActiveJobs.decrementAndGet();
        if (n < 0) {
            this.priorityLimitActiveJobs.set(0);
        }
    }

    public void changeJobPriority(JobHistory jobHistory) throws NotOnQueueException {
        PriorityBlockingQueue<JobHistory> priorityBlockingQueue = this.actualJobQueue;
        synchronized (priorityBlockingQueue) {
            this.nullAndNotOnQueueCheck(jobHistory);
            if (this.actualJobQueue.contains((Object)jobHistory) && this.actualJobQueue.remove((Object)jobHistory)) {
                this.actualJobQueue.add(jobHistory);
                return;
            }
            throw new NotOnQueueException("Job " + jobHistory.getJobName() + "(" + jobHistory.getId() + ") is not on the queue " + this.getNameAndID());
        }
    }

    public abstract int getActiveJobsCount();

    public abstract Long[] getAllActiveJobHistoryIDs();

    public abstract boolean setAgentAvailable(long var1);

    public abstract void setAgentUnavailable(long var1);

    public abstract boolean isAgentLocked(long var1);

    public abstract void setAgentLocked(long var1);

    public abstract boolean setAgentUnlocked(long var1);

    public abstract boolean isAgentAvailable(long var1);

    public abstract boolean incrementActiveJobs(JobHistory var1);

    public abstract boolean decrementActiveJobs(JobHistory var1);

    public boolean isBeingRegulated() {
        return this.beingRegulated;
    }

    public void setRegulated(boolean bl) {
        this.beingRegulated = bl;
    }
}

