/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import java.util.Date;

public class EnterpriseLicenseInfo
extends CommonVersionedObject
implements Cloneable {
    private static final long serialVersionUID = -8009325433879506568L;
    private EnterpriseProductLicense trialLicense;
    private EnterpriseProductLicense primaryLicense;
    private EnterpriseProductLicense[] allPrimaryLicenses;

    public EnterpriseLicenseInfo() {
    }

    public EnterpriseLicenseInfo(EnterpriseProductLicense enterpriseProductLicense, EnterpriseProductLicense enterpriseProductLicense2) {
        this.trialLicense = enterpriseProductLicense;
        this.primaryLicense = enterpriseProductLicense2;
    }

    public final EnterpriseProductLicense getTrialLicense() {
        return this.trialLicense;
    }

    public final void setTrialLicense(EnterpriseProductLicense enterpriseProductLicense) {
        this.trialLicense = enterpriseProductLicense;
    }

    public final EnterpriseProductLicense getPrimaryLicense() {
        return this.primaryLicense;
    }

    public final void setPrimaryLicense(EnterpriseProductLicense enterpriseProductLicense) {
        this.primaryLicense = enterpriseProductLicense;
    }

    public EnterpriseProductLicense[] getAllPrimaryLicenses() {
        return this.allPrimaryLicenses;
    }

    public void setAllPrimaryLicenses(EnterpriseProductLicense[] enterpriseProductLicenseArray) {
        this.allPrimaryLicenses = enterpriseProductLicenseArray;
    }

    public boolean isLicensedForFeature(EnterpriseProductLicense.FEATURE fEATURE, String string) {
        if (this.isValidTrialLicense()) {
            return true;
        }
        if (this.primaryLicense == null) {
            return false;
        }
        if (!this.primaryLicense.isValidPermanent(string)) {
            return false;
        }
        switch (fEATURE) {
            case SAP: {
                return this.primaryLicense.isSAPEnabled();
            }
            case INFORMATICA: {
                return this.primaryLicense.isInformaticaEnabled();
            }
            case ORACLE: {
                return this.primaryLicense.isOracleEnabled();
            }
            case RSI: {
                return this.primaryLicense.isRobotScheduleInterfaceEnabled();
            }
            case SEQUEL_BUNDLED: {
                return this.primaryLicense.isSequelBundledLicense();
            }
            case UNIVERSAL_CONNECTOR: {
                return this.primaryLicense.isUniversalConnectorEnabled();
            }
        }
        return false;
    }

    public boolean isValidTrialLicense() {
        Date date;
        Date date2 = new Date(System.currentTimeMillis());
        return this.getTrialLicense() != null && (date = this.getTrialLicense().getExpirationDate()) != null && date.after(date2);
    }

    public Object clone() {
        EnterpriseLicenseInfo enterpriseLicenseInfo = new EnterpriseLicenseInfo();
        return this.clone(enterpriseLicenseInfo);
    }

    protected Object clone(EnterpriseLicenseInfo enterpriseLicenseInfo) {
        enterpriseLicenseInfo.trialLicense = this.trialLicense;
        enterpriseLicenseInfo.primaryLicense = this.primaryLicense;
        return enterpriseLicenseInfo;
    }
}

