/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.enterprise.core.busobj.AgentCopyFileDefinition;
import com.helpsystems.enterprise.core.busobj.AgentServerPath;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import java.util.ArrayList;
import java.util.List;

public class AgentOutputOptions
extends AbstractBusinessObject
implements XMLSerializable {
    private static final long serialVersionUID = -1L;
    public static final int MAX_LENGTH_HOST_DIRECTORY = 1024;
    private String jobID = "";
    private boolean copySysLogsToHost = false;
    private String hostDirectory = "";
    private boolean copyAgentFilesToHost = false;
    private ArrayList<AgentCopyFileDefinition> activeCopyDefs = new ArrayList();
    private ArrayList<AgentCopyFileDefinition> removedCopyDefs = new ArrayList();
    private final String fldnameJobIdentifier = "Job ID";
    private final String fldnameDirectory = "directory";
    private final String fldnameCopyDefinition = "copy_definitions";

    public AgentOutputOptions() {
        this.addDoNotInvoke("getRemovedCopyDefs");
        this.addDoNotInvoke("getCopyDefList");
    }

    public AgentOutputOptions(String string) {
        this.addDoNotInvoke("getRemovedCopyDefs");
        this.addDoNotInvoke("getCopyDefList");
        this.setJobID(string);
    }

    public String getJobID() {
        return this.jobID;
    }

    public void setJobID(String string) {
        ValidationHelper.checkForNull((String)"Job ID", (Object)string);
        this.jobID = string.trim();
    }

    public boolean getCopySysLogsToHost() {
        return this.copySysLogsToHost;
    }

    public void setCopySysLogsToHost(boolean bl) {
        this.copySysLogsToHost = bl;
    }

    public String getHostDirectory() {
        return this.hostDirectory;
    }

    public void setHostDirectory(String string) {
        ValidationHelper.checkForNull((String)"directory", (Object)string);
        String string2 = Convert.trimL((String)string);
        ValidationHelper.validateLength((String)"directory", (int)1024, (String)string2);
        this.hostDirectory = string2 = AgentServerPath.validateDirectoryPath(string2);
    }

    public boolean getCopyAgentFilesToHost() {
        return this.copyAgentFilesToHost;
    }

    public void setCopyAgentFilesToHost(boolean bl) {
        this.copyAgentFilesToHost = bl;
    }

    public AgentCopyFileDefinition[] getCopyDefs() {
        AgentCopyFileDefinition[] agentCopyFileDefinitionArray = new AgentCopyFileDefinition[this.activeCopyDefs.size()];
        agentCopyFileDefinitionArray = this.activeCopyDefs.toArray(agentCopyFileDefinitionArray);
        return agentCopyFileDefinitionArray;
    }

    public List<AgentCopyFileDefinition> getCopyDefList() {
        return this.activeCopyDefs;
    }

    public AgentCopyFileDefinition[] getRemovedCopyDefs() {
        AgentCopyFileDefinition[] agentCopyFileDefinitionArray = new AgentCopyFileDefinition[this.removedCopyDefs.size()];
        agentCopyFileDefinitionArray = this.removedCopyDefs.toArray(agentCopyFileDefinitionArray);
        return agentCopyFileDefinitionArray;
    }

    public void setCopyDefList(AgentCopyFileDefinition[] agentCopyFileDefinitionArray) {
        ValidationHelper.checkForNull((String)"copy_definitions", (Object)agentCopyFileDefinitionArray);
        this.activeCopyDefs.clear();
        for (int i = 0; i < agentCopyFileDefinitionArray.length; ++i) {
            this.addCopyDef(agentCopyFileDefinitionArray[i]);
        }
    }

    public void addCopyDef(AgentCopyFileDefinition agentCopyFileDefinition) {
        ValidationHelper.checkForNull((String)"copy_definitions", (Object)((Object)agentCopyFileDefinition));
        this.activeCopyDefs.add(agentCopyFileDefinition);
    }

    public void clearRemovedCopyDefs() {
        this.removedCopyDefs.clear();
    }

    public boolean hasCopyDefs() {
        return !this.activeCopyDefs.isEmpty();
    }

    public boolean isEmpty() {
        return this.activeCopyDefs.isEmpty() && this.removedCopyDefs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeCopyDef(AgentCopyFileDefinition agentCopyFileDefinition) {
        int n = -1;
        ArrayList<AgentCopyFileDefinition> arrayList = this.activeCopyDefs;
        synchronized (arrayList) {
            if (this.activeCopyDefs.contains((Object)agentCopyFileDefinition)) {
                n = this.activeCopyDefs.indexOf((Object)agentCopyFileDefinition);
                this.activeCopyDefs.remove((Object)agentCopyFileDefinition);
                if (agentCopyFileDefinition.isPersistent()) {
                    ArrayList<AgentCopyFileDefinition> arrayList2 = this.removedCopyDefs;
                    synchronized (arrayList2) {
                        this.removedCopyDefs.add(agentCopyFileDefinition);
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCopyDef(int n) {
        AgentCopyFileDefinition agentCopyFileDefinition;
        ArrayList<AgentCopyFileDefinition> arrayList;
        try {
            arrayList = this.activeCopyDefs;
            synchronized (arrayList) {
                agentCopyFileDefinition = this.activeCopyDefs.remove(n);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string = "Program error: Agent Copy File Definition not found on remove.";
            throw new RuntimeException(string);
        }
        if (agentCopyFileDefinition.isPersistent()) {
            arrayList = this.removedCopyDefs;
            synchronized (arrayList) {
                this.removedCopyDefs.add(agentCopyFileDefinition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCopyDef(int n, AgentCopyFileDefinition agentCopyFileDefinition) {
        try {
            ArrayList<AgentCopyFileDefinition> arrayList = this.activeCopyDefs;
            synchronized (arrayList) {
                this.activeCopyDefs.set(n, agentCopyFileDefinition);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string = "Program error: Agent Copy File Definition not found for replacing.";
            throw new RuntimeException(string);
        }
    }

    public void validate() {
        if (this.copySysLogsToHost) {
            ValidationHelper.checkForBlankIgnoreNull((String)"directory", (String)this.hostDirectory);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof AgentOutputOptions)) {
            return false;
        }
        AgentOutputOptions agentOutputOptions = (AgentOutputOptions)((Object)object);
        return super.equals(object) && Equal.isEqual((long)this.getProductIIDInt(), (long)agentOutputOptions.getProductIIDInt());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSkybotJobNumber(String string) {
        if (string == null) {
            return;
        }
        this.setJobID(string);
        ArrayList<AgentCopyFileDefinition> arrayList = this.activeCopyDefs;
        synchronized (arrayList) {
            for (AgentCopyFileDefinition agentCopyFileDefinition : this.activeCopyDefs) {
                agentCopyFileDefinition.setJobID(string);
            }
        }
    }

    public void resetForCopy() {
        AgentCopyFileDefinition[] agentCopyFileDefinitionArray = this.getCopyDefs();
        for (int i = 0; i < agentCopyFileDefinitionArray.length; ++i) {
            agentCopyFileDefinitionArray[i].resetForCopy();
        }
        this.jobID = "";
        this.setPersistent(false);
    }
}

