/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.enterprise.core.busobj.AgentJobQueue;
import com.helpsystems.enterprise.core.busobj.CollectedExceptions;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.MissedAgentJob;
import com.helpsystems.enterprise.core.busobj.NotOnQueueException;
import com.helpsystems.enterprise.core.busobj.PersistedJobQueueEntry;
import com.helpsystems.enterprise.core.dm.JobQueuePersisterAM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import junit.framework.TestCase;

public class AgentJobQueueTest
extends TestCase {
    private JobHistory jh1;
    private JobHistory jh2;
    private JobHistory jh3;
    private AgentJobQueue ajq;

    protected void setUp() throws Exception {
        super.setUp();
        this.jh1 = new JobHistory();
        this.jh1.setId(12345L);
        this.jh2 = new JobHistory();
        this.jh2.setId(12648L);
        this.jh3 = new JobHistory();
        this.jh3.setId(12542L);
        this.ajq = new AgentJobQueue();
    }

    protected void tearDown() throws Exception {
        this.ajq = null;
        this.jh1 = null;
        this.jh2 = null;
        this.jh3 = null;
        super.tearDown();
    }

    public void testEnqueue() {
        AgentJobQueueTest.assertTrue((boolean)this.ajq.isEmpty());
        this.ajq.enqueue(this.jh1);
        AgentJobQueueTest.assertFalse((boolean)this.ajq.isEmpty());
        ArrayList<JobHistory> arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)1, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)arrayList.get(0)));
    }

    public void testEnqueueDoesNotAllowSameJobTwice() {
        AgentJobQueueTest.assertTrue((boolean)this.ajq.isEmpty());
        this.ajq.enqueue(this.jh1);
        AgentJobQueueTest.assertFalse((boolean)this.ajq.isEmpty());
        try {
            this.ajq.enqueue(this.jh1);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testDequeue() throws Exception {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        JobHistory jobHistory = this.ajq.dequeue();
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)jobHistory));
        jobHistory = this.ajq.dequeue();
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh2), (Object)((Object)jobHistory));
    }

    public void testToString() {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        String string = this.ajq.toString();
        AgentJobQueueTest.assertTrue((boolean)string.startsWith("The raw AgentJobQueue("));
        AgentJobQueueTest.assertTrue((boolean)string.contains(") (size = "));
    }

    public void testIsEmpty() throws Exception {
        AgentJobQueueTest.assertTrue((boolean)this.ajq.isEmpty());
        this.ajq.enqueue(this.jh1);
        AgentJobQueueTest.assertFalse((boolean)this.ajq.isEmpty());
        this.ajq.dequeue();
        AgentJobQueueTest.assertTrue((boolean)this.ajq.isEmpty());
    }

    public void testSize() throws Exception {
        AgentJobQueueTest.assertEquals((int)0, (int)this.ajq.size());
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        AgentJobQueueTest.assertEquals((int)3, (int)this.ajq.size());
        this.ajq.dequeue();
        AgentJobQueueTest.assertEquals((int)2, (int)this.ajq.size());
        this.ajq.removeJob(this.jh3);
        AgentJobQueueTest.assertEquals((int)1, (int)this.ajq.size());
    }

    public void testGetJobQueueEntries() {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        ArrayList<JobHistory> arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)3, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)arrayList.get(0)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh2), (Object)((Object)arrayList.get(1)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh3), (Object)((Object)arrayList.get(2)));
    }

    public void testRemoveJob() throws Exception {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        this.ajq.removeJob(this.jh2);
        ArrayList<JobHistory> arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)2, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)arrayList.get(0)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh3), (Object)((Object)arrayList.get(1)));
    }

    public void testRemoveJobNull() throws Exception {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        try {
            this.ajq.removeJob(null);
            AgentJobQueueTest.fail((String)"removedJob() should throw NullPointerException for null JobHistory");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList<JobHistory> arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)3, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)arrayList.get(0)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh2), (Object)((Object)arrayList.get(1)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh3), (Object)((Object)arrayList.get(2)));
    }

    public void testRemoveJobWithStatusCode() throws Exception {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        this.ajq.removeJob(this.jh2);
        ArrayList<JobHistory> arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)2, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)arrayList.get(0)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh3), (Object)((Object)arrayList.get(1)));
        try {
            this.ajq.removeJob(this.jh2);
            AgentJobQueueTest.fail((String)"removeJob() allowed job that was not on queue");
        }
        catch (NotOnQueueException notOnQueueException) {
            // empty catch block
        }
    }

    public void testRemoveJobChecksStatusCode() throws Exception {
        this.jh1.setStatusCode(JobStatusCode.SUBMITTED);
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        try {
            this.ajq.removeJob(this.jh2, JobStatusCode.INITIATED);
            AgentJobQueueTest.fail((String)"removedJob() for wrong status code should throw ActionFailedException");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
        ArrayList<JobHistory> arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)2, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)arrayList.get(0)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh3), (Object)((Object)arrayList.get(1)));
        try {
            this.ajq.removeJob(this.jh2);
            AgentJobQueueTest.fail((String)"removeJob() allowed job that was not on queue");
        }
        catch (NotOnQueueException notOnQueueException) {
            // empty catch block
        }
    }

    public void testRemoveAllJobs() {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        Collection<JobHistory> collection = this.ajq.removeAllJobs();
        AgentJobQueueTest.assertEquals((int)3, (int)collection.size());
        AgentJobQueueTest.assertTrue((boolean)this.ajq.isEmpty());
    }

    public void testRemoveJobs() throws Exception {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        this.ajq.enqueue(this.jh3);
        ArrayList<JobHistory> arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)3, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh1), (Object)((Object)arrayList.get(0)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh2), (Object)((Object)arrayList.get(1)));
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh3), (Object)((Object)arrayList.get(2)));
        ArrayList<JobHistory> arrayList2 = new ArrayList<JobHistory>();
        arrayList2.add(this.jh1);
        arrayList2.add(this.jh3);
        this.ajq.removeJobs(arrayList2);
        arrayList = this.ajq.getJobQueueEntries();
        AgentJobQueueTest.assertEquals((int)1, (int)arrayList.size());
        AgentJobQueueTest.assertEquals((Object)((Object)this.jh2), (Object)((Object)arrayList.get(0)));
    }

    public void testRemoveJobsFail() throws Exception {
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh3);
        ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>();
        arrayList.add(this.jh1);
        arrayList.add(this.jh2);
        try {
            this.ajq.removeJobs(arrayList);
            AgentJobQueueTest.fail((String)"removeJobs() should have thrown CollectedExceptions");
        }
        catch (CollectedExceptions collectedExceptions) {
            // empty catch block
        }
    }

    public void testContains() {
        AgentJobQueueTest.assertFalse((boolean)this.ajq.contains(this.jh1));
        this.ajq.enqueue(this.jh1);
        this.ajq.enqueue(this.jh2);
        AgentJobQueueTest.assertTrue((boolean)this.ajq.contains(this.jh1));
        AgentJobQueueTest.assertTrue((boolean)this.ajq.contains(this.jh2));
        AgentJobQueueTest.assertFalse((boolean)this.ajq.contains(this.jh3));
    }

    class MyPersisterAM
    implements JobQueuePersisterAM {
        MyPersisterAM() {
        }

        @Override
        public int deletePersistedJobQueueEntries(ArrayList<Long> arrayList) {
            return 0;
        }

        @Override
        public void processPersistentEntry(PersistedJobQueueEntry persistedJobQueueEntry) {
        }

        @Override
        public void processPersistentEntryGroup(ArrayList<PersistedJobQueueEntry> arrayList) {
        }

        @Override
        public Set<MissedAgentJob> start() {
            return null;
        }

        @Override
        public boolean isPersisterStopped() {
            return false;
        }

        @Override
        public void stopJobQueuePersister() {
        }

        public RelMod getInterfaceVersion() {
            return null;
        }

        public RelMod getManagerVersion() {
            return null;
        }

        public String getName() {
            return null;
        }

        public void managerRemoved() {
        }

        @Override
        public void processNewJobHistory(JobHistory jobHistory) {
        }

        @Override
        public void removePersistedEntry(long l, long l2) {
        }
    }
}

