/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitorProxy;
import junit.framework.TestCase;

public class AgentEventMonitorTest
extends TestCase {
    AgentEventMonitor aem;
    AgentEventMonitorProxy prox;
    private static final String NAME_MANUAL = "Manual";
    private static final String NAME_FILE_ADDED = "File Added";
    private static final String NAME_FILE_CHANGED = "File Changed";
    private static final String NAME_FILE_THRESHOLD = "File Threshold";
    private static final String NAME_FILE_REMOVED = "File Removed";
    private static final String NAME_DIR_ADDED = "Directory Added";
    private static final String NAME_DIR_CHANGED = "Directory Changed";
    private static final String NAME_DIR_THRESHOLD = "Directory Threshold";
    private static final String NAME_DIR_REMOVED = "Directory Removed";
    private static final String NAME_PROCESS_STARTED = "Process Started";
    private static final String NAME_PROCESS_ENDED = "Process Ended";

    protected void setUp() throws Exception {
        super.setUp();
        this.aem = new AgentEventMonitor();
        this.prox = new AgentEventMonitorProxy();
    }

    protected void tearDown() throws Exception {
        this.aem = null;
        this.prox = null;
        super.tearDown();
    }

    public void testEqualsObject() {
        AgentEventMonitorTest.assertFalse((boolean)this.aem.equals(new Object()));
        AgentEventMonitorTest.assertFalse((boolean)this.prox.equals(new Object()));
        this.aem.setTargetID(12345L);
        this.aem.setName("Event1");
        this.aem.setDescription("A test event");
        this.aem.setProductIIDInt(9494);
        this.aem.setDisabled(true);
        this.aem.setDaysToRetainHistory(123);
        this.aem.setUseDefaultsForHistoryPurge(true);
        this.aem.setCycle(666);
        this.aem.setOID(58493L);
        this.aem.setFromTime(1234);
        this.aem.setToTime(2468);
        AgentEventMonitor agentEventMonitor = new AgentEventMonitor();
        agentEventMonitor.setTargetID(12345L);
        agentEventMonitor.setName("Event1");
        agentEventMonitor.setDescription("A test event");
        agentEventMonitor.setProductIIDInt(9494);
        agentEventMonitor.setDisabled(true);
        agentEventMonitor.setDaysToRetainHistory(123);
        agentEventMonitor.setUseDefaultsForHistoryPurge(true);
        agentEventMonitor.setCycle(666);
        agentEventMonitor.setOID(58493L);
        agentEventMonitor.setFromTime(1234);
        agentEventMonitor.setToTime(2468);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.equals((Object)this.aem));
        AgentEventMonitorTest.assertTrue((boolean)agentEventMonitor.equals((Object)this.aem));
        AgentEventMonitorTest.assertTrue((boolean)this.aem.equals((Object)agentEventMonitor));
        agentEventMonitor.setTargetID(54321L);
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setTargetID(12345L);
        agentEventMonitor.setName("Event2");
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setName("Event1");
        agentEventMonitor.setDescription("A 2nd test event");
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setDescription("A test event");
        agentEventMonitor.setProductIIDInt(7070);
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setProductIIDInt(9494);
        agentEventMonitor.setDisabled(false);
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setDisabled(true);
        agentEventMonitor.setCycle(46352);
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setCycle(666);
        agentEventMonitor.setFromTime(432);
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setFromTime(1234);
        agentEventMonitor.setToTime(1579);
        AgentEventMonitorTest.assertFalse((boolean)agentEventMonitor.equals((Object)this.aem));
        agentEventMonitor.setToTime(2468);
        AgentEventMonitorTest.assertTrue((boolean)agentEventMonitor.equals((Object)this.aem));
    }

    public void testSetAgentOID() {
        this.aem.setTargetID(12345L);
        AgentEventMonitorTest.assertEquals((long)12345L, (long)this.aem.getTargetID());
    }

    public void testSetDisabled() {
        this.aem.setDisabled(true);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDisabled());
        AgentEventMonitorTest.assertTrue((boolean)this.aem.getDisabled());
        this.aem.setDisabled(false);
        AgentEventMonitorTest.assertFalse((boolean)this.aem.isDisabled());
        AgentEventMonitorTest.assertFalse((boolean)this.aem.getDisabled());
    }

    public void testSetCycle() {
        this.aem.setCycle(235438);
        AgentEventMonitorTest.assertEquals((int)235438, (int)this.aem.getCycle());
        this.aem.setCycle(-4827);
        AgentEventMonitorTest.assertEquals((int)-4827, (int)this.aem.getCycle());
        this.aem.setCycle(1);
        AgentEventMonitorTest.assertEquals((int)1, (int)this.aem.getCycle());
        this.aem.setCycle(0);
        AgentEventMonitorTest.assertEquals((int)0, (int)this.aem.getCycle());
    }

    public void testSetFromTime() {
        this.aem.setFromTime(583272);
        AgentEventMonitorTest.assertEquals((int)583272, (int)this.aem.getFromTime());
        this.aem.setFromTime(-3272);
        AgentEventMonitorTest.assertEquals((int)-3272, (int)this.aem.getFromTime());
        this.aem.setFromTime(5832);
        AgentEventMonitorTest.assertEquals((int)5832, (int)this.aem.getFromTime());
    }

    public void testSetToTime() {
        this.aem.setToTime(233242);
        AgentEventMonitorTest.assertEquals((int)233242, (int)this.aem.getToTime());
        this.aem.setToTime(-13472);
        AgentEventMonitorTest.assertEquals((int)-13472, (int)this.aem.getToTime());
        this.aem.setToTime(53270);
        AgentEventMonitorTest.assertEquals((int)53270, (int)this.aem.getToTime());
    }

    public void testSetName() {
        this.aem.setName("ABCDEFGH");
        AgentEventMonitorTest.assertEquals((String)"ABCDEFGH", (String)this.aem.getName());
        this.aem.setName("ZZZ");
        AgentEventMonitorTest.assertEquals((String)"ZZZ", (String)this.aem.getName());
    }

    public void testSetNameRejectsNull() {
        try {
            this.aem.setName(null);
            AgentEventMonitorTest.fail((String)"setName(String) allowed null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSetDescription() {
        this.aem.setDescription("Some description");
        AgentEventMonitorTest.assertEquals((String)"Some description", (String)this.aem.getDescription());
        this.aem.setDescription("Changed description");
        AgentEventMonitorTest.assertEquals((String)"Changed description", (String)this.aem.getDescription());
    }

    public void testSetDescriptionRejectsNull() {
        try {
            this.aem.setDescription(null);
            AgentEventMonitorTest.fail((String)"setDescription(String) allowed null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSetPID() {
        this.aem.setProductIIDInt(1234);
        AgentEventMonitorTest.assertEquals((int)1234, (int)this.aem.getProductIIDInt());
        this.aem.setProductIIDInt(-31244);
        AgentEventMonitorTest.assertEquals((int)-31244, (int)this.aem.getProductIIDInt());
        this.aem.setProductIIDInt(1);
        AgentEventMonitorTest.assertEquals((int)1, (int)this.aem.getProductIIDInt());
    }

    public void testSetOID() {
        this.aem.setOID(9595L);
        AgentEventMonitorTest.assertEquals((long)9595L, (long)this.aem.getOID());
    }

    public void testSetType() {
        this.aem.setType(1234);
        AgentEventMonitorTest.assertEquals((int)1234, (int)this.aem.getType());
        this.aem.setType(-848);
        AgentEventMonitorTest.assertEquals((int)-848, (int)this.aem.getType());
        this.aem.setType(1);
        AgentEventMonitorTest.assertEquals((int)1, (int)this.aem.getType());
        this.aem.setType(666);
        AgentEventMonitorTest.assertEquals((int)666, (int)this.aem.getType());
    }

    public void testSetDaysToRetain() {
        this.aem.setDaysToRetainHistory(-1);
        AgentEventMonitorTest.assertEquals((int)15, (int)this.aem.getDaysToRetainHistory());
        this.aem.setDaysToRetainHistory(100001);
        AgentEventMonitorTest.assertEquals((int)99999, (int)this.aem.getDaysToRetainHistory());
    }

    public void testSetUseDefaultsForHistoryPurge() {
        this.aem.setUseDefaultsForHistoryPurge(true);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isUseDefaultsForHistoryPurge());
        AgentEventMonitorTest.assertTrue((boolean)this.aem.getUseDefaultsForHistoryPurge());
        this.aem.setUseDefaultsForHistoryPurge(false);
        AgentEventMonitorTest.assertFalse((boolean)this.aem.isUseDefaultsForHistoryPurge());
        AgentEventMonitorTest.assertFalse((boolean)this.aem.getUseDefaultsForHistoryPurge());
    }

    public void testClone() {
        this.aem.setTargetID(12345L);
        this.aem.setName("Event1");
        this.aem.setDescription("A test event");
        this.aem.setProductIIDInt(9494);
        this.aem.setDisabled(true);
        this.aem.setDaysToRetainHistory(123);
        this.aem.setUseDefaultsForHistoryPurge(true);
        this.aem.setCycle(666);
        this.aem.setOID(58493L);
        this.aem.setFromTime(1234);
        this.aem.setToTime(2468);
        AgentEventMonitor agentEventMonitor = new AgentEventMonitor();
        agentEventMonitor.clone(this.aem);
        AgentEventMonitorTest.assertEquals((Object)((Object)this.aem), (Object)((Object)agentEventMonitor));
        AgentEventMonitorTest.assertFalse((this.aem == agentEventMonitor ? 1 : 0) != 0);
    }

    public void testGetTypeCategory() {
        AgentEventMonitorTest.assertEquals((int)0, (int)AgentEventMonitorProxy.getTypeCategory(0));
        AgentEventMonitorTest.assertEquals((int)2, (int)AgentEventMonitorProxy.getTypeCategory(201));
        AgentEventMonitorTest.assertEquals((int)2, (int)AgentEventMonitorProxy.getTypeCategory(203));
        AgentEventMonitorTest.assertEquals((int)2, (int)AgentEventMonitorProxy.getTypeCategory(202));
        AgentEventMonitorTest.assertEquals((int)2, (int)AgentEventMonitorProxy.getTypeCategory(204));
        AgentEventMonitorTest.assertEquals((int)1, (int)AgentEventMonitorProxy.getTypeCategory(101));
        AgentEventMonitorTest.assertEquals((int)1, (int)AgentEventMonitorProxy.getTypeCategory(103));
        AgentEventMonitorTest.assertEquals((int)1, (int)AgentEventMonitorProxy.getTypeCategory(102));
        AgentEventMonitorTest.assertEquals((int)1, (int)AgentEventMonitorProxy.getTypeCategory(104));
        AgentEventMonitorTest.assertEquals((int)3, (int)AgentEventMonitorProxy.getTypeCategory(302));
        AgentEventMonitorTest.assertEquals((int)3, (int)AgentEventMonitorProxy.getTypeCategory(301));
        AgentEventMonitorTest.assertEquals((int)-1, (int)AgentEventMonitorProxy.getTypeCategory(-999));
    }

    public void testGetTypeDescription() {
        this.prox.setType(0);
        AgentEventMonitorTest.assertEquals((String)NAME_MANUAL, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_MANUAL, (String)AgentEventMonitorProxy.getTypeDescription(0));
        this.prox.setType(101);
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_ADDED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_ADDED, (String)AgentEventMonitorProxy.getTypeDescription(101));
        this.prox.setType(103);
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_CHANGED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_CHANGED, (String)AgentEventMonitorProxy.getTypeDescription(103));
        this.prox.setType(104);
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_THRESHOLD, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_THRESHOLD, (String)AgentEventMonitorProxy.getTypeDescription(104));
        this.prox.setType(102);
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_REMOVED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_FILE_REMOVED, (String)AgentEventMonitorProxy.getTypeDescription(102));
        this.prox.setType(201);
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_ADDED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_ADDED, (String)AgentEventMonitorProxy.getTypeDescription(201));
        this.prox.setType(203);
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_CHANGED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_CHANGED, (String)AgentEventMonitorProxy.getTypeDescription(203));
        this.prox.setType(204);
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_THRESHOLD, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_THRESHOLD, (String)AgentEventMonitorProxy.getTypeDescription(204));
        this.prox.setType(202);
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_REMOVED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_DIR_REMOVED, (String)AgentEventMonitorProxy.getTypeDescription(202));
        this.prox.setType(301);
        AgentEventMonitorTest.assertEquals((String)NAME_PROCESS_STARTED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_PROCESS_STARTED, (String)AgentEventMonitorProxy.getTypeDescription(301));
        this.prox.setType(302);
        AgentEventMonitorTest.assertEquals((String)NAME_PROCESS_ENDED, (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)NAME_PROCESS_ENDED, (String)AgentEventMonitorProxy.getTypeDescription(302));
        this.prox.setType(-999);
        AgentEventMonitorTest.assertEquals((String)("Unsupported type: " + new Integer(-999)), (String)this.prox.getTypeDescription());
        AgentEventMonitorTest.assertEquals((String)("Unsupported type: " + new Integer(-999)), (String)AgentEventMonitorProxy.getTypeDescription(-999));
    }

    public void testValidateAgentTimes() {
        this.aem.setFromTime(0);
        this.aem.setFromTime(700);
        this.aem.setToTime(0);
    }

    public void testIsDifferentThan() {
        this.aem.setTargetID(12345L);
        this.aem.setName("Event1");
        this.aem.setDescription("A test event");
        this.aem.setType(1357);
        this.aem.setProductIIDInt(9494);
        this.aem.setDisabled(true);
        this.aem.setCycle(666);
        this.aem.setOID(58493L);
        this.aem.setFromTime(1234);
        this.aem.setToTime(2468);
        this.aem.setDaysToRetainHistory(123);
        this.aem.setUseDefaultsForHistoryPurge(true);
        this.aem.setSendSNMPTrap(true);
        this.aem.setSendEmail(true);
        this.aem.setNotificationListID(12345L);
        AgentEventMonitor agentEventMonitor = null;
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor = new AgentEventMonitor();
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setOID(58493L);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setName("Event1");
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setDescription("A test event");
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setTargetID(12345L);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setType(1357);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setFromTime(1234);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setToTime(2468);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setCycle(666);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setDaysToRetainHistory(123);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setUseDefaultsForHistoryPurge(true);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setDisabled(true);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setSendSNMPTrap(true);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setSendEmail(true);
        AgentEventMonitorTest.assertTrue((boolean)this.aem.isDifferentThan(agentEventMonitor));
        agentEventMonitor.setNotificationListID(12345L);
        AgentEventMonitorTest.assertFalse((boolean)this.aem.isDifferentThan(agentEventMonitor));
    }
}

