/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.SizeUnit;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class AgentEventFile
extends EnterpriseProxy {
    private static final long serialVersionUID = -1340605644482182327L;
    public static final int FIRST_TIME = 0;
    public static final int EVERY_TIME = 1;
    public static final int WHILE_INCREASING = 2;
    public static final int WHILE_DECREASING = 2;
    public static final int EOF_TEST_NONE = 0;
    public static final int EOF_TEST_TEXT = 1;
    public static final int EOF_TEST_HEX = 2;
    private long oid = 0L;
    private String filePath = null;
    private int increaseSize = 0;
    private SizeUnit increaseSizeUnit = SizeUnit.BYTES;
    private int decreaseSize = 0;
    private SizeUnit decreaseSizeUnit = SizeUnit.BYTES;
    private boolean increasedFlag = false;
    private boolean decreasedFlag = false;
    private boolean changedDate = false;
    private int fireWhenIncreasing = 0;
    private int fireWhenDecreasing = 0;
    private int parentType = 1;
    private int eofTest = 0;
    private String eofTextMarker = "";
    private String eofTextEncoding = "";
    private String eofHexMarker = "";
    private boolean greaterThanFlag = false;
    private boolean lessThanFlag = false;
    private int recheckSeconds = 0;

    public AgentEventFile() {
        this.setParentType(1);
    }

    public AgentEventFile(int n) {
        this.setParentType(n);
    }

    public void setOID(long l) {
        this.oid = l;
    }

    public long getOID() {
        return this.oid;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getIncreaseSize() {
        return this.increaseSize;
    }

    public void setIncreaseSize(int n) {
        this.increaseSize = n;
    }

    public int getDecreaseSize() {
        return this.decreaseSize;
    }

    public void setDecreaseSize(int n) {
        this.decreaseSize = n;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public void setDecreaseSizeUnit(SizeUnit sizeUnit) {
        this.decreaseSizeUnit = sizeUnit;
    }

    public SizeUnit getDecreaseSizeUnit() {
        return this.decreaseSizeUnit;
    }

    public void setIncreaseSizeUnit(SizeUnit sizeUnit) {
        this.increaseSizeUnit = sizeUnit;
    }

    public SizeUnit getIncreaseSizeUnit() {
        return this.increaseSizeUnit;
    }

    public void setIncreasedFlag(boolean bl) {
        this.increasedFlag = bl;
    }

    public boolean getIncreasedFlag() {
        return this.increasedFlag;
    }

    public boolean isIncreasedFlag() {
        return this.getIncreasedFlag();
    }

    public void setDecreasedFlag(boolean bl) {
        this.decreasedFlag = bl;
    }

    public boolean getDecreasedFlag() {
        return this.decreasedFlag;
    }

    public boolean isDecreasedFlag() {
        return this.getDecreasedFlag();
    }

    public void setGreaterThanFlag(boolean bl) {
        this.greaterThanFlag = bl;
    }

    public boolean getGreaterThanFlag() {
        return this.greaterThanFlag;
    }

    public boolean isGreaterThanFlag() {
        return this.getGreaterThanFlag();
    }

    public void setLessThanFlag(boolean bl) {
        this.lessThanFlag = bl;
    }

    public boolean getLessThanFlag() {
        return this.lessThanFlag;
    }

    public boolean isLessThanFlag() {
        return this.getLessThanFlag();
    }

    public void setRecheckSeconds(int n) {
        this.recheckSeconds = n;
    }

    public int getRecheckSeconds() {
        return this.recheckSeconds;
    }

    public void setChangeDateFlag(boolean bl) {
        this.changedDate = bl;
    }

    public boolean getChangeDateFlag() {
        return this.changedDate;
    }

    public boolean isChangeDateFlag() {
        return this.changedDate;
    }

    public int getFireWhenIncreasing() {
        return this.fireWhenIncreasing;
    }

    public void setFireWhenIncreasing(int n) {
        this.fireWhenIncreasing = n;
    }

    public int getFireWhenDecreasing() {
        return this.fireWhenDecreasing;
    }

    public void setFireWhenDecreasing(int n) {
        this.fireWhenDecreasing = n;
    }

    public void setIncreaseSizeUnitInt(int n) {
        this.increaseSizeUnit = SizeUnit.values()[n];
    }

    public int getIncreaseSizeUnitInt() {
        return this.increaseSizeUnit.ordinal();
    }

    public void setDecreaseSizeUnitInt(int n) {
        this.decreaseSizeUnit = SizeUnit.values()[n];
    }

    public int getDecreaseSizeUnitInt() {
        return this.decreaseSizeUnit.ordinal();
    }

    public int getEofTest() {
        return this.eofTest;
    }

    public void setEofTest(int n) {
        this.eofTest = n;
    }

    public String getEofTextMarker() {
        return this.eofTextMarker;
    }

    public static String encodeHexString(String string, String string2, String string3, int n) {
        ValidationHelper.checkForNullAndBlank((String)"Character set name", (String)string2);
        ValidationHelper.checkForNull((String)string, (Object)string3);
        ValidationHelper.validateLength((String)string, (int)n, (String)string3);
        AgentEventFile.validateCharacterSet(string2);
        try {
            byte[] byArray = string3.getBytes(string2);
            return Convert.toHexString((byte[])byArray).toUpperCase();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Could not encode " + string3 + " using the character set " + string2 + ".", unsupportedEncodingException);
        }
    }

    public static String decodeHexString(String string, String string2) {
        ValidationHelper.checkForNullAndBlank((String)"Character set name", (String)string);
        ValidationHelper.checkForNull((String)"Hex value", (Object)string2);
        AgentEventFile.validateCharacterSet(string);
        try {
            byte[] byArray = Convert.hexToBytes((String)string2);
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Could not dencode " + string2 + " using the character set " + string + ".", unsupportedEncodingException);
        }
    }

    private static boolean validateCharacterSet(String string) {
        try {
            Charset charset = Charset.forName(string);
            if (!charset.canEncode()) {
                throw new IllegalArgumentException("Character set " + string + " is not supported.");
            }
            return true;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string + " is not a valid character set.", exception);
        }
    }

    public void setEofTextMarker(String string) {
        this.eofTextMarker = string;
    }

    public String getEofTextEncoding() {
        return this.eofTextEncoding;
    }

    public void setEofTextEncoding(String string) {
        this.eofTextEncoding = string;
    }

    public String getEofHexMarker() {
        return this.eofHexMarker;
    }

    public void setEofHexMarker(String string) {
        this.eofHexMarker = this.isValidHexString("End of File Hex Marker", string);
    }

    private String isValidHexString(String string, String string2) {
        ValidationHelper.checkForNull((String)string, (Object)this.eofTextEncoding);
        if (string2 == null) {
            return null;
        }
        String string3 = string2.trim().toUpperCase();
        try {
            Convert.hexToBytes((String)string3);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string + " contains invalid Hex characters.");
        }
        return string3;
    }

    public void setParentType(int n) {
        this.parentType = n;
    }

    public int getParentType() {
        return this.parentType;
    }
}

