/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentEnvironmentVariable;
import junit.framework.TestCase;

public class AgentEnvironmentVariableTest
extends TestCase {
    AgentEnvironmentVariable var;

    protected void setUp() throws Exception {
        super.setUp();
        this.var = new AgentEnvironmentVariable();
    }

    protected void tearDown() throws Exception {
        this.var = null;
        super.tearDown();
    }

    public void testNameCanBeBlank() {
        this.var.setName("");
        AgentEnvironmentVariableTest.assertEquals((String)"", (String)this.var.getName());
    }

    public void testNameNullNotAllowed() {
        try {
            this.var.setName(null);
            AgentEnvironmentVariableTest.fail((String)"setName() accepted a null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetName() {
        this.var.setName("TestName");
        AgentEnvironmentVariableTest.assertEquals((String)"TestName", (String)this.var.getName());
    }

    public void testVariableCanBeBlank() {
        this.var.setVariable("");
        AgentEnvironmentVariableTest.assertEquals((String)"", (String)this.var.getVariable());
    }

    public void testVariableNullNotAllowed() {
        try {
            this.var.setVariable(null);
            AgentEnvironmentVariableTest.fail((String)"setVariable() accepted a null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetVariable() {
        String string = "copy /Y *.jar C:\\HELPSYS\\SCHENT\\v1\\trunk\\gui-install\\install_lib_v6";
        this.var.setVariable(string);
        AgentEnvironmentVariableTest.assertEquals((String)string, (String)this.var.getVariable());
    }

    public void testGetParentOid() {
        this.var.setParentOid(1234L);
        AgentEnvironmentVariableTest.assertEquals((long)1234L, (long)this.var.getParentOid());
    }

    public void testModifiedFlag() {
        this.var.resetModifiedFlag();
        AgentEnvironmentVariableTest.assertFalse((boolean)this.var.wasModified());
        this.var.setName("Some new name value");
        AgentEnvironmentVariableTest.assertTrue((boolean)this.var.wasModified());
    }

    public void testClone() {
        this.var.setName("Something");
        String string = "copy /Y *.jar C:\\HELPSYS\\SCHENT\\v1\\trunk\\gui-install\\install_lib_v6";
        this.var.setVariable(string);
        AgentEnvironmentVariable agentEnvironmentVariable = this.var.clone();
        AgentEnvironmentVariableTest.assertTrue((boolean)agentEnvironmentVariable.equals((Object)this.var));
        AgentEnvironmentVariableTest.assertFalse((agentEnvironmentVariable == this.var ? 1 : 0) != 0);
    }

    public void testEqualsFalseForNull() {
        AgentEnvironmentVariableTest.assertFalse((boolean)this.var.equals(null));
    }

    public void testEqualsFalseForSomeArbitraryObject() {
        this.var.setName("Something");
        AgentEnvironmentVariableTest.assertFalse((boolean)this.var.equals(new Object()));
    }

    public void testEqualsIsReflective() {
        AgentEnvironmentVariableTest.assertTrue((boolean)this.var.equals((Object)this.var));
        this.var.setOid(1234893L);
        AgentEnvironmentVariableTest.assertTrue((boolean)this.var.equals((Object)this.var));
    }

    public void testEqualsDependsOnOid() {
        this.var.setOid(1234L);
        AgentEnvironmentVariable agentEnvironmentVariable = this.var.clone();
        AgentEnvironmentVariableTest.assertTrue((boolean)agentEnvironmentVariable.equals((Object)this.var));
        agentEnvironmentVariable.setOid(9823L);
        AgentEnvironmentVariableTest.assertFalse((boolean)agentEnvironmentVariable.equals((Object)this.var));
    }

    public void testHashCode() {
        this.var.setName("OriginalName");
        this.var.setVariable("some value");
        int n = this.var.hashCode();
        this.var.setName("ChangedName");
        this.var.setVariable("changed value");
        int n2 = this.var.hashCode();
        AgentEnvironmentVariableTest.assertTrue((n == n2 ? 1 : 0) != 0);
        this.var.setOid(1234L);
        this.var.setName("OriginalName");
        this.var.setVariable("some value");
        n = this.var.hashCode();
        this.var.setName("ChangedName");
        this.var.setVariable("changed value");
        n2 = this.var.hashCode();
        AgentEnvironmentVariableTest.assertTrue((n == n2 ? 1 : 0) != 0);
    }
}

