/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentEnvironmentVariable;
import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import java.util.Map;
import junit.framework.TestCase;

public class AgentEnvironmentTest
extends TestCase {
    private AgentEnvironment env;
    private AgentEnvironmentVariable var1;
    private AgentEnvironmentVariable var2;
    private AgentEnvironmentVariable var3;
    private AgentEnvironmentVariable[] list;
    private AgentEnvironmentVariable[] shortList;
    private SkybotVariable rv1;
    private SkybotVariable rv2;
    private SkybotVariable rv3;
    static final long now = System.currentTimeMillis();

    protected void setUp() throws Exception {
        super.setUp();
        this.env = new AgentEnvironment();
        this.rv1 = new SkybotVariable(12345L, "RV1", "Value1", true);
        this.rv2 = new SkybotVariable(12356L, "RV2", "Value2", true);
        this.rv3 = new SkybotVariable(12367L, "RV3", "Value3", true);
        this.var1 = new AgentEnvironmentVariable();
        this.var1.setName("@@var1");
        this.var1.setSkybotVariable(this.rv1);
        this.var1.setVariable("SomeValue1");
        this.var1.setOid(1L);
        this.var1.setResolvedValue(null, now, null);
        this.var2 = new AgentEnvironmentVariable();
        this.var2.setName("@@var2");
        this.var2.setSkybotVariable(this.rv2);
        this.var2.setVariable("SomeValue2");
        this.var2.setOid(2L);
        this.var2.setResolvedValue(null, now, null);
        this.var3 = new AgentEnvironmentVariable();
        this.var3.setName("@@var3");
        this.var3.setSkybotVariable(this.rv3);
        this.var3.setVariable("SomeValue3");
        this.var3.setOid(3L);
        this.var3.setResolvedValue(null, now, null);
        this.list = new AgentEnvironmentVariable[3];
        this.list[0] = this.var1;
        this.list[1] = this.var2;
        this.list[2] = this.var3;
        this.shortList = new AgentEnvironmentVariable[2];
        this.shortList[0] = this.var1;
        this.shortList[1] = this.var2;
    }

    protected void tearDown() throws Exception {
        this.var1 = null;
        this.var2 = null;
        this.var3 = null;
        this.rv1 = null;
        this.rv2 = null;
        this.rv3 = null;
        this.env = null;
        super.tearDown();
    }

    public void testHashCode() {
        String string = "Some Name";
        this.env.setName(string);
        AgentEnvironmentTest.assertEquals((int)string.hashCode(), (int)this.env.hashCode());
    }

    public void testEqualsObject() {
        this.env.setOid(1234L);
        this.env.setName("Some Name");
        AgentEnvironmentTest.assertFalse((boolean)this.env.equals(new Object()));
        AgentEnvironment agentEnvironment = new AgentEnvironment();
        agentEnvironment.setName("Some Other Name");
        AgentEnvironmentTest.assertFalse((boolean)this.env.equals((Object)agentEnvironment));
        AgentEnvironment agentEnvironment2 = new AgentEnvironment();
        agentEnvironment2.setName(this.env.getName());
        agentEnvironment2.setOid(1235L);
        AgentEnvironmentTest.assertFalse((boolean)this.env.equals((Object)agentEnvironment2));
        AgentEnvironment agentEnvironment3 = new AgentEnvironment();
        agentEnvironment3.setName(this.env.getName());
        agentEnvironment3.setOid(this.env.getOid());
        AgentEnvironmentTest.assertTrue((boolean)this.env.equals((Object)agentEnvironment3));
    }

    public void testGetUserProfile() {
        this.env.setUserProfile("PROFILE");
        AgentEnvironmentTest.assertEquals((String)"PROFILE", (String)this.env.getUserProfile());
    }

    public void testGetMap() {
        this.env.setVariableList(this.list);
        Map<String, String> map = this.env.getMap();
        AgentEnvironmentTest.assertTrue((boolean)map.containsKey("@@var1"));
        AgentEnvironmentTest.assertTrue((boolean)map.containsKey("@@var2"));
        AgentEnvironmentTest.assertTrue((boolean)map.containsKey("@@var3"));
        AgentEnvironmentTest.assertFalse((boolean)map.containsKey("@@var4"));
        AgentEnvironmentTest.assertEquals((String)"Value1", (String)map.get("@@var1"));
        AgentEnvironmentTest.assertEquals((String)"Value2", (String)map.get("@@var2"));
        AgentEnvironmentTest.assertEquals((String)"Value3", (String)map.get("@@var3"));
    }

    public void testContainsVariable() {
        this.env.setVariableList(this.list);
        AgentEnvironmentTest.assertTrue((boolean)this.env.containsVariable(this.var1));
        AgentEnvironmentTest.assertTrue((boolean)this.env.containsVariable(this.var2));
        AgentEnvironmentTest.assertTrue((boolean)this.env.containsVariable(this.var3));
        this.env.setVariableList(this.shortList);
        AgentEnvironmentTest.assertTrue((boolean)this.env.containsVariable(this.var1));
        AgentEnvironmentTest.assertTrue((boolean)this.env.containsVariable(this.var2));
        AgentEnvironmentTest.assertFalse((boolean)this.env.containsVariable(this.var3));
    }

    public void testGetWorkingPath() {
        String string = "C:\\some\\working\\path\\value";
        this.env.setWorkingPath(string);
        AgentEnvironmentTest.assertEquals((String)string, (String)this.env.getWorkingPath());
    }

    public void testSetType() {
        this.env.setType(1);
        AgentEnvironmentTest.assertEquals((int)1, (int)this.env.getType());
        this.env.setType(2);
        AgentEnvironmentTest.assertEquals((int)2, (int)this.env.getType());
        try {
            this.env.setType(-2938423);
            AgentEnvironmentTest.fail((String)"setType() accepted an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetRefSharedOIDFailsWhenTypeIsShared() {
        this.env.setType(2);
        try {
            this.env.setRefSharedOID(1234L);
            AgentEnvironmentTest.fail((String)"setRefSharedOID() allowed when type is AGENT_TYPE_SHARED");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetSharedAgentEnvName() {
        this.env.setSharedAgentEnvName(null);
        AgentEnvironmentTest.assertEquals((String)"", (String)this.env.getSharedAgentEnvName());
        this.env.setSharedAgentEnvName("SomeName");
        AgentEnvironmentTest.assertEquals((String)"SomeName", (String)this.env.getSharedAgentEnvName());
    }

    public void testSetVariableList() {
        this.env.setVariableList(this.shortList);
        AgentEnvironmentVariable[] agentEnvironmentVariableArray = this.env.getVariables();
        AgentEnvironmentTest.assertEquals((int)2, (int)agentEnvironmentVariableArray.length);
        AgentEnvironmentTest.assertEquals((Object)((Object)this.var1), (Object)((Object)agentEnvironmentVariableArray[0]));
        AgentEnvironmentTest.assertEquals((Object)((Object)this.var2), (Object)((Object)agentEnvironmentVariableArray[1]));
    }

    public void testHasVariables() {
        AgentEnvironmentTest.assertFalse((boolean)this.env.hasVariables());
        this.env.setVariableList(this.list);
        AgentEnvironmentTest.assertTrue((boolean)this.env.hasVariables());
    }

    public void testIsEmpty() {
        AgentEnvironmentTest.assertTrue((boolean)this.env.isEmpty());
        this.env.setVariableList(this.shortList);
        AgentEnvironmentTest.assertFalse((boolean)this.env.isEmpty());
    }

    public void testGetName() {
        this.env.setName("SomeEnvironmentName");
        AgentEnvironmentTest.assertEquals((String)"SomeEnvironmentName", (String)this.env.getName());
    }

    public void testGetOid() {
        this.env.setOid(1234L);
        AgentEnvironmentTest.assertEquals((long)1234L, (long)this.env.getOid());
    }

    public void testTooSimpleToFail() {
        this.env.setType(1);
        AgentEnvironmentTest.assertTrue((boolean)this.env.isPrivate());
        AgentEnvironmentTest.assertFalse((boolean)this.env.isShared());
        this.env.setType(2);
        AgentEnvironmentTest.assertFalse((boolean)this.env.isPrivate());
        AgentEnvironmentTest.assertTrue((boolean)this.env.isShared());
    }

    public void testSetPassword() {
        this.env.setPassword("SomePassword");
        AgentEnvironmentTest.assertEquals((String)"SomePassword", (String)this.env.getPassword());
    }

    public void testSetPasswordAllowsNull() {
        this.env.setPassword(null);
        AgentEnvironmentTest.assertEquals((String)"", (String)this.env.getPassword());
    }

    public void testSetPasswordTrimsInput() {
        this.env.setPassword("  Password   ");
        AgentEnvironmentTest.assertEquals((String)"Password", (String)this.env.getPassword());
    }

    public void testSetEncryptedPassword() {
        String string = "drgQ$#aF$WEASDfAs$R%TSArDFahteger5GDrgd";
        this.env.setEncryptedPassword(string);
        AgentEnvironmentTest.assertEquals((String)string, (String)this.env.getEncryptedPassword());
    }

    public void testSetEncryptedPasswordAllowsNull() {
        this.env.setEncryptedPassword(null);
        AgentEnvironmentTest.assertEquals((String)"", (String)this.env.getEncryptedPassword());
    }

    public void testSetEncryptedPasswordTrimsInput() {
        String string = "   drgQ$#aF$WEASDfAs$R%TSArDFahteger5GDrgd   ";
        this.env.setEncryptedPassword(string);
        AgentEnvironmentTest.assertEquals((String)string.trim(), (String)this.env.getEncryptedPassword());
    }

    public void testGetType() {
        this.env.setType(1);
        AgentEnvironmentTest.assertEquals((int)1, (int)this.env.getType());
        this.env.setType(2);
        AgentEnvironmentTest.assertEquals((int)2, (int)this.env.getType());
        try {
            this.env.setType(-123);
            AgentEnvironmentTest.fail((String)"Allowed invalid Type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetRefSharedOID() {
        this.env.setRefSharedOID(123456789012345L);
        AgentEnvironmentTest.assertEquals((long)123456789012345L, (long)this.env.getRefSharedOID());
        this.env.setType(2);
        try {
            this.env.setRefSharedOID(123456789012345L);
            AgentEnvironmentTest.fail((String)"Allowed setting RefSharedOID when type is AGENT_TYPE_SHARED.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetSharedAgentEnvName() {
        this.env.setSharedAgentEnvName("somename");
        AgentEnvironmentTest.assertEquals((String)"somename", (String)this.env.getSharedAgentEnvName());
    }

    public void testIsSharedWithOverrides() {
        this.env.setType(1);
        this.env.setRefSharedOID(0L);
        AgentEnvironmentTest.assertFalse((boolean)this.env.isSharedWithOverrides());
        this.env.setRefSharedOID(1234567L);
        this.env.setType(2);
        AgentEnvironmentTest.assertFalse((boolean)this.env.isSharedWithOverrides());
        this.env.setType(1);
        this.env.setRefSharedOID(1234567L);
        AgentEnvironmentTest.assertTrue((boolean)this.env.isSharedWithOverrides());
    }
}

