/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import junit.framework.TestCase;

public class RosettaMsgTest
extends TestCase {
    Set<RosettaMsg> s = Collections.synchronizedSet(EnumSet.allOf(RosettaMsg.class));

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetMsgText() {
        for (RosettaMsg rosettaMsg : this.s) {
            String string = RosettaMsg.getMsgText(rosettaMsg, null);
            RosettaMsgTest.assertFalse((boolean)string.startsWith("Text is not defined"));
        }
    }

    public void testValueOf() {
        for (RosettaMsg rosettaMsg : this.s) {
            RosettaMsg rosettaMsg2 = RosettaMsg.valueOf(rosettaMsg.name());
            RosettaMsgTest.assertEquals((Object)((Object)rosettaMsg), (Object)((Object)rosettaMsg2));
        }
        try {
            RosettaMsg.valueOf("some funky String value");
            RosettaMsgTest.fail((String)"RosettaMsg.valueOf(String) accepted bad value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetMsgTextWithVars() {
        for (RosettaMsg rosettaMsg : this.s) {
            String string = RosettaMsg.getMsgText(rosettaMsg, new String[]{"var0"});
            RosettaMsgTest.assertFalse((boolean)string.startsWith("Text is not defined"));
        }
    }

    public void testNewLogEntry() {
        for (RosettaMsg rosettaMsg : this.s) {
            ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry();
            RosettaMsgTest.assertEquals((Object)((Object)rosettaMsg), (Object)((Object)scheduleLogEntry.getMessage()));
        }
    }

    public void testNewSystemMessage() {
        for (RosettaMsg rosettaMsg : this.s) {
            SystemMessage systemMessage = rosettaMsg.newSystemMessage();
            RosettaMsgTest.assertEquals((Object)((Object)rosettaMsg), (Object)((Object)systemMessage.getMessage()));
        }
    }

    public void testNewLogEntryVar() {
        RosettaMsg rosettaMsg = RosettaMsg.UNABLE_TO_PROCESS_COMMAND;
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry("UserName");
        String string = RosettaMsg.getMsgText(rosettaMsg, new String[]{"UserName"});
        String string2 = scheduleLogEntry.getMessageText();
        RosettaMsgTest.assertEquals((String)string, (String)string2);
    }

    public void testNewLogEntryVars() {
        RosettaMsg rosettaMsg = RosettaMsg.UNABLE_TO_PROCESS_COMMAND;
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(new String[]{"UserName"});
        String string = RosettaMsg.getMsgText(rosettaMsg, new String[]{"UserName"});
        String string2 = scheduleLogEntry.getMessageText();
        RosettaMsgTest.assertEquals((String)string, (String)string2);
    }

    public void testNewLogEntryVarsAgentJob() {
        RosettaMsg rosettaMsg = RosettaMsg.UNABLE_TO_PROCESS_COMMAND;
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(new String[]{"UserName"}, 1234L, 5678L);
        String string = RosettaMsg.getMsgText(rosettaMsg, new String[]{"UserName"});
        String string2 = scheduleLogEntry.getMessageText();
        RosettaMsgTest.assertEquals((String)string, (String)string2);
        RosettaMsgTest.assertEquals((long)1234L, (long)scheduleLogEntry.getAgentID());
        RosettaMsgTest.assertEquals((long)5678L, (long)scheduleLogEntry.getJobID());
    }

    public void testNewLogEntryVarsAgentJobJobHist() {
        RosettaMsg rosettaMsg = RosettaMsg.UNABLE_TO_PROCESS_COMMAND;
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(new String[]{"UserName"}, 1234L, 5678L, 91011L);
        String string = RosettaMsg.getMsgText(rosettaMsg, new String[]{"UserName"});
        String string2 = scheduleLogEntry.getMessageText();
        RosettaMsgTest.assertEquals((String)string, (String)string2);
        RosettaMsgTest.assertEquals((long)1234L, (long)scheduleLogEntry.getAgentID());
        RosettaMsgTest.assertEquals((long)5678L, (long)scheduleLogEntry.getJobID());
        RosettaMsgTest.assertEquals((long)91011L, (long)scheduleLogEntry.getJobHistoryID());
    }

    public void testNewSystemMessageVar() {
        RosettaMsg rosettaMsg = RosettaMsg.UNABLE_TO_PROCESS_COMMAND;
        SystemMessage systemMessage = rosettaMsg.newSystemMessage("UserName");
        String string = RosettaMsg.getMsgText(rosettaMsg, new String[]{"UserName"});
        String string2 = systemMessage.getMessageText();
        RosettaMsgTest.assertEquals((String)string, (String)string2);
    }

    public void testNewSystemMessageVars() {
        RosettaMsg rosettaMsg = RosettaMsg.UNABLE_TO_PROCESS_COMMAND;
        SystemMessage systemMessage = rosettaMsg.newSystemMessage(new String[]{"UserName"});
        String string = RosettaMsg.getMsgText(rosettaMsg, new String[]{"UserName"});
        String string2 = systemMessage.getMessageText();
        RosettaMsgTest.assertEquals((String)string, (String)string2);
    }
}

