/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.jdbc.ResultSetSimpleList;
import com.helpsystems.enterprise.access.scheduler.ScheduledJobsListJdbc;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledJobsList;
import com.helpsystems.enterprise.core.scheduler.ScheduledTime;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.core.scheduler.SimpleList;
import com.helpsystems.enterprise.core.scheduler.UpdateCounterException;
import com.helpsystems.enterprise.core.util.LongConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ScheduledTimeDMJdbc
extends AbstractDatabaseManager
implements ScheduledTimeDM {
    private static final String TABLE = "next_scheduled_times";
    private static final String JOBS_TABLE = "jobs";
    private String table;
    private String jobsTable;
    private ScheduleJobDM scheduleJobDM;
    private AgentDM agentDM;
    private BusinessObjectGenerator<ScheduledTime> busObjGenerator = new ScheduledTimeGenerator();
    private static final Logger logger = Logger.getLogger(ScheduledTimeDMJdbc.class);
    private static final String objDesc = "Scheduled Time";
    private Calendar cloneOnly_GMTCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));

    public ScheduledTimeDMJdbc(String string, String string2, String string3, ScheduleJobDM scheduleJobDM, AgentDM agentDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        ValidationHelper.checkForNull((String)"AgentDM", (Object)agentDM);
        this.table = string2 + "." + TABLE;
        this.jobsTable = string2 + "." + JOBS_TABLE;
        this.setName(string3);
        this.scheduleJobDM = scheduleJobDM;
        this.agentDM = agentDM;
        this.cloneOnly_GMTCalendar.clear();
    }

    @Override
    public int countNSTRecords(int n) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.table + " WHERE job_id=?";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            return this.doCount(string, objectArray);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = MessageUtil.formatMsg((String)"Error while counting the number of next_scheduled_time records for job {0}.", (Object[])new Object[]{n});
            throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public int delete(int n) throws ResourceUnavailableException {
        String string = "DELETE FROM " + this.table + " WHERE job_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            int n2;
            preparedStatement.setInt(1, n);
            int n3 = n2 = preparedStatement.executeUpdate();
            return n3;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while deleting the {0} information for job {1}, for all agents.", (Object[])new Object[]{objDesc, n});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public int delete(int n, int n2) throws ResourceUnavailableException {
        String string = "DELETE FROM " + this.table + " WHERE job_id=? AND agent_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            int n3;
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            int n4 = n3 = preparedStatement.executeUpdate();
            return n4;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while deleting the {0} information for job {1}, for agent {2}.", (Object[])new Object[]{objDesc, n, n2});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ScheduledTime get(int n, int n2) throws NoDataException, BadDataException, ResourceUnavailableException {
        String string = this.sqlSelectString() + " WHERE job_id=? AND agent_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduledTime scheduledTime;
                ScheduledTime scheduledTime2 = scheduledTime = (ScheduledTime)this.busObjGenerator.generateObject(resultSet);
                return scheduledTime2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Scheduled Time information for job {0}, agent {1} not found", (Object[])new Object[]{n, n2});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} information for job {1}, agent {2}.", (Object[])new Object[]{objDesc, n, n2});
                logger.debug((Object)string3, (Throwable)sQLException);
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public SimpleList<ScheduledTime> get(int n) throws ResourceUnavailableException {
        String string = this.sqlSelectString() + " WHERE agent_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            return new ResultSetSimpleList<ScheduledTime>(resultSet, this.busObjGenerator);
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} information for agent {1}.", (Object[])new Object[]{objDesc, n});
            logger.debug((Object)string2, (Throwable)sQLException);
            this.closeConnection(preparedStatement);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
    }

    @Override
    public ScheduledTime[] getDuplicateNSTPairs() throws ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ScheduledTimeDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error creating a Statement from the Connection.", (Throwable)sQLException);
        }
        ArrayList<ScheduledTime> arrayList = new ArrayList<ScheduledTime>();
        try {
            resultSet = statement.executeQuery("SELECT job_id, agent_id, count(*) AS count from " + this.table + " GROUP BY job_id, agent_id HAVING COUNT(*) > 1");
            while (resultSet.next()) {
                ScheduledTime scheduledTime = new ScheduledTime();
                scheduledTime.setJobNumber(resultSet.getInt("job_id"));
                scheduledTime.setSystem(resultSet.getInt("agent_id"));
                scheduledTime.setUpdateCounter(resultSet.getInt("count"));
                arrayList.add(scheduledTime);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error while looking for any next_scheduled_times rows with the same jobID/agentID pair.", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                ScheduledTimeDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, resultSet);
                throw throwable;
            }
        }
        ScheduledTimeDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
        return arrayList.toArray(new ScheduledTime[arrayList.size()]);
    }

    @Override
    public SimpleList<ScheduledTime> getNextScheduledTimeAuditList() throws ResourceUnavailableException {
        ResultSet resultSet;
        String string = this.sqlSelectString() + " ORDER BY job_id";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string);
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving the list of Schedule jobs.";
            this.closeConnection(preparedStatement);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        return new ResultSetSimpleList<ScheduledTime>(resultSet, this.busObjGenerator);
    }

    @Override
    public ScheduledTime[] getOrphanedNSTRecords() throws ResourceUnavailableException {
        String string = "schedule_type IN ('" + ScheduleJobProxy.ScheduleType.DATE_LIST.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.DAY_COUNT.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.TIMED_INTERVAL.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.CRON_EXPRESSION.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.DAY_OF_WEEK.persistanceCode() + "')";
        String string2 = "SELECT id AS jobID, COALESCE(target_id, 0) AS agentID FROM " + this.jobsTable + " WHERE " + string + " AND (target_type = 'Agent' OR target_type IS NULL)";
        String string3 = "SELECT j.id AS jobID, aga.agent_id AS agentID FROM " + this.jobsTable + " j JOIN agent_groups ag ON target_id = ag.id JOIN agent_group_agents aga ON ag.id = agent_group_id " + "WHERE " + string + " AND target_type = 'AgentGroup' AND group_type = 0";
        String string4 = "SELECT j.id AS jobID, CAST (0 AS BIGINT) AS agentID FROM " + this.jobsTable + " j JOIN agent_groups ag ON target_id = ag.id WHERE " + string + " AND target_type = 'AgentGroup' AND group_type <> 0";
        String string5 = "WITH time_based_entries (jobID, agentID) AS (" + string2 + " UNION ALL " + string3 + " UNION ALL " + string4 + ") " + "SELECT id, job_id, agent_id, next_scheduled_time FROM " + this.table + " WHERE NOT EXISTS " + "(SELECT jobID FROM time_based_entries WHERE jobID = job_id AND agentID = agent_id)";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string5);
        ArrayList<ScheduledTime> arrayList = new ArrayList<ScheduledTime>();
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ScheduledTime scheduledTime = new ScheduledTime();
                scheduledTime.setJobNumber(resultSet.getInt("job_id"));
                scheduledTime.setSystem(resultSet.getInt("agent_id"));
                scheduledTime.setUpdateCounter(resultSet.getInt("id"));
                Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
                Timestamp timestamp = resultSet.getTimestamp("next_scheduled_time", calendar);
                if (timestamp != null) {
                    Calendar calendar2 = (Calendar)this.cloneOnly_GMTCalendar.clone();
                    calendar2.setTimeInMillis(timestamp.getTime());
                    scheduledTime.setNextScheduledTime(calendar2);
                } else {
                    scheduledTime.setNextScheduledTime(null);
                }
                arrayList.add(scheduledTime);
            }
        }
        catch (SQLException sQLException) {
            String string6 = "SQL error while retrieving the list of orphaned next scheduled time entries in the database.";
            throw new ResourceUnavailableException(string6, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new ScheduledTime[arrayList.size()]);
    }

    @Override
    public ScheduledJobsList getScheduledJobsList() throws ResourceUnavailableException {
        String string = "SELECT job_id, agent_id, next_scheduled_time, days_moved, minutes_moved FROM " + this.table + " WHERE next_scheduled_time " + "IS NOT NULL ORDER BY next_scheduled_time";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string);
        return new ScheduledJobsListJdbc(preparedStatement, this.scheduleJobDM, this.agentDM);
    }

    @Override
    public ScheduleJobProxy[] getTimeBasedJobsWithNoNSTRecord() throws ResourceUnavailableException {
        String string = "schedule_type IN ('" + ScheduleJobProxy.ScheduleType.DATE_LIST.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.DAY_COUNT.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.TIMED_INTERVAL.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.CRON_EXPRESSION.persistanceCode() + "', '" + ScheduleJobProxy.ScheduleType.DAY_OF_WEEK.persistanceCode() + "')";
        String string2 = "SELECT j.id, COALESCE(target_id, 0) FROM jobs j WHERE " + string + " AND (target_type = 'Agent' OR target_type IS NULL) " + "AND NOT EXISTS (SELECT id FROM next_scheduled_times " + "WHERE j.id = job_id AND COALESCE(target_id, 0) = agent_id)";
        String string3 = "SELECT j.id, aga.agent_id FROM jobs j JOIN agent_groups ag ON target_id = ag.id JOIN agent_group_agents aga ON ag.id = agent_group_id WHERE " + string + " AND target_type = 'AgentGroup' AND group_type = 0 " + "AND NOT EXISTS (SELECT id from next_scheduled_times n " + "WHERE j.id = job_id AND aga.agent_id = n.agent_id)";
        String string4 = "SELECT j.id, CAST (0 AS BIGINT) AS agent_id FROM jobs j JOIN agent_groups ag ON target_id = ag.id  WHERE " + string + " AND target_type = 'AgentGroup' AND group_type <> 0 " + "AND NOT EXISTS (SELECT id from next_scheduled_times n " + "WHERE j.id = job_id AND n.agent_id = 0)";
        String string5 = string2 + " UNION ALL " + string3 + " UNION ALL " + string4 + " ORDER BY 1, 2";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string5);
        try {
            ScheduleJobProxy[] scheduleJobProxyArray;
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<ScheduleJobProxy[]> arrayList = new ArrayList<ScheduleJobProxy[]>();
            while (resultSet.next()) {
                scheduleJobProxyArray = new ScheduleJobProxy();
                scheduleJobProxyArray.setSkybotJobNumber(resultSet.getLong(1));
                scheduleJobProxyArray.setSystem(resultSet.getInt(2));
                arrayList.add(scheduleJobProxyArray);
            }
            scheduleJobProxyArray = new ScheduleJobProxy[arrayList.size()];
            ScheduleJobProxy[] scheduleJobProxyArray2 = scheduleJobProxyArray = arrayList.toArray(scheduleJobProxyArray);
            return scheduleJobProxyArray2;
        }
        catch (SQLException sQLException) {
            String string6 = "SQL error while retrieving the list of time-based schedule jobs with no next scheduled time entry in the database.";
            throw new ResourceUnavailableException(string6, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ScheduledTime insert(ScheduledTime scheduledTime) throws NotSavedException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"ScheduledTime", (Object)scheduledTime);
        scheduledTime.validate();
        Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
        int n = scheduledTime.getJobNumber();
        int n2 = scheduledTime.getSystem();
        String string = "INSERT INTO " + this.table + " (" + "job_id, agent_id, next_scheduled_time, considered_at_time, " + "days_moved, minutes_moved, maintained_at_time, update_counter) " + "VALUES(?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            Calendar calendar2 = scheduledTime.getNextScheduledTime();
            this.setTimestamp(calendar2, preparedStatement, 3, calendar);
            Calendar calendar3 = scheduledTime.getConsideredAtDateTime();
            this.setTimestamp(calendar3, preparedStatement, 4, calendar);
            preparedStatement.setInt(5, this.daysMoved(calendar2));
            preparedStatement.setInt(6, this.minutesMoved(calendar2));
            Calendar calendar4 = scheduledTime.getMaintainedAtDateTime();
            this.setTimestamp(calendar4, preparedStatement, 7, calendar);
            preparedStatement.setInt(8, scheduledTime.getUpdateCounter());
            int n3 = preparedStatement.executeUpdate();
            if (n3 < 1) {
                String string2 = MessageUtil.formatMsg((String)"Unable to add the scheduled time data for job {0}, agent {1}.", (Object[])new Object[]{n, n2});
                throw new NotSavedException(string2);
            }
            scheduledTime.setPersistent(true);
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while inserting the next scheduled time {0}, for job {1}, agent {2}.", (Object[])new Object[]{scheduledTime.getNextScheduledTime(), n, n2});
            logger.debug((Object)string3, (Throwable)sQLException);
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return scheduledTime;
    }

    @Override
    public boolean isInDatabase(int n, int n2) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.table + " WHERE job_id=? " + "AND agent_id=?";
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        try {
            return this.doCount(string, objectArray) > 0;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = MessageUtil.formatMsg((String)"Error while checking if Scheduled Time information exists for job {0}, agent {1}.", (Object[])new Object[]{n, n2});
            throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public ScheduledTime updateByCounter(ScheduledTime scheduledTime) throws NotSavedException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"ScheduledTime", (Object)scheduledTime);
        scheduledTime.validate();
        Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
        int n = scheduledTime.getJobNumber();
        int n2 = scheduledTime.getSystem();
        int n3 = scheduledTime.getUpdateCounter();
        String string = "UPDATE " + this.table + " SET next_scheduled_time=?, " + "considered_time=?, considered_at_time=?, days_moved=?, " + "minutes_moved=? WHERE job_id=? AND agent_id=? AND update_counter=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Calendar calendar2 = scheduledTime.getNextScheduledTime();
            this.setTimestamp(calendar2, preparedStatement, 1, calendar);
            Calendar calendar3 = scheduledTime.getConsideredScheduledTime();
            this.setTimestamp(calendar3, preparedStatement, 2, calendar);
            Calendar calendar4 = scheduledTime.getConsideredAtDateTime();
            this.setTimestamp(calendar4, preparedStatement, 3, calendar);
            preparedStatement.setInt(4, this.daysMoved(calendar2));
            preparedStatement.setInt(5, this.minutesMoved(calendar2));
            preparedStatement.setInt(6, n);
            preparedStatement.setInt(7, n2);
            preparedStatement.setInt(8, n3);
            int n4 = preparedStatement.executeUpdate();
            if (n4 < 1) {
                ScheduledTime scheduledTime2;
                try {
                    scheduledTime2 = this.get(n, n2);
                }
                catch (NoDataException noDataException) {
                    throw new NotSavedException("", (Throwable)noDataException);
                }
                catch (BadDataException badDataException) {
                    scheduledTime2 = (ScheduledTime)badDataException.getLoadedObject();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    String string2 = MessageUtil.formatMsg((String)"Unable to update the next scheduled time information for job {0}, agent {1}.", (Object[])new Object[]{n, n2});
                    throw new ResourceUnavailableException(string2, (Throwable)resourceUnavailableException);
                }
                UpdateCounterException updateCounterException = new UpdateCounterException("");
                updateCounterException.setUpdateCounterExpected(n3);
                updateCounterException.setUpdateCounterFound(scheduledTime2.getUpdateCounter());
                throw updateCounterException;
            }
            if (n4 > 1) {
                String string3 = MessageUtil.formatMsg((String)"Program error: More than 1 {0} was updated (job= {1}, agent= {2}.", (Object[])new Object[]{objDesc, n, n2});
                logger.debug((Object)string3);
                throw new RuntimeException(string3);
            }
        }
        catch (SQLException sQLException) {
            String string4 = MessageUtil.formatMsg((String)"SQL error while updating the {0} information for job {1}, agent {2}.", (Object[])new Object[]{objDesc, n, n2});
            logger.debug((Object)string4, (Throwable)sQLException);
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return scheduledTime;
    }

    @Override
    public ScheduledTime updateNST(ScheduledTime scheduledTime) throws NotSavedException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"ScheduledTime", (Object)scheduledTime);
        scheduledTime.validate();
        Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
        int n = scheduledTime.getJobNumber();
        int n2 = scheduledTime.getSystem();
        String string = "UPDATE " + this.table + " SET next_scheduled_time=?, " + "days_moved=?, minutes_moved=?, maintained_at_time=?, update_counter=? " + "WHERE job_id=? AND agent_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Calendar calendar2 = scheduledTime.getNextScheduledTime();
            this.setTimestamp(calendar2, preparedStatement, 1, calendar);
            preparedStatement.setInt(2, this.daysMoved(calendar2));
            preparedStatement.setInt(3, this.minutesMoved(calendar2));
            Calendar calendar3 = scheduledTime.getMaintainedAtDateTime();
            this.setTimestamp(calendar3, preparedStatement, 4, calendar);
            preparedStatement.setInt(5, scheduledTime.getUpdateCounter());
            preparedStatement.setInt(6, n);
            preparedStatement.setInt(7, n2);
            int n3 = preparedStatement.executeUpdate();
            if (n3 < 1) {
                String string2 = MessageUtil.formatMsg((String)"The Scheduled Time information for job {0}, agent {1} was not found.", (Object[])new Object[]{n, n2});
                throw new NotSavedException(string2);
            }
            if (n3 > 1) {
                String string3 = MessageUtil.formatMsg((String)"Program error: More than 1 {0} was updated (job= {1}, agent= {2}.", (Object[])new Object[]{objDesc, n, n2});
                logger.debug((Object)string3);
            }
        }
        catch (SQLException sQLException) {
            String string4 = MessageUtil.formatMsg((String)"SQL error while updating the {0} information for job {1}, agent {2}.", (Object[])new Object[]{objDesc, n, n2});
            logger.debug((Object)string4, (Throwable)sQLException);
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return scheduledTime;
    }

    @Override
    public ScheduledTime update(ScheduledTime scheduledTime) throws NotSavedException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"ScheduledTime", (Object)scheduledTime);
        scheduledTime.validate();
        Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
        int n = scheduledTime.getJobNumber();
        int n2 = scheduledTime.getSystem();
        String string = "UPDATE " + this.table + " SET next_scheduled_time=?, " + "considered_time=?, considered_at_time=?, days_moved=?, " + "minutes_moved=?, update_counter=? WHERE job_id=? AND agent_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Calendar calendar2 = scheduledTime.getNextScheduledTime();
            this.setTimestamp(calendar2, preparedStatement, 1, calendar);
            Calendar calendar3 = scheduledTime.getConsideredScheduledTime();
            this.setTimestamp(calendar3, preparedStatement, 2, calendar);
            Calendar calendar4 = scheduledTime.getConsideredAtDateTime();
            this.setTimestamp(calendar4, preparedStatement, 3, calendar);
            preparedStatement.setInt(4, this.daysMoved(calendar2));
            preparedStatement.setInt(5, this.minutesMoved(calendar2));
            preparedStatement.setInt(6, scheduledTime.getUpdateCounter());
            preparedStatement.setInt(7, n);
            preparedStatement.setInt(8, n2);
            int n3 = preparedStatement.executeUpdate();
            if (n3 < 1) {
                String string2 = MessageUtil.formatMsg((String)"The Scheduled Time information for job {0}, agent {1} was not found.", (Object[])new Object[]{n, n2});
                throw new NotSavedException(string2);
            }
            if (n3 > 1) {
                String string3 = MessageUtil.formatMsg((String)"Program error: More than 1 {0} was updated (job= {1}.", (Object[])new Object[]{objDesc, n});
                logger.debug((Object)string3);
                throw new RuntimeException(string3);
            }
        }
        catch (SQLException sQLException) {
            String string4 = MessageUtil.formatMsg((String)"SQL error while updating the {0} information for job {1}, agent {2}.", (Object[])new Object[]{objDesc, n, n2});
            logger.debug((Object)string4, (Throwable)sQLException);
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return scheduledTime;
    }

    @Override
    public int updateSystem(int n, int n2) throws ResourceUnavailableException {
        String string = "UPDATE " + this.table + " SET agent_id=? WHERE job_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            int n3 = preparedStatement.executeUpdate();
            if (n3 > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than 1 {0} was updated (job= {1}.", (Object[])new Object[]{objDesc, n});
                logger.debug((Object)string2);
                throw new IllegalStateException(string2);
            }
            int n4 = n3;
            return n4;
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the agent ID for job {1}.", (Object[])new Object[]{n});
            logger.debug((Object)string3, (Throwable)sQLException);
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ArrayList<Long> purgeObsoleteRuntimes(long l, long l2) throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "select agent_id from next_scheduled_times where job_id=? AND agent_id not in (select agent_id from agent_group_agents where agent_group_id=?)";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = super.getConnection();
            preparedStatement = super.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l3 = resultSet.getLong("agent_id");
                try {
                    this.delete((int)l, (int)l3);
                    arrayList.add(l3);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)("Error removing NST for job " + l + " agent " + l3 + "."), (Throwable)resourceUnavailableException);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("SQL error deleting obsolete group job runtimes for job " + l + " for agent group " + l2 + ".", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractDatabaseManager.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AbstractDatabaseManager.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public long[] getMissingRuntimeAgents(long l, long l2) throws ResourceUnavailableException {
        long[] lArray;
        String string = "select agent_id from agent_group_agents where agent_group_id=? AND agent_id not in (select agent_id from next_scheduled_times where job_id=?)";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = super.getConnection();
            preparedStatement = super.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("agent_id"));
            }
            lArray = LongConverter.toLongArray(arrayList);
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("SQL error getting missing agent runtimes for job " + l + " for agent group " + l2 + ".", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractDatabaseManager.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AbstractDatabaseManager.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return lArray;
    }

    private int daysMoved(Calendar calendar) {
        if (calendar != null && calendar instanceof MovedNST) {
            return ((MovedNST)calendar).getDaysMoved();
        }
        return 0;
    }

    private int minutesMoved(Calendar calendar) {
        if (calendar != null) {
            if (calendar instanceof MovedInvalidDateTime) {
                return ((MovedInvalidDateTime)calendar).getMinutesMoved();
            }
            if (calendar instanceof MovedNST) {
                return ((MovedNST)calendar).getMinutesMoved();
            }
        }
        return 0;
    }

    private void setTimestamp(Calendar calendar, PreparedStatement preparedStatement, int n, Calendar calendar2) throws SQLException {
        if (calendar != null) {
            Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
            preparedStatement.setTimestamp(n, timestamp, calendar2);
        } else {
            preparedStatement.setNull(n, 93);
        }
    }

    private String sqlSelectString() {
        return "SELECT job_id, agent_id, next_scheduled_time, days_moved, minutes_moved, considered_time, considered_at_time, maintained_at_time, update_counter FROM " + this.table;
    }

    private class ScheduledTimeGenerator
    extends AbstractBusObjGenerator {
        public ScheduledTimeGenerator() {
            super(8, ScheduledTimeDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new ScheduledTime();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            ScheduledTime scheduledTime = (ScheduledTime)object;
            Calendar calendar = (Calendar)ScheduledTimeDMJdbc.this.cloneOnly_GMTCalendar.clone();
            switch (n) {
                case 1: {
                    scheduledTime.setJobNumber(resultSet.getInt("job_id"));
                    break;
                }
                case 2: {
                    scheduledTime.setSystem(resultSet.getInt("agent_id"));
                    break;
                }
                case 3: {
                    Timestamp timestamp = resultSet.getTimestamp("next_scheduled_time", calendar);
                    if (timestamp != null) {
                        Calendar calendar2 = (Calendar)ScheduledTimeDMJdbc.this.cloneOnly_GMTCalendar.clone();
                        calendar2.setTimeInMillis(timestamp.getTime());
                        int n2 = resultSet.getInt("days_moved");
                        int n3 = resultSet.getInt("minutes_moved");
                        if (n2 != 0 || n3 != 0) {
                            calendar2 = new MovedNST(calendar2, n2, n3);
                        }
                        scheduledTime.setNextScheduledTime(calendar2);
                        break;
                    }
                    scheduledTime.setNextScheduledTime(null);
                    break;
                }
                case 4: {
                    Timestamp timestamp = resultSet.getTimestamp("considered_time", calendar);
                    if (timestamp != null) {
                        Calendar calendar3 = (Calendar)ScheduledTimeDMJdbc.this.cloneOnly_GMTCalendar.clone();
                        calendar3.setTimeInMillis(timestamp.getTime());
                        scheduledTime.setConsideredScheduledTime(calendar3);
                        break;
                    }
                    scheduledTime.setConsideredScheduledTime(null);
                    break;
                }
                case 5: {
                    Timestamp timestamp = resultSet.getTimestamp("considered_at_time", calendar);
                    if (timestamp != null) {
                        Calendar calendar4 = (Calendar)ScheduledTimeDMJdbc.this.cloneOnly_GMTCalendar.clone();
                        calendar4.setTimeInMillis(timestamp.getTime());
                        scheduledTime.setConsideredAtDateTime(calendar4);
                        break;
                    }
                    scheduledTime.setConsideredAtDateTime(null);
                    break;
                }
                case 6: {
                    Timestamp timestamp = resultSet.getTimestamp("maintained_at_time", calendar);
                    if (timestamp != null) {
                        Calendar calendar5 = (Calendar)ScheduledTimeDMJdbc.this.cloneOnly_GMTCalendar.clone();
                        calendar5.setTimeInMillis(timestamp.getTime());
                        scheduledTime.setMaintainedAtDateTime(calendar5);
                        break;
                    }
                    scheduledTime.setMaintainedAtDateTime(null);
                    break;
                }
                case 7: {
                    scheduledTime.setUpdateCounter(resultSet.getInt("update_counter"));
                    break;
                }
                case 8: {
                    scheduledTime.setPersistent(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected void validate(Object object) {
            ((ScheduledTime)object).validate();
        }
    }
}

