/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntry;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntryList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PrerequisiteEntryListJdbc
implements PrerequisiteEntryList {
    private static final Logger logger = Logger.getLogger(PrerequisiteEntryListJdbc.class);
    private Connection con;
    private PreparedStatement prereqStmt;
    private ResultSet rs;
    BusinessObjectGenerator busObjGenerator;

    PrerequisiteEntryListJdbc(PreparedStatement preparedStatement, BusinessObjectGenerator businessObjectGenerator) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Prerequisite Prepared Statement", (Object)preparedStatement);
        ValidationHelper.checkForNull((String)"Business Object Generator", (Object)businessObjectGenerator);
        this.prereqStmt = preparedStatement;
        this.busObjGenerator = businessObjectGenerator;
        this.con = this.extractConnectionFromStmt();
    }

    @Override
    public boolean next() throws ResourceUnavailableException {
        try {
            return this.rs.next();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while positioning to the next item in the list.";
            logger.debug((Object)string, (Throwable)sQLException);
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public PrerequisiteEntry getEntry() throws ResourceUnavailableException {
        PrerequisiteEntry prerequisiteEntry;
        try {
            prerequisiteEntry = (PrerequisiteEntry)((Object)this.busObjGenerator.generateObject(this.rs));
        }
        catch (BadDataException badDataException) {
            prerequisiteEntry = (PrerequisiteEntry)((Object)badDataException.getLoadedObject());
        }
        catch (SQLException sQLException) {
            String string = "SQL error while retrieving a Prerequisite Entry for a job or event.";
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        return prerequisiteEntry;
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.prereqStmt != null) {
            try {
                this.prereqStmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    PreparedStatement getPrereqStmt() {
        return this.prereqStmt;
    }

    Connection getConnection() {
        return this.con;
    }

    void runQuery(PreparedStatement preparedStatement) throws SQLException {
        this.rs = preparedStatement.executeQuery();
    }

    void closeRS() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Connection extractConnectionFromStmt() throws ResourceUnavailableException {
        try {
            return this.prereqStmt.getConnection();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            logger.debug((Object)"Cannot retrieve Connection from Statement.", (Throwable)sQLException);
            try {
                this.prereqStmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException2 = sQLException3;
                logger.debug((Object)"SQL error while trying to close the Statement.", (Throwable)sQLException3);
            }
            throw new ResourceUnavailableException("SQL error while trying to build the list.", (Throwable)sQLException2);
        }
    }
}

