/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableProcessChain;
import com.helpsystems.enterprise.core.dm.sap.SAPProcessChainsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SAPProcessChainsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPProcessChainsDM {
    private static final String objDesc = "SAP Process Chain";
    private static final String SAP_PROCESS_CHAINS_TABLE = "sap_process_chains";
    private String sapProcessChainsTable;

    public SAPProcessChainsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPProcessChainsDM");
        this.sapProcessChainsTable = string2 + "." + SAP_PROCESS_CHAINS_TABLE;
    }

    @Override
    public SAPExecutableProcessChain getViaCommandID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            SAPExecutableProcessChain sAPExecutableProcessChain;
            SAPExecutableProcessChainGenerator sAPExecutableProcessChainGenerator = new SAPExecutableProcessChainGenerator();
            String string = "SELECT id, sap_system_environment_id, sap_process_chain_name FROM " + this.sapProcessChainsTable + " WHERE command_id=?";
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            SAPExecutableProcessChain sAPExecutableProcessChain2 = sAPExecutableProcessChain = (SAPExecutableProcessChain)sAPExecutableProcessChainGenerator.generateObject(resultSet);
            SAPProcessChainsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPExecutableProcessChain2;
        }
        try {
            try {
                throw new NoDataException("SAP Process Chain not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command_id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPProcessChainsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class SAPExecutableProcessChainGenerator
    extends AbstractBusObjGenerator {
        public SAPExecutableProcessChainGenerator() {
            super(3, SAPProcessChainsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPExecutableProcessChain();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPExecutableProcessChain sAPExecutableProcessChain = (SAPExecutableProcessChain)object;
            switch (n) {
                case 1: {
                    sAPExecutableProcessChain.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sAPExecutableProcessChain.setSAPSystemEnvironmentID(resultSet.getInt("sap_system_environment_id"));
                    break;
                }
                case 3: {
                    String string = resultSet.getString("sap_process_chain_name");
                    if (string == null) {
                        string = "";
                    }
                    sAPExecutableProcessChain.setName(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

